/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.scheduler.product;

import java.util.Objects;

import activity.PeripheralAction;

/** The owner of a product being a peripheral or peripheral slot */
public class ProductOwner {
    private final String peripheralFqn;

    private final PeripheralAction action;

    public ProductOwner(PeripheralAction action) {
        this.action = action;
        this.peripheralFqn = action.fqn();
    }

    /**
     * @return The action.
     */
    public PeripheralAction getAction() {
        return action;
    }

    @Override
    public String toString() {
        return "ProductOwner [peripheral=" + peripheralFqn + "]";
    }

    /**
     * @return The peripheralFqn.
     */
    public String getPeripheral() {
        return peripheralFqn;
    }

    @Override
    public int hashCode() {
        return Objects.hash(peripheralFqn);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ProductOwner other = (ProductOwner)obj;
        // don't check action !!!
        return Objects.equals(peripheralFqn, other.peripheralFqn);
    }
}
