/*
 * Decompiled with CFR 0.152.
 */
package product;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TransferType implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    IN(1, "IN", "IN"),
    OUT(2, "OUT", "OUT"),
    ENTRY(3, "ENTRY", "ENTRY"),
    EXIT(4, "EXIT", "EXIT");

    public static final int UNKNOWN_VALUE = 0;
    public static final int IN_VALUE = 1;
    public static final int OUT_VALUE = 2;
    public static final int ENTRY_VALUE = 3;
    public static final int EXIT_VALUE = 4;
    private static final TransferType[] VALUES_ARRAY;
    public static final List<TransferType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransferType[]{UNKNOWN, IN, OUT, ENTRY, EXIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransferType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransferType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransferType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransferType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransferType get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return IN;
            }
            case 2: {
                return OUT;
            }
            case 3: {
                return ENTRY;
            }
            case 4: {
                return EXIT;
            }
        }
        return null;
    }

    private TransferType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

