/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.common.primitives.Chars;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.lsp4e.DocumentInputStream;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.refactoring.CreateFileChange;
import org.eclipse.lsp4e.refactoring.DeleteExternalFile;
import org.eclipse.lsp4e.refactoring.LSPTextChange;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.LinkedEditingRangeParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class LSPEclipseUtils {
    private static final String DEFAULT_LABEL = "LSP Workspace Edit";
    public static final String HTTP = "http";
    public static final String INTRO_URL = "http://org.eclipse.ui.intro";
    public static final String FILE_URI = "file://";
    private static final String FILE_SCHEME = "file";
    private static final String FILE_SLASH = "file:/";
    private static final String HTML = "html";
    private static final String MARKDOWN = "markdown";
    private static final String MD = "md";
    private static final int MAX_BROWSER_NAME_LENGTH = 30;
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage());
    private static final Pattern rangeFromUriExtractionPattern = Pattern.compile("^L?(\\d+)(?:,(\\d+))?(-L?(\\d+)(?:,(\\d+))?)?");
    private static final Range DEFAULT_RANGE = new Range(new Position(0, 0), new Position(0, 0));

    private LSPEclipseUtils() {
    }

    public static Position toPosition(int offset, IDocument document) throws BadLocationException {
        Position res = new Position();
        res.setLine(document.getLineOfOffset(offset));
        res.setCharacter(offset - document.getLineInformationOfOffset(offset).getOffset());
        return res;
    }

    public static int toOffset(Position position, IDocument document) throws BadLocationException {
        int line = position.getLine();
        int character = position.getCharacter();
        int zeroBasedDocumentLines = Math.max(0, document.getNumberOfLines() - 1);
        if (zeroBasedDocumentLines < position.getLine()) {
            line = zeroBasedDocumentLines;
            character = LSPEclipseUtils.getLineLength(document, line);
        } else {
            character = Math.min(LSPEclipseUtils.getLineLength(document, line), position.getCharacter());
        }
        return document.getLineOffset(line) + character;
    }

    private static int getLineLength(IDocument document, int line) throws BadLocationException {
        return Math.max(0, document.getLineLength(line));
    }

    public static boolean isOffsetInRange(int offset, Range range, IDocument document) {
        try {
            return offset != -1 && offset >= LSPEclipseUtils.toOffset(range.getStart(), document) && offset <= LSPEclipseUtils.toOffset(range.getEnd(), document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return false;
        }
    }

    public static CompletionParams toCompletionParams(URI fileUri, int offset, IDocument document, char[] completionTriggerChars) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        CompletionParams param = new CompletionParams();
        if (document.getLength() > 0) {
            try {
                int positionCharacterOffset = offset > 0 ? offset - 1 : offset;
                String positionCharacter = document.get(positionCharacterOffset, 1);
                if (Chars.contains((char[])completionTriggerChars, (char)positionCharacter.charAt(0))) {
                    param.setContext(new CompletionContext(CompletionTriggerKind.TriggerCharacter, positionCharacter));
                } else {
                    param.setContext(new CompletionContext(CompletionTriggerKind.Invoked));
                }
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        param.setPosition(start);
        param.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(fileUri));
        return param;
    }

    public static ISelection toSelection(Range range, IDocument document) {
        try {
            int offset = LSPEclipseUtils.toOffset(range.getStart(), document);
            int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), document);
            return new TextSelection(offset, endOffset > offset ? endOffset - offset : 0);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    @Deprecated
    public static TextDocumentPositionParams toTextDocumentPosistionParams(URI fileUri, int offset, IDocument document) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentPositionParams param = new TextDocumentPositionParams();
        param.setPosition(start);
        param.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(fileUri));
        return param;
    }

    private static <T extends TextDocumentPositionParams> T toTextDocumentPositionParamsCommon(@NonNull T param, int offset, IDocument document) throws BadLocationException {
        URI uri = LSPEclipseUtils.toUri(document);
        Position start = LSPEclipseUtils.toPosition(offset, document);
        param.setPosition(start);
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        if (uri != null) {
            id.setUri(uri.toASCIIString());
        }
        param.setTextDocument(id);
        return param;
    }

    public static HoverParams toHoverParams(int offset, IDocument document) throws BadLocationException {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new HoverParams(), offset, document);
    }

    public static SignatureHelpParams toSignatureHelpParams(int offset, IDocument document) throws BadLocationException {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new SignatureHelpParams(), offset, document);
    }

    public static TextDocumentPositionParams toTextDocumentPosistionParams(int offset, IDocument document) throws BadLocationException {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new TextDocumentPositionParams(), offset, document);
    }

    public static DefinitionParams toDefinitionParams(TextDocumentPositionParams params) {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new DefinitionParams(), params);
    }

    public static TypeDefinitionParams toTypeDefinitionParams(TextDocumentPositionParams params) {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new TypeDefinitionParams(), params);
    }

    public static ImplementationParams toImplementationParams(TextDocumentPositionParams params) {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new ImplementationParams(), params);
    }

    public static LinkedEditingRangeParams toLinkedEditingRangeParams(TextDocumentPositionParams params) {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new LinkedEditingRangeParams(), params);
    }

    private static <T extends TextDocumentPositionParams> T toTextDocumentPositionParamsCommon(@NonNull T specificParams, TextDocumentPositionParams genericParams) {
        if (genericParams.getPosition() != null) {
            specificParams.setPosition(genericParams.getPosition());
        }
        if (genericParams.getTextDocument() != null) {
            specificParams.setTextDocument(genericParams.getTextDocument());
        }
        return specificParams;
    }

    public static @NonNull TextDocumentIdentifier toTextDocumentIdentifier(@NonNull IDocument document) {
        return LSPEclipseUtils.toTextDocumentIdentifier(LSPEclipseUtils.toUri(document));
    }

    public static @NonNull TextDocumentIdentifier toTextDocumentIdentifier(@NonNull IResource res) {
        return LSPEclipseUtils.toTextDocumentIdentifier(LSPEclipseUtils.toUri(res));
    }

    public static @NonNull TextDocumentIdentifier toTextDocumentIdentifier(URI uri) {
        return new TextDocumentIdentifier(uri.toASCIIString());
    }

    public static CallHierarchyPrepareParams toCallHierarchyPrepareParams(int offset, @NonNull IDocument document) throws BadLocationException {
        Position position = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentIdentifier documentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
        return new CallHierarchyPrepareParams(documentIdentifier, position);
    }

    public static ITextFileBuffer toBuffer(IDocument document) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        if (bufferManager == null) {
            return null;
        }
        return bufferManager.getTextFileBuffer(document);
    }

    public static URI toUri(@Nullable IDocument document) {
        if (document == null) {
            return null;
        }
        ITextFileBuffer buffer = LSPEclipseUtils.toBuffer(document);
        IPath path = LSPEclipseUtils.toPath((IFileBuffer)buffer);
        IFile file = LSPEclipseUtils.getFile(path);
        if (file != null) {
            return LSPEclipseUtils.toUri((IResource)file);
        }
        if (path != null) {
            return LSPEclipseUtils.toUri(path.toFile());
        }
        if (buffer != null && buffer.getFileStore() != null) {
            return buffer.getFileStore().toURI();
        }
        return null;
    }

    private static IPath toPath(IFileBuffer buffer) {
        if (buffer != null) {
            return buffer.getLocation();
        }
        return null;
    }

    public static IPath toPath(IDocument document) {
        return LSPEclipseUtils.toPath((IFileBuffer)LSPEclipseUtils.toBuffer(document));
    }

    public static int toEclipseMarkerSeverity(DiagnosticSeverity lspSeverity) {
        if (lspSeverity == null) {
            return 2;
        }
        return switch (lspSeverity) {
            case DiagnosticSeverity.Error -> 2;
            case DiagnosticSeverity.Warning -> 1;
            default -> 0;
        };
    }

    public static @Nullable IFile getFileHandle(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        if (FILE_SCHEME.equals(uri.getScheme())) {
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files.length > 0) {
                return files[0];
            }
            return null;
        }
        return (IFile)Adapters.adapt((Object)uri.toString(), IFile.class, (boolean)true);
    }

    public static @Nullable IFile getFileHandle(@Nullable String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        if (uri.startsWith(FILE_SLASH)) {
            URI uriObj = URI.create(uri);
            return LSPEclipseUtils.getFileHandle(uriObj);
        }
        return (IFile)Adapters.adapt((Object)uri, IFile.class, (boolean)true);
    }

    public static @Nullable IResource findResourceFor(@Nullable String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        if (uri.startsWith(FILE_SLASH)) {
            return LSPEclipseUtils.findResourceFor(URI.create(uri));
        }
        return (IResource)Adapters.adapt((Object)uri, IResource.class, (boolean)true);
    }

    public static @Nullable IResource findResourceFor(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        if (FILE_SCHEME.equals(uri.getScheme())) {
            IFile file;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files.length > 0 && (file = LSPEclipseUtils.findMostNested(files)) != null) {
                return file;
            }
            IContainer[] containers = wsRoot.findContainersForLocationURI(uri);
            if (containers.length > 0) {
                return containers[0];
            }
            return null;
        }
        return (IResource)Adapters.adapt((Object)uri, IResource.class, (boolean)true);
    }

    public static IFile findMostNested(IFile[] files) {
        int shortestLen = Integer.MAX_VALUE;
        IFile shortest = null;
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            IFile file = iFileArray[n2];
            if (!file.isVirtual() && !file.getLocation().toFile().isDirectory() && (path = file.getFullPath()).segmentCount() < shortestLen) {
                shortest = file;
                shortestLen = path.segmentCount();
            }
            ++n2;
        }
        return shortest;
    }

    public static void applyEdit(org.eclipse.lsp4j.TextEdit textEdit, IDocument document) throws BadLocationException {
        document.replace(LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), textEdit.getNewText());
    }

    public static void applyEdits(IDocument document, List<? extends org.eclipse.lsp4j.TextEdit> edits) throws BadLocationException {
        if (document == null || edits == null || edits.isEmpty()) {
            return;
        }
        MultiTextEdit edit = new MultiTextEdit();
        for (org.eclipse.lsp4j.TextEdit textEdit : edits) {
            if (textEdit == null) continue;
            int offset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
            int length = LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - offset;
            if (length < 0) {
                throw new BadLocationException("Invalid location information found applying edits");
            }
            if (document.get(offset, length).equals(textEdit.getNewText())) continue;
            Object newText = textEdit.getNewText();
            int zeroBasedDocumentLines = Math.max(0, document.getNumberOfLines() - 1);
            int endLine = textEdit.getRange().getEnd().getLine();
            int n = endLine = endLine > zeroBasedDocumentLines ? zeroBasedDocumentLines : endLine;
            if ("\r\n".equals(document.getLineDelimiter(endLine)) && '\r' == ((String)newText).charAt(((String)newText).length() - 1) && offset + length < document.getLength()) {
                newText = (String)newText + "\n";
                ++length;
            }
            edit.addChild((TextEdit)new ReplaceEdit(offset, length, (String)newText));
        }
        if (!edit.hasChildren()) {
            return;
        }
        IDocumentUndoManager iDocumentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
        if (iDocumentUndoManager != null) {
            iDocumentUndoManager.beginCompoundChange();
        }
        try {
            RewriteSessionEditProcessor editProcessor = new RewriteSessionEditProcessor(document, (TextEdit)edit, 0);
            editProcessor.performEdits();
        }
        catch (BadLocationException | MalformedTreeException e) {
            LanguageServerPlugin.logError(e);
        }
        if (iDocumentUndoManager != null) {
            iDocumentUndoManager.endCompoundChange();
        }
    }

    public static @Nullable IDocument getDocument(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        IDocument document = LSPEclipseUtils.getExistingDocument(resource);
        if (document == null && resource.getType() == 1) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            if (bufferManager == null) {
                return document;
            }
            try {
                bufferManager.connect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return document;
            }
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
            if (buffer != null) {
                document = buffer.getDocument();
            }
        }
        return document;
    }

    public static @Nullable IDocument getExistingDocument(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        if (bufferManager == null) {
            return null;
        }
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return null;
    }

    public static @Nullable IDocument getDocument(URI uri) {
        if (uri == null) {
            return null;
        }
        IResource resource = LSPEclipseUtils.findResourceFor(uri);
        if (resource != null) {
            return LSPEclipseUtils.getDocument(resource);
        }
        IDocument document = null;
        IFileStore store = null;
        try {
            store = EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        if (bufferManager == null) {
            return null;
        }
        ITextFileBuffer buffer = bufferManager.getFileStoreTextFileBuffer(store);
        if (buffer != null) {
            document = buffer.getDocument();
        } else {
            try {
                bufferManager.connectFileStore(store, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return document;
            }
            buffer = bufferManager.getFileStoreTextFileBuffer(store);
            if (buffer != null) {
                document = buffer.getDocument();
            }
        }
        return document;
    }

    public static void openInEditor(Location location) {
        LSPEclipseUtils.openInEditor(location, UI.getActivePage());
    }

    public static void openInEditor(Location location, IWorkbenchPage page) {
        LSPEclipseUtils.open(location.getUri(), page, location.getRange());
    }

    public static void openInEditor(LocationLink link) {
        LSPEclipseUtils.openInEditor(link, UI.getActivePage());
    }

    public static void openInEditor(LocationLink link, IWorkbenchPage page) {
        LSPEclipseUtils.open(link.getTargetUri(), page, link.getTargetSelectionRange());
    }

    public static void open(String uri, Range optionalRange) {
        LSPEclipseUtils.open(uri, UI.getActivePage(), optionalRange);
    }

    public static void open(String uri, IWorkbenchPage page, Range optionalRange) {
        LSPEclipseUtils.open(uri, page, optionalRange, false);
    }

    public static void open(String uri, IWorkbenchPage page, Range optionalRange, boolean createFile) {
        if (uri.startsWith(HTTP)) {
            if (uri.startsWith(INTRO_URL)) {
                LSPEclipseUtils.openIntroURL(uri);
            } else {
                LSPEclipseUtils.openHttpLocationInBrowser(uri, page);
            }
        } else {
            if (optionalRange == null) {
                optionalRange = LSPEclipseUtils.parseRange(uri);
            }
            LSPEclipseUtils.openFileLocationInEditor(uri, page, optionalRange, createFile);
        }
    }

    public static Range parseRange(String location) {
        Matcher matcher;
        block7: {
            String fragment;
            block6: {
                block5: {
                    try {
                        if (location.startsWith(FILE_URI)) break block5;
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
                URI uri = URI.create(location).normalize();
                fragment = uri.getFragment();
                if (fragment != null && !fragment.isBlank()) break block6;
                return null;
            }
            matcher = rangeFromUriExtractionPattern.matcher(fragment);
            if (matcher.matches()) break block7;
            return null;
        }
        int startLine = matcher.group(1) != null ? Integer.parseInt(matcher.group(1)) : 1;
        int startChar = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 1;
        int endLine = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : startLine;
        int endChar = matcher.group(5) != null ? Integer.parseInt(matcher.group(5)) : startChar;
        Position start = new Position(startLine - 1, startChar - 1);
        Position end = new Position(endLine - 1, endChar - 1);
        return new Range(start, end);
    }

    protected static void openIntroURL(String uri) {
        IIntroURL introUrl = IntroURLFactory.createIntroURL((String)uri);
        if (introUrl != null) {
            try {
                if (!introUrl.execute()) {
                    LanguageServerPlugin.logWarning("Failed to execute IntroURL: " + uri, null);
                }
            }
            catch (Exception t) {
                LanguageServerPlugin.logWarning("Error executing IntroURL: " + uri, t);
            }
        }
    }

    protected static void openHttpLocationInBrowser(String uri, IWorkbenchPage page) {
        page.getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> {
            try {
                URL url = new URL(uri);
                IWorkbenchBrowserSupport browserSupport = page.getWorkbenchWindow().getWorkbench().getBrowserSupport();
                Object browserName = uri;
                if (((String)browserName).length() > 30) {
                    browserName = uri.substring(0, 29) + "\u2026";
                }
                browserSupport.createBrowser(38, "lsp4e-symbols", (String)browserName, uri).openURL(url);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        });
    }

    protected static void openFileLocationInEditor(String uri, IWorkbenchPage page, Range optionalRange, boolean createFile) {
        IEditorPart part = LSPEclipseUtils.openEditor(uri, page, createFile);
        IDocument targetDocument = null;
        if (optionalRange != null && part != null && part.getEditorSite() != null && part.getEditorSite().getSelectionProvider() != null) {
            ITextEditor textEditor = (ITextEditor)Adapters.adapt((Object)part, ITextEditor.class);
            if (textEditor != null) {
                targetDocument = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            }
            if (targetDocument != null) {
                ISelectionProvider selectionProvider = part.getEditorSite().getSelectionProvider();
                ISelection selection = LSPEclipseUtils.toSelection(optionalRange, targetDocument);
                if (selection != null) {
                    selectionProvider.setSelection(selection);
                }
            }
        }
    }

    private static IEditorPart openEditor(String uri, IWorkbenchPage page, boolean createFile) {
        block34: {
            IFileStore fileStore;
            block35: {
                if (page == null) {
                    return null;
                }
                IResource targetResource = LSPEclipseUtils.findResourceFor(uri);
                if (targetResource != null && targetResource.getType() == 1) {
                    if (!targetResource.exists() && createFile) {
                        if (MessageDialog.openQuestion((Shell)UI.getActiveShell(), (String)Messages.CreateFile_confirm_title, (String)Messages.bind((String)Messages.CreateFile_confirm_message, (Object)uri))) {
                            try {
                                Throwable throwable = null;
                                Object var5_9 = null;
                                try (ByteArrayInputStream input = new ByteArrayInputStream("".getBytes());){
                                    ((IFile)targetResource).create((InputStream)input, 2, null);
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Exception e) {
                                LanguageServerPlugin.logError(e);
                            }
                        } else {
                            return null;
                        }
                    }
                    try {
                        return IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)targetResource));
                    }
                    catch (PartInitException e) {
                        LanguageServerPlugin.logError(e);
                        break block34;
                    }
                }
                URI fileUri = URI.create(uri).normalize();
                IFileSystem fileSystem = EFS.getFileSystem((String)fileUri.getScheme());
                fileStore = fileSystem.getStore(fileUri);
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (fetchInfo.isDirectory()) break block34;
                if (fetchInfo.exists() || !createFile) break block35;
                if (MessageDialog.openQuestion((Shell)UI.getActiveShell(), (String)Messages.CreateFile_confirm_title, (String)Messages.bind((String)Messages.CreateFile_confirm_message, (Object)uri))) {
                    try {
                        fileStore.getParent().mkdir(0, null);
                        Throwable throwable = null;
                        Object var9_19 = null;
                        try (OutputStream out = fileStore.openOutputStream(0, null);){
                            out.write("".getBytes());
                            break block35;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        LanguageServerPlugin.logError(e);
                    }
                    break block35;
                }
                return null;
            }
            try {
                return IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    public static IDocument getDocument(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput != null) {
            IDocument document;
            IDocumentProvider documentProvider = editor.getDocumentProvider();
            if (documentProvider != null && (document = documentProvider.getDocument((Object)editorInput)) != null) {
                return document;
            }
            IDocument res = LSPEclipseUtils.getDocument(editorInput);
            if (res != null) {
                return res;
            }
        }
        if (editor instanceof AbstractTextEditor) {
            try {
                Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                getSourceViewerMethod.setAccessible(true);
                ITextViewer viewer = (ITextViewer)getSourceViewerMethod.invoke((Object)editor, new Object[0]);
                return viewer == null ? null : viewer.getDocument();
            }
            catch (Exception ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IDocument getDocument(IEditorInput editorInput) {
        if (!editorInput.exists()) {
            return null;
        }
        IEditorInput iEditorInput = editorInput;
        if (iEditorInput instanceof IFileEditorInput) {
            void fileEditorInput;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
            return LSPEclipseUtils.getDocument((IResource)fileEditorInput.getFile());
        }
        IEditorInput iEditorInput2 = editorInput;
        if (iEditorInput2 instanceof IPathEditorInput) {
            void pathEditorInput;
            IPathEditorInput iPathEditorInput = (IPathEditorInput)iEditorInput2;
            IPathEditorInput cfr_ignored_1 = (IPathEditorInput)iEditorInput2;
            return LSPEclipseUtils.getDocument((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(pathEditorInput.getPath()));
        }
        IEditorInput iEditorInput3 = editorInput;
        if (iEditorInput3 instanceof IURIEditorInput) {
            void uriEditorInput;
            IURIEditorInput iURIEditorInput = (IURIEditorInput)iEditorInput3;
            IURIEditorInput cfr_ignored_2 = (IURIEditorInput)iEditorInput3;
            IResource resource = LSPEclipseUtils.findResourceFor(uriEditorInput.getURI());
            if (resource != null) {
                return LSPEclipseUtils.getDocument(resource);
            }
            return LSPEclipseUtils.getDocument(uriEditorInput.getURI());
        }
        return null;
    }

    public static void applyWorkspaceEdit(WorkspaceEdit wsEdit) {
        LSPEclipseUtils.applyWorkspaceEdit(wsEdit, null);
    }

    public static void applyWorkspaceEdit(WorkspaceEdit wsEdit, String label) {
        if (wsEdit == null) {
            return;
        }
        if (LSPEclipseUtils.applyWorkspaceEditIfSingleOpenFile(wsEdit)) {
            return;
        }
        String name = label == null ? DEFAULT_LABEL : label;
        HashMap<URI, Range> changedURIs = new HashMap<URI, Range>();
        CompositeChange change = LSPEclipseUtils.toCompositeChange(wsEdit, name, changedURIs);
        PerformChangeOperation changeOperation = new PerformChangeOperation((Change)change);
        changeOperation.setUndoManager(RefactoringCore.getUndoManager(), name);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)changeOperation, (IProgressMonitor)new NullProgressMonitor());
            if (changedURIs.size() == 1) {
                changedURIs.keySet().stream().findFirst().ifPresent(uri -> {
                    Position start;
                    Range range = (Range)changedURIs.get(uri);
                    Position position = start = range.getStart() != null ? range.getStart() : new Position(0, 0);
                    if (Display.getCurrent() != null) {
                        LSPEclipseUtils.open(uri.toString(), new Range(start, start));
                    } else {
                        UI.getDisplay().asyncExec(() -> LSPEclipseUtils.open(uri.toString(), new Range(start, start)));
                    }
                });
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private static boolean applyWorkspaceEditIfSingleOpenFile(WorkspaceEdit wsEdit) {
        HashSet documentUris = new HashSet();
        ArrayList firstDocumentEdits = new ArrayList();
        if (wsEdit.getChanges() != null && !wsEdit.getChanges().isEmpty()) {
            wsEdit.getChanges().entrySet().stream().map(Map.Entry::getKey).map(LSPEclipseUtils::toUri).forEach(documentUris::add);
            firstDocumentEdits.addAll((Collection)wsEdit.getChanges().entrySet().iterator().next().getValue());
        }
        if (wsEdit.getDocumentChanges() != null && !wsEdit.getDocumentChanges().isEmpty()) {
            if (wsEdit.getDocumentChanges().stream().anyMatch(Either::isRight)) {
                documentUris.clear();
            } else {
                wsEdit.getDocumentChanges().stream().map(Either::getLeft).map(TextDocumentEdit::getTextDocument).map(TextDocumentIdentifier::getUri).map(LSPEclipseUtils::toUri).forEach(documentUris::add);
                firstDocumentEdits.addAll(((TextDocumentEdit)((Either)wsEdit.getDocumentChanges().get(0)).getLeft()).getEdits());
            }
        }
        if (documentUris.size() != 1 || firstDocumentEdits.isEmpty()) {
            return false;
        }
        URI singleDocumentUri = (URI)documentUris.iterator().next();
        Set<IEditorReference> editors = LSPEclipseUtils.findOpenEditorsFor(singleDocumentUri);
        if (editors == null || editors.isEmpty()) {
            return false;
        }
        Optional<IDocument> doc = editors.stream().map(editor -> {
            try {
                return editor.getEditorInput();
            }
            catch (PartInitException ex) {
                return null;
            }
        }).filter(Objects::nonNull).map(LSPEclipseUtils::getDocument).filter(Objects::nonNull).findFirst();
        doc.ifPresent(document -> UI.getDisplay().syncExec(() -> {
            try {
                LSPEclipseUtils.applyEdits(document, firstDocumentEdits);
            }
            catch (BadLocationException ex) {
                LanguageServerPlugin.logError(ex);
            }
        }));
        return doc.isPresent();
    }

    public static CompositeChange toCompositeChange(WorkspaceEdit wsEdit, String name) {
        return LSPEclipseUtils.toCompositeChange(wsEdit, name, null);
    }

    private static CompositeChange toCompositeChange(WorkspaceEdit wsEdit, String name, Map<URI, Range> collector) {
        CompositeChange change = new CompositeChange(name);
        List documentChanges = wsEdit.getDocumentChanges();
        if (documentChanges != null) {
            documentChanges.stream().forEach(action -> {
                String encoding;
                String content;
                DeleteResourceChange removeNewFile;
                IFile oldFile;
                URI newURI;
                URI oldURI;
                block27: {
                    void rename;
                    if (action.isLeft()) {
                        TextDocumentEdit edit = (TextDocumentEdit)action.getLeft();
                        VersionedTextDocumentIdentifier id = edit.getTextDocument();
                        URI uri = URI.create(id.getUri());
                        List textEdits = edit.getEdits();
                        change.addAll((Change[])LSPEclipseUtils.toChanges(uri, textEdits));
                        LSPEclipseUtils.collectChangedURI(uri, textEdits, collector);
                        return;
                    }
                    if (!action.isRight()) return;
                    ResourceOperation resourceOperation = (ResourceOperation)action.getRight();
                    ResourceOperation resourceOperation2 = resourceOperation;
                    if (resourceOperation2 instanceof CreateFile) {
                        void createOperation;
                        CreateFile id = (CreateFile)resourceOperation2;
                        CreateFile cfr_ignored_0 = (CreateFile)resourceOperation2;
                        URI targetURI = URI.create(createOperation.getUri());
                        File targetFile = LSPEclipseUtils.fromUri(targetURI);
                        if (targetFile.exists() && createOperation.getOptions() != null) {
                            if (createOperation.getOptions().getIgnoreIfExists() != false) return;
                            if (createOperation.getOptions().getOverwrite() == false) return;
                            change.add((Change)new LSPTextChange("Overwrite", targetURI, ""));
                            return;
                        }
                        CreateFileChange operation = new CreateFileChange(targetURI, "", null);
                        change.add((Change)operation);
                        return;
                    }
                    ResourceOperation resourceOperation3 = resourceOperation;
                    if (resourceOperation3 instanceof DeleteFile) {
                        void delete;
                        DeleteFile targetURI = (DeleteFile)resourceOperation3;
                        DeleteFile cfr_ignored_1 = (DeleteFile)resourceOperation3;
                        IResource resource = LSPEclipseUtils.findResourceFor(delete.getUri());
                        if (resource != null) {
                            DeleteResourceChange deleteChange = new DeleteResourceChange(resource.getFullPath(), true);
                            change.add((Change)deleteChange);
                            return;
                        }
                        LanguageServerPlugin.logWarning("Changes outside of visible projects are not supported at the moment.", null);
                        return;
                    }
                    ResourceOperation resourceOperation4 = resourceOperation;
                    if (!(resourceOperation4 instanceof RenameFile)) return;
                    RenameFile resource = (RenameFile)resourceOperation4;
                    RenameFile cfr_ignored_2 = (RenameFile)resourceOperation4;
                    oldURI = URI.create(rename.getOldUri());
                    newURI = URI.create(rename.getNewUri());
                    oldFile = LSPEclipseUtils.getFileHandle(oldURI);
                    IFile newFile = LSPEclipseUtils.getFileHandle(newURI);
                    removeNewFile = null;
                    if (newFile != null && newFile.exists()) {
                        if (rename.getOptions().getOverwrite().booleanValue()) {
                            removeNewFile = new DeleteResourceChange(newFile.getFullPath(), true);
                        } else if (rename.getOptions().getIgnoreIfExists().booleanValue()) {
                            return;
                        }
                    }
                    content = "";
                    encoding = null;
                    if (oldFile != null && oldFile.exists()) {
                        try {
                            Throwable throwable = null;
                            Object var21_29 = null;
                            try {
                                ByteArrayOutputStream stream = new ByteArrayOutputStream((int)oldFile.getLocation().toFile().length());
                                try {
                                    try (InputStream inputStream = oldFile.getContents();){
                                        FileUtil.transferStreams((InputStream)inputStream, (OutputStream)stream, (String)newURI.toString(), null);
                                        content = new String(stream.toByteArray());
                                        encoding = oldFile.getCharset();
                                    }
                                    if (stream == null) break block27;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (stream == null) throw throwable;
                                    stream.close();
                                    throw throwable;
                                }
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                        catch (IOException | CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                }
                CreateFileChange createFileChange = new CreateFileChange(newURI, content, encoding);
                change.add((Change)createFileChange);
                if (removeNewFile != null) {
                    change.add((Change)removeNewFile);
                }
                if (oldFile != null) {
                    DeleteResourceChange removeOldFile = new DeleteResourceChange(oldFile.getFullPath(), true);
                    change.add((Change)removeOldFile);
                    return;
                }
                change.add((Change)new DeleteExternalFile(new File(oldURI)));
            });
        } else {
            Map changes = wsEdit.getChanges();
            if (changes != null) {
                for (Map.Entry edit : changes.entrySet()) {
                    URI uri = URI.create((String)edit.getKey());
                    List textEdits = (List)edit.getValue();
                    change.addAll((Change[])LSPEclipseUtils.toChanges(uri, textEdits));
                    LSPEclipseUtils.collectChangedURI(uri, textEdits, collector);
                }
            }
        }
        return change;
    }

    private static void collectChangedURI(URI uri, List<org.eclipse.lsp4j.TextEdit> textEdits, Map<URI, Range> collector) {
        if (collector == null) {
            return;
        }
        Range start = textEdits != null && !textEdits.isEmpty() ? textEdits.get(textEdits.size() - 1).getRange() : DEFAULT_RANGE;
        Range range = collector.get(uri);
        if (range == null) {
            collector.put(uri, start);
        } else if (LSPEclipseUtils.rangeStartIsLessThan(start, range)) {
            collector.put(uri, range);
        }
    }

    private static boolean rangeStartIsLessThan(Range range, Range toCompare) {
        if (range == null) {
            return true;
        }
        if (toCompare == null) {
            return false;
        }
        Position start = range.getStart();
        Position compareStart = toCompare.getStart();
        if (start.getLine() < compareStart.getLine()) {
            return true;
        }
        if (start.getLine() == compareStart.getLine()) {
            return start.getCharacter() < compareStart.getCharacter();
        }
        return false;
    }

    private static LSPTextChange[] toChanges(URI uri, List<org.eclipse.lsp4j.TextEdit> textEdits) {
        Collections.sort(textEdits, Comparator.comparing(edit -> edit.getRange().getStart(), Comparator.comparingInt(Position::getLine).thenComparingInt(Position::getCharacter).reversed()));
        return (LSPTextChange[])textEdits.stream().map(te -> new LSPTextChange("LSP Text Edit", uri, (org.eclipse.lsp4j.TextEdit)te)).toArray(LSPTextChange[]::new);
    }

    public static URI toUri(IPath absolutePath) {
        return LSPEclipseUtils.toUri(absolutePath.toFile());
    }

    public static URI toUri(@NonNull IResource resource) {
        URI adaptedURI = (URI)Adapters.adapt((Object)resource, URI.class, (boolean)true);
        if (adaptedURI != null) {
            return adaptedURI;
        }
        IPath location = resource.getLocation();
        if (location != null) {
            return LSPEclipseUtils.toUri(location);
        }
        return resource.getLocationURI();
    }

    public static @Nullable URI toUri(@NonNull IFileBuffer buffer) {
        URI uri;
        IFile res;
        IPath bufferLocation = buffer.getLocation();
        IFile iFile = res = bufferLocation != null && bufferLocation.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile(buffer.getLocation()) : null;
        if (res != null && (uri = LSPEclipseUtils.toUri(res)) != null) {
            return uri;
        }
        if (buffer.getFileStore() != null) {
            return buffer.getFileStore().toURI();
        }
        return null;
    }

    public static URI toUri(File file) {
        try {
            return new URI(FILE_SCHEME, "", file.getAbsoluteFile().toURI().getPath(), null);
        }
        catch (URISyntaxException e) {
            LanguageServerPlugin.logError(e);
            return file.getAbsoluteFile().toURI();
        }
    }

    public static @Nullable IFile getFile(@NonNull IDocument document) {
        IPath path = LSPEclipseUtils.toPath(document);
        return LSPEclipseUtils.getFile(path);
    }

    public static @Nullable IFile getFile(IPath path) {
        if (path == null) {
            return null;
        }
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (res != null && res.exists()) {
            return res;
        }
        return null;
    }

    public static @NonNull List<@NonNull WorkspaceFolder> getWorkspaceFolders() {
        return Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(IResource::isAccessible).map(LSPEclipseUtils::toWorkspaceFolder).toList();
    }

    public static @NonNull WorkspaceFolder toWorkspaceFolder(@NonNull IProject project) {
        WorkspaceFolder folder = new WorkspaceFolder();
        URI folderUri = LSPEclipseUtils.toUri((IResource)project);
        folder.setUri(folderUri != null ? folderUri.toASCIIString() : "");
        folder.setName(project.getName());
        return folder;
    }

    public static @NonNull List<IContentType> getFileContentTypes(@NonNull IFile file) {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>();
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream contents = file.getContents();){
                    contentTypes.addAll(Arrays.asList(contentTypeManager.findContentTypesFor(contents, file.getName())));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                LanguageServerPlugin.logError(e);
            }
        } else {
            contentTypes.addAll(Arrays.asList(contentTypeManager.findContentTypesFor(file.getName())));
        }
        return contentTypes;
    }

    private static @Nullable String getFileName(@Nullable ITextFileBuffer buffer) {
        IPath path = LSPEclipseUtils.toPath((IFileBuffer)buffer);
        IFile file = LSPEclipseUtils.getFile(path);
        if (file != null) {
            return file.getName();
        }
        if (path != null) {
            return path.lastSegment();
        }
        if (buffer != null && buffer.getFileStore() != null) {
            return buffer.getFileStore().getName();
        }
        return null;
    }

    public static @NonNull List<IContentType> getDocumentContentTypes(@NonNull IDocument document) {
        String fileName;
        ITextFileBuffer buffer;
        ArrayList<IContentType> contentTypes;
        block16: {
            contentTypes = new ArrayList<IContentType>();
            buffer = LSPEclipseUtils.toBuffer(document);
            if (buffer != null) {
                try {
                    IContentType contentType = buffer.getContentType();
                    if (contentType != null) {
                        contentTypes.add(contentType);
                    }
                }
                catch (CoreException e) {
                    if (e.getCause() instanceof FileNotFoundException || e.getStatus().getCode() == 368) break block16;
                    LanguageServerPlugin.logError("Exception occurred while fetching the content type from the buffer", e);
                }
            }
        }
        if ((fileName = LSPEclipseUtils.getFileName(buffer)) != null) {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (DocumentInputStream contents = new DocumentInputStream(document);){
                    contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor((InputStream)contents, fileName)));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return contentTypes;
    }

    @Deprecated
    public static String getDocString(Either<String, MarkupContent> documentation) {
        if (documentation != null) {
            if (documentation.isLeft()) {
                return (String)documentation.getLeft();
            }
            return ((MarkupContent)documentation.getRight()).getValue();
        }
        return null;
    }

    public static String getHtmlDocString(Either<String, MarkupContent> documentation) {
        return (String)documentation.map(text -> {
            if (text != null && !text.isEmpty()) {
                return LSPEclipseUtils.htmlParagraph(text);
            }
            return null;
        }, markupContent -> {
            String text = markupContent.getValue();
            if (text != null && !text.isEmpty()) {
                String kind = markupContent.getKind();
                if (MARKDOWN.equalsIgnoreCase(kind) || MD.equalsIgnoreCase(kind)) {
                    try {
                        return MARKDOWN_PARSER.parseToHtml(text);
                    }
                    catch (Exception e) {
                        LanguageServerPlugin.logError(e);
                        return LSPEclipseUtils.htmlParagraph(text);
                    }
                }
                if (HTML.equalsIgnoreCase(kind)) {
                    return text;
                }
                return LSPEclipseUtils.htmlParagraph(text);
            }
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static ITextViewer getTextViewer(@Nullable IEditorPart editorPart) {
        @Nullable ITextViewer textViewer = (ITextViewer)Adapters.adapt((Object)editorPart, ITextViewer.class);
        if (textViewer != null) {
            return textViewer;
        }
        Object object = Adapters.adapt((Object)editorPart, ITextOperationTarget.class);
        if (object instanceof ITextViewer) {
            void viewer;
            ITextViewer iTextViewer = (ITextViewer)object;
            ITextViewer cfr_ignored_0 = (ITextViewer)object;
            return viewer;
        }
        return null;
    }

    private static String htmlParagraph(String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append(text);
        sb.append("</p>");
        return sb.toString();
    }

    public static Color toColor(RGB rgb) {
        return new Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    public static RGBA toRGBA(Color color) {
        return new RGBA((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), (int)color.getAlpha());
    }

    public static Set<IEditorReference> findOpenEditorsFor(URI uri) {
        if (uri == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows()).map(IWorkbenchWindow::getPages).flatMap(Arrays::stream).map(IWorkbenchPage::getEditorReferences).flatMap(Arrays::stream).filter(ref -> {
            try {
                return uri.equals(LSPEclipseUtils.toUri(ref.getEditorInput()));
            }
            catch (PartInitException e) {
                LanguageServerPlugin.logError(e);
                return false;
            }
        }).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public static URI toUri(IEditorInput editorInput) {
        IEditorInput iEditorInput = editorInput;
        if (iEditorInput instanceof FileEditorInput) {
            void fileEditorInput;
            FileEditorInput fileEditorInput2 = (FileEditorInput)iEditorInput;
            FileEditorInput cfr_ignored_0 = (FileEditorInput)iEditorInput;
            return LSPEclipseUtils.toUri((IResource)fileEditorInput.getFile());
        }
        IEditorInput iEditorInput2 = editorInput;
        if (iEditorInput2 instanceof IURIEditorInput) {
            void uriEditorInput;
            IURIEditorInput iURIEditorInput = (IURIEditorInput)iEditorInput2;
            IURIEditorInput cfr_ignored_1 = (IURIEditorInput)iEditorInput2;
            URI uri = uriEditorInput.getURI();
            return uri.getPath() != null ? LSPEclipseUtils.toUri(Path.fromPortableString((String)uri.getPath())) : uri;
        }
        return null;
    }

    public static URI toUri(String uri) {
        URI initialUri = URI.create(uri);
        return FILE_SCHEME.equals(initialUri.getScheme()) ? LSPEclipseUtils.toUri(Path.fromPortableString((String)initialUri.getPath())) : initialUri;
    }

    public static File fromUri(URI uri) {
        return Paths.get(uri).toFile();
    }

    public static boolean hasCapability(@Nullable Either<Boolean, ? extends Object> eitherCapability) {
        if (eitherCapability == null) {
            return false;
        }
        return eitherCapability.isRight() || (Boolean)eitherCapability.getLeft() != false;
    }

    public static boolean isReadOnly(@NonNull URI uri) {
        IResource resource = LSPEclipseUtils.findResourceFor(uri);
        return resource != null && LSPEclipseUtils.isReadOnly(resource);
    }

    public static boolean isReadOnly(@NonNull IDocument document) {
        IFile file = LSPEclipseUtils.getFile(document);
        return file != null && LSPEclipseUtils.isReadOnly((IResource)file);
    }

    public static boolean isReadOnly(@NonNull IResource resource) {
        ResourceAttributes attributes = resource.getResourceAttributes();
        return attributes != null && attributes.isReadOnly();
    }
}

