/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.MappingEnablementTester;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockLanguageServerMultiRootFolders;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LanguageServiceAccessorTest {
    private static final Predicate<ServerCapabilities> MATCH_ALL = capabilities -> true;
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("LanguageServiceAccessorTest" + System.currentTimeMillis());
    }

    @Test
    public void testGetLSWrapper() throws IOException {
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assert.assertNotNull((Object)serverDefinition);
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)this.project, (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        Assert.assertNotNull((Object)lsWrapper);
    }

    @Test
    public void testGetLSPDocumentInfoForInvalidDocument() {
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)new Document(), MATCH_ALL);
        Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetLSPDocumentInfoForInvalidTextEditor() throws CoreException {
        IFile testFile = TestUtils.createFile(this.project, "not_associated_with_ls.abc", "");
        ITextViewer textViewer = TestUtils.openTextViewer(testFile);
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)textViewer.getDocument(), MATCH_ALL);
        Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetLanguageServerInvalidFile() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "not_associated_with_ls.abc", "");
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile, MATCH_ALL));
    }

    @Test
    public void testLSAsExtension() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt", "");
        LanguageServers.forDocument((IDocument)LSPEclipseUtils.getDocument((IResource)testFile)).anyMatching();
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile, MATCH_ALL));
    }

    @Test
    public void testLSAsRunConfiguration() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseRunConfiguration.lspt2", "");
        LanguageServers.forDocument((IDocument)LSPEclipseUtils.getDocument((IResource)testFile)).anyMatching();
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile, MATCH_ALL));
    }

    @Test
    public void testLSAsExtensionForDifferentLanguageId() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt-different", "");
        List lsWrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)lsWrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)lsWrappers.iterator().next();
        Assert.assertNotNull((Object)wrapper);
        IContentType contentType = Platform.getContentTypeManager().getContentType("org.eclipse.lsp4e.test.content-type-different");
        Assert.assertEquals((Object)"differentLanguageId", (Object)wrapper.getLanguageId(new IContentType[]{contentType}));
    }

    @Test
    public void testGetLSWrappersInitializationFailed() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "fileWithFailedServer.lsptWithException", "");
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
    }

    @Test
    public void testReuseSameLSforMultiContentType() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        List file1LanguageServers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)file1LanguageServers.size());
        ArrayList<LanguageServersRegistry.LanguageServerDefinition> file2LanguageServers = new ArrayList<LanguageServersRegistry.LanguageServerDefinition>();
        for (LanguageServerWrapper future : LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL)) {
            file2LanguageServers.add(future.serverDefinition);
        }
        Assert.assertEquals((long)2L, (long)file2LanguageServers.size());
        LanguageServersRegistry.LanguageServerDefinition file1LS = ((LanguageServerWrapper)file1LanguageServers.get((int)0)).serverDefinition;
        Assert.assertTrue((boolean)file2LanguageServers.contains(file1LS));
        Assert.assertEquals((String)"Not right amount of language servers bound to project", (long)2L, (long)LanguageServers.forProject((IProject)this.project).computeAll(ls -> CompletableFuture.completedFuture(null)).size());
    }

    @Test
    public void testGetOnlyRunningLanguageServers() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        IEditorPart editor2 = TestUtils.openEditor(testFile2);
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile1, MATCH_ALL));
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile2, MATCH_ALL));
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(MATCH_ALL));
        editor1.getSite().getPage().closeEditor(editor1, false);
        editor2.getSite().getPage().closeEditor(editor2, false);
        TestUtils.waitForCondition(5000, () -> !LanguageServiceAccessor.hasActiveLanguageServers(MATCH_ALL));
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(MATCH_ALL));
        editor1 = TestUtils.openEditor(testFile1);
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile1, MATCH_ALL));
        TestUtils.waitForCondition(5000, () -> LanguageServiceAccessor.hasActiveLanguageServers(MATCH_ALL));
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(MATCH_ALL));
    }

    @Test
    public void testCreateNewLSAfterInitialProjectGotDeleted() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile1, MATCH_ALL));
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.isRunning());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile2);
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile2, MATCH_ALL));
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL);
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertTrue((wrapper1 != wrapper2 ? 1 : 0) != 0);
    }

    @Test
    public void testReuseMultirootFolderLSAfterInitialProjectGotDeleted() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "lsptWithMultiRoot", "");
        TestUtils.openEditor(testFile1);
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile1, MATCH_ALL));
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServerMultiRootFolders.INSTANCE.isRunning());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lsptWithMultiRoot", "");
        TestUtils.openEditor(testFile2);
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IFile)testFile2, MATCH_ALL));
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL);
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertSame((Object)wrapper1, (Object)wrapper2);
    }

    @Test
    public void testDontRestartUnrelatedLSForFileFromSameProject() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        List wrappers1 = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers1.size());
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers1.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        wrapper1.disconnect(testFile1.getLocationURI());
        Assert.assertFalse((boolean)wrapper1.isActive());
        List wrappers2 = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers2.size());
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers2.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertFalse((boolean)wrapper1.isActive());
        wrapper2.disconnect(testFile2.getLocationURI());
    }

    @Test
    public void testLastDocumentDisconnectedTimeoutManualStop() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptWithLastDocumentDisconnectedTimeout", "");
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.disconnect(testFile.getLocationURI());
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.stop();
        Assert.assertFalse((boolean)wrapper.isActive());
    }

    @Test
    public void testLastDocumentDisconnectedTimeoutTimerStop() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptWithLastDocumentDisconnectedTimeout", "");
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.disconnect(testFile.getLocationURI());
        Assert.assertTrue((boolean)wrapper.isActive());
        TestUtils.waitForAndAssertCondition(5000, () -> !wrapper.isActive());
    }

    @Test
    public void testLastDocumentDisconnectedTimeoutZero() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.disconnect(testFile.getLocationURI());
        Assert.assertFalse((boolean)wrapper.isActive());
    }

    @Test
    public void testLanguageServerHierarchy_moreSpecializedFirst() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptchild", "");
        List servers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Iterator iterator = servers.iterator();
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server2", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
    }

    @Test
    public void testLanguageServerHierarchy_parentContentTypeUsed() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptchildNoLS", "");
        List servers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Iterator iterator = servers.iterator();
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
        Assert.assertFalse((String)"Should only be a single LS", (boolean)iterator.hasNext());
    }

    @Test
    public void testLanguageServerEnablement() throws Exception {
        String serverId = "org.eclipse.lsp4e.test.server.disable";
        String prefKey = "org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled";
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled", Boolean.FALSE.toString());
        IFile disabledFile = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        Assert.assertFalse((boolean)LanguageServiceAccessor.getLSWrappers((IFile)disabledFile, MATCH_ALL).stream().anyMatch(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")));
        IFile enabledFile = TestUtils.createUniqueTestFile(this.project, "lspt-enabled", "");
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)enabledFile, MATCH_ALL).stream().anyMatch(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")));
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled", Boolean.TRUE.toString());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)disabledFile, MATCH_ALL).stream().anyMatch(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")));
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)enabledFile, MATCH_ALL).stream().anyMatch(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")));
    }

    @Test
    public void testLanguageServerEnablementTester() throws Exception {
        String serverId = "org.eclipse.lsp4e.test.server.disable";
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt-tester", "");
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)file, MATCH_ALL).isEmpty());
        MappingEnablementTester.enabled = true;
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)file, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server.disable", (Object)((LanguageServerWrapper)wrappers.iterator().next()).serverDefinition.id);
    }

    @Test
    public void testLSforExternalThenLocalFile() throws Exception {
        IWorkbenchWindow wb = UI.getActiveWindow();
        File local = TestUtils.createTempFile("testLSforExternalThenLocalFile", ".lspt");
        ITextEditor editor = (ITextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)wb.getActivePage(), (IFileStore)EFS.getStore((URI)local.toURI()));
        Predicate<ServerCapabilities> hasHoverCapabilities = capabilities -> {
            Either hoverProvider = capabilities.getHoverProvider();
            return hoverProvider.isLeft() ? (Boolean)hoverProvider.getLeft() : hoverProvider.getRight() != null;
        };
        IDocument externalDocument = LSPEclipseUtils.getTextViewer((IEditorPart)editor).getDocument();
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IDocument)externalDocument, hasHoverCapabilities));
        wb.getActivePage().closeAllEditors(false);
        IDocument internalDocument = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument();
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers((IDocument)internalDocument, hasHoverCapabilities));
    }

    @Test
    public void testSingletonLS() throws Exception {
        IFile testFile1 = TestUtils.createFile(this.project, "shouldUseSingletonLS.lsp-singletonLS", "");
        IDocument document1 = LSPEclipseUtils.getDocument((IResource)testFile1);
        Assert.assertNotNull((Object)document1);
        List languageServers = LanguageServiceAccessor.getLSWrappers((IFile)LSPEclipseUtils.getFile((IDocument)document1), MATCH_ALL);
        IProject project2 = TestUtils.createProject("project2");
        IFile testFile2 = TestUtils.createFile(project2, "shouldUseSingletonLS2.lsp-singletonLS", "");
        IDocument document2 = LSPEclipseUtils.getDocument((IResource)testFile2);
        Assert.assertNotNull((Object)document2);
        List languageServers2 = LanguageServiceAccessor.getLSWrappers((IFile)LSPEclipseUtils.getFile((IDocument)document2), MATCH_ALL);
        Assert.assertEquals((long)1L, (long)languageServers.size());
        Assert.assertEquals((Object)languageServers, (Object)languageServers2);
    }
}

