/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.inlayhint;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.operations.inlayhint.InlayHintProvider;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.InlayHintRegistrationOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class LSPLineContentCodeMining
extends LineContentCodeMining {
    private InlayHint inlayHint;
    private final LanguageServerWrapper wrapper;
    private IDocument document;
    private Point location;
    private FontData[] fontData;

    public LSPLineContentCodeMining(InlayHint inlayHint, IDocument document, LanguageServerWrapper languageServerWrapper, InlayHintProvider provider) throws BadLocationException {
        super(LSPLineContentCodeMining.toPosition(inlayHint.getPosition(), document), (ICodeMiningProvider)provider);
        this.inlayHint = inlayHint;
        this.wrapper = languageServerWrapper;
        this.document = document;
        this.setLabel(LSPLineContentCodeMining.getInlayHintString(inlayHint));
    }

    protected static @Nullable String getInlayHintString(@NonNull InlayHint inlayHint) {
        Either label = inlayHint.getLabel();
        return (String)label.map(Function.identity(), parts -> {
            if (parts == null) {
                return null;
            }
            return parts.stream().map(InlayHintLabelPart::getValue).collect(Collectors.joining());
        });
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        if (this.wrapper.isActive() && LSPLineContentCodeMining.canResolveInlayHint(this.wrapper.getServerCapabilities())) {
            return this.wrapper.execute(ls -> ls.getTextDocumentService().resolveInlayHint(this.inlayHint).thenAcceptAsync(resolvedInlayHint -> {
                this.inlayHint = resolvedInlayHint;
                if (resolvedInlayHint != null) {
                    this.setLabel(LSPLineContentCodeMining.getInlayHintString(resolvedInlayHint));
                }
            }));
        }
        return CompletableFuture.completedFuture(null);
    }

    private static boolean canResolveInlayHint(ServerCapabilities capabilities) {
        Either inlayProvider = capabilities.getInlayHintProvider();
        if (inlayProvider != null && inlayProvider.isRight()) {
            InlayHintRegistrationOptions options = (InlayHintRegistrationOptions)inlayProvider.getRight();
            return options.getResolveProvider() != null && options.getResolveProvider() != false;
        }
        return false;
    }

    private static org.eclipse.jface.text.Position toPosition(Position position, IDocument document) throws BadLocationException {
        int start = LSPEclipseUtils.toOffset(position, document);
        return new org.eclipse.jface.text.Position(start, 1);
    }

    public final Consumer<MouseEvent> getAction() {
        return me -> {
            String title = this.getLabel();
            if (title != null && !title.isEmpty()) {
                this.findLabelPart((MouseEvent)me).map(InlayHintLabelPart::getCommand).ifPresent(command -> {
                    ExecuteCommandOptions provider = this.wrapper.getServerCapabilities().getExecuteCommandProvider();
                    String commandId = command.getCommand();
                    if (provider != null && provider.getCommands().contains(commandId)) {
                        LanguageServers.LanguageServerDocumentExecutor.forDocument(this.document).computeAll((w, ls) -> {
                            if (w == this.wrapper) {
                                return ls.getWorkspaceService().executeCommand(new ExecuteCommandParams(commandId, command.getArguments()));
                            }
                            return CompletableFuture.completedFuture(null);
                        });
                    } else {
                        CommandExecutor.executeCommandClientSide(command, this.document);
                    }
                });
            }
        };
    }

    private Optional<InlayHintLabelPart> findLabelPart(MouseEvent me) {
        if (this.inlayHint.getLabel().isRight()) {
            List labelParts = (List)this.inlayHint.getLabel().getRight();
            if (labelParts.size() == 1) {
                return Optional.of((InlayHintLabelPart)labelParts.get(0));
            }
            if (this.location != null && this.fontData != null) {
                Point relativeLocation = new Point(me.x - this.location.x, me.y - this.location.y);
                Display display = Display.getCurrent();
                Image image = null;
                GC gc = null;
                Font font = null;
                try {
                    image = new Image((Device)display, 1, 1);
                    gc = new GC((Drawable)image);
                    font = new Font((Device)display, this.fontData);
                    gc.setFont(font);
                    Point origin = new Point(0, 0);
                    for (InlayHintLabelPart labelPart : labelParts) {
                        Point size = gc.stringExtent(labelPart.getValue());
                        Rectangle bounds = new Rectangle(origin.x, origin.y, size.x, size.y);
                        if (bounds.contains(relativeLocation)) {
                            Optional<InlayHintLabelPart> optional = Optional.of(labelPart);
                            return optional;
                        }
                        origin.x += size.x;
                    }
                }
                finally {
                    if (font != null && !font.isDisposed()) {
                        font.dispose();
                    }
                    if (gc != null && !gc.isDisposed()) {
                        gc.dispose();
                    }
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                }
            }
        }
        return Optional.empty();
    }

    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        this.location = new Point(x, y);
        Point size = super.draw(gc, textWidget, color, x, y);
        this.fontData = gc.getFont().getFontData();
        return size;
    }
}

