/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Test;

public class FormatTest
extends AbstractTestWithProject {
    @Test
    public void testFormattingInvalidDocument() throws Exception {
        LSPFormatter formatter = new LSPFormatter();
        ITextSelection selection = TextSelection.emptySelection();
        Optional edits = (Optional)formatter.requestFormatting((IDocument)new Document(), selection).get();
        Assert.assertTrue((boolean)edits.isEmpty());
    }

    @Test
    public void testFormattingNoChanges() throws Exception {
        MockLanguageServer.INSTANCE.setFormattingTextEdits(Collections.emptyList());
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LSPFormatter formatter = new LSPFormatter();
        ISelection selection = viewer.getSelectionProvider().getSelection();
        Optional edits = (Optional)formatter.requestFormatting(viewer.getDocument(), (ITextSelection)selection).get();
        Assert.assertTrue((boolean)edits.isPresent());
        editor.getSite().getShell().getDisplay().syncExec(() -> {
            try {
                ((VersionedEdits)edits.get()).apply();
            }
            catch (ConcurrentModificationException | BadLocationException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        ITextEditor textEditor = (ITextEditor)editor;
        textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        Assert.assertEquals((Object)"Formatting Other Text", (Object)viewer.getDocument().get());
        TestUtils.closeEditor(editor, false);
    }

    @Test
    public void testFormatting() throws Exception {
        ArrayList<TextEdit> formattingTextEdits = new ArrayList<TextEdit>();
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 1)), "MyF"));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 10), new Position(0, 11)), ""));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 21), new Position(0, 21)), " Second"));
        MockLanguageServer.INSTANCE.setFormattingTextEdits(formattingTextEdits);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LSPFormatter formatter = new LSPFormatter();
        ISelection selection = viewer.getSelectionProvider().getSelection();
        Optional edits = (Optional)formatter.requestFormatting(viewer.getDocument(), (ITextSelection)selection).get();
        Assert.assertTrue((boolean)edits.isPresent());
        editor.getSite().getShell().getDisplay().syncExec(() -> {
            try {
                ((VersionedEdits)edits.get()).apply();
            }
            catch (ConcurrentModificationException | BadLocationException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        ITextEditor textEditor = (ITextEditor)editor;
        textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        Assert.assertEquals((Object)"MyFormattingOther Text Second", (Object)viewer.getDocument().get());
        TestUtils.closeEditor(editor, false);
    }

    @Test
    public void testOutdatedFormatting() throws CoreException, InterruptedException, ExecutionException, BadLocationException {
        MockLanguageServer.INSTANCE.setFormattingTextEdits(Collections.emptyList());
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LSPFormatter formatter = new LSPFormatter();
        ISelection selection = viewer.getSelectionProvider().getSelection();
        Optional edits = (Optional)formatter.requestFormatting(viewer.getDocument(), (ITextSelection)selection).get();
        Assert.assertTrue((boolean)edits.isPresent());
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        Assert.assertThrows(ConcurrentModificationException.class, () -> ((VersionedEdits)edits.get()).apply());
        TestUtils.closeEditor(editor, false);
    }
}

