/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.cdi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.InsertAnnotationMissingQuickFix;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ReplaceAnnotationProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.cdi.Constants;

public class ManagedBeanQuickFix
extends InsertAnnotationMissingQuickFix {
    private static final Logger LOGGER = Logger.getLogger(ManagedBeanQuickFix.class.getName());
    private static final String[] REMOVE_ANNOTATION_NAMES = new ArrayList<String>(Constants.SCOPES).toArray(new String[Constants.SCOPES.size()]);

    public ManagedBeanQuickFix() {
        super("jakarta.enterprise.context.Dependent");
    }

    @Override
    public String getParticipantId() {
        return ManagedBeanQuickFix.class.getName();
    }

    @Override
    protected ICodeActionId getCodeActionId() {
        return JakartaCodeActionId.CDIReplaceScopeAnnotations;
    }

    @Override
    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions) throws CoreException {
        String[] annotations;
        String[] stringArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            this.insertAnnotation(diagnostic, context, codeActions, annotation);
            ++n2;
        }
    }

    protected void insertAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions, String annotation) throws CoreException {
        String name = ManagedBeanQuickFix.getLabel(annotation);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(name);
        codeAction.setRelevance(0);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put("annotation", Arrays.asList(annotation));
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), this.getCodeActionId()));
        codeActions.add(codeAction);
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        ASTNode parentNode = context.getASTRoot().findDeclaringNode(parentType);
        IBinding classBinding = this.getBinding(parentNode);
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        List resolveAnnotations = (List)data.getExtendedDataEntry("annotation");
        String[] resolveAnnotationsArray = (String[])resolveAnnotations.toArray(String[]::new);
        if (resolveAnnotationsArray.length == 1) {
            String annotation = resolveAnnotationsArray[0];
            String name = ManagedBeanQuickFix.getLabel(annotation);
            ReplaceAnnotationProposal proposal = new ReplaceAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), classBinding, 0, annotation, REMOVE_ANNOTATION_NAMES);
            try {
                toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "Unable to create workspace edit for code action to insert missing annotation", e);
            }
        }
        return toResolve;
    }

    private static String getLabel(String annotation) {
        String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
        return Messages.getMessage("ReplaceCurrentScope", "@" + annotationName);
    }
}

