/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.persistence.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.persistence.ErrorCode;

public class PersistenceMapKeyDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            Range range;
            String matchedAnnotation;
            IAnnotation annotation;
            int n3;
            int n4;
            IAnnotation[] iAnnotationArray;
            IAnnotation[] allAnnotations;
            boolean hasMapKeyClassAnnotation;
            boolean hasMapKeyAnnotation;
            ArrayList<IAnnotation> mapKeyJoinCols;
            IMethod[] methods;
            IType type = iTypeArray[n2];
            IMethod[] iMethodArray = methods = type.getMethods();
            int n5 = methods.length;
            int n6 = 0;
            while (n6 < n5) {
                IMethod method = iMethodArray[n6];
                mapKeyJoinCols = new ArrayList<IAnnotation>();
                hasMapKeyAnnotation = false;
                hasMapKeyClassAnnotation = false;
                iAnnotationArray = allAnnotations = method.getAnnotations();
                n4 = allAnnotations.length;
                n3 = 0;
                while (n3 < n4) {
                    annotation = iAnnotationArray[n3];
                    matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_PERSISTENCE_ANNOTATIONS);
                    if (matchedAnnotation != null) {
                        if ("jakarta.persistence.MapKey".equals(matchedAnnotation)) {
                            hasMapKeyAnnotation = true;
                        } else if ("jakarta.persistence.MapKeyClass".equals(matchedAnnotation)) {
                            hasMapKeyClassAnnotation = true;
                        } else if ("jakarta.persistence.MapKeyJoinColumn".equals(matchedAnnotation)) {
                            mapKeyJoinCols.add(annotation);
                        }
                    }
                    ++n3;
                }
                if (hasMapKeyAnnotation && hasMapKeyClassAnnotation) {
                    range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("MapKeyAnnotationsNotOnSameMethod", new Object[0]), range, "jakarta-persistence", null, ErrorCode.InvalidMapKeyAnnotationsOnSameMethod, DiagnosticSeverity.Error));
                }
                if (mapKeyJoinCols.size() > 1) {
                    this.validateMapKeyJoinColumnAnnotations(context, uri, mapKeyJoinCols, (IMember)method, unit, diagnostics);
                }
                ++n6;
            }
            IField[] fields = type.getFields();
            iMethodArray = fields;
            n5 = fields.length;
            n6 = 0;
            while (n6 < n5) {
                IMethod field = iMethodArray[n6];
                mapKeyJoinCols = new ArrayList();
                hasMapKeyAnnotation = false;
                hasMapKeyClassAnnotation = false;
                iAnnotationArray = allAnnotations = field.getAnnotations();
                n4 = allAnnotations.length;
                n3 = 0;
                while (n3 < n4) {
                    annotation = iAnnotationArray[n3];
                    matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_PERSISTENCE_ANNOTATIONS);
                    if (matchedAnnotation != null) {
                        if ("jakarta.persistence.MapKey".equals(matchedAnnotation)) {
                            hasMapKeyAnnotation = true;
                        } else if ("jakarta.persistence.MapKeyClass".equals(matchedAnnotation)) {
                            hasMapKeyClassAnnotation = true;
                        } else if ("jakarta.persistence.MapKeyJoinColumn".equals(matchedAnnotation)) {
                            mapKeyJoinCols.add(annotation);
                        }
                    }
                    ++n3;
                }
                if (hasMapKeyAnnotation && hasMapKeyClassAnnotation) {
                    range = PositionUtils.toNameRange((IField)field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("MapKeyAnnotationsNotOnSameField", new Object[0]), range, "jakarta-persistence", null, ErrorCode.InvalidMapKeyAnnotationsOnSameField, DiagnosticSeverity.Error));
                }
                if (mapKeyJoinCols.size() > 1) {
                    this.validateMapKeyJoinColumnAnnotations(context, uri, mapKeyJoinCols, (IMember)field, unit, diagnostics);
                }
                ++n6;
            }
            ++n2;
        }
        return diagnostics;
    }

    private void validateMapKeyJoinColumnAnnotations(JavaDiagnosticsContext context, String uri, List<IAnnotation> annotations, IMember element, ICompilationUnit unit, List<Diagnostic> diagnostics) throws CoreException {
        annotations.forEach(annotation -> {
            try {
                Range range = null;
                String message = null;
                ErrorCode errorCode = null;
                if (element instanceof IMethod) {
                    range = PositionUtils.toNameRange((IMethod)element, context.getUtils());
                    errorCode = ErrorCode.InvalidMethodWithMultipleMPJCAnnotations;
                    message = Messages.getMessage("MultipleMapKeyJoinColumnMethod", new Object[0]);
                } else {
                    range = PositionUtils.toNameRange((IField)element, context.getUtils());
                    errorCode = ErrorCode.InvalidFieldWithMultipleMPJCAnnotations;
                    message = Messages.getMessage("MultipleMapKeyJoinColumnField", new Object[0]);
                }
                List<IMemberValuePair> memberValues = Arrays.asList(annotation.getMemberValuePairs());
                boolean allNamesSpecified = memberValues.stream().anyMatch(mv -> mv.getMemberName().equals("name"));
                boolean allReferencedColumnNameSpecified = memberValues.stream().anyMatch(mv -> mv.getMemberName().equals("referencedColumnName"));
                if (!allNamesSpecified || !allReferencedColumnNameSpecified) {
                    diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-persistence", null, errorCode, DiagnosticSeverity.Error));
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Error while retrieving member values of @MapKeyJoinColumn Annotation", e);
            }
        });
    }
}

