/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.websocket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.TypeHierarchyUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.websocket.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.websocket.ErrorCode;

public class WebSocketDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        HashMap<String, Boolean> checkWSEnd = null;
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            checkWSEnd = this.isWSEndpoint(type);
            if (checkWSEnd.get("isAnnotation").booleanValue()) {
                this.invalidParamsCheck(context, uri, type, unit, diagnostics);
                List<String> endpointPathVars = this.findAndProcessEndpointURI(type);
                if (endpointPathVars != null) {
                    this.uriMismatchWarningCheck(context, uri, type, endpointPathVars, diagnostics, unit);
                }
                this.onMessageWSMessageFormats(context, uri, type, diagnostics, unit);
                this.serverEndpointErrorCheck(context, uri, type, diagnostics, unit);
            }
            ++n2;
        }
        return diagnostics;
    }

    private void invalidParamsCheck(JavaDiagnosticsContext context, String uri, IType type, ICompilationUnit unit, List<Diagnostic> diagnostics) throws JavaModelException {
        IMethod[] allMethods;
        IMethod[] iMethodArray = allMethods = type.getMethods();
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation[] allAnnotations = method.getAnnotations();
            Set<String> specialParamTypes = null;
            Set<String> rawSpecialParamTypes = null;
            IAnnotation[] iAnnotationArray = allAnnotations;
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                String annotationName = annotation.getElementName();
                ErrorCode diagnosticErrorCode = null;
                if (DiagnosticUtils.isMatchedJavaElement(type, annotationName, "jakarta.websocket.OnOpen")) {
                    specialParamTypes = Constants.ON_OPEN_PARAM_OPT_TYPES;
                    rawSpecialParamTypes = Constants.RAW_ON_OPEN_PARAM_OPT_TYPES;
                    diagnosticErrorCode = ErrorCode.InvalidOnOpenParams;
                } else if (DiagnosticUtils.isMatchedJavaElement(type, annotationName, "jakarta.websocket.OnClose")) {
                    specialParamTypes = Constants.ON_CLOSE_PARAM_OPT_TYPES;
                    rawSpecialParamTypes = Constants.RAW_ON_CLOSE_PARAM_OPT_TYPES;
                    diagnosticErrorCode = ErrorCode.InvalidOnCloseParams;
                }
                if (diagnosticErrorCode != null) {
                    ILocalVariable[] allParams;
                    ILocalVariable[] iLocalVariableArray = allParams = method.getParameters();
                    int n5 = allParams.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAnnotation[] param_annotations;
                        boolean hasPathParamAnnot;
                        boolean isPrimWrapped;
                        boolean isSpecialType;
                        ILocalVariable param = iLocalVariableArray[n6];
                        String signature = param.getTypeSignature();
                        String formatSignature = signature.replace("/", ".");
                        String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)formatSignature, (IType)type);
                        boolean isPrimitive = JavaModelUtil.isPrimitive((String)formatSignature);
                        if (resolvedTypeName != null) {
                            isSpecialType = specialParamTypes.contains(resolvedTypeName);
                            isPrimWrapped = this.isWrapper(resolvedTypeName);
                        } else {
                            String simpleParamType = Signature.getSignatureSimpleName((String)signature);
                            isSpecialType = rawSpecialParamTypes.contains(simpleParamType);
                            isPrimWrapped = this.isWrapper(simpleParamType);
                        }
                        if (!(isSpecialType || isPrimWrapped || isPrimitive)) {
                            Range range = PositionUtils.toNameRange(param, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, this.createParamTypeDiagMsg(specialParamTypes, annotationName), range, "jakarta-websocket", null, diagnosticErrorCode, DiagnosticSeverity.Error));
                        } else if (!isSpecialType && !(hasPathParamAnnot = Arrays.asList(param_annotations = param.getAnnotations()).stream().anyMatch(annot -> {
                            try {
                                return DiagnosticUtils.isMatchedJavaElement(type, annot.getElementName(), "jakarta.websocket.server.PathParam");
                            }
                            catch (JavaModelException e) {
                                JakartaCorePlugin.logException("Failed to get matched annotation", e);
                                return false;
                            }
                        }))) {
                            Range range = PositionUtils.toNameRange(param, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("PathParamsAnnotationMissing", new Object[0]), range, "jakarta-websocket", null, ErrorCode.PathParamsMissingFromParam, DiagnosticSeverity.Error));
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void uriMismatchWarningCheck(JavaDiagnosticsContext context, String uri, IType type, List<String> endpointPathVars, List<Diagnostic> diagnostics, ICompilationUnit unit) throws JavaModelException {
        IMethod[] typeMethods;
        IMethod[] iMethodArray = typeMethods = type.getMethods();
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable[] methodParams;
            IMethod method = iMethodArray[n2];
            ILocalVariable[] iLocalVariableArray = methodParams = method.getParameters();
            int n3 = methodParams.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation[] paramAnnotations;
                ILocalVariable param = iLocalVariableArray[n4];
                IAnnotation[] iAnnotationArray = paramAnnotations = param.getAnnotations();
                int n5 = paramAnnotations.length;
                int n6 = 0;
                while (n6 < n5) {
                    IAnnotation annotation = iAnnotationArray[n6];
                    if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.websocket.server.PathParam")) {
                        IMemberValuePair[] valuePairs;
                        IMemberValuePair[] iMemberValuePairArray = valuePairs = annotation.getMemberValuePairs();
                        int n7 = valuePairs.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            String pathValue;
                            IMemberValuePair pair = iMemberValuePairArray[n8];
                            if (pair.getMemberName().equals("value") && pair.getValueKind() == 9 && !endpointPathVars.contains(pathValue = (String)pair.getValue())) {
                                Range range = PositionUtils.toNameRange(annotation, context.getUtils());
                                diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("PathParamWarning", new Object[0]), range, "jakarta-websocket", null, ErrorCode.PathParamDoesNotMatchEndpointURI, DiagnosticSeverity.Warning));
                            }
                            ++n8;
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void onMessageWSMessageFormats(JavaDiagnosticsContext context, String uri, IType type, List<Diagnostic> diagnostics, ICompilationUnit unit) throws JavaModelException {
        IMethod[] typeMethods = type.getMethods();
        IAnnotation onMessageTextUsed = null;
        IAnnotation onMessageBinaryUsed = null;
        IAnnotation onMessagePongUsed = null;
        IMethod[] iMethodArray = typeMethods;
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation[] allAnnotations;
            IMethod method = iMethodArray[n2];
            IAnnotation[] iAnnotationArray = allAnnotations = method.getAnnotations();
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.websocket.OnMessage")) {
                    ILocalVariable[] allParams;
                    ILocalVariable[] iLocalVariableArray = allParams = method.getParameters();
                    int n5 = allParams.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ILocalVariable param = iLocalVariableArray[n6];
                        if (!this.isParamPath(type, param)) {
                            String signature = param.getTypeSignature();
                            String formatSignature = signature.replace("/", ".");
                            String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)formatSignature, (IType)type);
                            String typeName = null;
                            if (resolvedTypeName == null) {
                                typeName = Signature.getSignatureSimpleName((String)signature);
                            }
                            if (resolvedTypeName != null && Constants.LONG_MESSAGE_CLASSES.contains(resolvedTypeName) || Constants.SHORT_MESSAGE_CLASSES.contains(typeName)) {
                                Constants.MESSAGE_FORMAT messageFormat = resolvedTypeName != null ? this.getMessageFormat(resolvedTypeName, true) : this.getMessageFormat(typeName, false);
                                switch (messageFormat) {
                                    case TEXT: {
                                        Range range;
                                        if (onMessageTextUsed != null) {
                                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnMessageDuplicateMethod", new Object[0]), range, "jakarta-websocket", null, ErrorCode.OnMessageDuplicateMethod, DiagnosticSeverity.Error));
                                            range = PositionUtils.toNameRange(onMessageTextUsed, context.getUtils());
                                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnMessageDuplicateMethod", new Object[0]), range, "jakarta-websocket", null, ErrorCode.OnMessageDuplicateMethod, DiagnosticSeverity.Error));
                                        }
                                        onMessageTextUsed = annotation;
                                        break;
                                    }
                                    case BINARY: {
                                        Range range;
                                        if (onMessageBinaryUsed != null) {
                                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnMessageDuplicateMethod", new Object[0]), range, "jakarta-websocket", null, ErrorCode.OnMessageDuplicateMethod, DiagnosticSeverity.Error));
                                            range = PositionUtils.toNameRange(onMessageBinaryUsed, context.getUtils());
                                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnMessageDuplicateMethod", new Object[0]), range, "jakarta-websocket", null, ErrorCode.OnMessageDuplicateMethod, DiagnosticSeverity.Error));
                                        }
                                        onMessageBinaryUsed = annotation;
                                        break;
                                    }
                                    case PONG: {
                                        Range range;
                                        if (onMessagePongUsed != null) {
                                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnMessageDuplicateMethod", new Object[0]), range, "jakarta-websocket", null, ErrorCode.OnMessageDuplicateMethod, DiagnosticSeverity.Error));
                                            range = PositionUtils.toNameRange(onMessagePongUsed, context.getUtils());
                                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("OnMessageDuplicateMethod", new Object[0]), range, "jakarta-websocket", null, ErrorCode.OnMessageDuplicateMethod, DiagnosticSeverity.Error));
                                        }
                                        onMessagePongUsed = annotation;
                                    }
                                }
                            }
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void serverEndpointErrorCheck(JavaDiagnosticsContext context, String uri, IType type, List<Diagnostic> diagnostics, ICompilationUnit unit) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.websocket.server.ServerEndpoint")) {
                IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                int n3 = iMemberValuePairArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair annotationMemberValuePair = iMemberValuePairArray[n4];
                    if (annotationMemberValuePair.getMemberName().equals("value")) {
                        Range range;
                        String path = annotationMemberValuePair.getValue().toString();
                        if (!DiagnosticUtils.hasLeadingSlash(path)) {
                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ServerEndpointNoSlash", new Object[0]), range, "jakarta-websocket", null, ErrorCode.InvalidEndpointPathWithNoStartingSlash, DiagnosticSeverity.Error));
                        }
                        if (this.hasRelativePathURIs(path)) {
                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ServerEndpointRelative", new Object[0]), range, "jakarta-websocket", null, ErrorCode.InvalidEndpointPathWithRelativePaths, DiagnosticSeverity.Error));
                        } else if (!DiagnosticUtils.isValidLevel1URI(path)) {
                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ServerEndpointNotLevel1", new Object[0]), range, "jakarta-websocket", null, ErrorCode.InvalidEndpointPathNotTempleateOrPartialURI, DiagnosticSeverity.Error));
                        }
                        if (this.hasDuplicateURIVariables(path)) {
                            range = PositionUtils.toNameRange(annotation, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ServerEndpointDuplicateVar", new Object[0]), range, "jakarta-websocket", null, ErrorCode.InvalidEndpointPathDuplicateVariable, DiagnosticSeverity.Error));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private List<String> findAndProcessEndpointURI(IType type) throws JavaModelException {
        String[] endpointParts;
        String endpointURI = null;
        IAnnotation[] typeAnnotations = type.getAnnotations();
        String[] targetAnnotations = new String[]{"jakarta.websocket.server.ServerEndpoint", "jakarta.websocket.ClientEndpoint"};
        IAnnotation[] iAnnotationArray = typeAnnotations;
        int n = typeAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), targetAnnotations);
            if (matchedAnnotation != null) {
                IMemberValuePair[] valuePairs;
                IMemberValuePair[] iMemberValuePairArray = valuePairs = annotation.getMemberValuePairs();
                int n3 = valuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair pair = iMemberValuePairArray[n4];
                    if (pair.getMemberName().equals("value") && pair.getValueKind() == 9) {
                        endpointURI = (String)pair.getValue();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (endpointURI == null) {
            return null;
        }
        ArrayList<String> endpointPathVars = new ArrayList<String>();
        String[] stringArray = endpointParts = endpointURI.split("/");
        int n5 = endpointParts.length;
        int n6 = 0;
        while (n6 < n5) {
            String part = stringArray[n6];
            if (part.startsWith("{") && part.endsWith("}")) {
                endpointPathVars.add(part.substring(1, part.length() - 1));
            }
            ++n6;
        }
        return endpointPathVars;
    }

    private boolean isWrapper(String valueClass) {
        return Constants.WRAPPER_OBJS.contains(valueClass) || Constants.RAW_WRAPPER_OBJS.contains(valueClass);
    }

    private HashMap<String, Boolean> isWSEndpoint(IType type) throws JavaModelException {
        HashMap<String, Boolean> wsEndpoint = new HashMap<String, Boolean>();
        if (!type.isClass()) {
            wsEndpoint.put("isAnnotation", false);
            wsEndpoint.put("isSuperclass", false);
            return wsEndpoint;
        }
        List<String> endpointAnnotations = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(type.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), Constants.WS_ANNOTATION_CLASS);
        boolean useSuperclass = false;
        try {
            useSuperclass = TypeHierarchyUtils.doesITypeHaveSuperType(type, "Endpoint") >= 0;
        }
        catch (CoreException e) {
            JakartaCorePlugin.logException("Cannot calculate WebSocket diagnostics", e);
        }
        wsEndpoint.put("isAnnotation", endpointAnnotations.size() > 0);
        wsEndpoint.put("isSuperclass", useSuperclass);
        return wsEndpoint;
    }

    private boolean isParamPath(IType type, ILocalVariable param) throws JavaModelException {
        IAnnotation[] allVariableAnnotations;
        IAnnotation[] iAnnotationArray = allVariableAnnotations = param.getAnnotations();
        int n = allVariableAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation variableAnnotation = iAnnotationArray[n2];
            if (DiagnosticUtils.isMatchedJavaElement(type, variableAnnotation.getElementName(), "jakarta.websocket.server.PathParam")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Constants.MESSAGE_FORMAT getMessageFormat(String typeName, boolean longName) {
        block38: {
            if (!longName) break block38;
            switch (typeName) {
                case "java.lang.String": {
                    return Constants.MESSAGE_FORMAT.TEXT;
                }
                case "java.io.Reader": {
                    return Constants.MESSAGE_FORMAT.TEXT;
                }
                case "java.nio.ByteBuffer": {
                    return Constants.MESSAGE_FORMAT.BINARY;
                }
                case "java.io.InputStream": {
                    return Constants.MESSAGE_FORMAT.BINARY;
                }
                case "jakarta.websocket.PongMessage": {
                    return Constants.MESSAGE_FORMAT.PONG;
                }
            }
            throw new IllegalArgumentException("Invalid message format type");
        }
        switch (typeName) {
            case "String": {
                return Constants.MESSAGE_FORMAT.TEXT;
            }
            case "Reader": {
                return Constants.MESSAGE_FORMAT.TEXT;
            }
            case "ByteBuffer": {
                return Constants.MESSAGE_FORMAT.BINARY;
            }
            case "InputStream": {
                return Constants.MESSAGE_FORMAT.BINARY;
            }
            case "PongMessage": {
                return Constants.MESSAGE_FORMAT.PONG;
            }
        }
        throw new IllegalArgumentException("Invalid message format type");
    }

    private String createParamTypeDiagMsg(Set<String> methodParamOptTypes, String methodAnnotTarget) {
        String paramMessage = String.join((CharSequence)"\n- ", methodParamOptTypes);
        return Messages.getMessage("WebSocketParamType", "@" + methodAnnotTarget, paramMessage);
    }

    private boolean hasRelativePathURIs(String uriString) {
        return uriString.matches(".*\\/\\.{0,2}\\/.*");
    }

    private boolean hasDuplicateURIVariables(String uriString) {
        HashSet<String> variables = new HashSet<String>();
        String[] stringArray = uriString.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.matches("\\{(\\w|-|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+\\}")) {
                String variable = segment.substring(1, segment.length() - 1);
                if (variables.contains(variable)) {
                    return true;
                }
                variables.add(variable);
            }
            ++n2;
        }
        return false;
    }
}

