/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.hover;

import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.hover.IJavaHoverParticipant;
import org.eclipse.lsp4mp.jdt.core.java.hover.JavaHoverContext;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationMemberInfo;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class PropertiesHoverParticipant
implements IJavaHoverParticipant {
    private final String annotationName;
    private final String defaultValueAnnotationMemberName;
    private final String[] annotationMembers;
    private Function<String, String> propertyReplacer;

    public PropertiesHoverParticipant(String annotationName, String annotationMemberName) {
        this(annotationName, annotationMemberName, null);
    }

    public PropertiesHoverParticipant(String annotationName, String annotationMemberName, String defaultValueAnnotationMemberName) {
        this(annotationName, new String[]{annotationMemberName}, defaultValueAnnotationMemberName);
    }

    public PropertiesHoverParticipant(String annotationName, String[] annotationMembers, String defaultValueAnnotationMemberName) {
        this.annotationName = annotationName;
        this.annotationMembers = annotationMembers;
        this.defaultValueAnnotationMemberName = defaultValueAnnotationMemberName;
    }

    public PropertiesHoverParticipant(String annotationName, String[] annotationMembers, String defaultValueAnnotationMemberName, Function<String, String> propertyReplacer) {
        this(annotationName, annotationMembers, defaultValueAnnotationMemberName);
        this.propertyReplacer = propertyReplacer;
    }

    @Override
    public boolean isAdaptedForHover(JavaHoverContext context, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, this.annotationName) != null;
    }

    @Override
    public Hover collectHover(JavaHoverContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement hoverElement = context.getHoverElement();
        if (!this.isAdaptableFor(hoverElement)) {
            return null;
        }
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaProject javaProject = typeRoot.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        IJDTUtils utils = context.getUtils();
        Position hoverPosition = context.getHoverPosition();
        IAnnotatable hoverField = (IAnnotatable)hoverElement;
        IAnnotation annotation = AnnotationUtils.getFirstAnnotation(hoverField, this.annotationName);
        if (annotation == null) {
            return null;
        }
        AnnotationMemberInfo annotationMemberInfo = AnnotationUtils.getAnnotationMemberAt(annotation, this.annotationMembers, hoverPosition, typeRoot, utils);
        if (annotationMemberInfo == null) {
            return null;
        }
        String annotationMemberValue = annotationMemberInfo.getMemberValue();
        Range propertyKeyRange = annotationMemberInfo.getRange();
        if (this.propertyReplacer != null) {
            annotationMemberValue = this.propertyReplacer.apply(annotationMemberValue);
        }
        JDTMicroProfileProject mpProject = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject);
        List<MicroProfileConfigPropertyInformation> propertyInformation = PropertiesHoverParticipant.getConfigPropertyInformation(annotationMemberValue, annotation, this.defaultValueAnnotationMemberName, typeRoot, mpProject, utils);
        return new Hover(PropertiesHoverParticipant.getDocumentation(propertyInformation, context.getDocumentFormat(), context.isSurroundEqualsWithSpaces()), propertyKeyRange);
    }

    protected boolean isAdaptableFor(IJavaElement hoverElement) {
        return hoverElement.getElementType() == 8 || hoverElement.getElementType() == 14;
    }

    private static List<MicroProfileConfigPropertyInformation> getConfigPropertyInformation(String propertyKey, IAnnotation annotation, String defaultValueAnnotationMemberName, ITypeRoot typeRoot, JDTMicroProfileProject project, IJDTUtils utils) throws JavaModelException {
        List<MicroProfileConfigPropertyInformation> infos = project.getPropertyInformations(propertyKey);
        boolean defaultProfileDefined = false;
        for (MicroProfileConfigPropertyInformation info : infos) {
            if (!info.getPropertyNameWithProfile().equals(propertyKey)) continue;
            defaultProfileDefined = true;
        }
        if (defaultValueAnnotationMemberName != null && !defaultProfileDefined) {
            infos.add(new MicroProfileConfigPropertyInformation(propertyKey, AnnotationUtils.getAnnotationMemberValue(annotation, defaultValueAnnotationMemberName), utils.toUri(typeRoot), annotation.getResource().getName()));
        }
        return infos;
    }

    private static MarkupContent getDocumentation(List<MicroProfileConfigPropertyInformation> propertyInformation, DocumentFormat documentFormat, boolean insertSpacing) {
        StringBuilder content = new StringBuilder();
        boolean markdown = DocumentFormat.Markdown.equals((Object)documentFormat);
        PropertiesHoverParticipant.buildDocumentation(propertyInformation, markdown, insertSpacing, content);
        return new MarkupContent(markdown ? "markdown" : "plaintext", content.toString());
    }

    private static void buildDocumentation(List<MicroProfileConfigPropertyInformation> propertyInformation, boolean markdownSupported, boolean insertSpacing, StringBuilder content) {
        for (MicroProfileConfigPropertyInformation info : propertyInformation) {
            if (content.length() > 0) {
                content.append("  \n");
            }
            if (markdownSupported) {
                content.append("`");
            }
            content.append(info.getPropertyNameWithProfile());
            if (info.getValue() == null) {
                if (markdownSupported) {
                    content.append("`");
                }
                content.append(" is not set");
                continue;
            }
            if (insertSpacing) {
                content.append(" = ");
            } else {
                content.append("=");
            }
            content.append(info.getValue());
            if (markdownSupported) {
                content.append("`");
            }
            if (info.getConfigFileName() == null) continue;
            content.append(" ");
            if (markdownSupported) {
                content.append("*");
            }
            content.append("in");
            if (markdownSupported) {
                content.append("*");
            }
            content.append(" ");
            String href = info.getSourceConfigFileURI();
            if (markdownSupported && href != null) {
                content.append("[");
            }
            content.append(info.getConfigFileName());
            if (!markdownSupported || href == null) continue;
            content.append("]");
            content.append("(");
            content.append(href);
            content.append(")");
        }
    }
}

