/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.servers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.OverlaySelfComponent;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers.length == 0) {
            return;
        }
        IResourceDelta[] projectDeltas = delta.getAffectedChildren();
        if (projectDeltas == null || projectDeltas.length == 0) {
            return;
        }
        Set<IProject> changedProjects = this.getChangedProjects(projectDeltas);
        if (changedProjects.isEmpty()) {
            return;
        }
        HashSet<IServer> republishableServers = new HashSet<IServer>(servers.length);
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            IModule[] iModuleArray = server.getModules();
            int n3 = iModuleArray.length;
            int n4 = 0;
            block1: while (n4 < n3) {
                IModule module = iModuleArray[n4];
                IProject moduleProject = module.getProject();
                for (IProject changedProject : changedProjects) {
                    if (!this.hasOverlayChanged(changedProject, moduleProject, delta)) continue;
                    republishableServers.add(server);
                    break block1;
                }
                ++n4;
            }
            ++n2;
        }
        for (IServer server : republishableServers) {
            server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean isEnabled() {
        boolean isEnabled = new InstanceScope().getNode("org.eclipse.m2e.wtp.overlay").getBoolean("republishOnProjectChange", true);
        return isEnabled;
    }

    private Set<IProject> getChangedProjects(IResourceDelta[] projectDeltas) {
        HashSet<IProject> projects = new HashSet<IProject>();
        if (projectDeltas != null) {
            IResourceDelta[] iResourceDeltaArray = projectDeltas;
            int n = projectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IResource resource = delta.getResource();
                if (resource != null && resource instanceof IProject) {
                    projects.add((IProject)resource);
                }
                ++n2;
            }
        }
        return projects;
    }

    private boolean hasOverlayChanged(IProject changedProject, IProject projectDeployedOnServer, IResourceDelta delta) {
        if (!ModuleCoreNature.isFlexibleProject((IProject)projectDeployedOnServer)) {
            return false;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)projectDeployedOnServer);
        if (component == null) {
            return false;
        }
        IVirtualReference[] references = component.getReferences();
        if (references == null || references.length == 0) {
            return false;
        }
        IVirtualReference[] iVirtualReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference reference = iVirtualReferenceArray[n2];
            IVirtualComponent vc = reference.getReferencedComponent();
            if (vc instanceof IOverlayVirtualComponent) {
                IPath componentFilePath;
                IProject overlaidProject = vc.getProject();
                if (vc instanceof OverlaySelfComponent ? delta.findMember(componentFilePath = overlaidProject.getFile(".settings/org.eclipse.wst.common.component").getFullPath()) != null : !vc.isBinary() && overlaidProject.equals((Object)changedProject)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

