/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.earmodules;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.earmodules.AbstractEarModule;
import org.eclipse.m2e.wtp.earmodules.AppClientModule;
import org.eclipse.m2e.wtp.earmodules.ArtifactRepository;
import org.eclipse.m2e.wtp.earmodules.ArtifactTypeMappingService;
import org.eclipse.m2e.wtp.earmodules.EarModule;
import org.eclipse.m2e.wtp.earmodules.EarPluginException;
import org.eclipse.m2e.wtp.earmodules.EjbClientModule;
import org.eclipse.m2e.wtp.earmodules.EjbModule;
import org.eclipse.m2e.wtp.earmodules.HarModule;
import org.eclipse.m2e.wtp.earmodules.JarModule;
import org.eclipse.m2e.wtp.earmodules.ParModule;
import org.eclipse.m2e.wtp.earmodules.RarModule;
import org.eclipse.m2e.wtp.earmodules.SarModule;
import org.eclipse.m2e.wtp.earmodules.UnknownArtifactTypeException;
import org.eclipse.m2e.wtp.earmodules.WebModule;
import org.eclipse.m2e.wtp.earmodules.WsrModule;
import org.eclipse.m2e.wtp.namemapping.FileNameMapping;
import org.eclipse.m2e.wtp.namemapping.FileNameMappingFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EarModuleFactory {
    private ArtifactTypeMappingService artifactTypeMappingService;
    private FileNameMapping fileNameMapping;
    private ArtifactRepository artifactRepository;

    private EarModuleFactory(ArtifactTypeMappingService artifactTypeMappingService, FileNameMapping fileNameMapping, ArtifactRepository artifactRepository) {
        this.artifactTypeMappingService = artifactTypeMappingService;
        this.artifactRepository = artifactRepository;
        this.fileNameMapping = fileNameMapping;
    }

    public static EarModuleFactory createEarModuleFactory(ArtifactTypeMappingService artifactTypeMappingService, FileNameMapping fileNameMapping, String mainArtifactId, Set<Artifact> artifacts) throws EarPluginException {
        if (artifactTypeMappingService == null) {
            artifactTypeMappingService = new ArtifactTypeMappingService(null);
        }
        if (fileNameMapping == null) {
            fileNameMapping = FileNameMappingFactory.getDefaultFileNameMapping();
        }
        ArtifactRepository artifactRepository = new ArtifactRepository(artifacts, mainArtifactId, artifactTypeMappingService);
        return new EarModuleFactory(artifactTypeMappingService, fileNameMapping, artifactRepository);
    }

    public EarModule newEarModule(Artifact artifact, String defaultLibBundleDir, IProjectFacetVersion javaEEVersion, boolean defaultIncludeInApplicationXml) throws UnknownArtifactTypeException {
        String artifactType = this.artifactTypeMappingService.getStandardType(artifact.getType());
        AbstractEarModule earModule = null;
        if ("jar".equals(artifactType)) {
            earModule = new JarModule(artifact);
            ((JarModule)earModule).setIncludeInApplicationXml(defaultIncludeInApplicationXml);
            ((JarModule)earModule).setLibBundleDir(defaultLibBundleDir);
        } else if ("ejb".equals(artifactType) || "ejb3".equals(artifactType)) {
            earModule = new EjbModule(artifact);
        } else if ("par".equals(artifactType)) {
            earModule = new ParModule(artifact);
        } else if ("ejb-client".equals(artifactType)) {
            earModule = new EjbClientModule(artifact);
            if (javaEEVersion.compareTo((Object)IJ2EEFacetConstants.ENTERPRISE_APPLICATION_14) > 0) {
                ((EjbClientModule)earModule).setLibBundleDir(defaultLibBundleDir);
            }
        } else if ("rar".equals(artifactType)) {
            earModule = new RarModule(artifact);
        } else if ("war".equals(artifactType)) {
            earModule = new WebModule(artifact);
        } else if ("sar".equals(artifactType)) {
            earModule = new SarModule(artifact);
        } else if ("wsr".equals(artifactType)) {
            earModule = new WsrModule(artifact);
        } else if ("har".equals(artifactType)) {
            earModule = new HarModule(artifact);
        } else if ("app-client".equals(artifactType)) {
            earModule = new AppClientModule(artifact);
        } else {
            throw new IllegalStateException("Could not handle artifact type[" + artifactType + "]");
        }
        earModule.setBundleFileName(this.fileNameMapping.mapFileName(artifact));
        return earModule;
    }

    public EarModule newEarModule(Xpp3Dom domModule, String defaultLibBundleDir, IProjectFacetVersion javaEEVersion, boolean defaultIncludeInApplicationXml) throws EarPluginException {
        String bundleFileName;
        String artifactType = domModule.getName();
        String groupId = DomUtils.getChildValue(domModule, "groupId");
        String artifactId = DomUtils.getChildValue(domModule, "artifactId");
        String classifier = DomUtils.getChildValue(domModule, "classifier");
        AbstractEarModule earModule = null;
        if ("jarModule".equals(artifactType) || "javaModule".equals(artifactType)) {
            JarModule jarModule = new JarModule();
            jarModule.setBundleDir(defaultLibBundleDir);
            if (domModule.getChild("includeInApplicationXml") == null) {
                jarModule.setIncludeInApplicationXml(defaultIncludeInApplicationXml);
            } else {
                jarModule.setIncludeInApplicationXml(DomUtils.getBooleanChildValue(domModule, "includeInApplicationXml"));
            }
            earModule = jarModule;
        } else if ("ejbModule".equals(artifactType) || "ejb3Module".equals(artifactType)) {
            earModule = new EjbModule();
        } else if ("webModule".equals(artifactType)) {
            WebModule webModule = new WebModule();
            webModule.setContextRoot(DomUtils.getChildValue(domModule, "contextRoot"));
            earModule = webModule;
        } else if ("parModule".equals(artifactType)) {
            earModule = new ParModule();
        } else if ("ejbClientModule".equals(artifactType)) {
            earModule = new EjbClientModule();
            if (javaEEVersion.compareTo((Object)IJ2EEFacetConstants.ENTERPRISE_APPLICATION_14) > 0) {
                ((EjbClientModule)earModule).setLibBundleDir(defaultLibBundleDir);
            }
        } else if ("rarModule".equals(artifactType)) {
            earModule = new RarModule();
        } else if ("warModule".equals(artifactType)) {
            earModule = new WebModule();
        } else if ("sarModule".equals(artifactType)) {
            earModule = new SarModule();
        } else if ("wsrModule".equals(artifactType)) {
            earModule = new WsrModule();
        } else if ("harModule".equals(artifactType)) {
            earModule = new HarModule();
        } else if ("appClientModule".equals(artifactType)) {
            earModule = new AppClientModule();
        } else {
            throw new IllegalStateException("Could not handle artifact type[" + artifactType + "]");
        }
        Artifact artifact = this.artifactRepository.resolveArtifact(groupId, artifactId, earModule.getType(), classifier);
        earModule.setArtifact(artifact);
        String bundleDir = DomUtils.getChildValue(domModule, "bundleDir");
        if (StringUtils.isNotBlank((String)bundleDir)) {
            earModule.setBundleDir(bundleDir);
        }
        if ((bundleFileName = DomUtils.getChildValue(domModule, "bundleFileName")) == null) {
            bundleFileName = this.fileNameMapping.mapFileName(artifact);
        }
        earModule.setBundleFileName(bundleFileName);
        earModule.setUri(DomUtils.getChildValue(domModule, "uri"));
        earModule.setExcluded(DomUtils.getBooleanChildValue(domModule, "excluded"));
        earModule.setAltDeploymentDescriptor(DomUtils.getChildValue(domModule, "altDeploymentDescriptor"));
        String unpack = DomUtils.getChildValue(domModule, "unpack");
        earModule.setShouldUnpack(unpack == null ? null : Boolean.valueOf(unpack));
        return earModule;
    }
}

