/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.internal.browser.QueryBrowserProvider;
import org.eclipse.mat.ui.util.IPolicy;
import org.eclipse.mat.ui.util.PaneState;

public class QueryRegistryProvider
extends QueryBrowserProvider {
    IQueryContext context;
    CategoryDescriptor category;
    IPolicy policy;

    public QueryRegistryProvider(IQueryContext context, CategoryDescriptor c, IPolicy policy) {
        this.context = context;
        this.category = c;
        this.policy = policy;
    }

    @Override
    public QueryBrowserPopup.Element[] getElements() {
        List queries = this.category.getQueries();
        ArrayList<CQQElement> answer = new ArrayList<CQQElement>(queries.size());
        for (QueryDescriptor query : queries) {
            if (!query.accept(this.context) || !this.policy.accept(query) || QueryRegistryProvider.unsuitableSubjects(query, this.context)) continue;
            answer.add(new CQQElement(query));
        }
        return answer.toArray(new QueryBrowserPopup.Element[0]);
    }

    @Override
    public String getName() {
        String name = this.category.getFullName();
        if (name == null) {
            name = Messages.QueryRegistryProvider_Uncategorized;
        }
        return name;
    }

    class CQQElement
    implements QueryBrowserPopup.Element {
        String label;
        QueryDescriptor query;

        public CQQElement(QueryDescriptor query) {
            this.query = query;
        }

        @Override
        public void execute(MultiPaneEditor editor) throws SnapshotException {
            if (QueryRegistryProvider.this.policy != null) {
                ArgumentSet set = this.query.createNewArgumentSet(editor.getQueryContext());
                ISnapshot snapshot = (ISnapshot)editor.getQueryContext().get(ISnapshot.class, null);
                QueryRegistryProvider.this.policy.fillInObjectArguments(snapshot, this.query, set);
                AbstractEditorPane active = editor.getActiveEditor();
                PaneState ps = active != null ? active.getPaneState() : null;
                QueryExecution.execute(editor, ps, null, set, !this.query.isShallow(), false);
            } else {
                QueryExecution.executeQuery(editor, this.query);
            }
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return MemoryAnalyserPlugin.getDefault().getImageDescriptor(this.query);
        }

        @Override
        public String getLabel() {
            if (this.label == null) {
                StringBuilder b = new StringBuilder(128).append(this.query.getName());
                String shortDescription = this.query.getShortDescription();
                if (shortDescription != null) {
                    b.append("  -  ").append(shortDescription);
                }
                this.label = b.toString();
            }
            return this.label;
        }

        @Override
        public String getUsage() {
            return this.query.getUsage(QueryRegistryProvider.this.context);
        }

        @Override
        public QueryDescriptor getQuery() {
            return this.query;
        }
    }
}

