/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.miniocl.lookup.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.qvtd.doc.miniocl.NamedElement;
import org.eclipse.qvtd.doc.miniocl.lookup.LookupEnvironment;
import org.eclipse.qvtd.doc.miniocl.lookup.impl.LookupEnvironmentImpl;
import org.eclipse.qvtd.doc.miniocl.lookup.util.MiniOCLLookupFilter;

public class MiniOCLSingleResultLookupEnvironment
extends LookupEnvironmentImpl {
    private @NonNull Executor executor;
    private @NonNull String name;
    private @NonNull EClass typeFilter;
    private @Nullable MiniOCLLookupFilter expFilter;

    public MiniOCLSingleResultLookupEnvironment(@NonNull Executor executor, @NonNull EClass typeFilter, @NonNull String name, @Nullable MiniOCLLookupFilter expFilter) {
        this.executor = executor;
        this.name = name;
        this.typeFilter = typeFilter;
        this.expFilter = expFilter;
    }

    public MiniOCLSingleResultLookupEnvironment(@NonNull Executor executor, @NonNull EClass typeFilter, @NonNull String name) {
        this(executor, typeFilter, name, null);
    }

    @Override
    public @NonNull Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean hasFinalResult() {
        for (NamedElement element : this.getNamedElements()) {
            if (!this.name.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull LookupEnvironment addElements(@Nullable NamedElement namedElement) {
        EList<NamedElement> elements;
        MiniOCLLookupFilter expFilter2;
        if (namedElement != null && this.name.equals(namedElement.getName()) && this.typeFilter.isInstance((Object)namedElement) && ((expFilter2 = this.expFilter) == null || expFilter2.matches(namedElement)) && !(elements = this.getNamedElements()).contains(namedElement)) {
            elements.add(namedElement);
        }
        return this;
    }

    @Override
    public <NE extends NamedElement> @NonNull LookupEnvironment addElements(@Nullable Collection<NE> namedElements) {
        if (namedElements != null) {
            for (NamedElement namedElement : namedElements) {
                this.addElements(namedElement);
            }
        }
        return this;
    }

    public <NE extends NamedElement> List<NE> getNamedElementsByKind(Class<NE> class_) {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        for (NamedElement namedElement : this.getNamedElements()) {
            if (!class_.isAssignableFrom(namedElement.getClass())) continue;
            result.add(namedElement);
        }
        return result;
    }
}

