/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

public class LocateInExplorerAction
implements IObjectActionDelegate,
IViewActionDelegate {
    private boolean _ignoreWorkbenchPartSite;
    private IWorkbenchPartSite _site;

    protected Object getFirstSelectedElement(ISelection selection_p) {
        if (selection_p.isEmpty() || !(selection_p instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection_p;
        return structuredSelection.getFirstElement();
    }

    protected ISelection getSelection() {
        return this._site != null ? this._site.getSelectionProvider().getSelection() : StructuredSelection.EMPTY;
    }

    public void init(IViewPart view_p) {
        this._site = view_p.getSite();
    }

    public void run(IAction action_p) {
        ISelection selection;
        if ((this._ignoreWorkbenchPartSite || this._site != null) && (selection = this.getSelection()) instanceof IStructuredSelection) {
            Object uiSelectedElement = this.getFirstSelectedElement(selection);
            Object elementToSelectInModelExplorer = null;
            if (uiSelectedElement instanceof ItemWrapper) {
                uiSelectedElement = ((ItemWrapper)uiSelectedElement).getWrappedObject();
            }
            if ((elementToSelectInModelExplorer = uiSelectedElement instanceof DRepresentation ? uiSelectedElement : LocateInExplorerAction.getElement(uiSelectedElement)) instanceof EObject || elementToSelectInModelExplorer instanceof DRepresentation) {
                this.selectElementInModelExplorer((ISelection)new StructuredSelection(elementToSelectInModelExplorer));
            }
        }
    }

    protected void selectElementInModelExplorer(ISelection selection_p) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ProjectExplorer explorerView = (ProjectExplorer)activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (explorerView == null) {
                explorerView = (ProjectExplorer)activePage.showView("org.eclipse.ui.navigator.ProjectExplorer");
            }
            explorerView.selectReveal(selection_p);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
    }

    public void setActivePart(IAction action_p, IWorkbenchPart targetPart_p) {
        this._site = targetPart_p.getSite();
    }

    public void setSite(IWorkbenchPartSite site_p) {
        this._site = site_p;
    }

    public void shouldIgnoreWorkbenchPartSite(boolean ignore_p) {
        this._ignoreWorkbenchPartSite = ignore_p;
    }

    public static Object getElement(Object uiSelectedElement_p) {
        Object result = null;
        if (uiSelectedElement_p == null) {
            return result;
        }
        if (uiSelectedElement_p instanceof EObject) {
            result = uiSelectedElement_p;
        } else if (uiSelectedElement_p instanceof GraphicalEditPart) {
            GraphicalEditPart editPart = (GraphicalEditPart)uiSelectedElement_p;
            result = editPart.getModel();
            if (result instanceof View) {
                View view = (View)result;
                result = view.getElement();
            }
            if (result instanceof DSemanticDecorator && !(result instanceof DSemanticDiagram)) {
                DSemanticDecorator semanticDecorator = (DSemanticDecorator)result;
                result = semanticDecorator.getTarget();
            }
        } else if (uiSelectedElement_p instanceof DSemanticDecorator && !(uiSelectedElement_p instanceof DSemanticDiagram)) {
            DSemanticDecorator semanticDecorator = (DSemanticDecorator)uiSelectedElement_p;
            result = semanticDecorator.getTarget();
        }
        return result;
    }
}

