/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.PhantomManager;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBug560861 {
    private Comparison comparison;
    private CompareConfiguration cc;
    private EMFCompareConfiguration emfcc;
    private PhantomManager phantomManager;
    private boolean mirrored;

    @Before
    public void setUp() throws IOException {
        Bug560861InputData inputData = new Bug560861InputData();
        Resource left = inputData.getResource("left.nodes");
        Resource right = inputData.getResource("right.nodes");
        Notifier origin = null;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, origin);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.cc = new CompareConfiguration();
        this.emfcc = new EMFCompareConfiguration(this.cc);
    }

    @Test
    public void testSideBeforeSwappingLeftAndRight() {
        this.mirrored = false;
        this.cc.setProperty("MIRRORED", (Object)this.mirrored);
        Match match = (Match)((Match)this.comparison.getMatches().get(0)).getSubmatches().get(0);
        this.phantomManager = new PhantomManager(this.emfcc, null, null, null, null);
        IMergeViewer.MergeViewerSide phantomSide = this.phantomManager.getTargetSide(match, null);
        Assert.assertFalse((boolean)this.emfcc.isMirrored());
        Assert.assertEquals((Object)phantomSide, (Object)IMergeViewer.MergeViewerSide.RIGHT);
    }

    @Test
    public void testSideAfterSwappingLeftAndRight() {
        this.mirrored = true;
        this.cc.setProperty("MIRRORED", (Object)this.mirrored);
        Match match = (Match)((Match)this.comparison.getMatches().get(0)).getSubmatches().get(0);
        this.phantomManager = new PhantomManager(this.emfcc, null, null, null, null);
        IMergeViewer.MergeViewerSide phantomSide = this.phantomManager.getTargetSide(match, null);
        Assert.assertTrue((boolean)this.emfcc.isMirrored());
        Assert.assertEquals((Object)phantomSide, (Object)IMergeViewer.MergeViewerSide.LEFT);
    }

    public class Bug560861InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_560861/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

