/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.rental;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RentalCarSize implements Enumerator
{
    SMALL(0, "Small", "Small"),
    MEDIUM(1, "Medium", "Medium"),
    FAMILY(2, "Family", "Family");

    public static final int SMALL_VALUE = 0;
    public static final int MEDIUM_VALUE = 1;
    public static final int FAMILY_VALUE = 2;
    private static final RentalCarSize[] VALUES_ARRAY;
    public static final List<RentalCarSize> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RentalCarSize[]{SMALL, MEDIUM, FAMILY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RentalCarSize get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RentalCarSize result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RentalCarSize getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RentalCarSize result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RentalCarSize get(int value) {
        switch (value) {
            case 0: {
                return SMALL;
            }
            case 1: {
                return MEDIUM;
            }
            case 2: {
                return FAMILY;
            }
        }
        return null;
    }

    private RentalCarSize(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

