/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipse.genxml;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.teneo.eclipse.StoreEclipseException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunGenerateJob
extends WorkspaceJob
implements IJavaLaunchConfigurationConstants {
    private static final String CONFIGURATION_NAME = "Teneo OR-Mapping Generation";
    private final ArrayList<IJavaProject> jProjects;
    private final String[] ecores;
    private final String targetFileName;
    private final String mainClass;
    private final HashMap<String, String> options;

    public RunGenerateJob(ArrayList<IJavaProject> jProjects, String[] ecores, String targetFileName, String mainClass, HashMap<String, String> options) {
        super("Generate Mapping File");
        this.jProjects = jProjects;
        this.ecores = ecores;
        this.targetFileName = targetFileName;
        this.mainClass = mainClass;
        this.options = options;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration[] configurations;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations = manager.getLaunchConfigurations(type);
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration element = iLaunchConfigurationArray[n2];
            if (element.getName().compareTo(CONFIGURATION_NAME) == 0) {
                element.delete();
            }
            ++n2;
        }
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, CONFIGURATION_NAME);
        ArrayList<String> classPath = this.determineClassPath();
        workingCopy.setAttribute(ATTR_DEFAULT_CLASSPATH, false);
        workingCopy.setAttribute(ATTR_CLASSPATH, classPath);
        workingCopy.setAttribute(ATTR_MAIN_TYPE_NAME, this.mainClass);
        workingCopy.setAttribute(ATTR_PROJECT_NAME, this.jProjects.get(0).getProject().getName());
        workingCopy.setAttribute(ATTR_PROGRAM_ARGUMENTS, this.getProgramArguments());
        workingCopy.doSave();
        workingCopy.launch("run", null);
        return Status.OK_STATUS;
    }

    private ArrayList<String> determineClassPath() throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.jProjects.size()) {
            IJavaProject jProject = this.jProjects.get(i);
            IRuntimeClasspathEntry outputEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)jProject);
            result.add(outputEntry.getMemento());
            ++i;
        }
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        IRuntimeClasspathEntry systemLibsEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
        result.add(systemLibsEntry.getMemento());
        return result;
    }

    private String getEPackageNames() {
        try {
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < this.jProjects.size()) {
                IJavaProject ijp = this.jProjects.get(i);
                int j = 0;
                while (j < ijp.getPackageFragmentRoots().length) {
                    IPackageFragmentRoot ipf = ijp.getPackageFragmentRoots()[j];
                    if (!ipf.getClass().getName().endsWith("JarPackageFragmentRoot") && ipf.exists()) {
                        int c = 0;
                        while (c < ipf.getChildren().length) {
                            this.walk(ipf.getChildren()[c], "", result);
                            ++c;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            StringBuffer resultStr = new StringBuffer();
            int i2 = 0;
            while (i2 < result.size()) {
                String epackage = (String)result.get(i2);
                if (i2 > 0) {
                    resultStr.append(",");
                }
                resultStr.append(epackage);
                ++i2;
            }
            return resultStr.toString();
        }
        catch (Exception e) {
            throw new StoreEclipseException("Exception while looking for epackages in projects " + e.getMessage(), e);
        }
    }

    private void walk(IJavaElement ije, String pName, ArrayList<String> result) throws Exception {
        if (ije.getClass().getName().endsWith("JarPackageFragmentRoot")) {
            return;
        }
        if (!(ije instanceof IPackageFragment)) {
            return;
        }
        IPackageFragment pf = (IPackageFragment)ije;
        String packageName = String.valueOf(pName) + (pName.length() > 0 ? "." : "") + pf.getElementName();
        int c = 0;
        while (c < pf.getChildren().length) {
            IJavaElement child = pf.getChildren()[c];
            if (child instanceof IPackageFragment) {
                this.walk(child, packageName, result);
            } else if (child instanceof ICompilationUnit) {
                String[] types;
                ICompilationUnit icu = (ICompilationUnit)child;
                String[] stringArray = types = icu.getTypes()[0].getSuperInterfaceNames();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    if (element.compareTo("EPackage") == 0) {
                        result.add(String.valueOf(packageName) + "." + icu.getTypes()[0].getElementName());
                        return;
                    }
                    ++n2;
                }
                if (icu.getTypes()[0].getSuperclassName() != null && icu.getTypes()[0].getSuperclassName().equals("EPackageImpl")) {
                    result.add(String.valueOf(packageName) + "." + icu.getTypes()[0].getElementName());
                    return;
                }
            }
            ++c;
        }
    }

    private String getProgramArguments() {
        StringBuffer args = new StringBuffer();
        this.append(args, this.targetFileName);
        for (String key : this.options.keySet()) {
            this.append(args, "+" + key + "," + this.options.get(key));
        }
        String[] stringArray = this.ecores;
        int n = this.ecores.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.append(args, element);
            ++n2;
        }
        this.append(args, "-" + this.getEPackageNames());
        return args.toString();
    }

    private void append(StringBuffer buffer, String value) {
        buffer.append("\"" + value + "\" ");
    }
}

