/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.AbstractProcessingContext;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.AssociationOverride;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.annotations.pannotation.SecondaryTable;
import org.eclipse.emf.teneo.annotations.pannotation.Table;
import org.eclipse.emf.teneo.annotations.pannotation.UniqueConstraint;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionInitializable;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractMapper;
import org.eclipse.emf.teneo.hibernate.mapper.BasicMapper;
import org.eclipse.emf.teneo.hibernate.mapper.EmbeddedMapper;
import org.eclipse.emf.teneo.hibernate.mapper.EntityMapper;
import org.eclipse.emf.teneo.hibernate.mapper.FeatureMapMapping;
import org.eclipse.emf.teneo.hibernate.mapper.FeatureMapper;
import org.eclipse.emf.teneo.hibernate.mapper.IdMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyAttributeMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyExternalReferenceMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyToManyMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyToOneMapper;
import org.eclipse.emf.teneo.hibernate.mapper.OneToManyMapper;
import org.eclipse.emf.teneo.hibernate.mapper.OneToOneMapper;
import org.eclipse.emf.teneo.hibernate.mapper.TypedEReferenceMapper;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.mapping.strategy.SQLNameStrategy;
import org.eclipse.emf.teneo.simpledom.Document;
import org.eclipse.emf.teneo.simpledom.Element;

public class MappingContext
extends AbstractProcessingContext
implements ExtensionPoint,
ExtensionInitializable,
ExtensionManagerAware {
    private Document mappingDoc;
    private Element currentElement;
    private Map<EClass, String> entityNames = null;
    private final List<FeatureMapMapping> featureMapMappers = new ArrayList<FeatureMapMapping>();
    private final List<EAttribute> handledFeatureMapEAttributes = new ArrayList<EAttribute>();
    private FeatureMapper featureMapper;
    private boolean currentElementFeatureMap = false;
    private Table currentTable = null;
    private String namePrefix = "";
    private SecondaryTable currentSecondaryTable = null;
    protected EClass currentEClass = null;
    protected EStructuralFeature currentEFeature = null;
    protected PAnnotatedEStructuralFeature currentAFeature = null;
    private EntityMapper entityMapper;
    private ExtensionManager extensionManager;
    private EntityNameStrategy entityNameStrategy = null;
    private String versionColumnName = null;
    private String idColumnName = null;
    protected int maximumSqlNameLength = -1;
    protected SQLNameStrategy sqlNameStrategy;
    protected String escapeCharacter;
    private boolean adaptManualNames = false;
    private boolean forceOptional = false;
    private boolean alwaysVersion;
    private boolean isMapEMapAsTrueMap;
    private String idbagIDColumnName = "ID";
    private PAnnotatedModel paModel = null;
    private int maximumCommentLength = 0;
    private PersistenceOptions persistenceOptions;

    public EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    protected void setMappingProperties(PersistenceOptions po) {
        this.versionColumnName = po.getVersionColumnName();
        this.idColumnName = po.getIdColumnName();
        this.maximumSqlNameLength = po.getMaximumSqlNameLength();
        this.adaptManualNames = po.isAutoAdaptManualSQLNames();
        this.alwaysVersion = po.getAlwaysVersion();
        this.isMapEMapAsTrueMap = po.isMapEMapAsTrueMap();
        this.idbagIDColumnName = po.getIDBagIDColumnName();
        this.maximumCommentLength = po.getMaximumCommentLength();
        this.escapeCharacter = po.getSqlNameEscapeCharacter();
        this.persistenceOptions = po;
    }

    protected String getInstanceClassName(EClass eClass) {
        Class<?> clz = this.getInstanceClass((EClassifier)eClass);
        if (clz != null) {
            return clz.getName();
        }
        log.debug((Object)("Instance class for eclass " + eClass.getName() + " is null "));
        return DynamicEObjectImpl.class.getName();
    }

    protected Class<?> getInstanceClass(EClassifier eclassifier) {
        return EModelResolver.instance().getJavaClass(eclassifier);
    }

    public String getEntityName(EClass entityEClass) {
        return this.getEntityName(entityEClass, true);
    }

    public String getEntityName(EClass entityEClass, boolean throwCheckException) {
        Class<?> implClass;
        String name = this.entityNames.get(entityEClass);
        if (name == null && (implClass = this.getInstanceClass((EClassifier)entityEClass)) != null) {
            name = implClass.getName();
        }
        if (throwCheckException && name == null) {
            throw new IllegalStateException("An entity name has not been registered for " + entityEClass);
        }
        return name;
    }

    public void setEntityName(EClass entityEClass, String entityName) {
        this.entityNames.put(entityEClass, entityName);
    }

    public void beginDocument(Document draft) {
        this.mappingDoc = draft;
        this.currentElement = draft.getRoot();
        this.entityNames = new HashMap<EClass, String>();
    }

    public Document endDocument() {
        Document builtDocument = this.mappingDoc;
        this.mappingDoc = null;
        this.currentElement = null;
        this.entityNames = null;
        return builtDocument;
    }

    public Element getCurrent() {
        return this.currentElement;
    }

    public void setCurrent(Element newCurrent) {
        this.currentElement = newCurrent;
    }

    public String getComponentFeatureMapTuplizer() {
        return "org.eclipse.emf.teneo.hibernate.mapping.elist.FeatureMapEntryComponentTuplizer";
    }

    public List<FeatureMapMapping> getClearFeatureMapMappers() {
        ArrayList<FeatureMapMapping> result = new ArrayList<FeatureMapMapping>(this.featureMapMappers);
        this.featureMapMappers.clear();
        return result;
    }

    public void addFeatureMapMapper(FeatureMapMapping featureMapMapper) {
        if (!this.handledFeatureMapEAttributes.contains(featureMapMapper.getEAttribute())) {
            this.featureMapMappers.add(featureMapMapper);
            this.handledFeatureMapEAttributes.add(featureMapMapper.getEAttribute());
        }
    }

    public void initializeExtension() {
        this.featureMapper = this.createFeatureMapper();
        this.entityMapper = (EntityMapper)this.getExtensionManager().getExtension(EntityMapper.class);
        this.entityMapper.setHbmContext(this);
    }

    private FeatureMapper createFeatureMapper() {
        FeatureMapper featureMapper = (FeatureMapper)this.getExtensionManager().getExtension(FeatureMapper.class);
        featureMapper.setHbmContext(this);
        featureMapper.setBasicMapper(this.createMapper(BasicMapper.class));
        featureMapper.setManyAttributeMapper(this.createMapper(ManyAttributeMapper.class));
        featureMapper.setEmbeddedMapper(this.createMapper(EmbeddedMapper.class));
        featureMapper.setIdMapper(this.createMapper(IdMapper.class));
        featureMapper.setManyToManyMapper(this.createMapper(ManyToManyMapper.class));
        featureMapper.setManyToOneMapper(this.createMapper(ManyToOneMapper.class));
        featureMapper.setOneToManyMapper(this.createMapper(OneToManyMapper.class));
        featureMapper.setOneToOneMapper(this.createMapper(OneToOneMapper.class));
        featureMapper.setManyExternalReferenceMapper(this.createMapper(ManyExternalReferenceMapper.class));
        featureMapper.setTypedEReferenceMapper(this.createMapper(TypedEReferenceMapper.class));
        return featureMapper;
    }

    protected <T> T createMapper(Class<T> clz) {
        Object t = this.getExtensionManager().getExtension(clz);
        ((AbstractMapper)t).setHbmContext(this);
        return (T)t;
    }

    protected void processFeatures(List<PAnnotatedEStructuralFeature> features) {
        for (PAnnotatedEStructuralFeature annotatedEStructuralFeature : features) {
            this.entityMapper.processFeature(annotatedEStructuralFeature);
        }
    }

    public FeatureMapper getFeatureMapper() {
        return this.featureMapper;
    }

    public String getFeatureMapEntryClassName() {
        return "org.eclipse.emf.teneo.hibernate.mapping.elist.HibernateFeatureMapEntry";
    }

    public boolean isCurrentElementFeatureMap() {
        return this.currentElementFeatureMap;
    }

    public void setCurrentElementFeatureMap(boolean currentElementFeatureMap) {
        this.currentElementFeatureMap = currentElementFeatureMap;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(Table currentTable) {
        this.currentTable = currentTable;
    }

    public void setCurrentSecondaryTable(SecondaryTable currentSecondaryTable) {
        this.currentSecondaryTable = currentSecondaryTable;
    }

    public String getUniqueConstraintKey(String colName) {
        EList uniqueConstraints = null;
        if (this.currentSecondaryTable != null) {
            uniqueConstraints = this.currentSecondaryTable.getUniqueConstraints();
        } else if (this.currentTable != null) {
            uniqueConstraints = this.currentTable.getUniqueConstraints();
        }
        if (uniqueConstraints == null) {
            return null;
        }
        String tablePrefix = "c";
        if (this.getPersistenceOptions().isPrefixUniqueConstraintWithTableName()) {
            if (this.currentSecondaryTable != null && this.currentSecondaryTable.getName() != null) {
                tablePrefix = String.valueOf(this.currentSecondaryTable.getName().toLowerCase()) + "_c_";
            } else if (this.currentTable != null && this.currentTable.getName() != null) {
                tablePrefix = String.valueOf(this.currentTable.getName().toLowerCase()) + "_c_";
            }
        }
        String checkColName = colName.toLowerCase();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int n = uniqueConstraints.size();
        while (i < n) {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)uniqueConstraints.get(i);
            for (String uColName : uniqueConstraint.getColumnNames()) {
                if (!uColName.toLowerCase().equals(checkColName)) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(tablePrefix) + i);
            }
            ++i;
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    public void setVersionColumnName(String versionColumnName) {
        this.versionColumnName = versionColumnName;
    }

    public int getMaximumColumnNameLength() {
        return this.maximumSqlNameLength;
    }

    protected boolean doTrunc(PAnnotation pAnnotation) {
        if (this.adaptManualNames) {
            return true;
        }
        return pAnnotation.isGenerated();
    }

    protected String trunc(String name) {
        return this.trunc(null, name, true);
    }

    protected String trunc(String truncName, boolean truncPrefix) {
        return this.trunc(null, truncName, truncPrefix);
    }

    protected String trunc(PAnnotation pAnnotation, String name) {
        return this.trunc(pAnnotation, name, true);
    }

    protected String trunc(PAnnotation pAnnotation, String truncName, boolean truncPrefix) {
        String useName;
        if (pAnnotation != null && !this.doTrunc(pAnnotation)) {
            if (!truncName.startsWith(this.escapeCharacter) && !truncName.endsWith(this.escapeCharacter)) {
                return String.valueOf(this.escapeCharacter) + truncName + this.escapeCharacter;
            }
            return truncName;
        }
        if (this.currentAFeature != null) {
            boolean override = false;
            override = this.currentAFeature instanceof PAnnotatedEAttribute ? this.getAttributeOverride(this.currentAFeature) != null : this.getAssociationOverrides((PAnnotatedEReference)this.currentAFeature) != null;
            String otherEntityName = this.getEntityName(this.currentEFeature.getEContainingClass(), false);
            if (!override && this.currentEFeature.getEContainingClass() != this.currentEClass && otherEntityName != null && truncName.toUpperCase().startsWith(otherEntityName.toUpperCase())) {
                log.debug((Object)("Replacing name of table/joincolumn " + truncName));
                useName = String.valueOf(this.getNamePrefix()) + this.getEntityName(this.currentEClass) + truncName.substring(this.getEntityName(this.currentEFeature.getEContainingClass()).length());
                log.debug((Object)("with " + useName + " because efeature is inherited"));
                log.debug((Object)"This renaming does not work in case of manually specified joincolumn/table names and mappedsuperclass or multiple inheritance!");
            } else {
                useName = String.valueOf(this.getNamePrefix()) + truncName;
            }
        } else {
            useName = String.valueOf(this.getNamePrefix()) + truncName;
        }
        if (this.escapeCharacter.length() > 0 && useName.indexOf(this.escapeCharacter) == 0) {
            return this.getSqlNameStrategy().convert(useName, false);
        }
        return String.valueOf(this.escapeCharacter) + this.getSqlNameStrategy().convert(useName, false) + this.escapeCharacter;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public boolean alwaysVersion() {
        return this.alwaysVersion;
    }

    public List<EAttribute> getHandledFeatureMapEAttributes() {
        return this.handledFeatureMapEAttributes;
    }

    public String getPropertyName(EStructuralFeature ef) {
        return ef.getName();
    }

    public String getSyntheticVersionPropertyHandlerName() {
        return "org.eclipse.emf.teneo.hibernate.mapping.property.VersionPropertyHandler";
    }

    public String getSyntheticIdPropertyHandlerName() {
        return "org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierPropertyHandler";
    }

    public String getPropertyHandlerName() {
        return "";
    }

    public String getVersionPropertyHandlerName() {
        return "";
    }

    public String getIdPropertyHandlerName() {
        return "";
    }

    public String getComponentPropertyHandlerName() {
        return "";
    }

    public boolean isDynamic(EClassifier eclassifier) {
        return !EModelResolver.instance().hasImplementationClass(eclassifier);
    }

    public boolean forceUseOfInstance(PAnnotatedEClass aclass) {
        return false;
    }

    public boolean isGeneratedByEMF() {
        return true;
    }

    public void addTuplizerElement(Element entityElement, PAnnotatedEClass aclass) {
    }

    public String getEnumUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.ENumUserType";
    }

    public String getDurationType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.XSDDuration";
    }

    public String getEnumIntegerUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.ENumUserIntegerType";
    }

    public String getDynamicEnumUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.DynamicENumUserType";
    }

    public String getExternalUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.ExternalType";
    }

    public String getDynamicEnumIntegerUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.DynamicENumUserIntegerType";
    }

    public String getDefaultUserType() {
        return "org.eclipse.emf.teneo.hibernate.mapping.DefaultToStringUserType";
    }

    public String getAnytype() {
        return "org.eclipse.emf.teneo.hibernate.mapping.AnyEObjectType";
    }

    public String getXSDDateUserType() {
        return this.persistenceOptions.getUserXSDDateType();
    }

    public String getXSDTimeUserType() {
        return this.persistenceOptions.getUserXSDTime();
    }

    public String getXSDDateTimeUserType() {
        return this.persistenceOptions.getUserXSDDateTime();
    }

    public EntityNameStrategy getEntityNameStrategy() {
        if (this.entityNameStrategy == null) {
            this.entityNameStrategy = (EntityNameStrategy)this.getExtensionManager().getExtension(EntityNameStrategy.class);
            this.entityNameStrategy.setPaModel(this.getPaModel());
        }
        return this.entityNameStrategy;
    }

    public boolean isMapEMapAsTrueMap() {
        return this.isMapEMapAsTrueMap;
    }

    public EClass getCurrentEClass() {
        return this.currentEClass;
    }

    public void setCurrentEClass(EClass currentEClass) {
        this.currentEClass = currentEClass;
    }

    public EStructuralFeature getCurrentEFeature() {
        return this.currentEFeature;
    }

    public void setCurrentFeature(PAnnotatedEStructuralFeature currentFeature) {
        this.currentAFeature = currentFeature;
        this.currentEFeature = currentFeature == null ? null : currentFeature.getModelEStructuralFeature();
    }

    public String getIdbagIDColumnName() {
        return this.idbagIDColumnName;
    }

    public boolean isDoForceOptional(PAnnotatedEStructuralFeature aFeature) {
        boolean hasSecondaryTable;
        boolean bl = hasSecondaryTable = this.getSecondaryTableName(aFeature) != null;
        return !hasSecondaryTable && this.forceOptional;
    }

    public void setForceOptional(boolean forceOptional) {
        this.forceOptional = forceOptional;
    }

    public PAnnotatedModel getPaModel() {
        return this.paModel;
    }

    public void setPaModel(PAnnotatedModel paModel) {
        this.paModel = paModel;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public SQLNameStrategy getSqlNameStrategy() {
        if (this.sqlNameStrategy == null) {
            this.sqlNameStrategy = (SQLNameStrategy)this.getExtensionManager().getExtension(SQLNameStrategy.class);
        }
        return this.sqlNameStrategy;
    }

    public int getMaximumCommentLength() {
        return this.maximumCommentLength;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public PersistenceOptions getPersistenceOptions() {
        return this.persistenceOptions;
    }

    public String getSecondaryTableName(PAnnotatedEStructuralFeature pef) {
        String tableName = null;
        if (pef instanceof PAnnotatedEAttribute) {
            PAnnotatedEAttribute pea = (PAnnotatedEAttribute)pef;
            Column c = this.getAttributeOverride((PAnnotatedEStructuralFeature)pea);
            if (c == null) {
                c = pef.getColumn();
            }
            if (c != null) {
                tableName = c.getTable();
            }
        } else {
            PAnnotatedEReference per = (PAnnotatedEReference)pef;
            this.pushOverrideOnStack();
            this.addAttributeOverrides(per.getAttributeOverrides());
            this.addAssociationOverrides(per.getAssociationOverrides());
            try {
                if (per.getEmbedded() != null) {
                    EClass eClass = per.getModelEReference().getEReferenceType();
                    for (EAttribute ea : eClass.getEAllAttributes()) {
                        Column c = this.getAttributeOverride(ea.getName());
                        if (c == null || c.getTable() == null) continue;
                        String string = c.getTable();
                        return string;
                    }
                    for (EReference er : eClass.getEAllReferences()) {
                        tableName = this.tableNameFromAssociationOverride(er.getName());
                        if (tableName == null) continue;
                        String string = tableName;
                        return string;
                    }
                } else {
                    tableName = this.tableNameFromAssociationOverride(per.getModelEReference().getName());
                    if (tableName != null) {
                        String string = tableName;
                        return string;
                    }
                    if (!per.getJoinColumns().isEmpty()) {
                        for (JoinColumn jc : per.getJoinColumns()) {
                            if (jc.getTable() == null) continue;
                            String string = jc.getTable();
                            return string;
                        }
                    }
                }
            }
            finally {
                this.popOverrideStack();
            }
        }
        return tableName;
    }

    public String tableNameFromAssociationOverride(String name) {
        block3: {
            AssociationOverride override;
            block4: {
                override = this.getAssociationOverrides(name);
                if (override == null) break block3;
                if (override.getJoinTable() != null && override.getJoinTable().getName() != null) {
                    return override.getJoinTable().getName();
                }
                if (override.getJoinTable() == null || override.getJoinTable().getJoinColumns().size() <= 0) break block4;
                for (JoinColumn jc : override.getJoinTable().getJoinColumns()) {
                    if (jc.getTable() == null) continue;
                    return jc.getTable();
                }
                break block3;
            }
            if (override.getJoinColumns().size() <= 0) break block3;
            for (JoinColumn jc : override.getJoinColumns()) {
                if (jc.getTable() == null) continue;
                return jc.getTable();
            }
        }
        return null;
    }
}

