/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.eav;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVDelegatingEcoreEList;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVMultiValueHolder;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVValueHolder;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class EAVPropertyHandler
implements Getter,
Setter,
PropertyAccess,
PropertyAccessStrategy,
ExtensionPoint {
    private static final long serialVersionUID = -3712366809398761331L;
    private HbDataStore hbDataStore = null;

    public PropertyAccess buildPropertyAccess(Class containerJavaType, String propertyName) {
        return this;
    }

    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this;
    }

    public void setPropertyAccessStrategy(PropertyAccessStrategy propertyAccessStrategy) {
    }

    public Getter getGetter() throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter() throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        EObject eOwner = (EObject)owner;
        for (Adapter adapter : eOwner.eAdapters()) {
            if (!(adapter instanceof EAVObjectAdapter)) continue;
            EAVObjectAdapter eavAdapter = (EAVObjectAdapter)adapter;
            return eavAdapter.getValueList();
        }
        EAVObjectAdapter eavAdapter = new EAVObjectAdapter();
        eavAdapter.setTarget((Notifier)eOwner);
        List<EAVValueHolder> valueList = this.createValueList(eOwner);
        this.fillTargetObject(eOwner, valueList);
        eavAdapter.setValueList(valueList);
        eOwner.eAdapters().add((Object)eavAdapter);
        return valueList;
    }

    public Object getForInsert(Object owner, Map mergeMap, SharedSessionContractImplementor session) throws HibernateException {
        return this.get(owner);
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        EObject eOwner = (EObject)target;
        for (Adapter adapter : eOwner.eAdapters()) {
            if (!(adapter instanceof EAVObjectAdapter)) continue;
            EAVObjectAdapter eavAdapter = (EAVObjectAdapter)adapter;
            eavAdapter.setValueList((List)value);
            return;
        }
        this.fillTargetObject((EObject)target, (List)value);
        EAVObjectAdapter eavAdapter = new EAVObjectAdapter();
        eavAdapter.setTarget((Notifier)eOwner);
        eavAdapter.setValueList((List)value);
        eOwner.eAdapters().add((Object)eavAdapter);
    }

    public Method getMethod() {
        return null;
    }

    public Member getMember() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return InternalEObject.class;
    }

    private List<EAVValueHolder> createValueList(EObject target) {
        ArrayList<EAVValueHolder> valueHolders = new ArrayList<EAVValueHolder>();
        for (EStructuralFeature eFeature : target.eClass().getEAllStructuralFeatures()) {
            if (eFeature.isDerived() || eFeature.isTransient() || eFeature.isVolatile()) continue;
            EAVValueHolder valueHolder = EAVValueHolder.create(target, eFeature, this.hbDataStore);
            valueHolder.set(target.eGet(eFeature));
            if (eFeature.isUnsettable()) {
                valueHolder.setValueIsSet(target.eIsSet(eFeature));
            }
            valueHolders.add(valueHolder);
        }
        return valueHolders;
    }

    private void fillTargetObject(EObject target, List<EAVValueHolder> valueList) {
        for (EAVValueHolder valueHolder : valueList) {
            valueHolder.setValueInOwner((InternalEObject)target);
        }
    }

    public HbDataStore getHbDataStore() {
        return this.hbDataStore;
    }

    public void setHbDataStore(HbDataStore hbDataStore) {
        this.hbDataStore = hbDataStore;
    }

    private static class EAVObjectAdapter
    implements Adapter {
        private Notifier target;
        private List<EAVValueHolder> valueList;

        private EAVObjectAdapter() {
        }

        public Notifier getTarget() {
            return this.target;
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }

        public List<EAVValueHolder> getValueList() {
            return this.valueList;
        }

        public void setValueList(List<EAVValueHolder> valueList) {
            this.valueList = valueList;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        private EAVValueHolder getValueHolder(EStructuralFeature eFeature) {
            for (EAVValueHolder valueHolder : this.valueList) {
                if (valueHolder.getEStructuralFeature() != eFeature) continue;
                return valueHolder;
            }
            return null;
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature eFeature = (EStructuralFeature)notification.getFeature();
            EAVValueHolder valueHolder = this.getValueHolder(eFeature);
            EAVMultiValueHolder multiValueHolder = null;
            List list = null;
            if (valueHolder instanceof EAVMultiValueHolder) {
                list = (List)valueHolder.getValue();
                multiValueHolder = (EAVMultiValueHolder)valueHolder;
            }
            if (valueHolder == null) {
                return;
            }
            Object currentEMFValue = valueHolder.getOwner().eGet(eFeature);
            if (currentEMFValue instanceof EAVDelegatingEcoreEList) {
                return;
            }
            int repairFromIndex = -1;
            switch (notification.getEventType()) {
                case 3: {
                    if (notification.getPosition() != -1) {
                        repairFromIndex = notification.getPosition();
                        list.add(notification.getPosition(), multiValueHolder.getElement(notification.getNewValue()));
                        break;
                    }
                    repairFromIndex = list.size();
                    list.add(multiValueHolder.getElement(notification.getNewValue()));
                    break;
                }
                case 5: {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (Object o : (List)notification.getNewValue()) {
                        values.add(multiValueHolder.getElement(o));
                    }
                    if (notification.getPosition() != -1) {
                        repairFromIndex = notification.getPosition();
                        list.addAll(notification.getPosition(), values);
                        break;
                    }
                    repairFromIndex = list.size();
                    list.addAll(values);
                    break;
                }
                case 4: {
                    int removeIndex = notification.getPosition();
                    if (removeIndex == -1) {
                        Object oldValue = notification.getOldValue();
                        for (Object o : list) {
                            EAVValueHolder elemValue = (EAVValueHolder)o;
                            if (elemValue.getValue() != null && oldValue != null && elemValue.getValue().equals(oldValue)) {
                                removeIndex = list.indexOf(o);
                                break;
                            }
                            if (elemValue.getValue() != oldValue) continue;
                            removeIndex = list.indexOf(o);
                            break;
                        }
                    }
                    if (removeIndex == -1) break;
                    repairFromIndex = removeIndex;
                    list.remove(removeIndex);
                    break;
                }
                case 6: {
                    List oldValues = (List)notification.getOldValue();
                    for (Object oldValue : oldValues) {
                        int removeIndex = notification.getPosition();
                        if (removeIndex != -1) continue;
                        for (Object o : list) {
                            EAVValueHolder elemValue = (EAVValueHolder)o;
                            if (elemValue.getValue() != null && oldValue != null && elemValue.getValue().equals(oldValue)) {
                                removeIndex = list.indexOf(o);
                                break;
                            }
                            if (elemValue.getValue() == oldValue) {
                                removeIndex = list.indexOf(o);
                                break;
                            }
                            elemValue.setListIndex(-1);
                            elemValue.setValueOwner(null);
                            elemValue.setOwner(null);
                        }
                        if (removeIndex == -1) continue;
                        repairFromIndex = 0;
                        list.remove(removeIndex);
                    }
                    break;
                }
                case 7: {
                    if (list == null) break;
                    int oldPosition = (Integer)notification.getOldValue();
                    int newPosition = notification.getPosition();
                    Object o = list.remove(oldPosition);
                    list.add(newPosition, o);
                    if (newPosition < oldPosition) {
                        repairFromIndex = newPosition;
                        break;
                    }
                    repairFromIndex = oldPosition;
                    break;
                }
                case 1: {
                    if (eFeature.isMany()) {
                        int position = notification.getPosition();
                        EAVValueHolder elementValueHolder = (EAVValueHolder)list.set(position, multiValueHolder.getElement(notification.getNewValue()));
                        repairFromIndex = notification.getPosition();
                        if (elementValueHolder == null) break;
                        elementValueHolder.setListIndex(0);
                        elementValueHolder.setValueOwner(null);
                        elementValueHolder.setOwner(null);
                        break;
                    }
                    valueHolder.set(notification.getNewValue());
                    break;
                }
                case 2: {
                    if (eFeature.isMany()) break;
                    valueHolder.set(notification.getNewValue());
                }
            }
            if (repairFromIndex != -1) {
                int index = repairFromIndex;
                for (Object o : list.subList(repairFromIndex, list.size())) {
                    if (o instanceof EObject) {
                        StoreUtil.setSyntheticListIndex((EStructuralFeature)eFeature, o, (Integer)index++);
                        StoreUtil.setSyntheticListOwner((EStructuralFeature)eFeature, o, (Object)notification.getNotifier());
                    }
                    if (!(o instanceof EAVValueHolder)) continue;
                    EAVValueHolder eavValueHolder = (EAVValueHolder)o;
                    eavValueHolder.setListIndex(index++);
                    eavValueHolder.setValueOwner((EAVMultiValueHolder)valueHolder);
                }
            }
        }
    }
}

