/**
 * <copyright>
 * </copyright>
 *
 * $Id: PAnnotatedEAttributeValidator.java,v 1.3 2009/12/13 10:14:13 mtaal Exp $
 */
package org.eclipse.emf.teneo.annotations.pamodel.validation;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.teneo.annotations.pannotation.Basic;
import org.eclipse.emf.teneo.annotations.pannotation.Enumerated;
import org.eclipse.emf.teneo.annotations.pannotation.GeneratedValue;
import org.eclipse.emf.teneo.annotations.pannotation.Id;
import org.eclipse.emf.teneo.annotations.pannotation.Lob;
import org.eclipse.emf.teneo.annotations.pannotation.Temporal;
import org.eclipse.emf.teneo.annotations.pannotation.Version;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface PAnnotatedEAttributeValidator {
	boolean validate();

	boolean validateModelEAttribute(EAttribute value);

	boolean validateAnnotatedEAttribute(EAttribute value);
	boolean validateBasic(Basic value);
	boolean validateEnumerated(Enumerated value);
	boolean validateGeneratedValue(GeneratedValue value);
	boolean validateId(Id value);
	boolean validateLob(Lob value);
	boolean validateTemporal(Temporal value);
	boolean validateVersion(Version value);
}
