/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util.tests;

import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.util.CompositeChangeDescription;

public class CompositeChangeDescriptionTest
extends AbstractTest {
    private ResourceSet rset;
    private CompositeChangeDescription change;
    private ChangeRecorder recorder;

    public CompositeChangeDescriptionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(CompositeChangeDescriptionTest.class, "Composite Change Description Tests");
    }

    public void test_objectChanges() {
        Book book = (Book)this.find("root/Root Book");
        CompositeChangeDescriptionTest.assertNotNull((Object)book);
        this.root.setName("New root name");
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectChanges().containsAll((Collection)change1.getObjectChanges()));
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        this.root.getBooks().remove((Object)book);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectChanges().containsAll((Collection)change2.getObjectChanges()));
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectChanges().containsAll((Collection)change1.getObjectChanges()));
    }

    public void test_objectsToAttach() {
        Library newRoot = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.testResource.getContents().add((Object)newRoot);
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToAttach().containsAll((Collection)change1.getObjectsToAttach()));
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        Book newBook = EXTLibraryFactory.eINSTANCE.createBook();
        newRoot.getBooks().add((Object)newBook);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToAttach().containsAll((Collection)change2.getObjectsToAttach()));
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToAttach().containsAll((Collection)change1.getObjectsToAttach()));
    }

    public void test_objectsToDetach() {
        Book book = (Book)this.find("root/Root Book");
        CompositeChangeDescriptionTest.assertNotNull((Object)book);
        this.root.getBooks().remove((Object)book);
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToDetach().containsAll((Collection)change1.getObjectsToDetach()));
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        this.testResource.getContents().remove((Object)this.root);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToDetach().containsAll((Collection)change2.getObjectsToDetach()));
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToDetach().containsAll((Collection)change1.getObjectsToDetach()));
    }

    public void test_resourceChanges() {
        Library newRoot = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.testResource.getContents().add((Object)newRoot);
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getResourceChanges().containsAll((Collection)change1.getResourceChanges()));
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        this.testResource.getContents().remove((Object)this.root);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getResourceChanges().containsAll((Collection)change2.getResourceChanges()));
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.getResourceChanges().containsAll((Collection)change1.getResourceChanges()));
    }

    public void test_apply() {
        Book book = (Book)this.find("root/Root Book");
        CompositeChangeDescriptionTest.assertNotNull((Object)book);
        String oldName = this.root.getName();
        this.root.setName("New root name");
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        this.root.getBooks().remove((Object)book);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        this.change.apply();
        CompositeChangeDescriptionTest.assertEquals((String)oldName, (String)this.root.getName());
        CompositeChangeDescriptionTest.assertTrue((boolean)this.root.getBooks().contains((Object)book));
    }

    public void test_applyAndReverse() {
        Book book = (Book)this.find("root/Root Book");
        CompositeChangeDescriptionTest.assertNotNull((Object)book);
        String oldName = this.root.getName();
        String newName = "New root name";
        this.root.setName(newName);
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        this.root.getBooks().remove((Object)book);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        this.change.applyAndReverse();
        CompositeChangeDescriptionTest.assertEquals((String)oldName, (String)this.root.getName());
        CompositeChangeDescriptionTest.assertTrue((boolean)this.root.getBooks().contains((Object)book));
        this.change.applyAndReverse();
        CompositeChangeDescriptionTest.assertEquals((String)newName, (String)this.root.getName());
        CompositeChangeDescriptionTest.assertFalse((boolean)this.root.getBooks().contains((Object)book));
        this.change.applyAndReverse();
        CompositeChangeDescriptionTest.assertEquals((String)oldName, (String)this.root.getName());
        CompositeChangeDescriptionTest.assertTrue((boolean)this.root.getBooks().contains((Object)book));
    }

    public void test_canApply() {
        Book book = (Book)this.find("root/Root Book");
        CompositeChangeDescriptionTest.assertNotNull((Object)book);
        this.root.setName("New root name");
        ChangeDescription change1 = this.recorder.endRecording();
        this.change.add(change1);
        this.recorder.beginRecording(null, (Collection)this.rset.getResources());
        this.root.getBooks().remove((Object)book);
        ChangeDescription change2 = this.recorder.endRecording();
        this.change.add(change2);
        CompositeChangeDescriptionTest.assertTrue((boolean)this.change.canApply());
        this.change.add((ChangeDescription)new NonApplicableChange());
        CompositeChangeDescriptionTest.assertFalse((boolean)this.change.canApply());
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.startWriting();
        this.testResource.getResourceSet().getResources().remove((Object)this.testResource);
        this.rset = new ResourceSetImpl();
        this.rset.getResources().add((Object)this.testResource);
        this.commit();
        TreeIterator iter = this.testResource.getAllContents();
        while (iter.hasNext()) {
            ((Notifier)iter.next()).eAdapters().clear();
        }
        this.testResource.eAdapters().clear();
        this.recorder = new ChangeRecorder((Collection)this.rset.getResources());
        this.change = new CompositeChangeDescription();
    }

    protected void doTearDown() throws Exception {
        this.change = null;
        this.recorder = null;
        this.rset = null;
        super.doTearDown();
    }

    private static class NonApplicableChange
    extends ChangeDescriptionImpl
    implements TransactionChangeDescription {
        private NonApplicableChange() {
        }

        public boolean canApply() {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

