/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.ValidationRollbackTest;
import org.eclipse.emf.transaction.tests.fixtures.ItemDefaultPublicationDateTrigger;
import org.eclipse.emf.transaction.tests.fixtures.LibraryDefaultBookTrigger;
import org.eclipse.emf.transaction.tests.fixtures.TestCommand;
import org.eclipse.emf.transaction.util.ConditionalRedoCommand;

public class UndoRedoTest
extends AbstractTest {
    public UndoRedoTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(UndoRedoTest.class, "Command Undo/Redo Tests");
    }

    public void test_recordingCommand() {
        UndoRedoResourceSetListener listener = new UndoRedoResourceSetListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        UndoRedoTest.assertEquals((int)0, (int)listener.undoCount);
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        UndoRedoTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        Writer oldAuthor = book.getAuthor();
        String newTitle = "New Title";
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        UndoRedoTest.assertNotNull((Object)newAuthor);
        this.commit();
        RecordingCommand cmd = new RecordingCommand(this.domain){

            protected void doExecute() {
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        CommandStack stack = this.domain.getCommandStack();
        stack.execute((Command)cmd);
        this.startReading();
        UndoRedoTest.assertSame((Object)"New Title", (Object)book.getTitle());
        UndoRedoTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        UndoRedoTest.assertTrue((boolean)stack.canUndo());
        stack.undo();
        UndoRedoTest.assertEquals((int)1, (int)listener.undoCount);
        this.startReading();
        UndoRedoTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        UndoRedoTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
        UndoRedoTest.assertTrue((boolean)stack.canRedo());
        stack.redo();
        UndoRedoTest.assertEquals((int)2, (int)listener.undoCount);
        this.startReading();
        UndoRedoTest.assertSame((Object)"New Title", (Object)book.getTitle());
        UndoRedoTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        this.domain.removeResourceSetListener((ResourceSetListener)listener);
    }

    public void test_triggerCommands_nonRecording() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger());
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        AddCommand cmd = new AddCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, (Object)newLibrary);
        this.getCommandStack().execute((Command)cmd);
        this.startReading();
        UndoRedoTest.assertSame((Object)this.root, (Object)newLibrary.eContainer());
        UndoRedoTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        Book book = (Book)newLibrary.getBooks().get(0);
        UndoRedoTest.assertEquals((String)"New Book", (String)book.getTitle());
        UndoRedoTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
        this.getCommandStack().undo();
        this.startReading();
        UndoRedoTest.assertNotSame((Object)this.root, (Object)newLibrary.eContainer());
        UndoRedoTest.assertEquals((int)0, (int)newLibrary.getBooks().size());
        this.commit();
        this.getCommandStack().redo();
        this.startReading();
        UndoRedoTest.assertSame((Object)this.root, (Object)newLibrary.eContainer());
        UndoRedoTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        book = (Book)newLibrary.getBooks().get(0);
        UndoRedoTest.assertEquals((String)"New Book", (String)book.getTitle());
        UndoRedoTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
    }

    public void test_triggerCommands_recording() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger());
        final Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        RecordingCommand cmd = new RecordingCommand(this.domain){

            protected void doExecute() {
                UndoRedoTest.this.root.getBranches().add((Object)newLibrary);
                UndoRedoTest.assertNull((Object)newLibrary.getName());
                UndoRedoTest.assertTrue((boolean)newLibrary.getBranches().isEmpty());
            }
        };
        this.getCommandStack().execute((Command)cmd);
        this.startReading();
        UndoRedoTest.assertSame((Object)this.root, (Object)newLibrary.eContainer());
        UndoRedoTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        Book book = (Book)newLibrary.getBooks().get(0);
        UndoRedoTest.assertEquals((String)"New Book", (String)book.getTitle());
        UndoRedoTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
        this.getCommandStack().undo();
        this.startReading();
        UndoRedoTest.assertNotSame((Object)this.root, (Object)newLibrary.eContainer());
        UndoRedoTest.assertEquals((int)0, (int)newLibrary.getBooks().size());
        this.commit();
        this.getCommandStack().redo();
        this.startReading();
        UndoRedoTest.assertSame((Object)this.root, (Object)newLibrary.eContainer());
        UndoRedoTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        book = (Book)newLibrary.getBooks().get(0);
        UndoRedoTest.assertEquals((String)"New Book", (String)book.getTitle());
        UndoRedoTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
    }

    public void test_undoResourceUnload() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        UndoRedoTest.assertNotNull((Object)book);
        Writer author = (Writer)this.find("root/level1/Level1 Writer");
        UndoRedoTest.assertNotNull((Object)author);
        this.commit();
        this.startWriting();
        URI uri = this.unloadTestResource();
        Transaction tx = this.commit();
        TransactionChangeDescription change = tx.getChangeDescription();
        UndoRedoTest.assertTrue((boolean)book.eIsProxy());
        UndoRedoTest.assertNull((Object)book.eResource());
        UndoRedoTest.assertTrue((boolean)author.eIsProxy());
        UndoRedoTest.assertNull((Object)author.eResource());
        UndoRedoTest.assertTrue((boolean)change.canApply());
        this.startWriting("no_undo");
        change.applyAndReverse();
        this.commit();
        this.startReading();
        UndoRedoTest.assertSame((Object)this.testResource, (Object)this.domain.getResourceSet().getResource(uri, false));
        UndoRedoTest.assertNotNull((Object)this.testResource);
        UndoRedoTest.assertTrue((boolean)this.testResource.isLoaded());
        UndoRedoTest.assertSame((Object)this.testResource, (Object)book.eResource());
        UndoRedoTest.assertSame((Object)this.testResource, (Object)author.eResource());
        this.commit();
        UndoRedoTest.assertTrue((boolean)change.canApply());
        this.startWriting("no_undo");
        change.applyAndReverse();
        this.commit();
        UndoRedoTest.assertTrue((boolean)book.eIsProxy());
        UndoRedoTest.assertNull((Object)book.eResource());
        UndoRedoTest.assertTrue((boolean)author.eIsProxy());
        UndoRedoTest.assertNull((Object)author.eResource());
    }

    public void test_undoResourceLoad() {
        this.startReading();
        URI uri = this.unloadTestResource();
        this.domain.getResourceSet().getResources().remove((Object)this.testResource);
        this.commit();
        this.startWriting();
        this.testResource = this.domain.getResourceSet().getResource(uri, true);
        Transaction tx = this.commit();
        TransactionChangeDescription change = tx.getChangeDescription();
        this.startReading();
        UndoRedoTest.assertNotNull((Object)this.testResource);
        UndoRedoTest.assertTrue((boolean)this.testResource.isLoaded());
        Book book = (Book)this.find("root/Root Book");
        UndoRedoTest.assertNotNull((Object)book);
        Writer author = (Writer)this.find("root/level1/Level1 Writer");
        UndoRedoTest.assertNotNull((Object)author);
        UndoRedoTest.assertFalse((boolean)book.eIsProxy());
        UndoRedoTest.assertSame((Object)this.testResource, (Object)book.eResource());
        UndoRedoTest.assertFalse((boolean)author.eIsProxy());
        UndoRedoTest.assertSame((Object)this.testResource, (Object)author.eResource());
        this.commit();
        UndoRedoTest.assertTrue((boolean)change.canApply());
        UndoRedoTest.assertTrue((boolean)change.getObjectChanges().isEmpty());
        UndoRedoTest.assertTrue((boolean)change.getResourceChanges().isEmpty());
        UndoRedoTest.assertTrue((boolean)change.getObjectsToAttach().isEmpty());
        UndoRedoTest.assertTrue((boolean)change.getObjectsToDetach().isEmpty());
    }

    public void test_triggerCommands_singleUndoRedo_133388() {
        final HashSet countingCommands = new HashSet();
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                Command result = super.trigger(domain, notification);
                if (result != null) {
                    class CountingCommand
                    extends TestCommand {
                        private int count;

                        CountingCommand() {
                        }

                        void reset() {
                            this.count = 0;
                        }

                        public void execute() {
                            this.reset();
                        }

                        public void undo() {
                            UndoRedoTest.assertEquals((int)1, (int)(++this.count));
                        }

                        public void redo() {
                            UndoRedoTest.assertEquals((int)1, (int)(++this.count));
                        }
                    }
                    CountingCommand cc = new CountingCommand();
                    countingCommands.add(cc);
                    result = result.chain((Command)cc);
                }
                return result;
            }
        });
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                Command result = super.trigger(domain, notification);
                if (result != null) {
                    CountingCommand cc = new CountingCommand();
                    countingCommands.add(cc);
                    result = result.chain((Command)cc);
                }
                return result;
            }
        });
        this.startWriting();
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.root.getBranches().add((Object)newLibrary);
        UndoRedoTest.assertNull((Object)newLibrary.getName());
        UndoRedoTest.assertTrue((boolean)newLibrary.getBranches().isEmpty());
        Transaction tx = this.commit();
        TransactionChangeDescription change = tx.getChangeDescription();
        this.startWriting();
        change.applyAndReverse();
        this.commit();
        for (CountingCommand next : countingCommands) {
            next.reset();
        }
        this.startWriting();
        change.applyAndReverse();
        this.commit();
        for (CountingCommand next : countingCommands) {
            next.reset();
        }
        this.startWriting();
        change.applyAndReverse();
        this.commit();
        for (CountingCommand next : countingCommands) {
            next.reset();
        }
    }

    public void test_nonredoableCommand_138287() {
        TestCommand.Redoable cmd = new TestCommand.Redoable(){

            public void execute() {
            }

            public boolean canRedo() {
                return false;
            }
        };
        this.getCommandStack().execute((Command)cmd);
        UndoRedoTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        UndoRedoTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_nonredoableTriggerCommand_138287() {
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new TestCommand.Redoable(){

                    public void execute() {
                    }

                    public boolean canRedo() {
                        return false;
                    }
                };
            }
        });
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        ConditionalRedoCommand.Compound cmd = new ConditionalRedoCommand.Compound();
        cmd.chain(AddCommand.create((EditingDomain)this.domain, (Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, (Object)newLibrary));
        newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        cmd.chain(AddCommand.create((EditingDomain)this.domain, (Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, (Object)newLibrary));
        this.getCommandStack().execute((Command)cmd);
        UndoRedoTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        UndoRedoTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_nonredoableTriggerCommands() {
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new TestCommand.Redoable(){

                    public void execute() {
                    }

                    public boolean canRedo() {
                        return false;
                    }
                };
            }
        });
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new TestCommand.Redoable(){

                    public void execute() {
                    }

                    public boolean canRedo() {
                        return false;
                    }
                };
            }
        });
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        ConditionalRedoCommand.Compound cmd = new ConditionalRedoCommand.Compound();
        cmd.chain(AddCommand.create((EditingDomain)this.domain, (Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, (Object)newLibrary));
        this.getCommandStack().execute((Command)cmd);
        UndoRedoTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        UndoRedoTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_nonredoableTriggerCommand_RecordingCommand_138287() {
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new TestCommand.Redoable(){

                    public void execute() {
                    }

                    public boolean canRedo() {
                        return false;
                    }
                };
            }
        });
        final Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        RecordingCommand cmd = new RecordingCommand(this.domain){

            protected void doExecute() {
                UndoRedoTest.this.root.getBranches().add((Object)newLibrary);
            }
        };
        this.getCommandStack().execute((Command)cmd);
        UndoRedoTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        UndoRedoTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_undoRedoOptionsNotSharedbyDomains_bug207986() {
        InternalTransactionalEditingDomain otherDomain = (InternalTransactionalEditingDomain)TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        String BOGUS_OPTION = "**bogus_option**";
        otherDomain.getUndoRedoOptions().put("**bogus_option**", Boolean.TRUE);
        UndoRedoTest.assertFalse((boolean)((InternalTransactionalEditingDomain)this.domain).getUndoRedoOptions().containsKey("**bogus_option**"));
    }

    public void test_defaultUndoRedoOptionsMapReadOnly_bug207986() {
        String BOGUS_OPTION = "**bogus_option**";
        try {
            TransactionImpl.DEFAULT_UNDO_REDO_OPTIONS.put("**bogus_option**", Boolean.TRUE);
            UndoRedoTest.fail((String)"Should not have been permitted to add the bogus option");
        }
        catch (RuntimeException e) {
            System.out.println("Got expected runtime exception: " + e.getLocalizedMessage());
        }
        UndoRedoTest.assertFalse((boolean)((InternalTransactionalEditingDomain)this.domain).getUndoRedoOptions().containsKey("**bogus_option**"));
        UndoRedoTest.assertFalse((boolean)TransactionImpl.DEFAULT_UNDO_REDO_OPTIONS.containsKey("**bogus_option**"));
    }

    public void test_undoRecordingCommandWithRecordingCommandTrigger_218276() {
        final Book[] book = new Book[]{(Book)this.find("root/Root Book")};
        int newCopies = 30;
        final RecordingCommand trigger = new RecordingCommand(this.domain, "Test Trigger"){

            protected void doExecute() {
                book[0].setCopies(30);
            }
        };
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                CompoundCommand result = new CompoundCommand();
                for (Notification next : event.getNotifications()) {
                    if (next.getFeature() != EXTLibraryPackage.Literals.BOOK__TITLE) continue;
                    result.append((Command)trigger);
                }
                return result.isEmpty() ? null : result;
            }
        };
        try {
            this.domain.addResourceSetListener((ResourceSetListener)listener);
            String newTitle = "New Title";
            this.getCommandStack().execute((Command)new RecordingCommand(this.domain, "Test"){

                protected void doExecute() {
                    book[0].setTitle("New Title");
                }
            });
            UndoRedoTest.assertEquals((String)"Wrong number of copies on execute", (int)30, (int)book[0].getCopies());
            this.getCommandStack().undo();
            UndoRedoTest.assertFalse((String)"Wrong number of copies on undo", (book[0].getCopies() == 30 ? 1 : 0) != 0);
            this.getCommandStack().redo();
            UndoRedoTest.assertEquals((String)"Wrong number of copies on redo", (int)30, (int)book[0].getCopies());
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_undoNestedRecordingCommandWithRecordingCommandTrigger_218276() {
        final Book[] book = new Book[]{(Book)this.find("root/Root Book")};
        int newCopies = 30;
        final RecordingCommand trigger = new RecordingCommand(this.domain, "Test Trigger"){

            protected void doExecute() {
                book[0].setCopies(30);
            }
        };
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                CompoundCommand result = new CompoundCommand();
                for (Notification next : event.getNotifications()) {
                    if (next.getFeature() != EXTLibraryPackage.Literals.BOOK__TITLE) continue;
                    result.append((Command)trigger);
                }
                return result.isEmpty() ? null : result;
            }
        };
        try {
            this.domain.addResourceSetListener((ResourceSetListener)listener);
            String newTitle = "New Title";
            CompoundCommand cc = new CompoundCommand("Test");
            cc.append((Command)new RecordingCommand(this.domain, "Test"){

                protected void doExecute() {
                    book[0].setTitle("New Title");
                }
            });
            this.getCommandStack().execute((Command)cc);
            UndoRedoTest.assertEquals((String)"Wrong number of copies on execute", (int)30, (int)book[0].getCopies());
            this.getCommandStack().undo();
            UndoRedoTest.assertFalse((String)"Wrong number of copies on undo", (book[0].getCopies() == 30 ? 1 : 0) != 0);
            this.getCommandStack().redo();
            UndoRedoTest.assertEquals((String)"Wrong number of copies on redo", (int)30, (int)book[0].getCopies());
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ValidationRollbackTest.validationEnabled = true;
    }

    protected void doTearDown() throws Exception {
        ValidationRollbackTest.validationEnabled = false;
        super.doTearDown();
    }

    private URI unloadTestResource() {
        URI result = this.testResource.getURI();
        this.testResource.unload();
        return result;
    }

    public class UndoRedoResourceSetListener
    implements ResourceSetListener {
        public int undoCount = 0;

        public NotificationFilter getFilter() {
            return null;
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPostcommitOnly() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return false;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Transaction transaction = event.getTransaction();
            Object obj = transaction.getOptions().get("is_undo_redo_transaction");
            if (Boolean.TRUE.equals(obj)) {
                ++this.undoCount;
            }
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            return null;
        }
    }
}

