/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests.fixtures;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;

public class LibraryDefaultBookTrigger
extends TriggerListener {
    private final boolean isAggregate;

    public LibraryDefaultBookTrigger() {
        this(false);
    }

    public LibraryDefaultBookTrigger(boolean isAggregate) {
        super(NotificationFilter.createFeatureFilter((EStructuralFeature)EXTLibraryPackage.eINSTANCE.getLibrary_Branches()).and(NotificationFilter.createEventTypeFilter((int)3)));
        this.isAggregate = isAggregate;
    }

    protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
        AddCommand result = null;
        Library newLibrary = (Library)notification.getNewValue();
        if (newLibrary.getBooks().isEmpty()) {
            Book newBook = EXTLibraryFactory.eINSTANCE.createBook();
            newBook.setTitle("New Book");
            result = new AddCommand((EditingDomain)domain, newLibrary.getBooks(), (Object)newBook);
        }
        return result;
    }

    public boolean isAggregatePrecommitListener() {
        return this.isAggregate;
    }
}

