/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.util.tests;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.workspace.internal.EMFWorkspacePlugin;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class WorkspaceSynchronizerTest
extends AbstractTest {
    private WorkspaceSynchronizer synch;
    private TestDelegate delegate;

    public WorkspaceSynchronizerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(WorkspaceSynchronizerTest.class, "Workspace Synchronizer Tests");
    }

    public void test_getFile() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        WorkspaceSynchronizerTest.assertNotNull((Object)file);
        WorkspaceSynchronizerTest.assertTrue((boolean)file.exists());
        URI uri = this.testResource.getURI();
        WorkspaceSynchronizerTest.assertEquals((String)file.getName(), (String)uri.segment(uri.segmentCount() - 1));
    }

    public void test_getUnderlyingFile_163291() {
        ResourceImpl archiveResource = new ResourceImpl();
        archiveResource.setURI(URI.createURI((String)"archive:platform:/resource/emfwbtests/testres.extlibrary!/foo"));
        IFile file = WorkspaceSynchronizer.getUnderlyingFile((Resource)archiveResource);
        WorkspaceSynchronizerTest.assertNotNull((Object)file);
        WorkspaceSynchronizerTest.assertTrue((boolean)file.exists());
        WorkspaceSynchronizerTest.assertEquals((Object)file, (Object)this.file);
        archiveResource = new ResourceImpl();
        archiveResource.setURI(URI.createURI((String)"archive:platform:/resource/emfwbtests/testres.extlibrary!/foo.zip!/goo"));
        file = WorkspaceSynchronizer.getUnderlyingFile((Resource)archiveResource);
        WorkspaceSynchronizerTest.assertNotNull((Object)file);
        WorkspaceSynchronizerTest.assertTrue((boolean)file.exists());
        WorkspaceSynchronizerTest.assertEquals((Object)file, (Object)this.file);
        archiveResource = new ResourceImpl();
        archiveResource.setURI(URI.createURI((String)"archive:archive:platform:/resource/emfwbtests/testres.extlibrary!/foo.zip!/goo"));
        file = WorkspaceSynchronizer.getUnderlyingFile((Resource)archiveResource);
        WorkspaceSynchronizerTest.assertNotNull((Object)file);
        WorkspaceSynchronizerTest.assertTrue((boolean)file.exists());
        WorkspaceSynchronizerTest.assertEquals((Object)file, (Object)this.file);
    }

    public void test_getFile_fileURI_156772() {
        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("/emfwbtests/testres.extlibrary").toString();
        this.testResource.setURI(URI.createFileURI((String)path));
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        WorkspaceSynchronizerTest.assertNotNull((Object)file);
        WorkspaceSynchronizerTest.assertTrue((boolean)file.exists());
        URI uri = this.testResource.getURI();
        WorkspaceSynchronizerTest.assertEquals((String)file.getName(), (String)uri.segment(uri.segmentCount() - 1));
    }

    public void test_getFile_normalization_156772() {
        this.testResource.getResourceSet().getURIConverter().getURIMap().put(URI.createURI((String)"pathmap://FOO"), this.testResource.getURI().trimSegments(1));
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        WorkspaceSynchronizerTest.assertNotNull((Object)file);
        WorkspaceSynchronizerTest.assertTrue((boolean)file.exists());
        URI uri = this.testResource.getURI();
        WorkspaceSynchronizerTest.assertEquals((String)file.getName(), (String)uri.segment(uri.segmentCount() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_deletion() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.delete(true, null);
                this.delegate.wait();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.deletedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.changedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.movedResources.containsKey(this.testResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_change() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.touch(null);
                this.delegate.wait();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.changedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.deletedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.movedResources.containsKey(this.testResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_move() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        IPath newPath = file.getFullPath().removeLastSegments(1).append("moveDestination.extlibrary");
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.move(newPath, true, null);
                this.delegate.wait();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.changedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.deletedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.movedResources.containsKey(this.testResource));
        WorkspaceSynchronizerTest.assertEquals((Object)URI.createPlatformResourceURI((String)newPath.toString(), (boolean)true), (Object)this.delegate.movedResources.get(this.testResource));
    }

    public void test_multipleChanges() {
        final IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        final IFile[] copies = new IFile[2];
        final IPath copy1 = file.getFullPath().removeLastSegments(1).append("copy1.extlibrary");
        final IPath copy2 = file.getFullPath().removeLastSegments(1).append("copy2.extlibrary");
        final IPath newPath = file.getFullPath().removeLastSegments(1).append("moveDestination.extlibrary");
        WorkspaceJob job = new WorkspaceJob("Modify Workspace"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                file.copy(copy1, true, null);
                file.copy(copy2, true, null);
                copies[0] = file.getWorkspace().getRoot().getFile(copy1);
                copies[1] = file.getWorkspace().getRoot().getFile(copy2);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            this.fail(e);
        }
        Resource testResource2 = this.domain.getResourceSet().getResource(URI.createPlatformResourceURI((String)copy1.toString(), (boolean)true), true);
        Resource testResource3 = this.domain.getResourceSet().getResource(URI.createPlatformResourceURI((String)copy2.toString(), (boolean)true), true);
        WorkspaceSynchronizerTest.assertNotNull((Object)testResource2);
        WorkspaceSynchronizerTest.assertTrue((boolean)testResource2.isLoaded());
        WorkspaceSynchronizerTest.assertNotNull((Object)testResource3);
        WorkspaceSynchronizerTest.assertTrue((boolean)testResource3.isLoaded());
        try {
            job = new WorkspaceJob("Modify Workspace"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    file.delete(true, null);
                    copies[0].touch(null);
                    copies[1].move(newPath, true, null);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            job.join();
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.deletedResources.contains(this.testResource));
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.changedResources.contains(testResource2));
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.movedResources.containsKey(testResource3));
        WorkspaceSynchronizerTest.assertEquals((Object)URI.createPlatformResourceURI((String)newPath.toString(), (boolean)true), (Object)this.delegate.movedResources.get(testResource3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_defaultDeleteBehaviour() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.delete(true, null);
                this.delegate.wait();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertFalse((boolean)this.testResource.isLoaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_defaultChangeBehaviour() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.touch(null);
                this.delegate.wait();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        WorkspaceSynchronizerTest.assertFalse((boolean)this.testResource.getContents().contains((Object)this.root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_defaultMoveBehaviour() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        IPath newPath = file.getFullPath().removeLastSegments(1).append("moveDestination.extlibrary");
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.move(newPath, true, null);
                this.delegate.wait();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertFalse((boolean)this.testResource.isLoaded());
    }

    public void test_getFileWithEncodedURI_128315() {
        String filePath = "/My Project/some dir/file.foo";
        String encoded = "platform:/resource/My%20Project/some%20dir/file.foo";
        URI uri = URI.createPlatformResourceURI((String)"/My Project/some dir/file.foo", (boolean)true);
        WorkspaceSynchronizerTest.assertEquals((String)"platform:/resource/My%20Project/some%20dir/file.foo", (String)uri.toString());
        ResourceImpl res = new ResourceImpl(uri);
        IFile file = WorkspaceSynchronizer.getFile((Resource)res);
        WorkspaceSynchronizerTest.assertEquals((String)"/My Project/some dir/file.foo", (String)file.getFullPath().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_synchResourceWithUnencodedURI_197291() {
        Resource res = this.createTestResource("test_model.extlibrary", "name with spaces.extlibrary", false);
        this.root = (Library)res.getContents().get(0);
        IFile file = WorkspaceSynchronizer.getFile((Resource)res);
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.touch(null);
                this.delegate.wait(100000L);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertTrue((boolean)res.isLoaded());
        WorkspaceSynchronizerTest.assertFalse((boolean)res.getContents().contains((Object)this.root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_synchResourceWithEncodedURI_197291() {
        Resource res = this.createTestResource("test_model.extlibrary", "name with spaces.extlibrary", true);
        this.root = (Library)res.getContents().get(0);
        IFile file = WorkspaceSynchronizer.getFile((Resource)res);
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.touch(null);
                this.delegate.wait(10000L);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertTrue((boolean)res.isLoaded());
        WorkspaceSynchronizerTest.assertFalse((boolean)res.getContents().contains((Object)this.root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_synchMovedResourceWithUnencodedURI_197291() {
        Resource res = this.createTestResource("test_model.extlibrary", "name with spaces.extlibrary", false);
        this.root = (Library)res.getContents().get(0);
        IFile file = WorkspaceSynchronizer.getFile((Resource)res);
        IPath path = file.getFullPath().removeLastSegments(1).append("new name.extlibrary");
        Resource newRes = this.domain.createResource(URI.createPlatformResourceURI((String)path.toString(), (boolean)false).toString());
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.move(path, true, null);
                this.delegate.wait(100000L);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.changedResources.contains(res));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.deletedResources.contains(res));
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.movedResources.containsKey(res));
        WorkspaceSynchronizerTest.assertEquals((Object)newRes.getURI(), (Object)this.delegate.movedResources.get(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_synchMoveResourceWithEncodedURI_197291() {
        Resource res = this.createTestResource("test_model.extlibrary", "name with spaces.extlibrary", false);
        this.root = (Library)res.getContents().get(0);
        IFile file = WorkspaceSynchronizer.getFile((Resource)res);
        IPath path = file.getFullPath().removeLastSegments(1).append("new name.extlibrary");
        Resource newRes = this.domain.createResource(URI.createPlatformResourceURI((String)path.toString(), (boolean)true).toString());
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate testDelegate = this.delegate;
            synchronized (testDelegate) {
                file.move(path, true, null);
                this.delegate.wait(100000L);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.changedResources.contains(res));
        WorkspaceSynchronizerTest.assertFalse((boolean)this.delegate.deletedResources.contains(res));
        WorkspaceSynchronizerTest.assertTrue((boolean)this.delegate.movedResources.containsKey(res));
        WorkspaceSynchronizerTest.assertEquals((Object)newRes.getURI(), (Object)this.delegate.movedResources.get(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_resourceDeletedThatHadMarkers_207306() {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.testResource);
        try {
            IMarker marker = file.createMarker("org.eclipse.emf.validation.problem");
            marker.setAttribute("rule", (Object)"foo");
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
        this.delegate.defaultBehaviour = true;
        WorkspaceSynchronizerTest.assertTrue((boolean)this.testResource.isLoaded());
        try {
            TestDelegate e = this.delegate;
            synchronized (e) {
                file.delete(true, null);
                this.delegate.wait(20000L);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.waitForWorkspaceChanges();
        WorkspaceSynchronizerTest.assertFalse((boolean)this.testResource.isLoaded());
    }

    public void test_deleteProjectAndDisposeSynchronizer_233004() {
        final IStatus[] logged = new IStatus[1];
        ILogListener log = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                logged[0] = status;
            }
        };
        IResourceChangeListener listener = new IResourceChangeListener(){
            private boolean disposedSynch;

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1 && !this.disposedSynch) {
                    this.disposedSynch = true;
                    WorkspaceSynchronizerTest.this.synch.dispose();
                }
            }
        };
        try {
            try {
                ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
                EMFWorkspacePlugin.getPlugin().getLog().addLogListener(log);
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        WorkspaceSynchronizerTest.this.project.delete(true, null);
                    }
                }, null);
                Thread.sleep(1000L);
                if (logged[0] != null) {
                    WorkspaceSynchronizerTest.fail((String)("Should not have logged: " + logged[0].getException()));
                }
            }
            catch (CoreException e) {
                WorkspaceSynchronizerTest.fail((String)("Failed to delete project: " + e.getLocalizedMessage()));
                EMFWorkspacePlugin.getPlugin().getLog().removeLogListener(log);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
            }
            catch (InterruptedException e) {
                WorkspaceSynchronizerTest.fail((String)"Test interrupted in sleep");
                EMFWorkspacePlugin.getPlugin().getLog().removeLogListener(log);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            EMFWorkspacePlugin.getPlugin().getLog().removeLogListener(log);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.delegate = new TestDelegate();
        this.synch = new WorkspaceSynchronizer(this.domain, (WorkspaceSynchronizer.Delegate)this.delegate);
    }

    @Override
    protected void doTearDown() throws Exception {
        this.synch.dispose();
        this.synch = null;
        this.delegate = null;
        super.doTearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForWorkspaceChanges() {
        final Object lock = new Object();
        Job job = new Job("Wait Job"){
            {
                super($anonymous0);
                this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                this.setSystem(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
                return Status.OK_STATUS;
            }
        };
        Object object = lock;
        synchronized (object) {
            job.schedule();
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                this.fail(e);
            }
        }
    }

    static class TestDelegate
    implements WorkspaceSynchronizer.Delegate {
        final List<Resource> deletedResources = new ArrayList<Resource>();
        final Map<Resource, URI> movedResources = new LinkedHashMap<Resource, URI>();
        final List<Resource> changedResources = new ArrayList<Resource>();
        boolean defaultBehaviour = false;

        TestDelegate() {
        }

        public synchronized boolean handleResourceDeleted(Resource resource) {
            this.deletedResources.add(resource);
            this.notify();
            return !this.defaultBehaviour;
        }

        public synchronized boolean handleResourceMoved(Resource resource, URI newURI) {
            this.movedResources.put(resource, newURI);
            this.notify();
            return !this.defaultBehaviour;
        }

        public synchronized boolean handleResourceChanged(Resource resource) {
            this.changedResources.add(resource);
            this.notify();
            return !this.defaultBehaviour;
        }

        public void dispose() {
            this.deletedResources.clear();
            this.movedResources.clear();
            this.changedResources.clear();
        }
    }
}

