/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class LogCapture {
    private final Bundle targetBundle;
    private final ILogListener listener = new ILogListener(){

        public void logging(IStatus status, String plugin) {
            if (status.getPlugin().equals(LogCapture.this.targetBundle.getSymbolicName())) {
                LogCapture.this.record(status);
            }
        }
    };
    private final List<IStatus> logs = new ArrayList<IStatus>();
    private IStatus lastLog;

    public LogCapture() {
        this(Platform.getBundle((String)"org.eclipse.emf.validation"));
    }

    public LogCapture(Bundle targetBundle) {
        this.targetBundle = targetBundle;
        Platform.addLogListener((ILogListener)this.listener);
    }

    public void stop() {
        Platform.removeLogListener((ILogListener)this.listener);
    }

    public IStatus getLastLog() {
        return this.lastLog;
    }

    public List<IStatus> getLogs() {
        return this.logs;
    }

    public List<IStatus> getLogs(int statusCode) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        for (IStatus next : this.logs) {
            if (next.getCode() != statusCode) continue;
            result.add(next);
        }
        return result;
    }

    public void assertLogged(Throwable throwable) {
        IStatus log = this.getLastLog();
        Assert.assertNotNull((Object)log);
        log = this.findStatus(log, throwable);
        Assert.assertNotNull((Object)log);
    }

    private void record(IStatus log) {
        this.logs.add(log);
        this.lastLog = log;
    }

    private IStatus findStatus(IStatus status, Throwable exception) {
        IStatus result;
        Object object = result = status.getException() == exception ? status : null;
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (result == null && i < children.length) {
                result = this.findStatus(children[i], exception);
                ++i;
            }
        }
        return result;
    }
}

