/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfindex.CompositeIndexAdapter;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.ContainerDescriptorIterator;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.EObjectDescriptorIterator;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.EReferenceDescriptorIterator;
import org.eclipse.emf.emfindex.EmfIndexPlugin;
import org.eclipse.emf.emfindex.IndexAdapter;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.ResourceDescriptorIterable;
import org.eclipse.emf.emfindex.ecore.BufferedBinaryResourceFactory;
import org.eclipse.emf.emfindex.event.IndexChangeEvent;
import org.eclipse.emf.emfindex.event.IndexChangeEventImpl;
import org.eclipse.emf.emfindex.event.IndexChangeListener;
import org.eclipse.emf.emfindex.query.QueryCommand;
import org.eclipse.emf.emfindex.query.QueryExecutor;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.emfindex.store.UpdateCommand;
import org.eclipse.emf.emfindex.store.UpdateableIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MemoryIndexImpl
implements UpdateableIndex {
    private static final String INDEX_RESOURCE_URI_EXTENSION = "idx";
    private QueryExecutor queryExecutor;
    private IndexUpdater indexUpdater;
    private ResourceSet resourceSet;
    private CompositeIndexAdapter compositeAdapter;
    private ReadWriteLock lock;
    private List<IndexChangeListener> changeListeners = new ArrayList<IndexChangeListener>();
    private int resourceCount = 0;

    public MemoryIndexImpl() {
        this.resourceSet = new ResourceSetImpl();
        this.compositeAdapter = new CompositeIndexAdapter();
        this.resourceSet.eAdapters().add((Object)this.compositeAdapter);
        this.compositeAdapter.addIndexAdapter(new IndexAdapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(Resource.class) == 2 || notification.getFeatureID(ContainerDescriptor.class) == 2) {
                    switch (notification.getEventType()) {
                        case 3: {
                            MemoryIndexImpl.this.fireIndexChangedEvent(new IndexChangeEventImpl(IndexChangeEvent.Type.ADDED, null, notification.getNewValue()));
                            break;
                        }
                        case 4: {
                            MemoryIndexImpl.this.fireIndexChangedEvent(new IndexChangeEventImpl(IndexChangeEvent.Type.REMOVED, notification.getOldValue(), null));
                            break;
                        }
                        case 1: {
                            MemoryIndexImpl.this.fireIndexChangedEvent(new IndexChangeEventImpl(IndexChangeEvent.Type.MODIFIED, notification.getOldValue(), notification.getNewValue()));
                        }
                    }
                }
            }

            public void clear() {
            }
        });
        this.lock = new ReentrantReadWriteLock();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(INDEX_RESOURCE_URI_EXTENSION, new BufferedBinaryResourceFactory());
    }

    @Override
    public void registerIndexChangeListener(IndexChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void deregisterIndexChangeListener(IndexChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireIndexChangedEvent(IndexChangeEvent event) {
        for (IndexChangeListener changeListener : this.changeListeners) {
            changeListener.indexChanged(event);
        }
    }

    @Override
    public <T> T executeUpdateCommand(UpdateCommand<T> updateCommand) {
        try {
            this.lock.writeLock().lock();
            T t = updateCommand.execute(this.indexUpdater, this.queryExecutor);
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public <T> T executeQueryCommand(QueryCommand<T> queryCommand) {
        try {
            this.lock.readLock().lock();
            T t = queryCommand.execute(this.queryExecutor);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void load() throws IOException {
        this.lock.writeLock().lock();
        try {
            File[] indexFiles;
            this.compositeAdapter.setActive(false);
            this.resourceSet.getResources().clear();
            this.compositeAdapter.clear();
            this.compositeAdapter.setActive(true);
            File baseDirectory = EmfIndexPlugin.getBaseDirectory();
            final Pattern fileNamePattern = Pattern.compile("\\d*.idx");
            File[] fileArray = indexFiles = baseDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return fileNamePattern.matcher(name).matches();
                }
            });
            int n = indexFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File indexFile = fileArray[n2];
                URI fileURI = URI.createFileURI((String)indexFile.getAbsolutePath());
                this.resourceSet.getResource(fileURI, true);
                ++n2;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void save() throws IOException {
        this.lock.readLock().lock();
        try {
            for (Resource resource : this.resourceSet.getResources()) {
                if (!resource.isModified()) continue;
                resource.save(null);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean addIndexAdapter(IndexAdapter adapter) {
        return this.compositeAdapter.addIndexAdapter(adapter);
    }

    public boolean removeIndexAdapter(IndexAdapter adapter) {
        return this.compositeAdapter.removeIndexAdapter(adapter);
    }

    public <T extends IndexAdapter> T findIndexAdapter(Class<T> adapterClass) {
        return this.compositeAdapter.findIndexAdapter(adapterClass);
    }

    public Iterator<ContainerDescriptor> allContainerDescriptors() {
        return new ContainerDescriptorIterator((Iterable<?>)this.resourceSet.getResources());
    }

    public Iterator<ResourceDescriptor> allResourceDescriptors() {
        return new ResourceDescriptorIterable((Iterable<?>)this.resourceSet.getResources());
    }

    public Iterator<EObjectDescriptor> allEObjectDescriptors() {
        return new EObjectDescriptorIterator((Iterable<?>)this.resourceSet.getResources());
    }

    public Iterator<EReferenceDescriptor> allEReferenceDescriptors() {
        return new EReferenceDescriptorIterator((Iterable<?>)this.resourceSet.getResources());
    }

    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public Resource createResource() {
        URI uri = this.createURI();
        Resource newResource = this.resourceSet.createResource(uri);
        return newResource;
    }

    public void deleteResource(Resource resource) {
        this.resourceSet.getResources().remove((Object)resource);
    }

    private URI createURI() {
        return EmfIndexPlugin.getBaseDirectoryURI().appendSegment(this.resourceCount++ + "." + INDEX_RESOURCE_URI_EXTENSION);
    }

    @Inject
    public void setIndexUpdater(IndexUpdater indexUpdater) {
        this.indexUpdater = indexUpdater;
    }

    @Inject
    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }
}

