/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.store;

import java.io.Serializable;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfindex.BaseDescriptor;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.ResourceDescriptor;

/**
 * @author koehnlein
 */
public interface DescriptorFactory {

	ContainerDescriptor createContainerDescriptor(String name);

	ResourceDescriptor createResourceDescriptor(ContainerDescriptor container, URI resourceURI, long indexedVersion);

	EObjectDescriptor createEObjectDescriptor(ResourceDescriptor container, String name, String fragment,
			EClass eClass);

	EReferenceDescriptor createEReferenceDescriptor(ResourceDescriptor container, String sourceFragment,
			URI targetFragmentURI, EReference eReference);

	EReferenceDescriptor createEReferenceDescriptor(ResourceDescriptor container, String sourceFragment,
			EObjectDescriptor targetDescriptor, EReference eReference);

	void addUserData(BaseDescriptor descriptor, String key, Serializable value);
	
}
