/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class HighlightingTreeViewer
extends TreeViewer {
    protected boolean colorAssociated = true;
    protected boolean expandAssociated = false;
    protected List<TreeItem> associated = new ArrayList<TreeItem>();
    protected Color defaultColor = this.getColor(1);
    protected Color defaultMarkColor = this.getColor(255, 224, 224);
    protected int SPEC_FULL = 255;
    protected int SPEC_REDUCED = 224;

    public HighlightingTreeViewer(Tree tree) {
        super(tree);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HighlightingTreeViewer.this.colorSelection(event.getSelection());
            }
        });
    }

    protected void colorSelection(ISelection sel) {
        this.clearAssociated();
        if (this.colorAssociated && sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.markAssociated(it.next());
            }
        }
    }

    public void setColorAssociated(boolean colorAssociated) {
        this.colorAssociated = colorAssociated;
        this.colorSelection(this.getSelection());
    }

    public void setExpandAssociated(boolean expandAssociated) {
        this.expandAssociated = expandAssociated;
        this.colorSelection(this.getSelection());
    }

    protected void markAssociated(Object o) {
        if (o instanceof IWrapperItemProvider) {
            o = ((IWrapperItemProvider)o).getValue();
        }
        if (o instanceof Mapping) {
            Mapping m = (Mapping)o;
            this.mark(m.getOrigin(), this.getBLUE());
            this.mark(m.getImage(), this.getYELLOW());
        } else if (o instanceof ParameterMapping) {
            ParameterMapping pm = (ParameterMapping)o;
            this.mark(pm.getSource(), this.getRED());
            this.mark(pm.getTarget(), this.getGREEN());
        } else if (o instanceof Edge) {
            Edge e = (Edge)o;
            this.mark(e.getSource(), this.getRED());
            this.mark(e.getTarget(), this.getGREEN());
        } else if (o instanceof Node) {
            Rule rule;
            Node n = (Node)o;
            for (Edge e : n.getIncoming()) {
                this.mark(e, this.getGREEN());
            }
            for (Edge e : n.getOutgoing()) {
                this.mark(e, this.getRED());
            }
            Graph graph = n.getGraph();
            if (graph.isLhs()) {
                rule = n.getGraph().getRule();
                if (rule != null) {
                    for (Mapping m : rule.getMappings()) {
                        if (m.getOrigin() != n) continue;
                        this.mark(m, this.getYELLOW());
                        if (m.getImage() == null) continue;
                        this.mark(m.getImage(), this.getBLUE());
                    }
                }
                this.colorNodeAssociatesInFormula(n, graph.getFormula());
            } else if (graph.isRhs()) {
                rule = n.getGraph().getRule();
                if (rule != null) {
                    for (Mapping m : rule.getMappings()) {
                        if (m.getImage() != n) continue;
                        this.mark(m, this.getYELLOW());
                        if (m.getOrigin() == null) continue;
                        this.mark(m.getOrigin(), this.getBLUE());
                    }
                }
            } else {
                graph.isNestedCondition();
            }
        }
    }

    protected void colorNodeAssociatesInFormula(Node node, Formula formula) {
        if (formula == null) {
            return;
        }
        if (formula instanceof UnaryFormula) {
            this.colorNodeAssociatesInFormula(node, ((UnaryFormula)formula).getChild());
            return;
        }
        if (formula instanceof BinaryFormula) {
            this.colorNodeAssociatesInFormula(node, ((BinaryFormula)formula).getLeft());
            this.colorNodeAssociatesInFormula(node, ((BinaryFormula)formula).getRight());
            return;
        }
        if (formula instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)formula;
            for (Mapping m : nc.getMappings()) {
                if (m.getOrigin() != node) continue;
                this.mark(m, this.getYELLOW());
                if (m.getImage() == null) continue;
                this.mark(m.getImage(), this.getBLUE());
                if (nc.getConclusion() == null) continue;
                this.colorNodeAssociatesInFormula(m.getImage(), nc.getConclusion().getFormula());
            }
        }
    }

    protected void mark(Object o) {
        this.mark(o, this.defaultMarkColor);
    }

    protected void mark(Object o, Color markColor) {
        if (o == null) {
            return;
        }
        Widget w = this.internalExpand(o, this.expandAssociated);
        if (w instanceof TreeItem) {
            TreeItem tItem = (TreeItem)w;
            if (this.expandAssociated) {
                this.showItem((Item)tItem);
            }
            this.associated.add(tItem);
            tItem.setBackground(markColor);
        }
    }

    protected void clearAssociated() {
        for (TreeItem item : this.associated) {
            if (item.isDisposed()) continue;
            item.setBackground(this.defaultColor);
        }
        this.associated.clear();
    }

    protected Color getRED() {
        return this.getColor(this.SPEC_FULL, this.SPEC_REDUCED, this.SPEC_REDUCED);
    }

    protected Color getGREEN() {
        return this.getColor(this.SPEC_REDUCED, this.SPEC_FULL, this.SPEC_REDUCED);
    }

    protected Color getBLUE() {
        return this.getColor(this.SPEC_REDUCED, this.SPEC_REDUCED, this.SPEC_FULL);
    }

    protected Color getYELLOW() {
        return this.getColor(this.SPEC_FULL, this.SPEC_FULL, 192);
    }

    protected Color getColor(int r, int g, int b) {
        return new Color((Device)this.getTree().getDisplay(), r, g, b);
    }

    protected Color getColor(int color) {
        return this.getTree().getDisplay().getSystemColor(color);
    }
}

