/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class ParameterConfiguration {
    public static final int CLEAR = 0;
    public static final int NULL = 1;
    public static final int STRING = 2;
    public static final int BOOLEAN = 3;
    public static final int INT = 4;
    public static final int FLOAT = 5;
    public static final int LONG = 6;
    public static final int DOUBLE = 7;
    private static Map<Integer, String> supportedTypes;
    protected IPreferenceStore store;
    protected String name;
    protected Object value;
    protected int type;

    public static Map<Integer, String> getSupportedTypes() {
        if (supportedTypes == null) {
            supportedTypes = new HashMap<Integer, String>();
            supportedTypes.put(0, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Clear"));
            supportedTypes.put(1, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Null"));
            supportedTypes.put(2, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_String"));
            supportedTypes.put(3, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Boolean"));
            supportedTypes.put(4, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Int"));
            supportedTypes.put(6, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Long"));
            supportedTypes.put(5, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Float"));
            supportedTypes.put(7, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Double"));
        }
        return supportedTypes;
    }

    public static ParameterConfiguration loadConfiguration(IPreferenceStore store, String name) {
        ParameterConfiguration cfg = new ParameterConfiguration();
        cfg.name = name;
        cfg.store = store;
        cfg.initType();
        return cfg;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeLabel() {
        return ParameterConfiguration.getSupportedTypes().get(this.type);
    }

    public boolean isClear() {
        return this.type == 0;
    }

    public void setType(int type) {
        if (!ParameterConfiguration.getSupportedTypes().containsKey(type)) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not a valid type!");
        }
        if (type == this.type) {
            return;
        }
        this.type = type;
        this.initValue();
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected void initType() {
        Integer type = this.store.getInt(this.getTypeKey());
        this.type = ParameterConfiguration.getSupportedTypes().containsKey(type) ? type : 1;
        this.initValue();
    }

    protected void initValue() {
        switch (this.getType()) {
            case 1: {
                this.setValue(null);
                return;
            }
            case 2: {
                this.setValue(this.store.getString(this.getValueKey()));
                return;
            }
            case 3: {
                this.setValue(this.store.getBoolean(this.getValueKey()));
                return;
            }
            case 7: {
                this.setValue(this.store.getDouble(this.getValueKey()));
                return;
            }
            case 6: {
                this.setValue(this.store.getLong(this.getValueKey()));
                return;
            }
            case 4: {
                this.setValue(this.store.getInt(this.getValueKey()));
                return;
            }
            case 5: {
                this.setValue(Float.valueOf(this.store.getFloat(this.getValueKey())));
                return;
            }
        }
    }

    public void persist(IPreferenceStore store) {
        store.setValue(this.getTypeKey(), this.type);
        switch (this.getType()) {
            case 2: {
                store.setValue(this.getValueKey(), (String)this.value);
                break;
            }
            case 3: {
                store.setValue(this.getValueKey(), ((Boolean)this.value).booleanValue());
                break;
            }
            case 7: {
                store.setValue(this.getValueKey(), ((Double)this.value).doubleValue());
                break;
            }
            case 6: {
                store.setValue(this.getValueKey(), ((Long)this.value).longValue());
                break;
            }
            case 4: {
                store.setValue(this.getValueKey(), ((Integer)this.value).intValue());
                break;
            }
            case 5: {
                store.setValue(this.getValueKey(), ((Float)this.value).floatValue());
            }
        }
    }

    protected String getTypeKey() {
        return "param_" + this.name + "_type";
    }

    protected String getValueKey() {
        return "param_" + this.name + "_value_" + this.type;
    }
}

