/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfiguration;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResult;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResultView;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class HenshinationPreview
implements HenshinationResultView {
    protected CompareEditorInput editorInput;
    protected HenshinationResult henshinationResult;
    Composite cc;

    public HenshinationPreview(CompareEditorInput compareInput, HenshinationResult henshinationResult) {
        this.editorInput = compareInput;
        this.henshinationResult = henshinationResult;
    }

    @Override
    public void showDialog(Shell shell) {
        boolean result = false;
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)this.editorInput);
            result = this.editorInput.getMessage() == null && this.editorInput.getCompareResult() != null;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (!result) {
            MessageDialog.openError((Shell)shell, (String)HenshinInterpreterUIPlugin.LL("_UI_Preview_ComparisonError"), (String)HenshinInterpreterUIPlugin.LL("_UI_Preview_ComparisonError_msg"));
            return;
        }
        this.editorInput.setTitle(HenshinInterpreterUIPlugin.LL("_UI_Preview_Title"));
        this.editorInput.getCompareConfiguration().setRightLabel(HenshinInterpreterUIPlugin.LL("_UI_Preview_OriginalModel"));
        this.editorInput.getCompareConfiguration().setLeftLabel(HenshinInterpreterUIPlugin.LL("_UI_Preview_TransformedModel"));
        this.editorInput.getCompareConfiguration().setLeftEditable(false);
        this.editorInput.getCompareConfiguration().setRightEditable(false);
        Dialog dlg = new Dialog(shell){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(HenshinInterpreterUIPlugin.LL("_UI_Preview_Title"));
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return HenshinInterpreterUIPlugin.getPlugin().getDialogSettings();
            }

            protected Control createDialogArea(Composite parent) {
                Composite container = (Composite)super.createDialogArea(parent);
                HenshinationPreview.this.createTabFolder(container).setLayoutData((Object)new GridData(1808));
                return container;
            }

            protected boolean isResizable() {
                return true;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dlg.open();
    }

    public Control createTabFolder(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        TabItem compareTabItem = new TabItem(tabFolder, 0);
        compareTabItem.setText(HenshinInterpreterUIPlugin.LL("_UI_Preview_CompareTab"));
        compareTabItem.setControl(this.editorInput.createContents((Composite)tabFolder));
        TabItem parameterTabItem = new TabItem(tabFolder, 0);
        parameterTabItem.setText(HenshinInterpreterUIPlugin.LL("_UI_Preview_ParameterTab"));
        parameterTabItem.setControl(this.createParameterTable((Composite)tabFolder));
        return tabFolder;
    }

    protected Control createParameterTable(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 65536);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn parameterNameColumn = new TableViewerColumn(tableViewer, 0);
        parameterNameColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_Preview_ParameterTable_ParameterNameColumn"));
        parameterNameColumn.getColumn().setWidth(200);
        parameterNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Parameter)element).getName();
            }
        });
        TableViewerColumn parameterValueBeforeColumn = new TableViewerColumn(tableViewer, 0);
        parameterValueBeforeColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_Preview_ParameterTable_ValueBeforeColumn"));
        parameterValueBeforeColumn.getColumn().setWidth(200);
        parameterValueBeforeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Parameter parameter = (Parameter)element;
                ParameterConfiguration pCfg = HenshinationPreview.this.henshinationResult.getHenshination().getParameterConfiguration(parameter.getName());
                if (pCfg.isClear()) {
                    return "";
                }
                return pCfg.getValue() == null ? "null" : pCfg.getValue().toString();
            }
        });
        TableViewerColumn parameterValueAfterColumn = new TableViewerColumn(tableViewer, 0);
        parameterValueAfterColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_Preview_ParameterTable_ValueAfterColumn"));
        parameterValueAfterColumn.getColumn().setWidth(200);
        parameterValueAfterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Parameter parameter = (Parameter)element;
                Object value = HenshinationPreview.this.henshinationResult.getUnitApplication().getResultParameterValue(parameter.getName());
                return String.valueOf(value);
            }
        });
        tableViewer.setInput((Object)this.henshinationResult.getUnitApplication().getUnit().getParameters());
        return tableViewer.getTable();
    }
}

