/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Unit;

public class AssignmentImpl
implements Assignment {
    protected Unit unit;
    protected final Map<Object, Object> values = new HashMap<Object, Object>();
    protected final boolean isResult;

    public AssignmentImpl(Unit unit) {
        this(unit, false);
    }

    public AssignmentImpl(Unit unit, boolean isResult) {
        this.isResult = isResult;
        this.setUnit(unit);
    }

    public AssignmentImpl(Assignment assignment, boolean isResultAssignment) {
        this.isResult = isResultAssignment;
        this.setUnit(assignment.getUnit());
        this.copyParameterValues(assignment);
    }

    protected void setUnit(Unit unit) {
        if (unit == null) {
            throw new NullPointerException("Unit cannot be null");
        }
        this.unit = unit;
    }

    protected void copyParameterValues(Assignment assignment) {
        for (Parameter param : this.unit.getParameters()) {
            this.setParameterValue(param, assignment.getParameterValue(param));
        }
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public Object getParameterValue(Parameter param) {
        return this.values.get(param);
    }

    protected void setValue(Object key, Object value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
    }

    @Override
    public void setParameterValue(Parameter param, Object value) {
        this.setValue(param, value);
    }

    @Override
    public List<Object> getParameterValues() {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (Parameter param : this.unit.getParameters()) {
            if (!this.values.containsKey(param)) continue;
            paramValues.add(this.values.get(param));
        }
        return paramValues;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Assignment) {
            Assignment a = (Assignment)obj;
            if (this.unit != a.getUnit()) {
                return false;
            }
            if (this.isResult != a.isResult()) {
                return false;
            }
            for (Parameter param : this.unit.getParameters()) {
                Object v1 = this.values.get(param);
                Object v2 = a.getParameterValue(param);
                if ((v1 != null || v2 == null) && (v1 == null || v1.equals(v2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isResult) {
            return "Result assignment for unit '" + this.unit.getName() + "':\n" + this.toStringWithIndent("");
        }
        return "Assignment for unit '" + this.unit.getName() + "':\n" + this.toStringWithIndent("");
    }

    protected String toStringWithIndent(String indent) {
        if (this.unit.getParameters().isEmpty()) {
            return String.valueOf(indent) + "- no parameters\n";
        }
        String result = "";
        for (Parameter param : this.unit.getParameters()) {
            Object value = this.getParameterValue(param);
            if (value == null) continue;
            result = String.valueOf(result) + indent + "- parameter '" + param.getName() + "' => " + InterpreterUtil.objectToString(value) + "\n";
        }
        return result;
    }

    @Override
    public boolean isResult() {
        return this.isResult;
    }
}

