/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.Change;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;

public abstract class ChangeImpl
implements Change {
    public static boolean PRINT_WARNINGS = true;
    protected final EGraph graph;

    public ChangeImpl(EGraph graph) {
        this.graph = graph;
    }

    @Override
    public EGraph getEGraph() {
        return this.graph;
    }

    public static final class AttributeChangeImpl
    extends ChangeImpl
    implements Change.AttributeChange {
        private final EObject object;
        private EAttribute attribute;
        private Object oldValue;
        private Object newValue;
        private boolean initialized;

        public AttributeChangeImpl(EGraph graph, EObject object, EAttribute attribute, Object newValue) {
            super(graph);
            this.object = object;
            this.attribute = attribute;
            this.newValue = newValue;
            this.initialized = false;
        }

        @Override
        public void applyAndReverse() {
            if (!this.initialized) {
                this.oldValue = this.object.eGet((EStructuralFeature)this.attribute);
                if (this.oldValue == null && this.newValue == null || this.oldValue != null && this.oldValue.equals(this.newValue)) {
                    this.attribute = null;
                }
            }
            if (this.attribute == null) {
                return;
            }
            if (this.attribute.isMany()) {
                List values = (List)this.object.eGet((EStructuralFeature)this.attribute);
                values.clear();
                if (this.newValue instanceof List) {
                    values.addAll((List)this.newValue);
                } else {
                    values.add(this.newValue);
                }
            } else {
                this.object.eSet((EStructuralFeature)this.attribute, this.newValue);
            }
            Object dummy = this.oldValue;
            this.oldValue = this.newValue;
            this.newValue = dummy;
        }

        @Override
        public EObject getObject() {
            return this.object;
        }

        @Override
        public EAttribute getAttribute() {
            return this.attribute;
        }

        @Override
        public Object getOldValue() {
            return this.oldValue;
        }

        @Override
        public Object getNewValue() {
            return this.newValue;
        }
    }

    public static final class CompoundChangeImpl
    extends ChangeImpl
    implements Change.CompoundChange {
        private final List<Change> changes = new ArrayList<Change>();
        private boolean reverse = false;

        public CompoundChangeImpl(EGraph graph) {
            super(graph);
        }

        @Override
        public void applyAndReverse() {
            int size = this.changes.size();
            if (this.reverse) {
                int i = size - 1;
                while (i >= 0) {
                    this.changes.get(i).applyAndReverse();
                    --i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    this.changes.get(i).applyAndReverse();
                    ++i;
                }
            }
            this.reverse = !this.reverse;
        }

        @Override
        public List<Change> getChanges() {
            return this.changes;
        }
    }

    public static final class IndexChangeImpl
    extends ChangeImpl
    implements Change.IndexChange {
        private final EObject source;
        private final EObject target;
        private final EReference reference;
        private int oldIndex;
        private int newIndex;
        private boolean initialized;

        public IndexChangeImpl(EGraph graph, EObject source, EObject target, EReference reference, int newIndex) {
            super(graph);
            this.source = source;
            this.target = target;
            this.reference = reference;
            this.newIndex = newIndex;
            this.initialized = false;
        }

        @Override
        public void applyAndReverse() {
            List values;
            if (!this.initialized) {
                if (this.reference.isMany()) {
                    values = (List)this.source.eGet((EStructuralFeature)this.reference);
                    this.oldIndex = values.indexOf(this.target);
                } else {
                    this.oldIndex = this.target == this.source.eGet((EStructuralFeature)this.reference) ? 0 : -1;
                }
                if (this.oldIndex < 0) {
                    throw new RuntimeException("Error changing edge index for reference " + this.reference + " in object " + this.source + ": target " + this.target + " not found");
                }
                this.initialized = true;
            }
            if (this.reference.isMany()) {
                values = (EList)this.source.eGet((EStructuralFeature)this.reference);
                values.move(this.newIndex, this.oldIndex);
            } else if (this.newIndex != 0) {
                throw new RuntimeException("Cannot move element to position " + this.newIndex + " in the non-multi reference" + this.reference);
            }
            int dummy = this.oldIndex;
            this.oldIndex = this.newIndex;
            this.newIndex = dummy;
        }

        @Override
        public EObject getSource() {
            return this.source;
        }

        @Override
        public EObject getTarget() {
            return this.target;
        }

        @Override
        public EReference getReference() {
            return this.reference;
        }

        @Override
        public int getOldIndex() {
            return this.oldIndex;
        }

        @Override
        public int getNewIndex() {
            return this.newIndex;
        }
    }

    public static final class ObjectChangeImpl
    extends ChangeImpl
    implements Change.ObjectChange {
        private final EObject object;
        private boolean create;

        public ObjectChangeImpl(EGraph graph, EObject object, boolean create) {
            super(graph);
            this.object = object;
            this.create = create;
        }

        @Override
        public void applyAndReverse() {
            if (this.create) {
                this.graph.add(this.object);
            } else {
                this.graph.remove(this.object);
            }
            this.create = !this.create;
        }

        @Override
        public EObject getObject() {
            return this.object;
        }

        @Override
        public boolean isCreate() {
            return this.create;
        }
    }

    public static final class ReferenceChangeImpl
    extends ChangeImpl
    implements Change.ReferenceChange {
        private final EObject source;
        private EReference reference;
        private int index;
        private EObject target;
        private EObject oldTarget;
        private boolean create;
        private boolean initialized;

        public ReferenceChangeImpl(EGraph graph, EObject source, EObject target, EReference reference, boolean create) {
            super(graph);
            this.source = source;
            this.target = target;
            this.create = create;
            this.reference = reference;
            this.initialized = false;
        }

        @Override
        public void applyAndReverse() {
            List values;
            if (!this.initialized) {
                if (this.reference.isMany()) {
                    values = (List)this.source.eGet((EStructuralFeature)this.reference);
                    this.index = values.indexOf(this.target);
                    if (this.create && this.index >= 0 || !this.create && this.index < 0) {
                        this.reference = null;
                    }
                    if (this.create && this.index < 0) {
                        this.index = values.size();
                    }
                } else {
                    this.oldTarget = (EObject)this.source.eGet((EStructuralFeature)this.reference);
                    if (this.create && this.target == this.oldTarget || !this.create && this.target != this.oldTarget) {
                        if (PRINT_WARNINGS) {
                            System.out.println("WARNING (Hidden step): recreating '" + this.reference.getName() + "'-edge from " + InterpreterUtil.objectToString(this.source) + " to " + InterpreterUtil.objectToString(this.oldTarget));
                        }
                        this.reference = null;
                    }
                    if (this.create && this.oldTarget != null && this.reference != null && PRINT_WARNINGS) {
                        System.out.println("WARNING (Side effect):  deleting '" + this.reference.getName() + "'-edge from " + InterpreterUtil.objectToString(this.source) + " to " + InterpreterUtil.objectToString(this.oldTarget));
                    }
                    if (this.create && this.reference != null && this.reference.isContainment() && this.target.eContainer() != null && PRINT_WARNINGS) {
                        System.out.println("WARNING (Side effect):  deleting '" + this.reference.getName() + "'-edge from " + InterpreterUtil.objectToString(this.target.eContainer()) + " to " + InterpreterUtil.objectToString(this.target));
                    }
                    if (!this.create) {
                        this.target = null;
                    }
                }
                this.initialized = true;
            }
            if (this.reference == null) {
                return;
            }
            if (this.reference.isMany()) {
                values = (List)this.source.eGet((EStructuralFeature)this.reference);
                if (this.create) {
                    values.add(this.index, this.target);
                } else {
                    values.remove(this.index);
                }
                this.create = !this.create;
            } else {
                this.source.eSet((EStructuralFeature)this.reference, (Object)this.target);
                EObject dummy = this.target;
                this.target = this.oldTarget;
                this.oldTarget = dummy;
            }
        }

        @Override
        public EObject getSource() {
            return this.source;
        }

        @Override
        public EObject getTarget() {
            return this.target;
        }

        @Override
        public EReference getReference() {
            return this.reference;
        }

        @Override
        public boolean isCreate() {
            return this.create;
        }
    }
}

