/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.actions.AbstractMapEditor;
import org.eclipse.emf.henshin.model.actions.NodeMapEditor;

public class AttributeMapEditor
extends AbstractMapEditor<Attribute> {
    private NodeMapEditor nodeMapEditor;

    public AttributeMapEditor(Graph source, Graph target, MappingList mappings) {
        super(source, target, mappings);
        this.nodeMapEditor = new NodeMapEditor(source, target, mappings);
    }

    public AttributeMapEditor(Graph target) {
        super(target);
        this.nodeMapEditor = new NodeMapEditor(target);
    }

    public AttributeMapEditor(NodeMapEditor nodeMapEditor) {
        super(nodeMapEditor);
        this.nodeMapEditor = nodeMapEditor;
    }

    private void setOppositeAttribute(Attribute attribute, Attribute opposite) {
        Attribute old;
        Node node = this.nodeMapEditor.getOpposite(attribute.getNode());
        if (node == null) {
            node = this.nodeMapEditor.copy(attribute.getNode());
        }
        if ((old = node.getAttribute(attribute.getType())) != null) {
            node.getAttributes().remove((Object)old);
        }
        if (opposite != null) {
            node.getAttributes().add((Object)opposite);
        }
    }

    @Override
    protected Attribute doCopy(Attribute attribute) {
        Attribute opposite = this.getOpposite(attribute);
        if (opposite == null) {
            opposite = HenshinFactory.eINSTANCE.createAttribute();
            opposite.setType(attribute.getType());
            opposite.setValue(attribute.getValue());
            this.setOppositeAttribute(attribute, opposite);
        }
        return opposite;
    }

    @Override
    protected void doMove(Attribute attribute) {
        this.setOppositeAttribute(attribute, attribute);
    }

    @Override
    protected void doRemove(Attribute attribute) {
        attribute.setNode(null);
    }

    @Override
    protected Attribute doReplace(Attribute attribute) {
        Node node = attribute.getNode();
        int index = node.getAttributes().indexOf((Object)attribute);
        Attribute opposite = this.getOpposite(attribute);
        node.getAttributes().set(index, (Object)opposite);
        return opposite;
    }
}

