/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.util;

import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Unit;

public abstract class HenshinNameUtil {
    protected static final int INITIAL_INDEX = 1;
    private static final String PREFIX_NODE = "node";
    private static final String PREFIX_RULE = "rule";

    protected HenshinNameUtil() {
    }

    public static String generateNewNodeName(Graph graph) {
        int max = 1;
        for (Node node : graph.getNodes()) {
            String name = node.getName();
            String string = name = name != null ? name : "";
            if (!name.startsWith(PREFIX_NODE)) continue;
            try {
                int tmp = Integer.parseInt(name.substring(PREFIX_NODE.length()));
                if (tmp <= max) continue;
                max = tmp;
            }
            catch (Exception exception) {}
        }
        return PREFIX_NODE + ++max;
    }

    public static String generateNewUnitName(Module module) {
        int max = 1;
        for (Unit unit : module.getUnits()) {
            String name = unit.getName();
            String string = name = name != null ? name : "";
            if (!name.startsWith(PREFIX_RULE)) continue;
            try {
                int tmp = Integer.parseInt(name.substring(PREFIX_RULE.length()));
                if (tmp <= max) continue;
                max = tmp;
            }
            catch (Exception exception) {}
        }
        return PREFIX_RULE + ++max;
    }
}

