/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser;

import agg.attribute.AttrContext;
import agg.attribute.impl.ValueMember;
import agg.attribute.parser.JavaClassCreation;
import java.io.File;
import java.io.IOException;

public class ExpressionParser {
    private static String classpath = "";
    private static boolean addMethodCall;
    private static String errStr;
    private static String expression;

    static {
        errStr = "";
    }

    public static final boolean parse(String className, AttrContext attrContext, ValueMember member, String expr) {
        expression = expr;
        String exprStr = expr;
        String expr1 = ExpressionParser.checkStaticMethodCall(expr);
        if (expr1.equals(expr)) {
            expr1 = ExpressionParser.checkAddMethodCall(expr);
            if (!expr1.equals(expr)) {
                exprStr = expr1;
                addMethodCall = true;
            }
        } else {
            exprStr = expr1;
        }
        JavaClassCreation jcc = new JavaClassCreation();
        File file = jcc.createClass(className, attrContext, member, exprStr, addMethodCall);
        try {
            int c;
            StringBuffer fBuffer = new StringBuffer();
            Process p = Runtime.getRuntime().exec("javac " + ExpressionParser.getClasspath() + file.getName());
            while ((c = p.getErrorStream().read()) != -1) {
                fBuffer.append((char)c);
            }
            System.out.println("Process Error Stream: \n" + fBuffer.toString());
            errStr = fBuffer.toString().trim();
            if (errStr.length() != 0 && !errStr.startsWith("Note:")) {
                return false;
            }
        }
        catch (IOException e) {
            errStr = e.getLocalizedMessage();
            e.printStackTrace();
        }
        expression = exprStr;
        return true;
    }

    public static String getError() {
        return errStr;
    }

    public static String getExpression() {
        return expression;
    }

    private static String getClasspath() {
        classpath = System.getProperty("java.class.path");
        if (classpath.trim().length() != 0) {
            classpath = "-cp " + classpath + " ";
        }
        return classpath;
    }

    private static String checkStaticMethodCall(String aValue) {
        String result = aValue;
        if (aValue.indexOf("$") == 0) {
            int ind = aValue.substring(1).indexOf("$");
            if (ind > 0) {
                result = aValue.substring(ind + 1, aValue.length());
                String clstr = aValue.substring(1, ind + 1);
                String tst = clstr.substring(clstr.lastIndexOf(".") + 1, clstr.length());
                result = String.valueOf(tst) + aValue.substring(ind + 2, aValue.length());
            }
        } else {
            String tst = aValue;
            String pname = null;
            String tmp = "";
            while (tst.indexOf(".") != -1) {
                String next = tst.substring(0, tst.indexOf("."));
                Package p = Package.getPackage(String.valueOf(tmp) + next);
                if (p != null) {
                    pname = p.getName();
                    tmp = p.getName();
                } else {
                    tmp = String.valueOf(tmp) + next;
                }
                tmp = String.valueOf(tmp) + ".";
                tst = tst.substring(tst.indexOf(".") + 1, tst.length());
            }
            if (pname != null) {
                result = aValue.replaceFirst(String.valueOf(pname) + ".", "");
            }
        }
        return result;
    }

    private static String checkAddMethodCall(String aValue) {
        String result = aValue.replaceFirst(";", ".");
        return result;
    }
}

