/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.animation;

import agg.gui.animation.AnimationParam;
import agg.gui.animation.NodeAnimation;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AnimationParamDialog {
    protected final JDialog dialog = new JDialog((Frame)new JFrame(), " Node Animation Parameter ");
    protected final JComboBox kindField;
    protected JTextField stepField;
    protected JTextField delayField;
    protected JTextField plusField;
    protected boolean changed;
    protected final Vector<String> kinds;
    protected JComboBox targetEdgeTypesField;
    protected final Vector<String> targetEdgeTypeNames;
    protected final JLabel text;
    protected AnimationParam param;

    public AnimationParamDialog(AnimationParam parameter) {
        this.dialog.setModal(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnimationParamDialog.this.dialog.setVisible(false);
            }
        });
        this.param = parameter;
        this.text = new JLabel("   ");
        this.kinds = NodeAnimation.getAnimationKindsAsString();
        this.kindField = new JComboBox<String>(this.kinds);
        this.targetEdgeTypeNames = new Vector();
        JPanel content = this.initDialog();
        if (this.param.kind == 11 || this.param.kind == 30 || this.param.kind == 31) {
            this.stepField.setEditable(false);
        }
        this.dialog.getContentPane().add(content);
        this.dialog.validate();
        this.dialog.setSize(300, 200);
        this.dialog.pack();
    }

    public AnimationParamDialog(AnimationParam parameter, Type nodeType, Graph typeGraph) {
        this.dialog.setModal(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnimationParamDialog.this.dialog.setVisible(false);
            }
        });
        this.param = parameter;
        this.text = new JLabel("   ");
        this.kinds = NodeAnimation.getAnimationKindsAsString();
        this.kindField = new JComboBox<String>(this.kinds);
        this.targetEdgeTypeNames = new Vector();
        if (typeGraph instanceof TypeGraph) {
            List<Node> list = typeGraph.getNodes(nodeType);
            if (list != null && list.size() == 1) {
                Node n = list.get(0);
                for (Arc arc : n.getOutgoingArcsSet()) {
                    if (arc.isInheritance()) {
                        this.getNameOfParentEdge((Node)arc.getTarget());
                        continue;
                    }
                    String tname = arc.getType().getName();
                    if ("".equals(tname)) {
                        tname = "[unnamed";
                    }
                    if (this.targetEdgeTypeNames.contains(tname)) continue;
                    this.targetEdgeTypeNames.add(tname);
                }
            }
            this.targetEdgeTypesField = new JComboBox<String>(this.targetEdgeTypeNames);
        }
        JPanel content = this.initDialog();
        if (this.param.kind == 11 || this.param.kind == 30 || this.param.kind == 31) {
            this.stepField.setEditable(false);
        }
        this.dialog.getContentPane().add(content);
        this.dialog.validate();
        this.dialog.setSize(300, 200);
        this.dialog.pack();
    }

    private void getNameOfParentEdge(Node n) {
        for (Arc arc : n.getOutgoingArcsSet()) {
            if (arc.isInheritance()) {
                this.getNameOfParentEdge((Node)arc.getTarget());
                continue;
            }
            String tname = arc.getType().getName();
            if ("".equals(tname)) {
                tname = "[unnamed";
            }
            if (this.targetEdgeTypeNames.contains(tname)) continue;
            this.targetEdgeTypeNames.add(tname);
        }
    }

    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }

    public void showParameterDialog(int x, int y) {
        this.dialog.setLocation(x, y);
        this.dialog.setVisible(true);
        this.dialog.toFront();
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void unsetChanged() {
        this.changed = false;
    }

    private JPanel initDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(" Please set values "));
        JPanel p = new JPanel(new GridLayout(0, 1));
        JPanel p1 = this.makeKindField(this.param.getKind());
        p.add(p1);
        JPanel p2 = this.makeStepField(this.param.getStep());
        p.add(p2);
        JPanel p3 = this.makeDelayField(this.param.getDelay());
        p.add(p3);
        JPanel p4 = this.makeEndPlusField(this.param.getEndPlus());
        p.add(p4);
        if (this.targetEdgeTypesField != null && !this.targetEdgeTypeNames.isEmpty()) {
            String paramTargetEdgeTypeName = this.targetEdgeTypeNames.get(0);
            if (this.param.getTargetEdgeTypeName() != null) {
                paramTargetEdgeTypeName = this.param.getTargetEdgeTypeName();
            } else {
                this.param.setTargetEdgeTypeName(paramTargetEdgeTypeName);
            }
            JPanel p5 = this.makeTargetEdgeTypesField(paramTargetEdgeTypeName);
            p.add(p5);
        }
        JPanel pClose = this.makeCloseButton();
        panel.add((Component)p, "Center");
        panel.add((Component)pClose, "South");
        return panel;
    }

    private JPanel makeKindField(String value) {
        JPanel p1 = new JPanel(new GridLayout(0, 1));
        p1.setBorder(new TitledBorder(""));
        JLabel l1 = new JLabel("Animation kind");
        this.kindField.setSelectedItem(value);
        this.kindField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String kind = (String)e.getItem();
                    if (kind.equals("JUMP")) {
                        AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || AnimationParamDialog.this.param.kind != 11;
                        AnimationParamDialog.this.param.kind = 11;
                        AnimationParamDialog.this.stepField.setEditable(false);
                    } else if (kind.equals("WORM")) {
                        AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || AnimationParamDialog.this.param.kind != 20;
                        AnimationParamDialog.this.param.kind = 20;
                        AnimationParamDialog.this.stepField.setEditable(true);
                    } else if (kind.equals("CROSS")) {
                        AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || AnimationParamDialog.this.param.kind != 30;
                        AnimationParamDialog.this.param.kind = 30;
                        AnimationParamDialog.this.stepField.setEditable(false);
                    } else if (kind.equals("COMBI_CROSS")) {
                        AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || AnimationParamDialog.this.param.kind != 31;
                        AnimationParamDialog.this.param.kind = 31;
                        AnimationParamDialog.this.stepField.setEditable(false);
                    }
                }
            }
        });
        p1.add(l1);
        p1.add(this.kindField);
        return p1;
    }

    private JPanel makeCloseButton() {
        JPanel p = new JPanel(new GridLayout(1, 0));
        JButton close = new JButton("Close");
        p.add((Component)close, "Center");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationParamDialog.this.getAnimationParameter();
                AnimationParamDialog.this.dialog.setVisible(false);
            }
        });
        p.add(new JLabel("   "));
        p.add(close);
        p.add(new JLabel("   "));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)p, "South");
        return p1;
    }

    public AnimationParam getAnimationParameter() {
        this.param.setKind((String)this.kindField.getSelectedItem());
        this.param.setStep(this.stepField.getText());
        this.param.setDelay(this.delayField.getText());
        this.param.setEndPlus(this.plusField.getText());
        this.param.setTargetEdgeTypeName((String)this.targetEdgeTypesField.getSelectedItem());
        return this.param;
    }

    private JPanel makeStepField(final String value) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(" Animation step size "));
        JLabel l = new JLabel("Points: ");
        this.stepField = new JTextField(value, 5);
        this.stepField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        if (nb >= 0) {
                            AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || AnimationParamDialog.this.param.step != nb;
                            AnimationParamDialog.this.param.step = nb;
                        } else {
                            AnimationParamDialog.this.stepField.setText(value);
                        }
                    }
                    catch (NumberFormatException ex) {
                        AnimationParamDialog.this.stepField.setText(value);
                    }
                }
            }
        });
        p.add((Component)l, "Center");
        p.add((Component)this.stepField, "East");
        return p;
    }

    private JPanel makeDelayField(final String value) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(" Animation delay time "));
        JLabel l = new JLabel(" Milliseconds: ");
        this.delayField = new JTextField(value, 5);
        this.delayField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        if (nb >= 0) {
                            AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || nb != AnimationParamDialog.this.param.delay;
                            AnimationParamDialog.this.param.delay = nb;
                        } else {
                            AnimationParamDialog.this.delayField.setText(value);
                        }
                    }
                    catch (NumberFormatException ex) {
                        AnimationParamDialog.this.delayField.setText(value);
                    }
                }
            }
        });
        p.add((Component)l, "Center");
        p.add((Component)this.delayField, "East");
        return p;
    }

    private JPanel makeEndPlusField(final String value) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(" End position offset "));
        JLabel l = new JLabel(" Points: ");
        this.plusField = new JTextField(value, 5);
        this.plusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || nb != AnimationParamDialog.this.param.plus;
                        AnimationParamDialog.this.param.plus = nb;
                    }
                    catch (NumberFormatException ex) {
                        AnimationParamDialog.this.plusField.setText(value);
                    }
                }
            }
        });
        p.add((Component)l, "Center");
        p.add((Component)this.plusField, "East");
        return p;
    }

    private JPanel makeTargetEdgeTypesField(String value) {
        JPanel p1 = new JPanel(new GridLayout(0, 1));
        p1.setBorder(new TitledBorder(""));
        JLabel l1 = new JLabel("Edge Type");
        this.targetEdgeTypesField.setSelectedItem(value);
        this.targetEdgeTypesField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String tname = (String)e.getItem();
                    AnimationParamDialog.this.changed = AnimationParamDialog.this.changed || !AnimationParamDialog.this.param.targetEdgeTypeName.equals(tname);
                    AnimationParamDialog.this.param.setTargetEdgeTypeName(tname);
                }
            }
        });
        p1.add(l1);
        p1.add(this.targetEdgeTypesField);
        return p1;
    }
}

