/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdGraph;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTextualComment;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GraphPopupMenu
extends JPopupMenu {
    private GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    GraGraTreeNodeData data;
    EdGraph graph;
    private JMenuItem delete;

    public GraphPopupMenu(GraGraTreeView tree) {
        super("Graph");
        this.treeView = tree;
        JMenuItem mi = this.add(new JMenuItem("Reset"));
        mi.setActionCommand("resetGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphPopupMenu.this.treeView.resetGraph(GraphPopupMenu.this.graph);
            }
        });
        mi = this.add(new JMenuItem("Delete                   Delete"));
        mi.setActionCommand("deleteGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphPopupMenu.this.treeView.hasMultipleSelection()) {
                    GraphPopupMenu.this.treeView.delete("selected");
                } else {
                    GraphPopupMenu.this.treeView.deleteGraph(GraphPopupMenu.this.node, GraphPopupMenu.this.path, true);
                }
            }
        });
        mi.setEnabled(false);
        this.delete = mi;
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphPopupMenu.this.editComments();
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            if (this.path.getPath().length == 3) {
                this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
                this.data = (GraGraTreeNodeData)this.node.getUserObject();
                if (this.data != null && this.data.isGraph() && !this.data.isTypeGraph()) {
                    this.graph = this.treeView.getGraph(this.node);
                    if (this.graph.getGraGra().getGraphs().size() > 1) {
                        this.delete.setEnabled(true);
                    } else {
                        this.delete.setEnabled(false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    void editComments() {
        if (this.graph != null) {
            GraGraTextualComment comments;
            this.treeView.cancelCommentsEdit();
            Point p = this.treeView.getPopupMenuLocation();
            if (p == null) {
                p = new Point(200, 200);
            }
            if ((comments = new GraGraTextualComment(this.treeView.getFrame(), p.x, p.y, this.graph.getBasisGraph())) != null) {
                comments.setVisible(true);
            }
        }
    }
}

