/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.trafo;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.VarMember;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.trafo.GraGraTransform;
import agg.util.Pair;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_NAC;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.ParallelRule;
import agg.xt_basis.Rule;
import agg.xt_basis.StaticStep;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import agg.xt_basis.csp.Completion_PartialInjCSP;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class TransformDebug
implements GraTraEventListener,
EditEventListener {
    int count = -1;
    Pair<OrdinaryMorphism, OrdinaryMorphism> mod1;
    Pair<OrdinaryMorphism, OrdinaryMorphism> mod2;
    private final GraGraTransform gragraTransform;
    EdRule rule;
    Match match;
    private Match lastValidMatch;
    private final Pair<String, String> lastErrorMsg = new Pair<String, String>("", "");
    private MorphCompletionStrategy strategy;
    private boolean matchIsValid;
    private final GraTra gratra;
    private int msgGraTra;
    private boolean stepInputParameterNotSet;
    private boolean completeInputParameterNotSet;
    private AttrContext ac;
    private AttrVariableTuple avt;
    private AttrConditionTuple act;

    public TransformDebug(GraGraTransform transform) {
        this.gragraTransform = transform;
        this.gratra = new DefaultGraTraImpl();
        this.gratra.addGraTraListener(this);
        this.completeInputParameterNotSet = false;
        this.stepInputParameterNotSet = false;
    }

    public void dispose() {
        this.gratra.dispose();
        this.match = null;
        this.lastValidMatch = null;
        this.rule = null;
        this.ac = null;
        this.act = null;
        this.avt = null;
    }

    public void refreshAsGraTraListener() {
        this.gratra.addGraTraListener(this);
    }

    public Vector<Rule> getApplicableRules(EdGraGra gragra) {
        Vector<Rule> applicableRules = new Vector<Rule>();
        Pair<Object, String> test = gragra.getBasisGraGra().isReadyToTransform();
        boolean testg = gragra.getBasisGraGra().isGraphReadyForTransform();
        if (test != null) {
            if (test instanceof Rule) {
                JOptionPane.showMessageDialog(null, "Something is wrong.\nPlease check attribute settings of the rule \"" + ((Rule)((Object)test)).getName() + "\".");
            }
        } else if (!testg) {
            JOptionPane.showMessageDialog(null, "Something is wrong.\nPlease check attribute settings of the host graph.");
        } else {
            applicableRules.addAll(gragra.getApplicableRules(this.strategy));
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 20, applicableRules));
        }
        return applicableRules;
    }

    public Vector<EdRule> getApplicableRules(EdGraGra gragra, boolean applicable) {
        int i = 0;
        while (i < gragra.getRules().size()) {
            EdRule r = gragra.getRules().elementAt(i);
            r.setApplicable(applicable);
            ++i;
        }
        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 20, gragra.getRules()));
        return gragra.getRules();
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
        this.gratra.setCompletionStrategy(this.strategy);
    }

    public void setRule(EdRule r) {
        this.rule = r;
        this.ac = null;
        this.avt = null;
        this.act = null;
        if (this.rule == null) {
            this.gratra.setGraGra(null);
            return;
        }
        if (this.gratra.getGraGra() == null || this.gratra.getGraGra() != this.rule.getGraGra().getBasisGraGra()) {
            this.rule.getGraGra().getBasisGraGra().setGraTraOptions(this.strategy);
            this.gratra.setGraGra(this.rule.getGraGra().getBasisGraGra());
        }
        this.gratra.setHostGraph(this.rule.getGraGra().getBasisGraGra().getGraph());
        this.completeInputParameterNotSet = true;
        this.stepInputParameterNotSet = true;
    }

    public EdRule getRule() {
        return this.rule;
    }

    public Match getMatch() {
        return this.match;
    }

    private Match getMatch(EdRule r) {
        Match m = null;
        if (r.getBasisRule().getRuleScheme() != null) {
            if (r.getBasisRule() instanceof KernelRule || r.getBasisRule() instanceof MultiRule || r.getBasisRule() instanceof AmalgamatedRule) {
                m = r.getBasisRule().getMatch();
            }
        } else {
            m = r.getBasisRule().getMatch();
        }
        return m;
    }

    public void matchDef() {
        if (this.rule == null) {
            return;
        }
        if (!this.rule.getName().equals(this.lastErrorMsg.second)) {
            this.lastErrorMsg.second = this.rule.getName();
        }
        this.lastErrorMsg.first = "";
        if (!this.checkIfReadyForTransform()) {
            return;
        }
        this.match = this.getMatch(this.rule);
        if (this.match == null) {
            this.newMatch();
        } else {
            this.clearMatch();
            this.setMatch();
            this.resetTargetGraphOfMatchIfNeeded();
            this.match.setTypeObjectsMapChanged(true);
            this.match.setPartialMorphismCompletion(false);
        }
        this.gragraTransform.fireTransform(new TransformEvent(this, 5));
        this.gragraTransform.fireTransform(new TransformEvent(this, 11));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nextCompletion() {
        if (this.rule == null) {
            return;
        }
        if (!this.rule.getName().equals(this.lastErrorMsg.second)) {
            this.lastErrorMsg.first = "";
            this.lastErrorMsg.second = this.rule.getName();
        }
        if (!this.checkIfReadyForTransform()) {
            return;
        }
        this.gragraTransform.fireTransform(new TransformEvent(this, 12));
        this.match = this.getMatch(this.rule);
        if (this.match == null) {
            this.completeInputParameterNotSet = true;
            this.stepInputParameterNotSet = true;
            this.newMatch();
            if (this.match != null && this.match.canComplete()) {
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.completeInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
            }
        } else {
            this.setMatch();
            this.resetTargetGraphOfMatchIfNeeded();
            if (this.match.isEmpty() && !this.match.getRule().isParallelApplyEnabled()) {
                this.match.getCompletionStrategy().resetSolver(true);
            }
            if (!this.match.isTotal()) {
                this.matchIsValid = false;
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.completeInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
            } else {
                this.completeInputParameterNotSet = true;
                this.stepInputParameterNotSet = true;
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.completeInputParameterNotSet = false;
                if (this.matchIsValid) {
                    this.completeInputParameterNotSet = true;
                    if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                    this.completeInputParameterNotSet = false;
                    this.matchIsValid = this.doNextCompletion();
                } else {
                    this.matchIsValid = !this.match.isAttrConditionSatisfied() ? this.doNextCompletion() : (!this.match.areNACsSatisfied() ? this.doNextCompletion() : (!this.match.arePACsSatisfied() ? this.doNextCompletion() : (!this.match.getRule().evalFormula() ? this.doNextCompletion() : (!this.match.isParallelArcSatisfied() ? this.doNextCompletion() : this.match.isValid()))));
                }
            }
        }
        if (this.matchIsValid) {
            this.rule.update();
            this.lastValidMatch = this.match;
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 7, this.match));
            return;
        } else {
            String msg = (String)this.lastErrorMsg.first;
            this.destroyMatch();
            if (this.gragraTransform.selectMatchObjectsEnabled()) {
                this.rule.getGraGra().getGraph().deselectAll();
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, msg));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void step() {
        if (this.rule == null || !this.checkIfReadyForTransform()) {
            return;
        }
        if (!this.rule.getName().equals(this.lastErrorMsg.second)) {
            this.lastErrorMsg.first = "";
            this.lastErrorMsg.second = this.rule.getName();
        }
        this.gragraTransform.fireTransform(new TransformEvent(this, 13));
        this.gratra.setGraTraOptions(this.gragraTransform.getGraTraOptions());
        if (this.rule.getBasisRule().getRuleScheme() != null) {
            this.rule.getBasisRule().getRuleScheme().clearMatchesOfMultiRules();
            this.completeInputParameterNotSet = false;
            this.stepInputParameterNotSet = true;
            if (!this.areAllInputParameterSet(this.rule.getBasisRule().getRuleScheme(), true) || this.gratra.apply(this.rule.getBasisRule().getRuleScheme())) return;
            this.destroyMatch();
            String errmsg = this.rule.getBasisRule().getRuleScheme().getErrorMsg();
            if ("".equals(errmsg)) {
                errmsg = "Amalgamated match failed.";
            }
            this.rule.updateMatch();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, errmsg));
            return;
        }
        this.match = this.getMatch(this.rule);
        if (this.match == null) {
            this.completeInputParameterNotSet = false;
            this.stepInputParameterNotSet = true;
            this.newMatch();
            if (this.match != null && this.match.canComplete()) {
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.stepInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
            }
        } else {
            this.setMatch();
            this.resetTargetGraphOfMatchIfNeeded();
            if (!this.match.hasPartialMorphismCompletion() && this.match.isEmpty() && !this.match.getRule().isParallelApplyEnabled()) {
                this.match.getCompletionStrategy().resetSolver(true);
            }
            if (!this.match.isTotal()) {
                this.matchIsValid = false;
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.stepInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
                if (!this.matchIsValid && this.match.getRule().isParallelApplyEnabled()) {
                    this.clearMatch();
                    this.match.setTypeObjectsMapChanged(true);
                    this.matchIsValid = this.doNextCompletion();
                }
                if (!this.matchIsValid) {
                    String msg = ((String)this.lastErrorMsg.first).length() > 0 ? (String)this.lastErrorMsg.first : "The rule  \"" + this.rule.getName() + "\"  doesn't match.";
                    this.destroyMatch();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, msg));
                    return;
                }
            } else if (this.match.equals(this.lastValidMatch)) {
                this.matchIsValid = true;
            } else if (!this.matchIsValid) {
                boolean totalOK = true;
                this.completeInputParameterNotSet = false;
                if (!this.areAllInputParameterSet(this.rule.getRight(), false)) return;
                this.stepInputParameterNotSet = false;
                if (!this.match.areNACsSatisfied()) {
                    this.lastErrorMsg.first = this.match.getErrorMsg();
                    totalOK = false;
                } else if (!this.match.arePACsSatisfied()) {
                    this.lastErrorMsg.first = this.match.getErrorMsg();
                    totalOK = false;
                } else if (!this.match.getRule().evalFormula()) {
                    this.lastErrorMsg.first = this.match.getErrorMsg();
                    totalOK = false;
                } else if (!this.match.isParallelArcSatisfied()) {
                    this.lastErrorMsg.first = this.match.getErrorMsg();
                    totalOK = false;
                }
                if (totalOK && this.match.isValid()) {
                    this.matchIsValid = true;
                }
            }
        }
        if (this.matchIsValid) {
            this.completeInputParameterNotSet = false;
            if (!this.areAllInputParameterSet(this.rule.getRight(), false)) return;
            this.stepInputParameterNotSet = false;
            if (this.isReadyToTransform()) {
                this.rule.addDeletedMatchMappingToUndo();
                this.rule.undoManagerEndEdit();
                this.gragraTransform.fireTransform(new TransformEvent(this, 17, this.match, ""));
                this.gratra.apply(this.match);
                return;
            } else {
                this.destroyMatch();
            }
            return;
        } else {
            String msg = ((String)this.lastErrorMsg.first).length() > 0 ? (String)this.lastErrorMsg.first : "The rule  \"" + this.rule.getName() + "\"  doesn't match.";
            this.destroyMatch();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, msg));
        }
    }

    private boolean stepByMatch() {
        if (this.isReadyToTransform()) {
            this.rule.addDeletedMatchMappingToUndo();
            this.rule.undoManagerEndEdit();
            this.gragraTransform.fireTransform(new TransformEvent(this, 17, this.match, ""));
            this.gratra.apply(this.match);
            return true;
        }
        return false;
    }

    private boolean isTotalMatchValid(Match m) {
        if (!this.match.areNACsSatisfied()) {
            this.lastErrorMsg.first = this.match.getErrorMsg();
        } else if (!this.match.arePACsSatisfied()) {
            this.lastErrorMsg.first = this.match.getErrorMsg();
        } else if (!this.match.isValid()) {
            this.lastErrorMsg.first = this.match.getErrorMsg();
        } else {
            this.matchIsValid = true;
            return true;
        }
        return false;
    }

    @Override
    public void graTraEventOccurred(GraTraEvent e) {
        this.msgGraTra = e.getMessage();
        if (this.msgGraTra == 3) {
            System.out.println("TransformDebug.graTraEventOccurred : " + e.getMessage());
            if (e.getMatch().getRule().isParallelApplyEnabled()) {
                e.getMatch().getCompletionStrategy().resetSolver(true);
            }
        } else if (this.msgGraTra == 8) {
            this.rule.getGraGra().getGraph().unsetNodeNumberChanged();
            if (this.gragraTransform.selectMatchObjectsEnabled()) {
                this.rule.getGraGra().getGraph().updateAlongMorph(e.getMatch());
            }
        } else if (this.msgGraTra == 2) {
            if (this.match == null) {
                this.match = e.getMatch();
            }
            this.rule.getGraGra().getGraph().setXYofNewNode(this.rule, this.match, this.match.getCoMorphism());
            if (this.rule.isAnimated()) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 25, this.match));
            } else {
                this.gragraTransform.getEditor().doStandardLayoutProc();
            }
            if (this.gragraTransform.selectNewAfterStepEnabled()) {
                this.rule.getGraGra().getGraph().updateAlongMorph(this.match.getCoMorphism(), this.rule.getBasisRule());
            }
            if (!this.rule.getBasisRule().isParallelApplyEnabled()) {
                this.destroyMatch();
            } else {
                this.clearMatch();
            }
            this.gragraTransform.fireTransform(new TransformEvent(this, 2));
        } else if (this.msgGraTra == 4) {
            String msg;
            String string = msg = this.match != null && !"".equals(this.match.getErrorMsg()) ? this.match.getErrorMsg() : e.getMessageText();
            if ("".equals(msg)) {
                msg = "Undefined error occured. \nPlease check the rule  " + this.rule.getName() + "  resp. its match.";
            }
            this.destroyMatch();
            this.rule.getGraGra().getGraph().update();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, msg));
        } else if (this.msgGraTra == 11) {
            String msg = "";
            if (this.rule != null && this.rule.getBasisRule() != null) {
                msg = "Inconsistency of the host graph after the rule < " + this.rule.getBasisRule().getName() + ">  !";
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, msg));
                if (!this.rule.getBasisRule().isParallelApplyEnabled()) {
                    this.destroyMatch();
                } else {
                    this.clearMatch();
                }
                this.rule.getGraGra().getGraph().update();
            } else {
                msg = "Inconsistency of the host graph after this rule applied!";
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, msg));
            }
        } else if (this.msgGraTra == 21) {
            System.out.println("TransformDebug.graTraEventOccurred : " + e.getMessage());
        }
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -3) {
            if (this.match == null || this.rule.getBasisRule().getRuleScheme() != null) {
                if (this.rule != null && this.rule.getBasisRule() != null && this.rule.getBasisRule().getRuleScheme() != null) {
                    this.rule.getBasisRule().getRuleScheme().applyValueOfInputParameter();
                    if (this.completeInputParameterNotSet) {
                        this.completeInputParameterNotSet = false;
                        this.nextCompletion();
                    } else if (this.stepInputParameterNotSet) {
                        this.stepInputParameterNotSet = false;
                        if (!this.gratra.apply(this.rule.getBasisRule().getRuleScheme())) {
                            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, "Amalgamated match failed."));
                        }
                    }
                }
            } else {
                if (this.completeInputParameterNotSet) {
                    this.completeInputParameterNotSet = false;
                    this.nextCompletion();
                } else if (this.stepInputParameterNotSet) {
                    this.stepInputParameterNotSet = false;
                    if (!this.matchIsValid) {
                        if (this.match.isTotal()) {
                            this.matchIsValid = this.isTotalMatchValid(this.match);
                        } else {
                            this.matchIsValid = this.doNextCompletion();
                            if (!this.matchIsValid) {
                                this.destroyMatch();
                                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, ""));
                            }
                        }
                    }
                }
                if (this.matchIsValid && !this.stepInputParameterNotSet && !this.stepByMatch() && this.match != null) {
                    String msg = this.match.getErrorMsg();
                    this.destroyMatch();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, msg));
                }
            }
        }
    }

    private void newMatch() {
        if (this.rule.getBasisRule().getRuleScheme() != null) {
            if (this.rule.getBasisRule() instanceof KernelRule) {
                this.match = this.rule.getGraGra().getRuleScheme(this.rule.getBasisRule()).getBasisRuleScheme().getKernelMatch(this.rule.getGraGra().getBasisGraGra().getGraph());
            } else if (this.rule.getBasisRule() instanceof MultiRule) {
                RuleScheme rs = this.rule.getGraGra().getRuleScheme(this.rule.getBasisRule()).getBasisRuleScheme();
                rs.getKernelMatch(this.rule.getGraGra().getBasisGraGra().getGraph());
                this.match = ((MultiRule)this.rule.getBasisRule()).getMatch(rs.getKernelRule());
            } else if (this.rule.getBasisRule() instanceof AmalgamatedRule) {
                this.match = this.rule.getBasisRule().getMatch();
            }
        } else {
            this.match = this.rule.getGraGra().getBasisGraGra().createMatch(this.rule.getBasisRule());
        }
        if (this.match != null) {
            this.match.addObserver(this.rule.getLeft());
            this.match.addObserver(this.rule.getGraGra().getGraph());
            if (this.rule.getBasisRule() instanceof ParallelRule) {
                if (this.gragraTransform.getGraTraOptions().hasOption("NACs") || this.gragraTransform.getGraTraOptions().hasOption("PACs") || this.gragraTransform.getGraTraOptions().hasOption("GACs")) {
                    this.match.setCompletionStrategy(new Completion_NAC(new Completion_PartialInjCSP()), true);
                } else {
                    this.match.setCompletionStrategy(new Completion_PartialInjCSP(), true);
                }
                this.adjustMatchComplStrategyOfParallelRule();
            } else {
                this.match.setCompletionStrategy((MorphCompletionStrategy)this.strategy.clone(), true);
            }
            if (this.rule.getBasisRule() instanceof KernelRule || this.rule.getBasisRule() instanceof MultiRule) {
                this.match.getCompletionStrategy().getProperties().set(1, false);
            }
            this.ac = this.match.getAttrContext();
            this.avt = this.ac.getVariables();
            this.act = this.ac.getConditions();
            this.lastErrorMsg.first = "";
            this.lastErrorMsg.second = "";
            this.matchIsValid = false;
            this.lastValidMatch = null;
        }
    }

    private void adjustMatchComplStrategyOfParallelRule() {
        if (this.gragraTransform.getGraTraOptions().hasOption("NACs")) {
            this.match.getCompletionStrategy().setProperty("NACs");
        } else {
            this.match.getCompletionStrategy().removeProperty("NACs");
        }
        if (this.gragraTransform.getGraTraOptions().hasOption("PACs")) {
            this.match.getCompletionStrategy().setProperty("PACs");
        } else {
            this.match.getCompletionStrategy().removeProperty("PACs");
        }
        if (this.gragraTransform.getGraTraOptions().hasOption("GACs")) {
            this.match.getCompletionStrategy().setProperty("GACs");
        } else {
            this.match.getCompletionStrategy().removeProperty("GACs");
        }
        if (this.gragraTransform.getGraTraOptions().hasOption("injective")) {
            this.match.getCompletionStrategy().setProperty("injective");
        } else {
            this.match.getCompletionStrategy().removeProperty("injective");
        }
        if (this.gragraTransform.getGraTraOptions().hasOption("dangling")) {
            this.match.getCompletionStrategy().setProperty("dangling");
        } else {
            this.match.getCompletionStrategy().removeProperty("dangling");
        }
        if (this.gragraTransform.getGraTraOptions().hasOption("identification")) {
            this.match.getCompletionStrategy().setProperty("identification");
        } else {
            this.match.getCompletionStrategy().removeProperty("identification");
        }
    }

    private void setMatch() {
        if (this.rule.getMatch() != this.match) {
            this.ac = this.match.getAttrContext();
            this.avt = this.ac.getVariables();
            this.act = this.ac.getConditions();
            this.matchIsValid = false;
            this.lastValidMatch = null;
        }
    }

    private boolean doNextCompletion() {
        if (this.match == null) {
            return false;
        }
        this.rule.addCreatedMatchMappingToUndo();
        boolean completionDone = false;
        while (this.match.nextCompletion()) {
            completionDone = true;
            if (this.match.isValid()) {
                this.lastErrorMsg.first = "";
                this.rule.undoManagerEndEdit();
                return true;
            }
            this.lastErrorMsg.first = this.match.getErrorMsg();
            this.match.clear();
        }
        if (!completionDone) {
            this.lastErrorMsg.first = this.match.getErrorMsg();
        }
        this.match.clear();
        this.rule.undoManagerLastEditDie();
        return false;
    }

    private void resetTargetGraphOfMatchIfNeeded() {
        if (this.match != null && this.match.getTarget() != this.rule.getGraGra().getGraph().getBasisGraph()) {
            this.match.resetTarget(this.rule.getGraGra().getGraph().getBasisGraph());
            this.match.setTypeObjectsMapChanged(true);
        }
    }

    public void destroyMatch() {
        if (this.match == null || this.match.getRule() == null) {
            return;
        }
        if (this.rule.getBasisRule().getRuleScheme() == null) {
            this.rule.getGraGra().getBasisGraGra().destroyMatch(this.match);
        }
        this.rule.update();
        this.match = null;
        this.ac = null;
        this.act = null;
        this.avt = null;
        this.lastValidMatch = null;
        this.matchIsValid = false;
        this.completeInputParameterNotSet = true;
        this.stepInputParameterNotSet = true;
    }

    protected void clearMatch() {
        if (this.match != null) {
            this.match.clear();
            this.rule.update();
        }
        this.lastValidMatch = null;
        this.matchIsValid = false;
        this.completeInputParameterNotSet = true;
        this.stepInputParameterNotSet = true;
    }

    private boolean areAllInputParameterSet(RuleScheme rs, boolean left) {
        if (rs.getAmalgamatedRule() == null && !rs.isInputParameterSet(left)) {
            int answer = this.parameterWarning(rs.getName());
            if (answer == 0) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, rs));
            } else {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 8, rs));
                rs.disposeAmalgamatedRule();
            }
            return false;
        }
        return true;
    }

    private boolean areAllInputParameterSet(EdGraph g, boolean left) {
        if (this.match == null) {
            return true;
        }
        this.ac = this.match.getAttrContext();
        this.avt = this.ac.getVariables();
        if (this.avt == null || this.avt.getNumberOfEntries() == 0 || this.avt.areInputParametersSet()) {
            return true;
        }
        this.act = this.ac.getConditions();
        int i = 0;
        while (i < this.avt.getNumberOfEntries()) {
            VarMember v = this.avt.getVarMemberAt(i);
            if (v.isInputParameter() && !v.isSet()) {
                if (g.isUsingVariable(v)) {
                    int answer = this.parameterWarning(this.match.getRule().getName());
                    if (answer == 0) {
                        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
                    } else {
                        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 8, this.match));
                    }
                    return false;
                }
                if (left) {
                    List<OrdinaryMorphism> nacs = this.rule.getBasisRule().getNACsList();
                    int l = 0;
                    while (l < nacs.size()) {
                        OrdinaryMorphism nac = nacs.get(l);
                        if (nac.getTarget().isUsingVariable(v)) {
                            int answer = this.parameterWarning(this.match.getRule().getName());
                            if (answer == 0) {
                                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
                            } else {
                                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 8, this.match));
                            }
                            return false;
                        }
                        Vector<String> nacVars = nac.getTarget().getVariableNamesOfAttributes();
                        int j = 0;
                        while (j < nacVars.size()) {
                            String varName = nacVars.get(j);
                            int k = 0;
                            while (k < this.act.getNumberOfEntries()) {
                                CondMember cond = (CondMember)this.act.getMemberAt(k);
                                Vector<String> condVars = cond.getAllVariables();
                                if (condVars.contains(varName) && condVars.contains(v.getName())) {
                                    int answer = this.parameterWarning(this.match.getRule().getName());
                                    if (answer == 0) {
                                        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
                                    } else {
                                        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 8, this.match));
                                    }
                                    return false;
                                }
                                ++k;
                            }
                            ++j;
                        }
                        ++l;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkIfReadyForTransform() {
        Type t = this.gratra.getGraGra().doAttrTypesExist();
        if (t != null) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, "Not all attribute members of the type :  \"" + t.getName() + "\"  are declared correctly."));
            return false;
        }
        Pair<Object, String> p = this.gratra.getGraGra().checkInheritedAttributesValid();
        if (p != null) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, (String)p.second));
            return false;
        }
        if (!this.gratra.getGraGra().getGraph().isReadyForTransform()) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, "Not all attributes of objects of the host graph are set."));
            return false;
        }
        if (this.rule instanceof EdRuleScheme) {
            if (!((EdRuleScheme)this.rule).getBasisRuleScheme().isReadyToTransform()) {
                String msgStr = this.rule.getName().concat("   is not ready to transform");
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, msgStr));
                return false;
            }
        } else {
            if (!this.rule.getBasisRule().isReadyToTransform()) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, this.rule.getBasisRule().getErrorMsg()));
                return false;
            }
            p = this.gratra.getGraGra().isGraphConstraintReadyForTransform();
            if (p != null) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, (String)p.second));
                return false;
            }
        }
        return true;
    }

    private boolean isReadyToTransform() {
        if (this.match != null) {
            this.ac = this.match.getAttrContext();
            try {
                this.ac.getVariables().getAttrManager().checkIfReadyToTransform(this.ac);
            }
            catch (AttrException ex) {
                String s = ex.getLocalizedMessage();
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, s));
                return false;
            }
            return true;
        }
        return false;
    }

    private int parameterWarning(String ruleName) {
        Object[] options = new Object[]{"Set", "Cancel"};
        int answer = JOptionPane.showOptionDialog(null, "Input parameter of the rule  \" " + ruleName + " \"  not set!\nDo you want to set parameter?", "Warning", -1, 3, null, options, options[0]);
        return answer;
    }

    private void minimalRuleOfTrafoSpan(Rule r, Match m) {
        JOptionPane.showMessageDialog(null, "Test : The Minimal Rule of direct Transformation Span");
        try {
            Pair<OrdinaryMorphism, OrdinaryMorphism> po = StaticStep.executeColim(r, m, false, false);
            this.rule.getGraGra().addGraph(new EdGraph(((OrdinaryMorphism)po.first).getTarget()));
            Rule minr = BaseFactory.theFactory().makeMinimalRule((OrdinaryMorphism)po.first);
            if (minr != null) {
                EdRule minRule = new EdRule(minr);
                if (this.rule.getGraGra().addRule(minRule)) {
                    this.rule.getGraGra().save();
                    JOptionPane.showMessageDialog(null, "", "Please reload this GraGra to see the Minimal Rule.", 1);
                }
            } else {
                JOptionPane.showMessageDialog(null, "", "Construction of minimal rule FAILED!", 0);
            }
        }
        catch (TypeException typeException) {
            // empty catch block
        }
    }

    private void setMod1() {
        if (this.mod1 == null) {
            try {
                this.mod1 = StaticStep.executeColim(this.rule.getBasisRule(), this.match, false, false);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
    }

    private void setMod2() {
        if (this.mod2 == null) {
            try {
                this.mod2 = StaticStep.executeColim(this.rule.getBasisRule(), this.match, false, false);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
    }

    private void merge(Pair<OrdinaryMorphism, OrdinaryMorphism> po1, Pair<OrdinaryMorphism, OrdinaryMorphism> po2) {
        JOptionPane.showMessageDialog(null, "Test : Merging of graph modifications ");
        Pair<OrdinaryMorphism, OrdinaryMorphism> mrg = BaseFactory.theFactory().makeMerge((OrdinaryMorphism)po1.first, (OrdinaryMorphism)po2.first);
        if (mrg != null) {
            this.rule.getGraGra().addGraph(new EdGraph(((OrdinaryMorphism)mrg.second).getTarget()));
            this.rule.getGraGra().save();
            JOptionPane.showMessageDialog(null, "", "Please reload this GraGra to see the modified graph.", 1);
        } else {
            JOptionPane.showMessageDialog(null, "", "Merging of graph modifications FAILED.", 0);
        }
        this.mod1 = null;
        this.mod2 = null;
    }
}

