/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview;

import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.EvalSet;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.convert.AGG2ColorGraph;
import agg.convert.ConverterXML;
import agg.editor.impl.EdAtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleConstraint;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.gui.AGGAppl;
import agg.gui.AGGToolBar;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.LoadEvent;
import agg.gui.event.LoadEventListener;
import agg.gui.event.SaveEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.event.TransformEventListener;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.icons.DeleteAtomicIcon;
import agg.gui.icons.DeleteConclusionIcon;
import agg.gui.icons.DeleteConstraintIcon;
import agg.gui.icons.DeleteGraGraIcon;
import agg.gui.icons.DeleteGraphIcon;
import agg.gui.icons.DeleteNACIcon;
import agg.gui.icons.DeleteNestedACIcon;
import agg.gui.icons.DeletePACIcon;
import agg.gui.icons.DeleteRuleIcon;
import agg.gui.icons.DeleteTypeGraphIcon;
import agg.gui.icons.NewAtomicIcon;
import agg.gui.icons.NewConclusionIcon;
import agg.gui.icons.NewConstraintIcon;
import agg.gui.icons.NewGraGraIcon;
import agg.gui.icons.NewGraphIcon;
import agg.gui.icons.NewNACIcon;
import agg.gui.icons.NewNestedACIcon;
import agg.gui.icons.NewPACIcon;
import agg.gui.icons.NewRuleIcon;
import agg.gui.icons.NewTypeGraphIcon;
import agg.gui.popupmenu.AmalgamRulePopupMenu;
import agg.gui.popupmenu.ApplFormulaPopupMenu;
import agg.gui.popupmenu.AtomApplCondPopupMenu;
import agg.gui.popupmenu.AtomicPopupMenu;
import agg.gui.popupmenu.AttrConditionPopupMenu;
import agg.gui.popupmenu.ConclusionPopupMenu;
import agg.gui.popupmenu.ConstraintPopupMenu;
import agg.gui.popupmenu.FilePopupMenu;
import agg.gui.popupmenu.GraGraPopupMenu;
import agg.gui.popupmenu.GraphPopupMenu;
import agg.gui.popupmenu.KernelRulePopupMenu;
import agg.gui.popupmenu.MultiRulePopupMenu;
import agg.gui.popupmenu.NACPopupMenu;
import agg.gui.popupmenu.NestedACPopupMenu;
import agg.gui.popupmenu.PACPopupMenu;
import agg.gui.popupmenu.RuleConstraintPopupMenu;
import agg.gui.popupmenu.RulePopupMenu;
import agg.gui.popupmenu.RuleSchemePopupMenu;
import agg.gui.popupmenu.RuleSequencePopupMenu;
import agg.gui.popupmenu.TypeGraphPopupMenu;
import agg.gui.saveload.AGGFileFilter;
import agg.gui.saveload.GraGraElementsStore;
import agg.gui.saveload.GraGraLoad;
import agg.gui.saveload.GraGraSave;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.gui.treeview.GraGraTreeCellRenderer;
import agg.gui.treeview.GraGraTreeModel;
import agg.gui.treeview.GraGraTreeViewKeyAdapter;
import agg.gui.treeview.GraGraTreeViewMouseAdapter;
import agg.gui.treeview.TreeViewActionAdapter;
import agg.gui.treeview.dialog.ConstraintPriorityDialog;
import agg.gui.treeview.dialog.FormulaGraphGUI;
import agg.gui.treeview.dialog.GraGraConstraintLayerDialog;
import agg.gui.treeview.dialog.GraphImportDialog;
import agg.gui.treeview.dialog.ItemImportDialog;
import agg.gui.treeview.dialog.RuleConstraintsDialog;
import agg.gui.treeview.nodedata.ApplFormulaTreeNodeData;
import agg.gui.treeview.nodedata.AtomicGraphConstraintTreeNodeData;
import agg.gui.treeview.nodedata.ConclusionAttrConditionTreeNodeData;
import agg.gui.treeview.nodedata.ConclusionTreeNodeData;
import agg.gui.treeview.nodedata.ConstraintTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTextualComment;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.nodedata.GraGrasTreeNodeData;
import agg.gui.treeview.nodedata.GrammarTreeNodeData;
import agg.gui.treeview.nodedata.GraphTreeNodeData;
import agg.gui.treeview.nodedata.KernelRuleTreeNodeData;
import agg.gui.treeview.nodedata.MultiRuleTreeNodeData;
import agg.gui.treeview.nodedata.NACTreeNodeData;
import agg.gui.treeview.nodedata.NestedACTreeNodeData;
import agg.gui.treeview.nodedata.PACTreeNodeData;
import agg.gui.treeview.nodedata.RuleApplConstraintTreeNodeData;
import agg.gui.treeview.nodedata.RuleAtomicApplConstraintTreeNodeData;
import agg.gui.treeview.nodedata.RuleAttrCondTreeNodeData;
import agg.gui.treeview.nodedata.RuleSchemeTreeNodeData;
import agg.gui.treeview.nodedata.RuleSequenceTreeNodeData;
import agg.gui.treeview.nodedata.RuleTreeNodeData;
import agg.gui.treeview.nodedata.TypeGraphTreeNodeData;
import agg.gui.treeview.path.GrammarTreeNode;
import agg.gui.treeview.path.RuleSchemeTreeNode;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Completion_NAC;
import agg.xt_basis.GraGra;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.StateEditable;

public class GraGraTreeView
extends JPanel
implements TransformEventListener,
EditEventListener,
LoadEventListener {
    protected final JFrame applFrame;
    private final GraGraTreeViewKeyAdapter keyAdapter;
    private final GraGraTreeViewMouseAdapter mouseAdapter;
    private final TreeViewActionAdapter actionAdapter;
    protected String msg;
    private final Vector<JMenu> menus = new Vector();
    private final JMenu file;
    private final AGGToolBar toolBar;
    private final GraGraSave gragraSave;
    private final GraGraLoad gragraLoad;
    private final Vector<TreeViewEventListener> treeEventListeners = new Vector();
    private String directory = "";
    protected EdGraGra currentGraGra;
    protected RuleSequence currentRuleSequence;
    private EdGraph currentGraph;
    protected EdRule currentRule;
    protected EdRuleScheme currentRuleScheme;
    private EdNAC currentNAC;
    private EdPAC currentPAC;
    private EdPAC currentNestedAC;
    private EdAtomic currentAtomic;
    private EdAtomic currentConclusion;
    private EdConstraint currentConstraint;
    private EdRuleConstraint currentRuleConstraint;
    private EdAtomApplCond currentAtomApplCond;
    private Pair<EdRule, Vector<String>> currentRuleContext;
    private Pair<EdAtomic, Vector<String>> currentConclusionContext;
    protected final FilePopupMenu filePopupMenu;
    protected final ConstraintPopupMenu constraintPopupMenu;
    protected final AtomicPopupMenu atomicPopupMenu;
    protected final ConclusionPopupMenu conclusionPopupMenu;
    protected final RuleConstraintPopupMenu ruleConstraintPopupMenu;
    protected final AtomApplCondPopupMenu atomApplCondPopupMenu;
    protected final GraGraPopupMenu gragraPopupMenu;
    protected final RulePopupMenu rulePopupMenu;
    protected final AmalgamRulePopupMenu amalgamRulePopupMenu;
    protected final RuleSchemePopupMenu ruleSchemePopupMenu;
    protected final KernelRulePopupMenu kernRulePopupMenu;
    protected final MultiRulePopupMenu multiRulePopupMenu;
    protected final RuleSequencePopupMenu ruleSequencePopupMenu;
    protected final NACPopupMenu nacPopupMenu;
    protected final PACPopupMenu pacPopupMenu;
    protected final NestedACPopupMenu acPopupMenu;
    protected final TypeGraphPopupMenu typeGraphPopupMenu;
    protected final GraphPopupMenu graphPopupMenu;
    protected final AttrConditionPopupMenu attrConditionPopupMenu;
    protected final ApplFormulaPopupMenu applFormulaPopupMenu;
    protected Point popupLocation;
    protected final JTree tree;
    protected final GraGraTreeModel treeModel;
    private final DefaultMutableTreeNode top;
    public TreePath selPath;
    public TreePath editorPath;
    protected Rectangle movedRect;
    protected DefaultMutableTreeNode movedNode;
    protected Point movedPoint = new Point(0, 0);
    private boolean newRuleOK = false;
    private boolean newApplCondOK = false;
    protected boolean pressedMouseLeft = false;
    protected boolean wasMoved = false;
    protected DefaultMutableTreeNode tmpSelNode;
    protected TreePath tmpSelPath;
    protected boolean isSelected = false;
    public boolean layered = false;
    public boolean priority = false;
    boolean ruleSequence = false;
    boolean ruleSequenceHidden = false;
    private boolean rewriteTypeGraph = false;
    private boolean undirectedArcs;
    private boolean nonparallelArcs;
    private boolean checkEmptyAttrs;
    protected final GraGraElementsStore gragraStore;
    protected final JButton trash;
    protected JButton newNestedAC;
    protected JButton delNestedAC;
    protected int indxNewNestedAC;
    protected int indxDelNestedAC;
    private GraGraTextualComment comments;
    private GraphicsExportJPEG exportJPEG;
    private EdType nodeTypeOfColorGraph;
    private EdType edgeTypeOfColorGraph;

    public GraGraTreeView(JFrame aggappl) {
        super(new BorderLayout());
        this.applFrame = aggappl;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.top = new DefaultMutableTreeNode(new GraGrasTreeNodeData("GraGras"));
        this.treeModel = new GraGraTreeModel(this.top);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setDoubleBuffered(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.mouseAdapter = new GraGraTreeViewMouseAdapter(this);
        this.tree.addMouseListener(this.mouseAdapter);
        this.actionAdapter = new TreeViewActionAdapter(this);
        this.keyAdapter = new GraGraTreeViewKeyAdapter(this);
        this.tree.addKeyListener(this.keyAdapter);
        this.gragraStore = new GraGraElementsStore(this);
        this.file = new JMenu("File", true);
        this.createMenus();
        this.toolBar = new AGGToolBar(0);
        this.trash = this.toolBar.createTool("imageable", "trash", "Trash of grammar elements", "undoDelete", this.actionAdapter, false);
        this.createToolBar();
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new GraGraTreeCellRenderer());
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.filePopupMenu = new FilePopupMenu(this.actionAdapter);
        this.gragraPopupMenu = new GraGraPopupMenu(this);
        this.rulePopupMenu = new RulePopupMenu(this);
        this.amalgamRulePopupMenu = new AmalgamRulePopupMenu(this);
        this.ruleSchemePopupMenu = new RuleSchemePopupMenu(this);
        this.kernRulePopupMenu = new KernelRulePopupMenu(this);
        this.multiRulePopupMenu = new MultiRulePopupMenu(this);
        this.ruleSequencePopupMenu = new RuleSequencePopupMenu(this);
        this.nacPopupMenu = new NACPopupMenu(this);
        this.pacPopupMenu = new PACPopupMenu(this);
        this.acPopupMenu = new NestedACPopupMenu(this);
        this.constraintPopupMenu = new ConstraintPopupMenu(this);
        this.atomicPopupMenu = new AtomicPopupMenu(this);
        this.ruleConstraintPopupMenu = new RuleConstraintPopupMenu(this);
        this.atomApplCondPopupMenu = new AtomApplCondPopupMenu(this);
        this.conclusionPopupMenu = new ConclusionPopupMenu(this);
        this.typeGraphPopupMenu = new TypeGraphPopupMenu(this);
        this.graphPopupMenu = new GraphPopupMenu(this);
        this.attrConditionPopupMenu = new AttrConditionPopupMenu(this);
        this.applFormulaPopupMenu = new ApplFormulaPopupMenu(this);
        this.gragraSave = new GraGraSave(this.applFrame);
        this.gragraLoad = new GraGraLoad(this.applFrame);
        this.gragraLoad.addLoadEventListener(this);
        this.trash.addMouseListener(this.mouseAdapter);
        this.tree.getSelectionModel().setSelectionMode(4);
    }

    void propagateSelectedTreeItem() {
        this.tree.setEditable(false);
        if (!this.wasMoved) {
            if (!this.selPath.equals(this.editorPath)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
                if (node.getUserObject() != null && ((GraGraTreeNodeData)node.getUserObject()).isNestedAC() && this.currentRule != ((GraGraTreeNodeData)node.getUserObject()).getNestedAC().getRule()) {
                    this.selectPath(this.getTreePathOfGrammarElement(((GraGraTreeNodeData)node.getUserObject()).getNestedAC().getRule()));
                    this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, node, true, true, false, this.tree.getRowForPath(this.selPath), true);
                    return;
                }
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 6, this.selPath));
                this.setFlagForNew();
                this.editorPath = this.selPath;
                if ((DefaultMutableTreeNode)this.editorPath.getLastPathComponent() != (DefaultMutableTreeNode)this.treeModel.getRoot()) {
                    this.setCurrentData(this.editorPath);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            } else {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 25, this.selPath));
            }
        }
    }

    public TreePath getSelectedPath() {
        return this.selPath;
    }

    public TreePath getEditorPath() {
        return this.editorPath;
    }

    public TreeViewActionAdapter getActionAdapter() {
        return this.actionAdapter;
    }

    protected void executeCommand(String command) {
        if (command.equals("newGraGra")) {
            this.addGraGra();
            this.resetEnabledOfFileMenuItems(command);
            this.filePopupMenu.resetEnabledOfFileMenuItems(command);
            this.resetEnabledOfToolBarItems(command);
        } else if (command.equals("newTypeGraph")) {
            this.addTypeGraph();
        } else if (command.equals("newGraph")) {
            this.addGraph(null, null);
        } else if (command.equals("newRule")) {
            this.addRule();
        } else if (command.equals("newNestedAC")) {
            this.addNestedAC(false);
        } else if (command.equals("makeGACFromRHS")) {
            this.addNestedAC(true);
        } else if (command.equals("newNAC")) {
            this.addNAC(false);
        } else if (command.equals("makeNACFromRHS")) {
            this.addNAC(true);
        } else if (command.equals("newPAC")) {
            this.addPAC();
        } else if (command.equals("newAtomic")) {
            this.addAtomic();
        } else if (command.equals("newConclusion")) {
            this.addConclusion();
        } else if (command.equals("newConstraint")) {
            this.addConstraint();
        } else if (command.equals("newAtomic")) {
            this.addAtomic();
        } else if (command.equals("newConclusion")) {
            this.addConclusion();
        } else if (command.equals("newConstraint")) {
            this.addConstraint();
        } else if (command.equals("convertAtomicsOfRule")) {
            this.doPostApplicationConditionOfRule();
        } else if (command.equals("checkOneAtomic")) {
            this.checkOne();
        } else if (command.equals("checkOneConstraint")) {
            this.checkOne();
        } else if (command.equals("checkAtomics")) {
            this.gragraPopupMenu.doAtomics(1);
        } else if (command.equals("checkConstraints")) {
            this.gragraPopupMenu.doAtomics(2);
        } else if (command.equals("editConstraint")) {
            this.editConstraint();
        } else if (command.equals("open")) {
            this.loadGraGra();
        } else if (command.equals("save")) {
            this.saveGraGra();
        } else if (command.equals("saveAs")) {
            this.saveAsGraGra();
        } else if (command.equals("exportGraphJPEG")) {
            this.exportGraphJPEG();
        } else if (command.equals("exportJPEG")) {
            this.exportJPEG();
        } else if (command.equals("openBase")) {
            this.loadBaseGraGra();
        } else if (command.equals("saveAsBase")) {
            this.saveAsBaseGraGra();
        } else if (command.equals("exportGXL")) {
            this.exportGraGra("GXL");
        } else if (command.equals("exportGTXL")) {
            this.exportGraGra("GTXL");
        } else if (command.equals("EXPORT_BY_TYPE_TO_COLOR_GRAPH")) {
            this.exportGraGra("EXPORT_BY_TYPE_TO_COLOR_GRAPH");
        } else if (command.equals("EXPORT_TO_COLOR_GRAPH")) {
            this.exportGraGra("EXPORT_TO_COLOR_GRAPH");
        } else if (command.equals("importGGX")) {
            this.importGraGra("GGX");
        } else if (command.equals("importGXL")) {
            this.importGraGra("GXL");
        } else if (command.equals("importGTXL")) {
            this.importGraGra("GTXL");
        } else if (command.equals("importOMONDOXMI")) {
            this.importGraGra("OMONDOXMI");
        } else if (command.equals("IMPORT_BY_TYPE_FROM_COLOR_GRAPH")) {
            this.importGraGra("IMPORT_BY_TYPE_FROM_COLOR_GRAPH");
        } else if (command.equals("IMPORT_FROM_COLOR_GRAPH")) {
            this.importGraGra("IMPORT_FROM_COLOR_GRAPH");
        } else if (command.equals("delete")) {
            this.delete("");
            this.resetEnabledOfFileMenuItems(command);
            this.filePopupMenu.resetEnabledOfFileMenuItems(command);
            this.resetEnabledOfToolBarItems(command);
            if (this.tree.getRowCount() == 1) {
                this.fireTreeViewEvent(new TreeViewEvent(this, 11));
            }
        } else if (command.equals("deleteGraGra")) {
            this.delete("GraGra");
        } else if (command.equals("deleteGraph")) {
            this.delete("Graph");
        } else if (command.equals("deleteTypeGraph")) {
            this.delete("TypeGraph");
        } else if (command.equals("deleteRule")) {
            this.delete("Rule");
        } else if (command.equals("deleteRuleSequence")) {
            this.delete("RuleSequence");
        } else if (command.equals("deleteNAC")) {
            this.delete("NAC");
        } else if (command.equals("deletePAC")) {
            this.delete("PAC");
        } else if (command.equals("deleteNestedAC")) {
            this.delete("NestedAC");
        } else if (command.equals("deleteAtomic")) {
            this.delete("Atomic");
        } else if (command.equals("deleteConclusion")) {
            this.delete("Conclusion");
        } else if (command.equals("deleteConstraint")) {
            this.delete("Constraint");
        } else if (command.equals("deleteRuleConstraints")) {
            this.delete("RuleConstraints");
        } else if (command.equals("deleteRuleConstraint")) {
            this.delete("RuleConstraint");
        } else if (command.equals("deleteAtomApplCond")) {
            this.delete("AtomApplCond");
        } else if (command.equals("moveRule") || command.equals("moveRuleScheme")) {
            this.moveRule();
        } else if (command.equals("copyRule")) {
            this.copy("Rule");
        } else if (command.equals("copyRuleScheme")) {
            this.copy("RuleScheme");
        } else if (command.equals("concurrentRule")) {
            this.makeConcurrentRule(true);
        } else if (command.equals("disableRuleScheme")) {
            this.disable("RuleScheme", true);
        } else if (command.equals("enableRuleScheme")) {
            this.disable("RuleScheme", false);
        } else if (command.equals("disableRule")) {
            this.disable("Rule", true);
        } else if (command.equals("enableRule")) {
            this.disable("Rule", false);
        } else if (command.equals("disableNAC")) {
            this.disable("NAC", true);
        } else if (command.equals("enableNAC")) {
            this.disable("NAC", false);
        } else if (command.equals("disablePAC")) {
            this.disable("PAC", true);
        } else if (command.equals("enablePAC")) {
            this.disable("PAC", false);
        } else if (command.equals("disableNestedAC")) {
            this.disable("NestedAC", true);
        } else if (command.equals("enableNestedAC")) {
            this.disable("NestedAC", false);
        } else if (command.equals("disableAttrCondition")) {
            this.disable("AttrCondition", true);
        } else if (command.equals("enableAttrCondition")) {
            this.disable("AttrCondition", false);
        } else if (command.equals("disableConstraint")) {
            this.disable("Constraint", true);
        } else if (command.equals("enableConstraint")) {
            this.disable("Constraint", false);
        } else if (command.equals("setRuleLayer")) {
            this.setRuleLayer();
        } else if (command.equals("setConstraintLayer")) {
            this.setConstraintLayer();
        } else if (command.equals("setConstraintPriority")) {
            this.setConstraintPriority();
        } else if (command.equals("showNAC")) {
            this.showNAC();
        } else if (command.equals("hideNAC")) {
            this.hideNAC();
        } else if (command.equals("showAttrConditions")) {
            this.showRuleAttrConditions(null);
        } else if (command.equals("setRulePriority")) {
            this.setRulePriority();
        } else if (command.equals("undoDelete")) {
            this.undoDelete();
        } else if (command.equals("undoDeleteTypeGraph")) {
            this.undoDeleteTypeGraph();
        } else if (command.equals("undoDeleteRule")) {
            this.undoDeleteRule();
        } else if (command.equals("undoDeleteNAC")) {
            this.undoDeleteNAC();
        } else if (command.equals("undoDeletePAC")) {
            this.undoDeletePAC();
        } else if (command.equals("undoDeleteNestedAC")) {
            this.undoDeleteNestedAC();
        } else if (command.equals("undoDeleteAtomicConstraint")) {
            this.undoDeleteAtomicConstraint();
        } else if (command.equals("undoDeleteConstraint")) {
            this.undoDeleteConstraint();
        } else if (command.equals("undoDeleteAtomicConclusion")) {
            this.undoDeleteAtomicConclusion();
        } else if (command.equals("commentGraph")) {
            this.editTextualComments("commentGraph");
        } else if (command.equals("commentRule")) {
            this.editTextualComments("commentRule");
        } else if (command.equals("commentNAC")) {
            this.editTextualComments("commentNAC");
        } else if (command.equals("commentPAC")) {
            this.editTextualComments("commentPAC");
        } else if (command.equals("commentNestedAC")) {
            this.editTextualComments("commentNestedAC");
        } else if (command.equals("commentAtomConstraint")) {
            this.editTextualComments("commentAtomConstraint");
        } else if (command.equals("commentConstraint")) {
            this.editTextualComments("commentConstraint");
        } else if (command.equals("exit")) {
            Object[] options = new Object[]{"SAVE", "EXIT", "CANCEL"};
            this.exitAppl(options);
        }
    }

    public void exitAppl(Object[] options) {
        int answ = 1;
        Vector<EdGraGra> gragras = this.getGraGras();
        int i = 0;
        while (i < gragras.size()) {
            EdGraGra gra = gragras.get(i);
            if (gra.isChanged()) {
                answ = this.exitWarning(options, "grammar", gra.getName());
                if (answ == 0) {
                    this.saveGraGra(gra);
                    answ = 1;
                } else if (answ == 1) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 999));
                    System.exit(0);
                }
            }
            ++i;
        }
        if (answ == 1) {
            System.exit(0);
        }
    }

    public synchronized void addSaveEventListener(SaveEventListener l) {
        this.gragraSave.addSaveEventListener(l);
    }

    public synchronized void removeSaveEventListener(SaveEventListener l) {
        this.gragraSave.removeSaveEventListener(l);
    }

    public synchronized void addLoadEventListener(LoadEventListener l) {
        this.gragraLoad.addLoadEventListener(l);
    }

    public synchronized void removeLoadEventListener(LoadEventListener l) {
        this.gragraLoad.removeLoadEventListener(l);
    }

    public synchronized void addTreeViewEventListener(TreeViewEventListener l) {
        if (!this.treeEventListeners.contains(l)) {
            this.treeEventListeners.addElement(l);
        }
    }

    public synchronized void removeTreeViewEventListener(TreeViewEventListener l) {
        if (this.treeEventListeners.contains(l)) {
            this.treeEventListeners.removeElement(l);
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener l) {
        this.getTree().getModel().addTreeModelListener(l);
    }

    public synchronized void removeTreeModelListener(TreeModelListener l) {
        this.getTree().getModel().removeTreeModelListener(l);
    }

    public ActionListener getActionListener() {
        return this.actionAdapter;
    }

    public synchronized void fireTreeViewEvent(TreeViewEvent e) {
        int i = 0;
        while (i < this.treeEventListeners.size()) {
            this.treeEventListeners.elementAt(i).treeViewEventOccurred(e);
            ++i;
        }
    }

    public Enumeration<JMenu> getMenus() {
        return this.menus.elements();
    }

    public JMenu getFileMenu() {
        return this.file;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JFrame getFrame() {
        return this.applFrame;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeNode getTopTreeNode() {
        return this.top;
    }

    public GraGraTreeModel getTreeModel() {
        return this.treeModel;
    }

    public GraGraElementsStore getGraGraStore() {
        return this.gragraStore;
    }

    public EdGraGra getCurrentGraGra() {
        return this.currentGraGra;
    }

    public EdGraph getCurrentGraph() {
        return this.currentGraph;
    }

    public EdRule getCurrentRule() {
        return this.currentRule;
    }

    public EdConstraint getCurrentConstraint() {
        return this.currentConstraint;
    }

    public EdRule getCurrentRuleScheme() {
        return this.currentRuleScheme;
    }

    public RuleSequence getCurrentRuleSequence() {
        return this.currentRuleSequence;
    }

    public void graphDidChange() {
        this.fireTreeViewEvent(new TreeViewEvent(this, 19));
    }

    public void selectPath(int x, int y) {
        this.selPath = this.tree.getPathForLocation(x, y);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 6, this.selPath));
        this.tree.setSelectionPath(this.selPath);
        this.tree.treeDidChange();
        this.editorPath = this.selPath;
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        this.setFlagForNewData(sd);
        if ((DefaultMutableTreeNode)this.editorPath.getLastPathComponent() != (DefaultMutableTreeNode)this.treeModel.getRoot()) {
            this.setCurrentData(this.editorPath);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
        }
    }

    public void selectPath(int row) {
        this.selectPath(this.tree.getPathForRow(row));
    }

    public void selectPath(TreePath path) {
        this.selPath = path;
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 6, this.selPath));
        this.tree.setSelectionPath(this.selPath);
        this.tree.treeDidChange();
        this.editorPath = this.selPath;
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        this.setFlagForNewData(sd);
        if ((DefaultMutableTreeNode)this.editorPath.getLastPathComponent() != (DefaultMutableTreeNode)this.treeModel.getRoot()) {
            this.setCurrentData(this.editorPath);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
        }
    }

    void setUndirectedArcsOfGraphs(ActionEvent e) {
        this.undirectedArcs = ((JCheckBoxMenuItem)e.getSource()).isSelected();
    }

    void resetUndirectedArcProperty(boolean b) {
        if (this.applFrame instanceof AGGAppl) {
            ((AGGAppl)this.applFrame).getPreferences().selectArcUndirected(b);
            this.undirectedArcs = b;
        }
    }

    void setNoParallelArcsOfGraphs(ActionEvent e) {
        this.nonparallelArcs = ((JCheckBoxMenuItem)e.getSource()).isSelected();
    }

    void setCheckEmptyAttrs(ActionEvent e) {
        this.checkEmptyAttrs = ((JCheckBoxMenuItem)e.getSource()).isSelected();
        this.resetAllowEmptyAttrs(!this.checkEmptyAttrs);
    }

    void setGraTraOption_layered(ActionEvent e) {
        if (this.currentGraGra == null) {
            return;
        }
        this.layered = ((JRadioButton)e.getSource()).isSelected();
        if (this.ruleSequence) {
            this.ruleSequence = false;
            this.hideRuleSequence();
        }
        if (this.layered) {
            this.currentGraGra.getBasisGraGra().addGraTraOption("layered");
            this.currentGraGra.getBasisGraGra().removeGraTraOption("priority");
            this.currentGraGra.getBasisGraGra().removeGraTraOption("ruleSequence");
            this.priority = false;
            this.ruleSequence = false;
        } else {
            this.currentGraGra.getBasisGraGra().removeGraTraOption("layered");
        }
        this.treeModel.ruleNameChanged(this.currentGraGra, this.layered);
        this.treeModel.constraintNameChanged(this.currentGraGra, this.layered);
    }

    void setGraTraOption_priority(ActionEvent e) {
        if (this.currentGraGra == null) {
            return;
        }
        this.priority = ((JRadioButton)e.getSource()).isSelected();
        if (this.ruleSequence) {
            this.ruleSequence = false;
            this.hideRuleSequence();
        }
        if (this.priority) {
            this.currentGraGra.getBasisGraGra().addGraTraOption("priority");
            this.currentGraGra.getBasisGraGra().removeGraTraOption("layered");
            this.currentGraGra.getBasisGraGra().removeGraTraOption("ruleSequence");
            this.layered = false;
            this.ruleSequence = false;
        } else {
            this.currentGraGra.getBasisGraGra().removeGraTraOption("priority");
        }
        this.treeModel.ruleNameChanged(this.currentGraGra, this.layered, this.priority);
        this.treeModel.constraintNameChanged(this.currentGraGra, this.layered, this.priority);
    }

    void setGraTraOption_ruleSequence(ActionEvent e) {
        if (this.currentGraGra == null) {
            return;
        }
        boolean ruleSeqShown = this.ruleSequence;
        this.ruleSequence = ((JRadioButton)e.getSource()).isSelected();
        if (this.ruleSequence) {
            this.currentGraGra.getBasisGraGra().addGraTraOption("ruleSequence");
            this.currentGraGra.getBasisGraGra().removeGraTraOption("layered");
            this.currentGraGra.getBasisGraGra().removeGraTraOption("priority");
            this.priority = false;
            this.layered = false;
            if (!ruleSeqShown) {
                this.showRuleSequence();
            }
        } else {
            this.currentGraGra.getBasisGraGra().removeGraTraOption("ruleSequence");
        }
        this.treeModel.ruleNameChanged(this.currentGraGra, this.layered, this.priority);
        this.treeModel.constraintNameChanged(this.currentGraGra, this.layered, this.priority);
    }

    void setGraTraOption_nondeterministically() {
        if (this.currentGraGra == null) {
            return;
        }
        this.layered = false;
        this.priority = false;
        if (this.ruleSequence) {
            this.ruleSequence = false;
            this.hideRuleSequence();
        }
        this.currentGraGra.getBasisGraGra().removeGraTraOption("layered");
        this.currentGraGra.getBasisGraGra().removeGraTraOption("priority");
        this.currentGraGra.getBasisGraGra().removeGraTraOption("ruleSequence");
        this.treeModel.ruleNameChanged(this.currentGraGra, this.layered, this.priority);
        this.treeModel.constraintNameChanged(this.currentGraGra, this.layered, this.priority);
    }

    public boolean addGraGra(EdGraGra grammar) {
        if (grammar != null) {
            BaseFactory.theFactory().notify(grammar.getBasisGraGra());
            grammar.update();
            GrammarTreeNode grammarTreeNode = new GrammarTreeNode(grammar);
            int indx = grammarTreeNode.insertIntoTree(this);
            this.tree.treeDidChange();
            this.propagateGraGraToEditor(indx);
            if (this.currentGraGra.getGraTraOptions().contains("layered")) {
                this.layered = true;
                this.priority = false;
                this.treeModel.ruleNameChanged(this.currentGraGra, this.layered, this.priority);
                this.treeModel.constraintNameChanged(this.currentGraGra, this.layered, this.priority);
            } else if (this.currentGraGra.getGraTraOptions().contains("priority")) {
                this.priority = true;
                this.layered = false;
                this.treeModel.ruleNameChanged(this.currentGraGra, this.layered, this.priority);
                this.treeModel.constraintNameChanged(this.currentGraGra, this.layered, this.priority);
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
            this.directory = this.gragraLoad.getDirName();
            this.resetEnabledOfFileMenuItems("open");
            this.filePopupMenu.resetEnabledOfFileMenuItems("open");
            this.resetEnabledOfToolBarItems("open");
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
            return true;
        }
        return false;
    }

    public EdGraGra addGraGra() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int newIndex = parent.getChildCount();
        String name = "GraGra";
        if (parent.getChildCount() > 0) {
            name = "GraGra" + newIndex;
        }
        if (!((GraGraTreeModel)this.tree.getModel()).isValid(((GraGraTreeModel)this.tree.getModel()).getGraGraNames(), name, "")) {
            name = String.valueOf(name) + "_";
        }
        EdGraGra newGraGra = new EdGraGra(name, !this.undirectedArcs, !this.nonparallelArcs);
        newGraGra.getTypeSet().getBasisTypeSet().setAllowEmptyAttr(!this.checkEmptyAttrs);
        GrammarTreeNodeData sdGraGra = new GrammarTreeNodeData(newGraGra);
        DefaultMutableTreeNode newGraGraNode = new DefaultMutableTreeNode(sdGraGra);
        sdGraGra.setTreeNode(newGraGraNode);
        this.treeModel.insertNodeInto(newGraGraNode, parent, newIndex);
        if (!this.tree.isExpanded(this.tree.getPathForRow(0))) {
            this.tree.expandPath(this.tree.getPathForRow(0));
        }
        int graIndex = this.tree.getRowCount() - 1;
        GraphTreeNodeData sdGraph = new GraphTreeNodeData(newGraGra.getGraph());
        DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
        sdGraph.setTreeNode(newGraphNode);
        parent = newGraGraNode;
        newIndex = parent.getChildCount();
        this.treeModel.insertNodeInto(newGraphNode, parent, newIndex);
        RuleTreeNodeData sdRule = new RuleTreeNodeData(newGraGra.getRules().firstElement());
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
        sdRule.setTreeNode(newRuleNode);
        newIndex = parent.getChildCount();
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
        if (!this.tree.isExpanded(this.tree.getPathForRow(graIndex))) {
            this.tree.expandPath(this.tree.getPathForRow(graIndex));
        }
        this.tree.setSelectionRow(graIndex);
        this.editorPath = this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        this.setFlagForNew();
        this.setCurrentData(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
        this.layered = false;
        this.priority = false;
        this.treeModel.ruleNameChanged(newGraGra, this.layered, this.priority);
        this.treeModel.constraintNameChanged(newGraGra, this.layered, this.priority);
        newGraGra.setChanged(false);
        return newGraGra;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addGraph(EdGraGra gra, EdGraph graph) {
        String ggname;
        String gname = graph != null ? graph.getName() : "";
        String string = ggname = gra != null ? gra.getName() : "";
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a graph  " + gname + "." + "\n Please select suitable grammar  " + ggname + ".", "", 2);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a graph  " + gname + "." + "\n Please select suitable grammar  " + ggname + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (gra != null && gra != eGra && graph != null) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add graph: " + graph.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        if (!eGra.isEditable()) {
            this.lockWarning();
            return false;
        }
        if (graph == null) {
            graph = new EdGraph(BaseFactory.theFactory().createGraph(eGra.getTypeSet().getBasisTypeSet(), true), eGra.getTypeSet());
            graph.getBasisGraph().setName(String.valueOf(graph.getBasisGraph().getName()) + eGra.getGraphs().size());
        }
        if (!eGra.getGraphs().contains(graph)) {
            eGra.addGraph(graph);
        }
        graph.setGraGra(eGra);
        GraphTreeNodeData sdGraph = new GraphTreeNodeData(graph);
        DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
        sdGraph.setTreeNode(newGraphNode);
        int indx = eGra.getGraphs().size() - 1;
        if (eGra.getTypeGraph() != null) {
            ++indx;
        }
        this.treeModel.insertNodeInto(newGraphNode, parent, indx);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdGraph addTypeGraph() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (eGra.getTypeSet().getTypeGraph() != null) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body> The type graph already exists.</body></html>", "", 2);
            return null;
        }
        EdGraph typeGraph = eGra.createTypeGraph();
        TypeGraphTreeNodeData sdTypeGraph = new TypeGraphTreeNodeData(typeGraph);
        sdTypeGraph.setString("[D]TypeGraph");
        DefaultMutableTreeNode newTypeGraphNode = new DefaultMutableTreeNode(sdTypeGraph);
        sdTypeGraph.setTreeNode(newTypeGraphNode);
        this.treeModel.insertNodeInto(newTypeGraphNode, parent, 0);
        return typeGraph;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addTypeGraph(EdGraGra gra, EdGraph g) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (eGra.getTypeSet().getTypeGraph() != null && eGra.getTypeSet().getTypeGraph() != g) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body> The type graph already exists.</body></html>", "", 2);
            return false;
        }
        if (eGra != gra) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select the apropriate grammar.", "", 2);
            return false;
        }
        eGra.setTypeGraph(g);
        TypeGraphTreeNodeData sdTypeGraph = new TypeGraphTreeNodeData(g);
        sdTypeGraph.setString("[D]TypeGraph");
        DefaultMutableTreeNode newTypeGraphNode = new DefaultMutableTreeNode(sdTypeGraph);
        sdTypeGraph.setTreeNode(newTypeGraphNode);
        this.treeModel.insertNodeInto(newTypeGraphNode, parent, 0);
        return true;
    }

    public boolean addRuleScheme(EdGraGra gra, EdRuleScheme newRS) {
        return this.addRuleSchemeAt(gra, newRS, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addRuleSchemeAt(EdGraGra gra, EdRuleScheme newRS, int index) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (eGra != gra) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a rule scheme: " + newRS.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        if (!eGra.isEditable()) {
            this.lockWarning();
            return false;
        }
        eGra.addRule(newRS);
        int indx = index;
        if (indx < 0) {
            indx = eGra.getGraphs().size() + eGra.getRules().size() - 1;
            if (eGra.getTypeSet().getTypeGraph() != null) {
                ++indx;
            }
        }
        this.putRuleSchemeIntoTree(newRS, parent, indx);
        return true;
    }

    public void putRuleSchemeIntoTree(EdRuleScheme newRS, DefaultMutableTreeNode parentNode, int index) {
        RuleSchemeTreeNodeData sdRuleScheme = new RuleSchemeTreeNodeData(newRS);
        DefaultMutableTreeNode newRuleSchemeNode = new DefaultMutableTreeNode(sdRuleScheme);
        sdRuleScheme.setTreeNode(newRuleSchemeNode);
        this.treeModel.insertNodeInto(newRuleSchemeNode, parentNode, index);
        this.treeModel.ruleNameChanged(newRuleSchemeNode, this.layered);
        DefaultMutableTreeNode parent = newRuleSchemeNode;
        KernelRuleTreeNodeData sdKernelRule = new KernelRuleTreeNodeData(newRS.getKernelRule());
        DefaultMutableTreeNode newKernelRuleNode = new DefaultMutableTreeNode(sdKernelRule);
        sdKernelRule.setTreeNode(newKernelRuleNode);
        int indx = 0;
        this.treeModel.insertNodeInto(newKernelRuleNode, parent, indx);
        int nn = 0;
        nn = this.addGACsToRuleTreeNode(newRS.getKernelRule(), newKernelRuleNode, nn);
        this.addNACsToRuleTreeNode(newRS.getKernelRule(), newKernelRuleNode, nn += newRS.getKernelRule().getNestedACs().size());
        this.addPACsToRuleTreeNode(newRS.getKernelRule(), newKernelRuleNode, nn += newRS.getKernelRule().getNACs().size());
        this.addAttrCondToRuleTreeNode(newRS.getKernelRule(), newKernelRuleNode);
        int j = 0;
        while (j < newRS.getMultiRules().size()) {
            EdRule mr = newRS.getMultiRules().get(j);
            MultiRuleTreeNodeData sdMultiRule = new MultiRuleTreeNodeData(mr);
            DefaultMutableTreeNode newMultiRuleNode = new DefaultMutableTreeNode(sdMultiRule);
            sdMultiRule.setTreeNode(newMultiRuleNode);
            this.treeModel.insertNodeInto(newMultiRuleNode, parent, j + 1);
            nn = 0;
            nn = this.addGACsToRuleTreeNode(mr, newMultiRuleNode, nn);
            this.addNACsToRuleTreeNode(mr, newMultiRuleNode, nn += mr.getNestedACs().size());
            this.addPACsToRuleTreeNode(mr, newMultiRuleNode, nn += mr.getNACs().size());
            this.addAttrCondToRuleTreeNode(mr, newMultiRuleNode);
            ++j;
        }
    }

    private void addNestedACs(List<EdNestedApplCond> acs, DefaultMutableTreeNode parent) {
        int i = 0;
        while (i < acs.size()) {
            EdNestedApplCond ac = acs.get(i);
            NestedACTreeNodeData sd = new NestedACTreeNodeData(ac);
            DefaultMutableTreeNode acNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(acNode);
            this.treeModel.insertNodeInto(acNode, parent, parent.getChildCount());
            String f = ac.getNestedMorphism().getFormulaText();
            if (!"true".equals(f)) {
                ApplFormulaTreeNodeData fdata = new ApplFormulaTreeNodeData(f, true, ac);
                fdata.setString(f);
                DefaultMutableTreeNode fnode = new DefaultMutableTreeNode(fdata);
                fdata.setTreeNode(fnode);
                this.treeModel.insertNodeInto(fnode, acNode, 0);
            }
            this.addNestedACs(ac.getEnabledACs(), acNode);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdRule addRule() {
        String tag;
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (!eGra.isEditable()) {
            this.lockWarning();
            return null;
        }
        int newIndex = eGra.getGraphs().size() + eGra.getRules().size();
        if (eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = "Rule" + eGra.getRules().size();
        name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(eGra, name);
        EdRule newRule = eGra.createRule(name);
        RuleTreeNodeData sdRule = new RuleTreeNodeData(newRule);
        if (this.layered) {
            tag = "[" + newRule.getBasisRule().getLayer() + "]";
            sdRule.setString(tag, name);
        } else if (this.priority) {
            tag = "[" + newRule.getBasisRule().getPriority() + "]";
            sdRule.setString(tag, name);
        }
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
        sdRule.setTreeNode(newRuleNode);
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.selPath));
        return newRule;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addRule(EdGraGra gra, EdRule newRule) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a rule: " + newRule.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a rule: " + newRule.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (eGra != gra) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add rule: " + newRule.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        if (!eGra.isEditable()) {
            this.lockWarning();
            return false;
        }
        eGra.addRule(newRule);
        int newIndex = eGra.getGraphs().size() + eGra.getRules().size() - 1;
        if (eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = newRule.getBasisRule().getName();
        RuleTreeNodeData sdRule = new RuleTreeNodeData(newRule);
        String tagD = "";
        if (!newRule.getBasisRule().isEnabled()) {
            tagD = "[D]";
        }
        if (this.layered) {
            String tagL = "[" + newRule.getBasisRule().getLayer() + "]";
            sdRule.setString(tagD, tagL, name);
        } else if (this.priority) {
            String tagP = "[" + newRule.getBasisRule().getPriority() + "]";
            sdRule.setString(tagD, tagP, name);
        } else {
            sdRule.setString(tagD, name);
        }
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
        sdRule.setTreeNode(newRuleNode);
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
        int nn = 0;
        nn = this.addGACsToRuleTreeNode(newRule, newRuleNode, nn);
        this.addNACsToRuleTreeNode(newRule, newRuleNode, nn += newRule.getNestedACs().size());
        this.addPACsToRuleTreeNode(newRule, newRuleNode, nn += newRule.getNACs().size());
        this.addAttrCondToRuleTreeNode(newRule, newRuleNode);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.selPath));
        return true;
    }

    private int addGACsToRuleTreeNode(EdRule rule, DefaultMutableTreeNode ruleNode, int nn) {
        int indx = 0;
        String f = rule.getBasisRule().getFormulaStr();
        if (!"true".equals(f)) {
            ++indx;
            ApplFormulaTreeNodeData fdata = new ApplFormulaTreeNodeData(f, true, rule);
            fdata.setString(f);
            DefaultMutableTreeNode fnode = new DefaultMutableTreeNode(fdata);
            fdata.setTreeNode(fnode);
            this.treeModel.insertNodeInto(fnode, ruleNode, 0);
            ++nn;
        }
        int i = 0;
        while (i < rule.getNestedACs().size()) {
            EdNestedApplCond ac = (EdNestedApplCond)rule.getNestedACs().get(i);
            NestedACTreeNodeData sd = new NestedACTreeNodeData(ac);
            DefaultMutableTreeNode acNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(acNode);
            this.treeModel.insertNodeInto(acNode, ruleNode, nn);
            ++nn;
            f = ac.getNestedMorphism().getFormulaText();
            if (!"true".equals(f)) {
                ApplFormulaTreeNodeData fdata = new ApplFormulaTreeNodeData(f, true, ac);
                fdata.setString(f);
                DefaultMutableTreeNode fnode = new DefaultMutableTreeNode(fdata);
                fdata.setTreeNode(fnode);
                this.treeModel.insertNodeInto(fnode, acNode, 0);
            }
            this.addNestedACs(ac.getEnabledACs(), acNode);
            ++i;
        }
        return indx;
    }

    private void addNACsToRuleTreeNode(EdRule rule, DefaultMutableTreeNode ruleNode, int nn) {
        int i = 0;
        while (i < rule.getNACs().size()) {
            EdNAC nac = rule.getNACs().get(i);
            NACTreeNodeData sd = new NACTreeNodeData(nac);
            DefaultMutableTreeNode nacNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(nacNode);
            this.treeModel.insertNodeInto(nacNode, ruleNode, nn + i);
            ++i;
        }
    }

    private void addPACsToRuleTreeNode(EdRule rule, DefaultMutableTreeNode ruleNode, int nn) {
        int i = 0;
        while (i < rule.getPACs().size()) {
            EdPAC pac = rule.getPACs().get(i);
            PACTreeNodeData sd = new PACTreeNodeData(pac);
            DefaultMutableTreeNode pacNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(pacNode);
            this.treeModel.insertNodeInto(pacNode, ruleNode, nn + i);
            ++i;
        }
    }

    private void addAttrCondToRuleTreeNode(EdRule rule, DefaultMutableTreeNode ruleNode) {
        CondTuple conds = (CondTuple)rule.getBasisRule().getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize()) {
            CondMember c = (CondMember)conds.getMemberAt(i);
            RuleAttrCondTreeNodeData cdata = new RuleAttrCondTreeNodeData(c, rule);
            cdata.setString(c.getExprAsText());
            DefaultMutableTreeNode cchild = new DefaultMutableTreeNode(cdata);
            cdata.setTreeNode(cchild);
            this.treeModel.insertNodeInto(cchild, ruleNode, ruleNode.getChildCount());
            ++i;
        }
    }

    protected void inheritanceWarning() {
        JOptionPane.showMessageDialog(this.applFrame, "<html><body>Sorry!<br>This item is not available for the graph grammar <br>with node type inheritance.", "", 2);
    }

    private void addRuleSequences() {
        if (this.selPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            EdGraGra eGra = this.getGraGra(node);
            if (eGra == null && this.currentGraGra != null) {
                eGra = this.currentGraGra;
                node = this.getTreeNodeOfGrammar(eGra.getBasisGraGra());
            }
            if (eGra != null) {
                int indx = eGra.getGraphs().size() + eGra.getRules().size() + eGra.getAtomics().size() + eGra.getConstraints().size();
                if (eGra.getTypeSet().getTypeGraph() != null) {
                    ++indx;
                }
                int i = 0;
                while (i < eGra.getBasisGraGra().getRuleSequences().size()) {
                    RuleSequence rseq = eGra.getBasisGraGra().getRuleSequences().get(i);
                    rseq.setCriticalPairOption(((AGGAppl)this.getFrame()).getCPA().getCriticalPairOption());
                    if (this.getTreeNodeOfGrammarElement(rseq) == null) {
                        RuleSequenceTreeNodeData sdRuleSequence = new RuleSequenceTreeNodeData(rseq);
                        DefaultMutableTreeNode newRuleSequenceNode = new DefaultMutableTreeNode(sdRuleSequence);
                        sdRuleSequence.setTreeNode(newRuleSequenceNode);
                        this.treeModel.insertNodeInto(newRuleSequenceNode, node, indx + i);
                    }
                    ++i;
                }
            }
        }
    }

    public void showRuleSequence() {
        if (!this.ruleSequenceHidden) {
            this.hideRuleSequence();
        }
        this.addRuleSequences();
        this.ruleSequenceHidden = false;
    }

    public void hideRuleSequence() {
        if (this.currentGraGra != null) {
            int i = 0;
            while (i < this.currentGraGra.getBasisGraGra().getRuleSequences().size()) {
                TreePath rsPath = this.getTreePathOfGrammarElement(this.currentGraGra.getBasisGraGra().getRuleSequences().get(i));
                if (rsPath != null) {
                    this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)rsPath.getLastPathComponent());
                    this.ruleSequenceHidden = true;
                }
                ++i;
            }
        }
    }

    public void lockWarning() {
        JOptionPane.showMessageDialog(this.applFrame, "Cannot execute this action. This grammar is locked.", "Edit Formula", 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdAtomic addAtomic() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (!eGra.isEditable()) {
            this.lockWarning();
            return null;
        }
        int newIndex = eGra.getGraphs().size() + eGra.getRules().size() + eGra.getAtomics().size();
        if (eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = "Atomic";
        if (eGra.getAtomics().size() > 0) {
            name = String.valueOf(name) + eGra.getAtomics().size();
        }
        name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(eGra, name);
        EdAtomic newAtomic = eGra.createAtomic(name);
        AtomicGraphConstraintTreeNodeData sd = new AtomicGraphConstraintTreeNodeData(newAtomic);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        newIndex = newAtomic.getConclusions().size() - 1;
        EdAtomic aConclusion = newAtomic.getConclusion(0);
        name = aConclusion.getMorphism().getName();
        ConclusionTreeNodeData sdc = new ConclusionTreeNodeData(aConclusion);
        DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(sdc);
        sdc.setTreeNode(aNode);
        this.treeModel.insertNodeInto(aNode, newNode, newIndex);
        return newAtomic;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addAtomic(EdGraGra gra, EdAtomic newAtomic) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a graph constraint: " + newAtomic.getName() + "." + "\n Please select suitable grammar: " + gra.getName() + ".", "", 2);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a graph constraint: " + newAtomic.getName() + "." + "\n Please select suitable grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (eGra != gra) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a graph constraint: " + newAtomic.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        if (!eGra.isEditable()) {
            this.lockWarning();
            return false;
        }
        eGra.addAtomic(newAtomic);
        int newIndex = eGra.getGraphs().size() + eGra.getRules().size() + eGra.getAtomics().size() - 1;
        if (eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        AtomicGraphConstraintTreeNodeData sd = new AtomicGraphConstraintTreeNodeData(newAtomic);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        int i = 0;
        while (i < newAtomic.getConclusions().size()) {
            EdAtomic aConclusion = newAtomic.getConclusion(i);
            ConclusionTreeNodeData sdc = new ConclusionTreeNodeData(aConclusion);
            DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(sdc);
            sdc.setTreeNode(aNode);
            this.treeModel.insertNodeInto(aNode, newNode, i);
            ++i;
        }
        return true;
    }

    public EdAtomic addConclusion() {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select an atomic.", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (!data.isAtomic()) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select an atomic.", "", 2);
            return null;
        }
        if (data.getAtomic().getGraGra().isEditable()) {
            EdAtomic parentAtomic = data.getAtomic();
            TreePath graPath = this.selPath.getParentPath();
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            this.handleRuleConstraints(graNode, false, parentAtomic);
            int newIndex = parentAtomic.getConclusions().size();
            String name = "Conclusion" + parentAtomic.getConclusions().size();
            EdAtomic newConclusion = parentAtomic.createNextConclusion(name);
            ConclusionTreeNodeData sd = new ConclusionTreeNodeData(newConclusion);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(newNode);
            this.treeModel.insertNodeInto(newNode, parent, newIndex);
            if (!this.tree.isExpanded(this.selPath)) {
                this.tree.expandPath(this.selPath);
            }
            return newConclusion;
        }
        this.lockWarning();
        return null;
    }

    public boolean addConclusion(EdAtomic atomic, EdAtomic newConclusion) {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add conclusion: " + newConclusion.getName() + "." + "\n Please select suitable graph constraint: " + atomic.getName() + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (!data.isAtomic()) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add conclusion: " + newConclusion.getName() + "." + "\n Please select suitable graph constraint: " + atomic.getName() + ".", "", 2);
            return false;
        }
        EdAtomic parentAtomic = data.getAtomic();
        if (parentAtomic != atomic) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add conclusion: " + newConclusion.getName() + "." + "\n Please select suitable graph constraint: " + atomic.getName() + ".", "", 2);
            return false;
        }
        if (parentAtomic.getGraGra().isEditable()) {
            TreePath graPath = this.selPath.getParentPath();
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            this.handleRuleConstraints(graNode, false, parentAtomic);
            parentAtomic.addConclusion(newConclusion);
            int newIndex = parentAtomic.getConclusions().size();
            ConclusionTreeNodeData sd = new ConclusionTreeNodeData(newConclusion);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(newNode);
            this.treeModel.insertNodeInto(newNode, parent, newIndex - 1);
            if (!this.tree.isExpanded(this.selPath)) {
                this.tree.expandPath(this.selPath);
            }
            return true;
        }
        this.lockWarning();
        return false;
    }

    public boolean setLevelOfTypeGraphCheck(EdGraGra gragra, int level, boolean showErrorMsg) {
        Collection<TypeError> errors = gragra.setLevelOfTypeGraphCheck(level);
        if (errors != null && errors.size() > 0) {
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 21, ""));
            if (showErrorMsg) {
                String message = "<html><body>";
                message = message.concat("Cannot change the type graph mode.<br>Some type mismatches found.");
                Iterator<TypeError> iter = errors.iterator();
                int i = 0;
                while (iter.hasNext() && i < 20) {
                    message = message.concat("\n");
                    message = message.concat(iter.next().getMessage());
                    ++i;
                }
                if (i >= 20 && iter.hasNext()) {
                    message = message.concat("\n ... more undisplayed mismatches");
                }
                JOptionPane.showMessageDialog(this.applFrame, message, "Type Graph Error", 0);
            }
            return false;
        }
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 211, ""));
        return true;
    }

    public void setTypeGraphLevel(int level) {
        this.typeGraphPopupMenu.setTypeGraphLevel(level);
    }

    public void updateTypeGraphTreeNode(DefaultMutableTreeNode node, EdGraGra gragra) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        if (data.isTypeGraph()) {
            String mode = "";
            switch (gragra.getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck()) {
                case 0: {
                    mode = "[D]";
                    break;
                }
                case 5: {
                    mode = "[Inh]";
                    break;
                }
                case 10: {
                    mode = "[E]";
                    break;
                }
                case 20: {
                    mode = "[Em]";
                    break;
                }
                case 30: {
                    mode = "[Emm]";
                    break;
                }
                default: {
                    mode = "[?]";
                }
            }
            String str = String.valueOf(mode) + gragra.getTypeGraph().getBasisGraph().getName();
            data.setString(str);
            gragra.setChanged(true);
            this.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkOne() {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a graph constraint.", "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        EdGraGra gra = this.getGraGra((DefaultMutableTreeNode)node.getParent());
        if (gra == null) {
            String s = "Yikes.  Internal brokeness.";
            JOptionPane.showMessageDialog(this.applFrame, s);
            return;
        }
        TreeViewEvent e = new TreeViewEvent(this, 13);
        this.fireTreeViewEvent(e);
        boolean valid = false;
        boolean good = false;
        String thing = "";
        boolean changed = gra.isChanged();
        if (data.isAtomic()) {
            thing = "atomic";
            EdAtomic eatom = data.getAtomic();
            valid = eatom.getBasisAtomic().isValid();
            if (valid) {
                if (!gra.getBasisGraGra().isGraphReadyForTransform()) {
                    String mesg = "The host graph isn't ready! Please check its attributes.";
                    JOptionPane.showMessageDialog(this.applFrame, mesg, "Graph not ready", 0);
                    return;
                }
                eatom.getBasisAtomic().setMorphismCompletionStrategy(gra.getBasisGraGra().getMorphismCompletionStrategy());
                good = eatom.getBasisAtomic().eval((Object)gra.getBasisGraGra().getGraph());
            }
        } else if (data.isConstraint()) {
            thing = "constraint (formula)";
            EdConstraint econs = data.getConstraint();
            valid = econs.getBasisConstraint().isValid();
            if (valid) {
                if (!gra.getBasisGraGra().isGraphReadyForTransform()) {
                    String mesg = "The Host graph is not ready! Please check its attributes.";
                    JOptionPane.showMessageDialog(this.applFrame, mesg, "Graph not ready", 0);
                    return;
                }
                gra.getBasisGraGra().setMorphismCompletionStrategyOfGraphConstraints();
                good = econs.getBasisConstraint().eval(gra.getBasisGraGra().getGraph());
            }
        }
        if (!valid) {
            String mesg = "This " + thing + " isn't valid.  No checking done.";
            JOptionPane.showMessageDialog(this.applFrame, mesg, "Not valid", 0);
        } else if (!good) {
            String mesg = "The graph doesn't fulfill this " + thing + ".";
            JOptionPane.showMessageDialog(this.applFrame, mesg, "Not fulfilled", 0);
        } else {
            String mesg = "The graph fulfills this " + thing + ".";
            JOptionPane.showMessageDialog(this.applFrame, mesg, "Fulfilled", 1);
        }
        gra.setChanged(changed);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doPostApplicationConditionOfRule() {
        block10: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setFlagForNew();
                    break block10;
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a rule.", "", 2);
                    return;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setFlagForNew();
            }
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a rule.", "", 2);
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        final EdRule eRule = this.getRule(parent);
        RuleConstraintsDialog ruleConstraintsDialog = new RuleConstraintsDialog(this.applFrame, eRule);
        ruleConstraintsDialog.showGUI();
        if (!ruleConstraintsDialog.isCancelled() && !ruleConstraintsDialog.getFormulas().isEmpty()) {
            this.handleRuleConstraints(parent, false, null);
            eRule.getBasisRule().setUsedFormulas(ruleConstraintsDialog.getFormulas());
            Thread thread = new Thread(){

                @Override
                public void run() {
                    GraGraTreeView.this.msg = eRule.getBasisRule().convertUsedFormulas();
                    eRule.getGraGra().setChanged(true);
                }
            };
            thread.start();
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Creating Post Application Condition. Please wait ..."));
            JOptionPane.showMessageDialog(this.applFrame, "Creating Post Application Condition ... ");
            while (thread.isAlive()) {
            }
            if (!this.msg.equals("")) {
                if (eRule.getBasisRule().getConstraints().size() == 0) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Cannot convert Graph Atomics to Post Application Condition of rule.  " + this.msg));
                }
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>" + this.msg, "Create Post Application Condition", 0);
            }
            if (eRule.getBasisRule().getConstraints().size() > 0) {
                this.handleRuleConstraints(parent, true, null);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Creating Post Application Condition ... done."));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdConstraint addConstraint() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "<html><body>Bad selection.<br> Please select a grammar.";
                JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a grammar.</body></html>", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (!eGra.isEditable()) {
            this.lockWarning();
            return null;
        }
        int newIndex = eGra.getGraphs().size() + eGra.getRules().size() + eGra.getAtomics().size() + eGra.getConstraints().size();
        if (eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = "Constraint";
        if (eGra.getConstraints().size() > 0) {
            name = String.valueOf(name) + eGra.getConstraints().size();
        }
        name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(eGra, name);
        EdConstraint newConstraint = eGra.createConstraint(name);
        this.handleRuleConstraints(parent, false, newConstraint);
        ConstraintTreeNodeData sd = new ConstraintTreeNodeData(newConstraint);
        if (this.layered && !newConstraint.getBasisConstraint().getLayer().isEmpty()) {
            String tag = "[" + newConstraint.getBasisConstraint().getLayerAsString() + "]";
            sd.setString(tag, name);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        return newConstraint;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addConstraint(EdGraGra gra, EdConstraint newConstraint) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add formula: " + newConstraint.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
        } else if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add formula: " + newConstraint.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra eGra = this.getGraGra(parent);
        if (eGra != gra) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add formula: " + newConstraint.getName() + "." + "\n Please select the grammar: " + gra.getName() + ".", "", 2);
            return false;
        }
        if (!eGra.isEditable()) {
            this.lockWarning();
            return false;
        }
        this.handleRuleConstraints(parent, false, newConstraint);
        eGra.addConstraint(newConstraint);
        int newIndex = eGra.getGraphs().size() + eGra.getRules().size() + eGra.getAtomics().size() + eGra.getConstraints().size() - 1;
        if (eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = newConstraint.getName();
        ConstraintTreeNodeData sd = new ConstraintTreeNodeData(newConstraint);
        String tagD = "";
        if (!newConstraint.getBasisConstraint().isEnabled()) {
            tagD = "[D]";
        }
        if (this.layered && !newConstraint.getBasisConstraint().getLayer().isEmpty()) {
            String tagL = "[" + newConstraint.getBasisConstraint().getLayerAsString() + "]";
            sd.setString(tagD, tagL, name);
        } else if (this.priority && !newConstraint.getBasisConstraint().getPriority().isEmpty()) {
            String tagP = "[" + newConstraint.getBasisConstraint().getPriorityAsString() + "]";
            sd.setString(tagD, tagP, name);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        return true;
    }

    public void editConstraint() {
        block4: {
            String f;
            boolean formulaChanged;
            if (this.selPath == null) {
                String s = "<html><body>Bad selection.<br> Please select a constraint to edit.</body></html>";
                JOptionPane.showMessageDialog(this.applFrame, s);
                return;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            DefaultMutableTreeNode granode = (DefaultMutableTreeNode)parent.getParent();
            EdGraGra eGra = granode != null ? this.getGraGra(granode) : null;
            EdConstraint con = this.getConstraint(parent);
            if (eGra == null || con == null) {
                return;
            }
            String ownerName = "graph constraint : " + con.getName();
            FormulaGraphGUI d = new FormulaGraphGUI(this.applFrame, ownerName, " Graph editor of Formula above Atomic Graph Constraints.", " An empty graph is the TRUE case.", true);
            d.setExportJPEG(this.exportJPEG);
            d.disableFORALL(true);
            List<Evaluable> atomics = eGra.getBasisGraGra().getListOfAtomicObjects();
            String oldf = con.getBasisConstraint().getAsString(atomics);
            d.setVarsAsObjs(eGra.getAtomics(), oldf);
            d.setLocation(200, 100);
            while (true) {
                d.setVisible(true);
                if (d.isCanceled()) break block4;
                formulaChanged = d.isChanged();
                f = d.getFormula();
                if (con.getBasisConstraint().setFormula(atomics, f)) break;
                JOptionPane.showMessageDialog(this.applFrame, "The formula definition failed. Please correct.", " Formula failed ", 2);
            }
            if (formulaChanged && !f.equals(oldf)) {
                this.handleRuleConstraints(granode, false, con);
                con.setVarSet(atomics, eGra.getAtomicNames());
                con.update();
                eGra.setChanged(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdNAC addNAC(boolean copyRHS) {
        DefaultMutableTreeNode child;
        block11: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setFlagForNew();
                    break block11;
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a rule.</body></html>", "", 2);
                    return null;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setFlagForNew();
            } else if (this.selPath != this.tree.getSelectionPath()) {
                this.selPath = this.tree.getSelectionPath();
                this.setFlagForNew();
            }
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection.<br> Please select a rule.</body></html>", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdRule eRule = this.getRule(parent);
        if (!eRule.getGraGra().isEditable()) {
            this.lockWarning();
            return null;
        }
        int newIndex = eRule.getNestedACs().size() + eRule.getNACs().size();
        if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
            ++newIndex;
        }
        String name = "Nac";
        if (eRule.getNACs().size() > 0) {
            name = String.valueOf(name) + eRule.getNACs().size();
        }
        name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(eRule, name);
        EdNAC newNAC = copyRHS ? eRule.createNACDuetoRHS(name) : eRule.createNAC(name, false);
        this.putNACIntoTree(newNAC, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return newNAC;
    }

    public void putNACIntoTree(EdNAC nac, DefaultMutableTreeNode parentNode, int index) {
        NACTreeNodeData sd = new NACTreeNodeData(nac);
        String name = nac.getName();
        if (!nac.getMorphism().isEnabled()) {
            String tag = "[D]";
            sd.setString(tag, name);
        }
        DefaultMutableTreeNode newACNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newACNode);
        this.treeModel.insertNodeInto(newACNode, parentNode, index);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addNAC(EdRule r, EdNAC newNAC) {
        DefaultMutableTreeNode child;
        block11: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setFlagForNew();
                    break block11;
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a NAC: " + newNAC.getName() + "." + "\n Please select the rule: " + r.getName() + ".", "", 2);
                    return false;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setFlagForNew();
            } else if (this.selPath != this.tree.getSelectionPath()) {
                this.selPath = this.tree.getSelectionPath();
                this.setFlagForNew();
            }
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a NAC: " + newNAC.getName() + "." + "\n Please select the rule: " + r.getName() + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdRule eRule = this.getRule(parent);
        if (eRule != r) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a NAC: " + newNAC.getName() + "." + "\n Please select the rule: " + r.getName() + ".", "", 2);
            return false;
        }
        if (!eRule.getGraGra().isEditable()) {
            this.lockWarning();
            return false;
        }
        int newIndex = eRule.getNestedACs().size() + eRule.getNACs().size();
        if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
            ++newIndex;
        }
        eRule.addNAC(newNAC);
        this.putNACIntoTree(newNAC, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdPAC addPAC() {
        DefaultMutableTreeNode child;
        block11: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setFlagForNew();
                    break block11;
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.", "", 2);
                    return null;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setFlagForNew();
            } else if (this.selPath != this.tree.getSelectionPath()) {
                this.selPath = this.tree.getSelectionPath();
                this.setFlagForNew();
            }
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.", "", 2);
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdRule eRule = this.getRule(parent);
        if (!eRule.getGraGra().isEditable()) {
            this.lockWarning();
            return null;
        }
        int newIndex = eRule.getNestedACs().size() + eRule.getNACs().size() + eRule.getPACs().size();
        if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
            ++newIndex;
        }
        String name = "Pac";
        if (eRule.getPACs().size() > 0) {
            name = String.valueOf(name) + eRule.getPACs().size();
        }
        name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(eRule, name);
        EdPAC newPAC = eRule.createPAC(name, false);
        this.putPACIntoTree(newPAC, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return newPAC;
    }

    public void putPACIntoTree(EdPAC pac, DefaultMutableTreeNode parentNode, int index) {
        PACTreeNodeData sd = new PACTreeNodeData(pac);
        String name = pac.getName();
        if (!pac.getMorphism().isEnabled()) {
            String tag = "[D]";
            sd.setString(tag, name);
        }
        DefaultMutableTreeNode newACNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newACNode);
        this.treeModel.insertNodeInto(newACNode, parentNode, index);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addPAC(EdRule r, EdPAC newPAC) {
        DefaultMutableTreeNode child;
        block11: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setFlagForNew();
                    break block11;
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a PAC: " + newPAC.getName() + "." + "\n Please select the rule: " + r.getName() + ".", "", 2);
                    return false;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setFlagForNew();
            } else if (this.selPath != this.tree.getSelectionPath()) {
                this.selPath = this.tree.getSelectionPath();
                this.setFlagForNew();
            }
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a PAC: " + newPAC.getName() + "." + "\n Please select the rule: " + r.getName() + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdRule eRule = this.getRule(parent);
        if (eRule != r) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a PAC: " + newPAC.getName() + "." + "\n Please select the rule: " + r.getName() + ".", "", 2);
            return false;
        }
        if (!eRule.getGraGra().isEditable()) {
            this.lockWarning();
            return false;
        }
        int newIndex = eRule.getNestedACs().size() + eRule.getNACs().size() + eRule.getPACs().size();
        if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
            ++newIndex;
        }
        eRule.addPAC(newPAC);
        this.putPACIntoTree(newPAC, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return true;
    }

    public EdNestedApplCond addNestedAC(boolean copyRHS) {
        String nb;
        StateEditable parObj;
        DefaultMutableTreeNode child;
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule or a general application condition.", "", 2);
            return null;
        }
        if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule or a general application condition.", "", 2);
            return null;
        }
        EdNestedApplCond newAC = null;
        String name = "ApplCond";
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        int newIndex = 0;
        if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
            newIndex = 1;
        }
        if ((parObj = this.getRule(parent)) != null) {
            EdRule eRule = parObj;
            if (eRule.getGraGra().isEditable()) {
                newIndex += eRule.getNestedACs().size();
                nb = eRule.getNestedACs().size() > 0 ? String.valueOf(eRule.getNestedACs().size()) : "";
                name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(eRule, "ApplCond".concat(nb));
                newAC = copyRHS ? eRule.createGACDuetoRHS(name) : eRule.createNestedAC(name, false);
            } else {
                this.lockWarning();
            }
        } else {
            parObj = this.getNestedAC(parent);
            if (parObj != null) {
                EdNestedApplCond parAC = (EdNestedApplCond)parObj;
                if (parAC.getGraGra().isEditable()) {
                    nb = (newIndex += parAC.getSizeOfNestedACs()) > 0 ? String.valueOf(newIndex) : "";
                    name = ((GraGraTreeModel)this.tree.getModel()).makeNewName(parAC, "NestCond".concat(nb));
                    newAC = parAC.createNestedAC(name, false);
                } else {
                    this.lockWarning();
                }
            }
        }
        if (newAC != null) {
            NestedACTreeNodeData sd = new NestedACTreeNodeData(newAC);
            DefaultMutableTreeNode newACNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(newACNode);
            this.treeModel.insertNodeInto(newACNode, parent, newIndex);
            if (!this.tree.isExpanded(this.selPath)) {
                this.tree.expandPath(this.selPath);
            }
        }
        return newAC;
    }

    public boolean addNestedAC(EdRule r, EdNestedApplCond newAC) {
        return this.addNestedCond(r, "rule", r.getName(), newAC);
    }

    public boolean addNestedAC(EdNestedApplCond ac, EdNestedApplCond newAC) {
        return this.addNestedCond(ac, "condition", ac.getName(), newAC);
    }

    private boolean addNestedCond(Object parentObj, String parentKind, String parentName, EdNestedApplCond newAC) {
        DefaultMutableTreeNode child;
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a (Nested) Application Condition: " + newAC.getName() + "." + "\n Please select a " + parentKind + " : " + parentName + ".", "", 2);
            return false;
        }
        if (this.selPath != this.tree.getSelectionPath()) {
            this.selPath = this.tree.getSelectionPath();
            this.setFlagForNew();
        }
        if (!this.newApplCondOK) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a (Nested) Application Condition: " + newAC.getName() + "." + "\n Please select a " + parentKind + " : " + parentName + ".", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        int newIndex = -1;
        if (parentObj instanceof EdRule) {
            EdRule eRule = this.getRule(parent);
            if (eRule != parentObj) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a (Nested) Application Condition: " + newAC.getName() + "." + "\n Please select a " + parentKind + " : " + parentName + ".", "", 2);
                return false;
            }
            newIndex = eRule.getNestedACs().size();
            if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
                ++newIndex;
            }
            eRule.addNestedAC(newAC);
        } else if (parentObj instanceof EdNestedApplCond) {
            EdNestedApplCond ac = this.getNestedAC(parent);
            if (ac != parentObj) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to add a (Nested) Application Condition: " + newAC.getName() + "." + "\n Please select a " + parentKind + " : " + parentName + ".", "", 2);
                return false;
            }
            newIndex = ac.getSizeOfNestedACs();
            if (parent.getChildCount() > 0 && (child = (DefaultMutableTreeNode)parent.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
                ++newIndex;
            }
            ac.addNestedAC(newAC);
        }
        if (newIndex != -1) {
            NestedACTreeNodeData sd = new NestedACTreeNodeData(newAC);
            if (!newAC.getMorphism().isEnabled()) {
                String tag = "[D]";
                sd.setString(tag, newAC.getName());
            }
            this.putNestedACIntoTree(newAC, parent, newIndex);
            if (!this.tree.isExpanded(this.selPath)) {
                this.tree.expandPath(this.selPath);
            }
            return true;
        }
        return false;
    }

    public void putNestedACIntoTree(EdNestedApplCond ac, DefaultMutableTreeNode parentNode, int index) {
        NestedACTreeNodeData sd = new NestedACTreeNodeData(ac);
        String name = ac.getName();
        if (!ac.getMorphism().isEnabled()) {
            String tag = "[D]";
            sd.setString(tag, name);
        }
        DefaultMutableTreeNode newACNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newACNode);
        this.treeModel.insertNodeInto(newACNode, parentNode, index);
        this.addSubTreeOfNestedAC(ac, newACNode);
    }

    private void addSubTreeOfNestedAC(EdNestedApplCond ac, DefaultMutableTreeNode acNode) {
        int indx = 0;
        if (!"true".equals(ac.getNestedMorphism().getFormulaText())) {
            List<String> allVars = ac.getNestedMorphism().getNameOfEnabledACs();
            List<Integer> vars = Formula.getFromStringAboveList(ac.getNestedMorphism().getFormulaText(), allVars);
            ApplFormulaTreeNodeData conddata = new ApplFormulaTreeNodeData(ac.getNestedMorphism().getFormulaText(), true, ac);
            DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
            conddata.setTreeNode(condchild);
            this.treeModel.insertNodeInto(condchild, acNode, indx);
            ++indx;
        }
        int i = 0;
        while (i < ac.getNestedACs().size()) {
            EdNestedApplCond cond = ac.getNestedACs().get(i);
            NestedACTreeNodeData sd = new NestedACTreeNodeData(cond);
            if (!cond.getMorphism().isEnabled()) {
                String tag = "[D]";
                sd.setString(tag, cond.getName());
            }
            DefaultMutableTreeNode condNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(condNode);
            this.treeModel.insertNodeInto(condNode, acNode, indx);
            ++indx;
            this.addSubTreeOfNestedAC(cond, condNode);
            ++i;
        }
    }

    public void resetEnabled(boolean enable) {
        this.setEnabled(enable);
        this.file.setEnabled(enable);
    }

    public void moveRule() {
        if (this.tree.isExpanded(this.selPath)) {
            this.tree.collapsePath(this.selPath);
        }
        this.movedNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.tmpSelPath = this.tree.getSelectionPath();
        if (this.tmpSelPath == null) {
            this.movedNode = null;
            this.wasMoved = false;
            return;
        }
        this.tmpSelNode = (DefaultMutableTreeNode)this.tmpSelPath.getLastPathComponent();
        this.wasMoved = true;
        this.applFrame.setCursor(new Cursor(13));
    }

    public void setRuleLayer() {
        DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
        if (sd.isRule()) {
            EdRule r = sd.getRule();
            String initLayer = String.valueOf(r.getBasisRule().getLayer());
            String layer = new String("-1");
            Integer i = Integer.valueOf(layer);
            while (i == null || i < 0) {
                layer = JOptionPane.showInputDialog(this.applFrame, "Please set the rule layer >= 0.", initLayer);
                if (layer == null) {
                    i = Integer.valueOf(initLayer);
                    break;
                }
                try {
                    i = Integer.valueOf(layer);
                }
                catch (NumberFormatException ex) {
                    i = null;
                }
            }
            if (r.getBasisRule().getLayer() != i.intValue()) {
                r.getBasisRule().setLayer(i);
                r.getGraGra().setChanged(true);
                r.getGraGra().getBasisGraGra().oneRuleHasChangedLayer();
                r.getGraGra().getBasisGraGra().refreshConstraintsForLayer();
                if (this.layered) {
                    this.treeModel.ruleNameChanged(ruleNode, this.layered);
                    this.treeModel.nodeChanged(ruleNode);
                    this.treeModel.constraintNameChanged(r.getGraGra(), this.layered);
                    this.tree.treeDidChange();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 26, this.selPath));
                }
            }
        }
    }

    public void setConstraintLayer() {
        DefaultMutableTreeNode formulaNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)formulaNode.getUserObject();
        if (sd.isConstraint()) {
            EdConstraint c = sd.getConstraint();
            Vector<Formula> v = new Vector<Formula>(1);
            v.add(c.getBasisConstraint());
            GraGraConstraintLayerDialog lg = new GraGraConstraintLayerDialog(this.applFrame, v, c.getGraGra().getBasisGraGra().getLayers());
            lg.showGUI();
            if (!lg.isCancelled()) {
                c.getGraGra().setChanged(true);
                if (this.layered) {
                    this.treeModel.constraintNameChanged(c.getGraGra(), this.layered);
                    this.treeModel.nodeChanged(formulaNode);
                    this.tree.treeDidChange();
                }
            }
        }
    }

    public void setConstraintPriority() {
        DefaultMutableTreeNode formulaNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)formulaNode.getUserObject();
        if (sd.isConstraint()) {
            EdConstraint c = sd.getConstraint();
            Vector<Formula> v = new Vector<Formula>(1);
            v.add(c.getBasisConstraint());
            ConstraintPriorityDialog lg = new ConstraintPriorityDialog(this.applFrame, v, c.getGraGra().getBasisGraGra().getPriorities());
            lg.showGUI();
            if (!lg.isCancelled()) {
                c.getGraGra().setChanged(true);
                if (this.priority) {
                    this.treeModel.constraintNameChanged(c.getGraGra(), false, this.priority);
                    this.treeModel.nodeChanged(formulaNode);
                    this.tree.treeDidChange();
                }
            }
        }
    }

    public void showRuleAttrConditions(DefaultMutableTreeNode aNode) {
        GraGraTreeNodeData sd;
        DefaultMutableTreeNode node = aNode;
        if (node == null) {
            node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        }
        if ((sd = (GraGraTreeNodeData)node.getUserObject()).isRule()) {
            EdRule r = sd.getRule();
            int i = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)node.getChildAt(i);
                GraGraTreeNodeData delData = (GraGraTreeNodeData)delNode.getUserObject();
                if (delData.isAttrCondition()) {
                    this.treeModel.removeNodeFromParent(delNode);
                    continue;
                }
                ++i;
            }
            CondTuple conds = (CondTuple)r.getBasisRule().getAttrContext().getConditions();
            i = 0;
            while (i < conds.getSize()) {
                CondMember cond = (CondMember)conds.getMemberAt(i);
                String condStr = cond.getExprAsText();
                if (condStr != null && !condStr.equals("")) {
                    RuleAttrCondTreeNodeData conddata = new RuleAttrCondTreeNodeData(cond, r);
                    conddata.setString(condStr);
                    DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                    conddata.setTreeNode(condchild);
                    this.treeModel.insertNodeInto(condchild, node, node.getChildCount());
                }
                ++i;
            }
            this.treeModel.nodeChanged(node);
        }
    }

    public void showAtomicAttrConditions(DefaultMutableTreeNode aNode) {
        GraGraTreeNodeData sd;
        DefaultMutableTreeNode node = aNode;
        if (node == null) {
            node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        }
        if ((sd = (GraGraTreeNodeData)node.getUserObject()).isConclusion()) {
            EdAtomic concl = sd.getConclusion();
            int i = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)node.getChildAt(i);
                GraGraTreeNodeData delData = (GraGraTreeNodeData)delNode.getUserObject();
                if (delData.isAttrCondition()) {
                    this.treeModel.removeNodeFromParent(delNode);
                    continue;
                }
                ++i;
            }
            CondTuple conds = (CondTuple)concl.getBasisAtomic().getAttrContext().getConditions();
            i = 0;
            while (i < conds.getSize()) {
                CondMember cond = (CondMember)conds.getMemberAt(i);
                String condStr = cond.getExprAsText();
                if (condStr != null && !condStr.equals("")) {
                    ConclusionAttrConditionTreeNodeData conddata = new ConclusionAttrConditionTreeNodeData(cond, concl);
                    conddata.setString(condStr);
                    DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                    conddata.setTreeNode(condchild);
                    this.treeModel.insertNodeInto(condchild, node, node.getChildCount());
                }
                ++i;
            }
            this.treeModel.nodeChanged(node);
        }
    }

    public Point getPopupMenuLocation() {
        return this.popupLocation;
    }

    public void setRulePriority() {
        DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
        if (sd.isRule()) {
            EdRule r = sd.getRule();
            String initPriority = String.valueOf(r.getBasisRule().getPriority());
            String priorityStr = new String("-1");
            Integer i = Integer.valueOf(priorityStr);
            while (i == null || i <= 0) {
                priorityStr = JOptionPane.showInputDialog(this.applFrame, "Please set the rule priority > 0.", initPriority);
                if (priorityStr == null) {
                    i = Integer.valueOf(initPriority);
                    break;
                }
                try {
                    i = Integer.valueOf(priorityStr);
                }
                catch (NumberFormatException ex) {
                    i = null;
                }
            }
            if (r.getBasisRule().getPriority() != i.intValue()) {
                r.getBasisRule().setPriority(i);
                r.getGraGra().setChanged(true);
                r.getGraGra().getBasisGraGra().oneRuleHasChangedPriority();
                if (this.priority) {
                    this.treeModel.ruleNameChanged(ruleNode, this.layered, this.priority);
                    this.treeModel.nodeChanged(ruleNode);
                    this.tree.treeDidChange();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 27, this.selPath));
                }
            }
        }
    }

    public void showNAC() {
        this.editorPath = this.selPath;
        this.setCurrentData(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 8, this.editorPath));
    }

    public void hideNAC() {
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 9, this.editorPath));
    }

    public Vector<String> getGraGraNames() {
        return ((GraGraTreeModel)this.tree.getModel()).getGraGraNames();
    }

    public EdGraGra getGraGra(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isGraGra()) {
            return data.getGraGra();
        }
        return null;
    }

    public EdGraph getGraph(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isGraph()) {
            return data.getGraph();
        }
        return null;
    }

    public EdAtomic getAtomic(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAtomic()) {
            return data.getAtomic();
        }
        return null;
    }

    public EdAtomic getConclusion(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isConclusion()) {
            return data.getConclusion();
        }
        return null;
    }

    public EdConstraint getConstraint(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isConstraint()) {
            return data.getConstraint();
        }
        return null;
    }

    public EdRule getRule(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isRule()) {
            return data.getRule();
        }
        return null;
    }

    public EdRule getKernelRule(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isKernelRule()) {
            return data.getKernelRule();
        }
        return null;
    }

    public EdRule getMultiRule(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isMultiRule()) {
            return data.getMultiRule();
        }
        return null;
    }

    public EdRuleScheme getRuleScheme(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isRuleScheme()) {
            return data.getRuleScheme();
        }
        return null;
    }

    public RuleSequence getRuleSequence(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isRuleSequence()) {
            return data.getRuleSequence();
        }
        return null;
    }

    public EdNAC getNAC(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isNAC()) {
            return data.getNAC();
        }
        return null;
    }

    public EdPAC getPAC(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isPAC()) {
            return data.getPAC();
        }
        return null;
    }

    public EdNestedApplCond getNestedAC(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isNestedAC()) {
            return data.getNestedAC();
        }
        return null;
    }

    public Pair<EdRule, Vector<String>> getRuleContext(DefaultMutableTreeNode n) {
        Pair<EdRule, Vector<String>> context = null;
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAttrCondition()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)n.getParent();
            if (parent == null) {
                return null;
            }
            GraGraTreeNodeData sd = (GraGraTreeNodeData)parent.getUserObject();
            if (sd.isRule()) {
                Vector<String> attrconds = sd.getRule().getAttrConditions();
                context = new Pair<EdRule, Vector<String>>(sd.getRule(), attrconds);
            }
        }
        return context;
    }

    public Pair<EdAtomic, Vector<String>> getConclusionContext(DefaultMutableTreeNode n) {
        Pair<EdAtomic, Vector<String>> context = null;
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAttrCondition()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)n.getParent();
            if (parent == null) {
                return null;
            }
            GraGraTreeNodeData sd = (GraGraTreeNodeData)parent.getUserObject();
            if (sd.isConclusion()) {
                Vector<String> attrconds = sd.getConclusion().getAttrConditions();
                context = new Pair<EdAtomic, Vector<String>>(sd.getConclusion(), attrconds);
            }
        }
        return context;
    }

    public EdRuleConstraint getRuleConstraint(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isRuleConstraint()) {
            return data.getRuleConstraint();
        }
        return null;
    }

    public EdAtomApplCond getAtomApplCond(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAtomApplCond()) {
            return data.getAtomApplCond();
        }
        return null;
    }

    public Vector<EdGraGra> getGraGras() {
        Vector<EdGraGra> gragras = new Vector<EdGraGra>();
        int i = 0;
        while (i < this.top.getChildCount()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.top.getChildAt(i);
            GraGraTreeNodeData data = (GraGraTreeNodeData)aNode.getUserObject();
            if (data.isGraGra()) {
                gragras.addElement(data.getGraGra());
            }
            ++i;
        }
        return gragras;
    }

    void resetAllowEmptyAttrs(boolean b) {
        int i = 0;
        while (i < this.top.getChildCount()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.top.getChildAt(i);
            GraGraTreeNodeData data = (GraGraTreeNodeData)aNode.getUserObject();
            if (data.isGraGra()) {
                data.getGraGra().getTypeSet().getBasisTypeSet().setAllowEmptyAttr(b);
            }
            ++i;
        }
    }

    public void copy(String menuItemString) {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a rule.", "", 2);
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            return;
        }
        if (menuItemString.equals("Rule")) {
            if (sd.isRule()) {
                this.copyRule(aNode);
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a rule.", "", 2);
            }
        }
    }

    private void copyRule(DefaultMutableTreeNode node) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        TreePath graPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        graPath = this.selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            if (graNode.getUserObject() instanceof GrammarTreeNodeData) {
                GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
                if (graData.getGraGra().isEditable()) {
                    EdRule ruleClone = graData.getGraGra().cloneRule(data.getRule(), true);
                    this.putRuleIntoTree(ruleClone, graNode, graNode.getIndex(node) + 1);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.selPath));
                }
            } else if (graNode.getUserObject() instanceof RuleSchemeTreeNodeData) {
                TreePath rsPath = graPath;
                DefaultMutableTreeNode rsNode = graNode;
                RuleSchemeTreeNodeData rsData = (RuleSchemeTreeNodeData)rsNode.getUserObject();
                graPath = rsPath.getParentPath();
                graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
                GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
                if (graData.getGraGra().isEditable()) {
                    EdRule ruleClone = graData.getGraGra().cloneAmalgamatedRule(data.getRule(), rsData.getRuleScheme(), true);
                    this.tree.collapsePath(rsPath);
                    this.putRuleIntoTree(ruleClone, graNode, graNode.getIndex(rsNode) + 1);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.selPath));
                }
            }
        }
    }

    protected void copyRule() {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.", "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.copyRule(node);
    }

    private void makeConcurrentRule(boolean disjoint) {
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.makeConcurrentRule(node, disjoint);
    }

    private void makeConcurrentRule(DefaultMutableTreeNode node, boolean disjoint) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        TreePath graPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule sequence.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        graPath = this.selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            EdRule rule1 = data.getRule();
            int rule2indx = graData.getGraGra().getIndexOfRule(rule1);
            int nn = 1;
            if (rule2indx < graData.getGraGra().getRules().size() - 1) {
                ++rule2indx;
                ++nn;
            }
            EdRule rule2 = graData.getGraGra().getRule(rule2indx);
            if (rule1.getBasisRule().getRuleScheme() != null || rule2.getBasisRule().getRuleScheme() != null) {
                JOptionPane.showMessageDialog(this.applFrame, "One of the rules is a Rule Scheme.\nBuilding of a concurrent rule is not available in this case.\nOnly plain rules will be supported.", "Feature not available", 0);
                return;
            }
            EdRule concurrentRule = graData.getGraGra().makeConcurrentRule(rule1, rule2, true, true);
            if (concurrentRule != null) {
                this.putRuleIntoTree(concurrentRule, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + nn);
                if (!concurrentRule.getBasisRule().getErrorMsg().equals("")) {
                    String warnMsg = concurrentRule.getBasisRule().getErrorMsg().replaceAll(";", "<br>");
                    warnMsg = warnMsg.replaceAll("\n", "<br>");
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>During creating concurrent rule the following change(s) done:<br><br><font color=\"#FF0000\">" + warnMsg + "</font>" + "<br>(It would be advisable to check the change(s).)" + "<br><br>The new concurrent rule:  " + concurrentRule.getName() + "<br>" + "is added after its original rules into the rule set.<br><br>", "Concurrent Rule:  " + concurrentRule.getName(), 1);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>Creating concurrent rule was successful.<br><br>The new concurrent rule:  " + concurrentRule.getName() + "<br>" + "is added after its original rules into the rule set.<br><br>", "Concurrent Rule:  " + concurrentRule.getName(), 1);
                }
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>It isn't possible to create concurrent rule based on :<br>    " + data.getRule().getName() + ".", "Concurrent Rule", 0);
            }
        }
    }

    public void concurrentRuleWarning(EdRule concurrentRule) {
        if (!concurrentRule.getBasisRule().getErrorMsg().equals("")) {
            String warnMsg = concurrentRule.getBasisRule().getErrorMsg().replaceAll(";", "\n");
            JOptionPane.showMessageDialog(this.applFrame, "During creating concurrent rule some warnings arised.\n\n" + warnMsg + "\n(It would be advisable to check this rule.)" + "\n\nThe new rule: \n" + concurrentRule.getName() + "\n" + "is added at the end of the rule set.\n\n", "Concurrent Rule:  " + concurrentRule.getName(), 1);
        } else if (concurrentRule.getBasisRule().getMatch() != null && !concurrentRule.getBasisRule().getMatch().isEmpty()) {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Creating concurrent rule was successful.<br><br>The new concurrent rule:<br>  " + concurrentRule.getName() + "<br>" + "is added at the end of the rule set.<br><br>" + "The match of this rule is partially set due to object flow.<br><br>", "Concurrent Rule:  " + concurrentRule.getName(), 1);
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Creating concurrent rule was successful.<br><br>The new concurrent rule: <br> " + concurrentRule.getName() + "<br>" + "is added at the end of the rule set.<br><br>", "Concurrent Rule:  " + concurrentRule.getName(), 1);
        }
    }

    public void putRuleIntoTree(EdRule rule, DefaultMutableTreeNode parentNode, int index) {
        RuleTreeNodeData sd = new RuleTreeNodeData(rule);
        DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(ruleNode);
        this.treeModel.insertNodeInto(ruleNode, parentNode, index);
        int indx = 0;
        indx = this.addGACsToRuleTreeNode(rule, ruleNode, indx);
        this.addNACsToRuleTreeNode(rule, ruleNode, indx += rule.getNestedACs().size());
        this.addPACsToRuleTreeNode(rule, ruleNode, indx += rule.getNACs().size());
        this.addAttrCondToRuleTreeNode(rule, ruleNode);
        this.treeModel.ruleNameChanged(ruleNode, this.layered);
        this.tree.treeDidChange();
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.selPath));
    }

    public void disable(String key, boolean disable) {
        if (this.selPath == null) {
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            return;
        }
        if (key.equals("Rule")) {
            if (sd.isRule()) {
                if (disable) {
                    if (this.layered && !sd.isMultiRule()) {
                        sd.setString("[D]", "[" + sd.getRule().getBasisRule().getLayer() + "]", sd.getRule().getBasisRule().getName());
                    } else if (this.priority && !sd.isMultiRule()) {
                        sd.setString("[D]", "[" + sd.getRule().getBasisRule().getPriority() + "]", sd.getRule().getBasisRule().getName());
                    } else {
                        sd.setString("[D]", sd.getRule().getBasisRule().getName());
                    }
                } else if (this.layered && !sd.isMultiRule()) {
                    sd.setString("", "[" + sd.getRule().getBasisRule().getLayer() + "]", sd.getRule().getBasisRule().getName());
                } else if (this.priority && !sd.isMultiRule()) {
                    sd.setString("", "[" + sd.getRule().getBasisRule().getPriority() + "]", sd.getRule().getBasisRule().getName());
                } else {
                    sd.setString("", sd.getRule().getBasisRule().getName());
                }
                sd.getRule().getBasisRule().setEnabled(!disable);
                sd.getRule().getGraGra().getBasisGraGra().oneRuleHasChangedEvailability();
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
            }
        } else if (key.equals("RuleScheme")) {
            if (sd.isRuleScheme()) {
                if (disable) {
                    if (this.layered) {
                        sd.setString("[D]", "[" + sd.getRuleScheme().getBasisRule().getLayer() + "]", sd.getRuleScheme().getBasisRule().getName());
                    } else if (this.priority) {
                        sd.setString("[D]", "[" + sd.getRuleScheme().getBasisRule().getPriority() + "]", sd.getRuleScheme().getBasisRule().getName());
                    } else {
                        sd.setString("[D]", sd.getRuleScheme().getBasisRule().getName());
                    }
                } else if (this.layered) {
                    sd.setString("", "[" + sd.getRuleScheme().getBasisRule().getLayer() + "]", sd.getRuleScheme().getBasisRule().getName());
                } else if (this.priority) {
                    sd.setString("", "[" + sd.getRuleScheme().getBasisRule().getPriority() + "]", sd.getRuleScheme().getBasisRule().getName());
                } else {
                    sd.setString("", sd.getRuleScheme().getBasisRule().getName());
                }
                sd.getRuleScheme().getBasisRule().setEnabled(!disable);
                sd.getRuleScheme().getGraGra().getBasisGraGra().oneRuleHasChangedEvailability();
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
            }
        } else if (key.equals("NAC")) {
            if (sd.isNAC()) {
                if (disable) {
                    sd.setString("[D]", sd.getNAC().getMorphism().getName());
                } else {
                    sd.setString("", sd.getNAC().getMorphism().getName());
                }
                sd.getNAC().getMorphism().setEnabled(!disable);
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
            }
        } else if (key.equals("PAC")) {
            if (sd.isPAC()) {
                if (disable) {
                    sd.setString("[D]", sd.getPAC().getMorphism().getName());
                } else {
                    sd.setString("", sd.getPAC().getMorphism().getName());
                }
                sd.getPAC().getMorphism().setEnabled(!disable);
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
            }
        } else if (key.equals("NestedAC")) {
            if (sd.isNestedAC()) {
                if (disable) {
                    sd.setString("[D]", sd.getNestedAC().getMorphism().getName());
                } else {
                    sd.setString("", sd.getNestedAC().getMorphism().getName());
                }
                sd.getNestedAC().getMorphism().setEnabled(!disable);
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
            }
        } else if (key.equals("AttrCondition")) {
            if (sd.isAttrCondition()) {
                String condstr = ((CondMember)sd.getAttrCondition().first).getExprAsText();
                if (disable) {
                    sd.setString("[D]", condstr);
                } else {
                    sd.setString("", condstr);
                }
                ((CondMember)sd.getAttrCondition().first).setEnabled(!disable);
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
                if (((AGGAppl)this.applFrame).getGraGraEditor().getEditMode() != 114) {
                    ((AGGAppl)this.applFrame).getGraGraEditor().resetGraphEditor();
                }
            }
        } else if (key.equals("Constraint") && sd.isConstraint()) {
            if (disable) {
                if (this.layered) {
                    sd.setString("[D]", "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]", sd.getConstraint().getName());
                } else if (this.priority) {
                    sd.setString("[D]", "[" + sd.getConstraint().getBasisConstraint().getPriorityAsString() + "]", sd.getConstraint().getName());
                } else {
                    sd.setString("[D]", sd.getConstraint().getName());
                }
            } else if (this.layered) {
                sd.setString("", "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]", sd.getConstraint().getName());
            } else if (this.priority) {
                sd.setString("", "[" + sd.getConstraint().getBasisConstraint().getPriorityAsString() + "]", sd.getConstraint().getName());
            } else {
                sd.setString("", sd.getConstraint().getName());
            }
            sd.getConstraint().getBasisConstraint().setEnabled(!disable);
            this.treeModel.nodeChanged(aNode);
            this.tree.treeDidChange();
        }
    }

    public void cancelCommentsEdit() {
        if (this.comments != null) {
            this.comments.cancel();
            this.comments = null;
        }
    }

    private void editTextualComments(String command) {
        if (this.selPath == null || command.equals("")) {
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            return;
        }
        this.cancelCommentsEdit();
        if (command.equals("commentGraph")) {
            if (sd.isGraph() && !sd.getGraph().isTypeGraph()) {
                this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getGraph().getBasisGraph());
            }
        } else if (command.equals("commentRule")) {
            if (sd.isRule()) {
                this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getRule().getBasisRule());
            }
        } else if (command.equals("commentNAC")) {
            if (sd.isNAC()) {
                this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getNAC().getMorphism());
            }
        } else if (command.equals("commentPAC")) {
            if (sd.isPAC()) {
                this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getPAC().getMorphism());
            }
        } else if (command.equals("commentNestedAC")) {
            if (sd.isNestedAC()) {
                this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getNestedAC().getMorphism());
            }
        } else if (command.equals("commentAtomConstraint")) {
            if (sd.isAtomic()) {
                this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getAtomic().getBasisAtomic());
            }
        } else if (command.equals("commentConstraint") && sd.isConstraint()) {
            this.comments = new GraGraTextualComment(this.applFrame, this.popupLocation.x, this.popupLocation.y, sd.getConstraint().getBasisConstraint());
        }
        if (this.comments != null) {
            this.comments.setVisible(true);
        }
    }

    public void deleteCurrentGraGra(EdGraGra gra) {
        TreePath path = this.getTreePathOfGrammarElement(gra);
        if (path != null) {
            if (path != this.selPath) {
                this.tree.setSelectionPath(path);
                this.editorPath = this.selPath = path;
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
            }
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.deleteGraGra(treenode, path, true);
        }
    }

    public boolean hasMultipleSelection() {
        return this.tree.getSelectionPaths() != null && this.tree.getSelectionPaths().length > 1;
    }

    private void deleteMultipleSelElems() {
        int row = this.tree.getSelectionModel().getMinSelectionRow();
        TreePath[] elems = this.tree.getSelectionPaths();
        int i = 0;
        while (i < elems.length) {
            TreePath p = elems[i];
            this.deleteTreeNode((DefaultMutableTreeNode)p.getLastPathComponent(), p, false);
            ++i;
        }
        this.setEditPath(--row);
        this.setFlagForNew();
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.getEditorPath()));
        if (((GraGraTreeNodeData)((DefaultMutableTreeNode)this.selPath.getLastPathComponent()).getUserObject()).isGraph() && !this.getCurrentGraGra().getRules().isEmpty()) {
            this.setEditPath(++row);
            this.setFlagForNew();
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.getEditorPath()));
        }
    }

    public void delete(String treeItemString) {
        if (this.selPath == null) {
            if (this.currentGraGra != null) {
                JOptionPane.showMessageDialog(this.applFrame, "Bad selection for deletion.", "", 2);
            }
            return;
        }
        if (this.hasMultipleSelection()) {
            Object[] options = new Object[]{"Delete", "Cancel"};
            int op = JOptionPane.showOptionDialog(this.applFrame, "Are you sure you want to delete all selected grammar elements?", "Multiple Delete", -1, 2, null, options, options[0]);
            if (op == 0) {
                this.deleteMultipleSelElems();
            }
            return;
        }
        if (!treeItemString.equals("GraGra") && this.currentGraGra != null && !this.currentGraGra.getGraph().isEditable()) {
            JOptionPane.showMessageDialog(this.applFrame, "Cannot delete this grammar. It is locked.", "Delete", 0);
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            JOptionPane.showMessageDialog(this.applFrame, "Cannot delete. Data is not defined.", "", 0);
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            JOptionPane.showMessageDialog(this.applFrame, "Cannot delete. Tree node data is not defined.", "", 0);
            return;
        }
        if (!treeItemString.equals("")) {
            if (treeItemString.equals("GraGra")) {
                if (sd.isGraGra()) {
                    this.deleteGraGra(aNode, this.selPath, true);
                    this.resetEnabledOfFileMenuItems("deleteGraGra");
                    this.filePopupMenu.resetEnabledOfFileMenuItems("deleteGraGra");
                    this.resetEnabledOfToolBarItems("deleteGraGra");
                    if (this.tree.getRowCount() == 1) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, 11));
                    }
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a grammar.", "", 2);
                }
            } else if (treeItemString.equals("TypeGraph")) {
                if (sd.isTypeGraph()) {
                    this.deleteTypeGraph(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a type graph.", "", 2);
                }
            } else if (treeItemString.equals("Graph")) {
                if (sd.isGraph() && !sd.isTypeGraph()) {
                    this.deleteGraph(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a graph.", "", 2);
                }
            } else if (treeItemString.equals("Rule")) {
                if (sd.isRule()) {
                    if (sd.isMultiRule()) {
                        this.deleteMultiRule(aNode, true);
                    } else if (sd.isAmalgamatedRule()) {
                        this.deleteAmalgamatedRule(aNode, false);
                    } else {
                        this.deleteRule(aNode, this.selPath, true);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a rule.", "", 2);
                }
            } else if (treeItemString.equals("NAC")) {
                if (sd.isNAC()) {
                    this.deleteNAC(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a NAC.", "", 2);
                }
            } else if (treeItemString.equals("PAC")) {
                if (sd.isPAC()) {
                    this.deletePAC(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a PAC.", "", 2);
                }
            } else if (treeItemString.equals("NestedAC")) {
                if (sd.isNestedAC()) {
                    this.deleteNestedAC(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a (Nested) Application Condition.", "", 2);
                }
            } else if (treeItemString.equals("Atomic")) {
                if (sd.isAtomic()) {
                    this.deleteAtomic(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlase select an atomic graph constraint.", "", 2);
                }
            } else if (treeItemString.equals("Conclusion")) {
                if (sd.isConclusion()) {
                    this.deleteConclusion(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection,\nPlease select a conclusion.", "", 2);
                }
            } else if (treeItemString.equals("Constraint")) {
                if (sd.isConstraint()) {
                    this.deleteConstraint(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a constraint.", "", 2);
                }
            } else if (treeItemString.equals("RuleConstraint")) {
                if (sd.isRuleConstraint()) {
                    this.deleteRuleConstraint(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a rule post application constraint.", "", 2);
                }
            } else if (treeItemString.equals("AtomApplCond")) {
                if (sd.isAtomApplCond()) {
                    this.deleteAtomApplCond(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a rule atomic post application condition.", "", 2);
                }
            } else if (treeItemString.equals("RuleConstraints")) {
                if (sd.isRule()) {
                    this.deleteRuleConstraints(aNode, this.selPath, true);
                } else {
                    JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\nPlease select a rule.", "", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "Bad selection for deletion.", "", 2);
            }
        } else {
            this.deleteTreeNode(aNode, this.selPath, false);
        }
    }

    protected void deleteTreeNode(DefaultMutableTreeNode aNode, TreePath path, boolean withWarning) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd != null) {
            if (sd.isGraGra()) {
                this.deleteGraGra(aNode, path, withWarning);
            } else if (sd.isTypeGraph()) {
                this.deleteTypeGraph(aNode, path, withWarning);
            } else if (sd.isGraph() && !sd.isTypeGraph()) {
                this.deleteGraph(aNode, path, withWarning);
            } else if (sd.isRuleScheme()) {
                new GrammarTreeNode().deleteRuleScheme(this, aNode, path, withWarning);
            } else if (sd.isRule()) {
                this.deleteRule(aNode, path, withWarning);
            } else if (sd.isNAC()) {
                this.deleteNAC(aNode, path, withWarning);
            } else if (sd.isPAC()) {
                this.deletePAC(aNode, path, withWarning);
            } else if (sd.isNestedAC()) {
                this.deleteNestedAC(aNode, path, withWarning);
            } else if (sd.isAtomic()) {
                this.deleteAtomic(aNode, path, withWarning);
            } else if (sd.isConclusion()) {
                this.deleteConclusion(aNode, path, withWarning);
            } else if (sd.isConstraint()) {
                this.deleteConstraint(aNode, path, withWarning);
            } else if (sd.isRuleSequence()) {
                this.deleteRuleSequence(aNode, path, withWarning);
            } else if (sd.isRuleConstraint()) {
                this.deleteRuleConstraint(aNode, path, withWarning);
            } else if (sd.isAtomApplCond()) {
                this.deleteAtomApplCond(aNode, path, withWarning);
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "Bad selection for deletion.", "", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection for deletion.", "", 2);
        }
    }

    private int cpaGraGraWarning(String action) {
        Object[] options = new Object[]{action, "CANCEL"};
        String act = action.toLowerCase();
        int answer = JOptionPane.showOptionDialog(this.applFrame, "This grammar is currently used by CPA.\nAlready computed critical pairs will be lost.\nDo you want to " + act + " the grammar really?", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private void deleteGraGra(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)delNode.getUserObject();
        if (sd.getGraGra() != this.currentGraGra) {
            if (sd.getGraGra().isChanged() && this.changedGraGraWarning("CLOSE") != 0) {
                return;
            }
            if (((AGGAppl)this.applFrame).getCPA().getGraGra() == sd.getGraGra() && !((AGGAppl)this.applFrame).getCPA().isEmpty() && withWarning && this.cpaGraGraWarning("CLOSE") != 0) {
                return;
            }
            this.gragraStore.removeGraGra(sd.getGraGra());
            this.treeModel.removeNodeFromParent(delNode);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
            EdGraGra gra = sd.getGraGra();
            this.deleteGraGraSubtree(delNode);
            gra.dispose();
            path = null;
        } else if (!((AGGAppl)this.applFrame).getGraGraEditor().isTransformationRunning()) {
            if (this.currentGraGra.isChanged() && withWarning && this.changedGraGraWarning("CLOSE") != 0) {
                return;
            }
            if (((AGGAppl)this.applFrame).getCPA().getGraGra() == this.currentGraGra && ((AGGAppl)this.applFrame).getCPA().getGraGra() == sd.getGraGra() && !((AGGAppl)this.applFrame).getCPA().isEmpty() && withWarning && this.cpaGraGraWarning("CLOSE") != 0) {
                return;
            }
            this.gragraStore.removeGraGra(this.currentGraGra);
            this.treeModel.removeNodeFromParent(delNode);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
            this.deleteGraGraSubtree(delNode);
            this.currentGraGra.dispose();
            this.selPath = null;
            this.currentGraGra = null;
            this.currentGraph = null;
            this.currentRule = null;
            this.currentNAC = null;
            this.currentPAC = null;
            this.currentNestedAC = null;
            this.currentAtomic = null;
            this.currentConstraint = null;
            this.currentRuleConstraint = null;
            this.currentAtomApplCond = null;
        } else if (withWarning) {
            JOptionPane.showMessageDialog(this.applFrame, "Please complete the graph transformation before to close the grammar.", "", 0);
        }
        System.gc();
    }

    private void deleteGraGraSubtree(DefaultMutableTreeNode delNode) {
        ((GraGraTreeNodeData)delNode.getUserObject()).dispose();
        delNode.setUserObject(null);
        int i = 0;
        while (i < delNode.getChildCount()) {
            DefaultMutableTreeNode ch = (DefaultMutableTreeNode)delNode.getChildAt(i);
            GraGraTreeNodeData sdch = (GraGraTreeNodeData)ch.getUserObject();
            ch.setUserObject(null);
            sdch.dispose();
            ++i;
        }
        delNode.removeAllChildren();
    }

    public void deleteGraph(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        this.selPath = new GrammarTreeNode().deleteGraph(this, delNode, path, withWarning);
    }

    public void setEditPath(int aRow) {
        int row = aRow;
        if (row < 0) {
            row = 0;
        }
        this.tree.setSelectionRow(row);
        this.tree.treeDidChange();
        this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        if (this.selPath != null) {
            this.editorPath = this.selPath;
            this.setCurrentData(this.editorPath);
        }
    }

    public void deleteTypeGraph(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        this.selPath = new GrammarTreeNode().deleteTypeGraph(this, delNode, path, withWarning);
    }

    private void deleteRule(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        this.selPath = new GrammarTreeNode().deleteRule(this, delNode, path, withWarning);
    }

    private void deleteMultiRule(DefaultMutableTreeNode delNode, boolean withWarning) {
        this.selPath = new RuleSchemeTreeNode().deleteMultiRule(this, delNode, this.selPath, withWarning);
    }

    private void deleteAmalgamatedRule(DefaultMutableTreeNode delNode, boolean withWarning) {
        this.selPath = new RuleSchemeTreeNode().deleteAmalgamatedRule(this, delNode, this.selPath, withWarning);
    }

    public void deleteRuleSequence(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        this.selPath = new GrammarTreeNode().deleteRuleSequence(this, delNode, path, withWarning);
    }

    private void deleteAtomic(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select an Atomic Graph Constraint.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = path.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getAtomic() == this.currentAtomic && path == this.tree.getSelectionPath()) {
                int answer;
                int row = this.tree.getRowForPath(path);
                int n = answer = withWarning ? this.removeCurrentObjectWarning("Atomic") : 0;
                if (answer == 0) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    this.handleRuleConstraints(graNode, false, this.currentAtomic);
                    this.treeModel.removeNodeFromParent(delNode);
                    if (graData.isGraGra()) {
                        this.gragraStore.storeAtomConstraint(graData.getGraGra(), data.getAtomic());
                        graData.getGraGra().removeAtomic(data.getAtomic());
                    }
                    this.setEditPath(--row);
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            } else {
                int answer;
                int n = answer = withWarning ? this.removeWarning("Atomic") : 0;
                if (answer == 0) {
                    int row = this.tree.getRowForPath(path);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    this.handleRuleConstraints(graNode, false, this.currentAtomic);
                    this.treeModel.removeNodeFromParent(delNode);
                    if (graData.isGraGra()) {
                        this.gragraStore.storeAtomConstraint(graData.getGraGra(), data.getAtomic());
                        graData.getGraGra().removeAtomic(data.getAtomic());
                    }
                    this.setEditPath(--row);
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    private void deleteConclusion(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select a conclusion.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath atomicPath = this.selPath.getParentPath();
        if (atomicPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)atomicPath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode atomicNode = (DefaultMutableTreeNode)atomicPath.getLastPathComponent();
            GraGraTreeNodeData atomicData = (GraGraTreeNodeData)atomicNode.getUserObject();
            if (data.getConclusion().getParent().getConclusions().size() > 1) {
                if (withWarning && data.getConclusion().isParent()) {
                    JOptionPane.showMessageDialog(this.applFrame, "Sorry, cannot delete the first conclusion.", "", 0);
                    return;
                }
                if (data.getConclusion() == this.currentConclusion && path == this.tree.getSelectionPath()) {
                    int answer;
                    int row = this.tree.getRowForPath(path);
                    int n = answer = withWarning ? this.removeCurrentObjectWarning("Conclusion") : 0;
                    if (answer == 0) {
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                        this.handleRuleConstraints(graNode, false, atomicData.getAtomic());
                        this.treeModel.removeNodeFromParent(delNode);
                        this.gragraStore.storeAtomConclusion(data.getConclusion().getParent(), data.getConclusion());
                        atomicData.getAtomic().removeConclusion(data.getConclusion());
                        this.setEditPath(--row);
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                    }
                } else {
                    int answer;
                    int n = answer = withWarning ? this.removeWarning("Conclusion") : 0;
                    if (answer == 0) {
                        int row = this.tree.getRowForPath(path);
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                        this.handleRuleConstraints(graNode, false, atomicData.getAtomic());
                        this.treeModel.removeNodeFromParent(delNode);
                        this.gragraStore.storeAtomConclusion(data.getConclusion().getParent(), data.getConclusion());
                        atomicData.getAtomic().removeConclusion(data.getConclusion());
                        this.setEditPath(--row);
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot delete. At least one conclusion should exist.", "", 0);
                return;
            }
        }
    }

    private void deleteConstraint(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select a consistency constraint.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = this.selPath.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getConstraint() != this.currentConstraint) {
                int answer;
                int n = answer = withWarning ? this.removeWarning("Constraint") : 0;
                if (answer == 0) {
                    int row = this.tree.getRowForPath(path);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    this.handleRuleConstraints(graNode, false, data.getConstraint());
                    this.treeModel.removeNodeFromParent(delNode);
                    this.gragraStore.storeConstraint(graData.getGraGra(), data.getConstraint());
                    graData.getGraGra().removeConstraint(data.getConstraint());
                    this.setEditPath(--row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            } else {
                int answer;
                int row = this.tree.getRowForPath(path);
                int n = answer = withWarning ? this.removeCurrentObjectWarning("Constraint") : 0;
                if (answer == 0) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    this.handleRuleConstraints(graNode, false, data.getConstraint());
                    this.treeModel.removeNodeFromParent(delNode);
                    this.gragraStore.storeConstraint(graData.getGraGra(), data.getConstraint());
                    graData.getGraGra().removeConstraint(data.getConstraint());
                    this.setEditPath(--row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    public void deleteRuleConstraint(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule constraint.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath rulePath = path.getParentPath();
        if (rulePath != null) {
            if (!data.isRuleConstraint()) {
                String s = "Bad selection.\n Please select a rule constraint.";
                JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
                return;
            }
            if (data.getRuleConstraint() != null) {
                EdRuleConstraint ruleConstr = data.getRuleConstraint();
                DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
                GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
                if (ruleConstr != this.currentRuleConstraint) {
                    int row = this.tree.getRowForPath(path);
                    this.treeModel.removeNodeFromParent(delNode);
                    ruleData.getRule().getBasisRule().removeConstraint(ruleConstr.getConstraint());
                    ruleData.getRule().getGraGra().setChanged(true);
                    this.setEditPath(--row);
                    this.setFlagForNew();
                } else {
                    int row = this.tree.getRowForPath(path);
                    this.treeModel.removeNodeFromParent(delNode);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    ruleData.getRule().getBasisRule().removeConstraint(ruleConstr.getConstraint());
                    ruleData.getRule().getGraGra().setChanged(true);
                    this.setEditPath(--row);
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    public void deleteAtomApplCond(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select an atomic application condition.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        if (!data.isAtomApplCond()) {
            String s = "Bad selection.\n Please select an atomic application condition.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        if (data.getAtomApplCond() != null) {
            EdAtomApplCond aac = data.getAtomApplCond();
            TreeNode parent = delNode.getParent();
            if (parent.getChildCount() == 1) {
                return;
            }
            TreePath rulePath = path.getParentPath().getParentPath();
            DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (aac != this.currentAtomApplCond) {
                int row = this.tree.getRowForPath(path);
                this.treeModel.removeNodeFromParent(delNode);
                ruleData.getRule().getBasisRule().removeAtomApplCond(aac.getAtomApplCond());
                this.setEditPath(--row);
            } else {
                int row = this.tree.getRowForPath(path);
                this.treeModel.removeNodeFromParent(delNode);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                ruleData.getRule().getBasisRule().removeAtomApplCond(aac.getAtomApplCond());
                this.currentAtomApplCond = null;
                this.setEditPath(--row);
            }
        }
    }

    public void deleteRuleConstraints(DefaultMutableTreeNode ruleNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        TreePath rulePath = path.getParentPath();
        if (rulePath != null) {
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (!ruleData.isRule()) {
                String s = "Bad selection.\n Please select a rule.";
                JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
                return;
            }
            if (ruleData.getRule().getBasisRule().getAtomApplConds().size() != 0) {
                int i = 0;
                while (i < ruleNode.getChildCount()) {
                    DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)ruleNode.getChildAt(i);
                    GraGraTreeNodeData delData = (GraGraTreeNodeData)delNode.getUserObject();
                    if (delData.isRuleConstraint()) {
                        this.treeModel.removeNodeFromParent(delNode);
                        continue;
                    }
                    ++i;
                }
                ruleData.getRule().getBasisRule().removeApplConditions();
                ruleData.getRule().getGraGra().setChanged(true);
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
                int row = this.tree.getRowForPath(path);
                this.setEditPath(row);
                this.setFlagForNew();
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
            }
        }
    }

    private void deleteNAC(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select a NAC.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath rulePath = path.getParentPath();
        if (rulePath != null) {
            DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (data.getNAC() != this.currentNAC) {
                int answer;
                int n = answer = withWarning ? this.removeWarning("NAC") : 0;
                if (answer == 0) {
                    this.treeModel.removeNodeFromParent(delNode);
                    EdNAC nac = data.getNAC();
                    this.gragraStore.storeNAC(nac.getRule(), nac);
                    ruleData.getRule().removeNAC(nac);
                    path = this.tree.getSelectionPath();
                    this.tree.setSelectionPath(path);
                    this.setEditPath(this.tree.getRowForPath(path));
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            } else {
                int answer;
                int row = this.tree.getRowForPath(path);
                int n = answer = withWarning ? this.removeCurrentObjectWarning("NAC") : 0;
                if (answer == 0) {
                    this.treeModel.removeNodeFromParent(delNode);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    EdNAC nac = data.getNAC();
                    this.gragraStore.storeNAC(nac.getRule(), nac);
                    ruleData.getRule().removeNAC(nac);
                    this.setEditPath(--row);
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    private void deletePAC(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select a PAC.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath rulePath = path.getParentPath();
        if (rulePath != null) {
            DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (data.getPAC() != this.currentPAC) {
                int answer;
                int n = answer = withWarning ? this.removeWarning("PAC") : 0;
                if (answer == 0) {
                    this.treeModel.removeNodeFromParent(delNode);
                    EdPAC pac = data.getPAC();
                    this.gragraStore.storePAC(pac.getRule(), pac);
                    ruleData.getRule().removePAC(pac);
                    path = this.tree.getSelectionPath();
                    this.setEditPath(this.tree.getRowForPath(path));
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            } else {
                int answer;
                int row = this.tree.getRowForPath(path);
                int n = answer = withWarning ? this.removeCurrentObjectWarning("PAC") : 0;
                if (answer == 0) {
                    this.treeModel.removeNodeFromParent(delNode);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, path));
                    EdPAC pac = data.getPAC();
                    this.gragraStore.storePAC(pac.getRule(), pac);
                    ruleData.getRule().removePAC(pac);
                    this.setEditPath(--row);
                    this.setFlagForNew();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    private void deleteNestedAC(DefaultMutableTreeNode delNode, TreePath path, boolean withWarning) {
        if (path == null) {
            String s = "Bad selection.\n Please select a (Nested) Application Condition.";
            JOptionPane.showMessageDialog(this.applFrame, s, "", 2);
            return;
        }
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath parentPath = this.selPath.getParentPath();
        if (parentPath != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
            GraGraTreeNodeData parentData = (GraGraTreeNodeData)parentNode.getUserObject();
            boolean candelete = false;
            if (data.getNestedAC() == this.currentNestedAC) {
                int answer;
                int n = answer = withWarning ? this.removeCurrentObjectWarning("(Nested) Application Condition") : 0;
                if (answer == 0 && delNode.getParent() != null) {
                    this.treeModel.removeNodeFromParent(delNode);
                    candelete = true;
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, this.selPath));
                }
            }
            if (candelete) {
                EdNestedApplCond ac = data.getNestedAC();
                if (parentData.isRule()) {
                    this.gragraStore.storeNestedAC(ac.getRule(), ac);
                } else if (parentData.isNestedAC()) {
                    this.gragraStore.storeNestedAC(ac.getParent(), ac);
                }
                GraGraTreeNodeData firstChildData = null;
                if (parentData.getTreeNode().getChildCount() > 0) {
                    firstChildData = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentData.getTreeNode().getFirstChild()).getUserObject();
                }
                if (parentData.isRule()) {
                    parentData.getRule().removeNestedAC(ac);
                } else if (parentData.isNestedAC()) {
                    parentData.getNestedAC().removeNestedAC(ac);
                }
                if (firstChildData != null && firstChildData.isApplFormula()) {
                    this.treeModel.removeNodeFromParent(firstChildData.getTreeNode());
                }
                if (parentData.isRule()) {
                    parentData.getRule().getBasisRule().setFormula("true");
                } else if (parentData.isNestedAC()) {
                    parentData.getNestedAC().getNestedMorphism().setFormula("true");
                }
                this.tree.treeDidChange();
                this.selectPath(parentPath);
            }
        }
    }

    public void removeRuleConstraints(DefaultMutableTreeNode rnode, Object objToCheck) {
        boolean again;
        GraGraTreeNodeData sd = (GraGraTreeNodeData)rnode.getUserObject();
        if (!sd.isRule() || sd.getRule().getBasisRule().getAtomApplConds().size() == 0) {
            return;
        }
        if (objToCheck != null) {
            if (objToCheck instanceof EdAtomic) {
                EdAtomic parAtom = ((EdAtomic)objToCheck).getParent();
                if (parAtom != null) {
                    if (!sd.getRule().getBasisRule().getUsedAtomics().contains(parAtom.getBasisAtomic())) {
                        return;
                    }
                } else {
                    AtomConstraint atomic = ((EdAtomic)objToCheck).getBasisAtomic();
                    if (!sd.getRule().getBasisRule().getUsedAtomics().contains(atomic)) {
                        return;
                    }
                }
            } else if (objToCheck instanceof EdConstraint) {
                boolean used = false;
                Vector<Formula> formulas = sd.getRule().getBasisRule().getUsedFormulas();
                int i = 0;
                while (i < formulas.size()) {
                    Formula f = formulas.get(i);
                    if (f.compareTo(((EdConstraint)objToCheck).getBasisConstraint())) {
                        used = true;
                        break;
                    }
                    ++i;
                }
                if (!used) {
                    return;
                }
            }
        }
        TreePath path = new TreePath(rnode.getPath());
        this.tree.collapsePath(path);
        block1: do {
            Enumeration<TreeNode> en = rnode.children();
            again = false;
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                GraGraTreeNodeData cdata = (GraGraTreeNodeData)child.getUserObject();
                if (!cdata.isRuleConstraint()) continue;
                again = true;
                child.removeAllChildren();
                this.treeModel.removeNodeFromParent(child);
                continue block1;
            }
        } while (again);
        this.tree.expandPath(path);
    }

    public void addRuleConstraints(DefaultMutableTreeNode rnode, Object objToCheck) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)rnode.getUserObject();
        if (!sd.isRule()) {
            return;
        }
        EdRule er = sd.getRule();
        if (er.getGraGra().isEditable()) {
            TreePath path = new TreePath(rnode.getPath());
            if (sd.getRule().getBasisRule().getAtomApplConds().size() == 0) {
                return;
            }
            if (objToCheck != null && objToCheck instanceof EdAtomic) {
                EdAtomic parAtom = (EdAtomic)objToCheck;
                if (!sd.getRule().getBasisRule().getUsedAtomics().contains(parAtom.getBasisAtomic())) {
                    return;
                }
            }
            this.tree.collapsePath(path);
            Vector<EvalSet> atoms = er.getBasisRule().getAtomApplConds();
            Vector<String> names = er.getBasisRule().getConstraintNames();
            int i = 0;
            while (i < atoms.size()) {
                EvalSet es = atoms.get(i);
                String name = "PAC_" + names.get(i);
                EdRuleConstraint rc = new EdRuleConstraint(name, er, es);
                RuleApplConstraintTreeNodeData subsd = new RuleApplConstraintTreeNodeData(rc);
                subsd.setString(name);
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(subsd);
                subsd.setTreeNode(child);
                boolean parentAdded = false;
                int j = 0;
                while (j < es.getSet().size()) {
                    Vector<Object> set = ((EvalSet)es.getSet().get(j)).getSet();
                    if (set.size() == 0) break;
                    if (!parentAdded) {
                        this.treeModel.insertNodeInto(child, rnode, rnode.getChildCount());
                        parentAdded = true;
                    }
                    int k = 0;
                    while (k < set.size()) {
                        AtomApplCond cond = (AtomApplCond)set.elementAt(k);
                        String condName = cond.getSourceAtomConstraint().getName();
                        String n = String.valueOf(k + j * set.size() + 1) + "_" + condName;
                        EdAtomApplCond aac = new EdAtomApplCond(n, er, cond);
                        RuleAtomicApplConstraintTreeNodeData conddata = new RuleAtomicApplConstraintTreeNodeData(aac);
                        conddata.setString(n);
                        DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                        conddata.setTreeNode(condchild);
                        this.treeModel.insertNodeInto(condchild, child, child.getChildCount());
                        int l = 0;
                        while (l < cond.getEquivalents().size()) {
                            AtomApplCond eq = cond.getEquivalents().elementAt(l);
                            String eqn = String.valueOf(n) + "_Eq" + l;
                            EdAtomApplCond aacEq = new EdAtomApplCond(eqn, er, eq);
                            RuleAtomicApplConstraintTreeNodeData eqdata = new RuleAtomicApplConstraintTreeNodeData(aacEq);
                            eqdata.setString(eqn);
                            DefaultMutableTreeNode eqchild = new DefaultMutableTreeNode(eqdata);
                            eqdata.setTreeNode(eqchild);
                            this.treeModel.insertNodeInto(eqchild, child, child.getChildCount());
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.tree.expandPath(path);
        } else {
            this.lockWarning();
        }
    }

    public void handleRuleConstraints(DefaultMutableTreeNode node, boolean insert, Object objToCheck) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isGraGra()) {
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (!csd.isRule()) continue;
                if (insert) {
                    this.addRuleConstraints(child, objToCheck);
                    continue;
                }
                this.removeRuleConstraints(child, objToCheck);
            }
        } else if (sd.isRule()) {
            if (insert) {
                this.addRuleConstraints(node, objToCheck);
            } else {
                this.removeRuleConstraints(node, objToCheck);
            }
        }
    }

    @Override
    public void loadEventOccurred(LoadEvent e) {
    }

    public void loadGraGra() {
        this.loadGraGra(null);
        AGGAppl.hideFileLoadLogo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGraGra(String fullFileName) {
        JTree jTree = this.tree;
        synchronized (jTree) {
            this.fireTreeViewEvent(new TreeViewEvent(this, 2));
            EdGraGra loadedGraGra = null;
            if (fullFileName != null) {
                AGGAppl.showFileLoadLogo();
                File f = new File(fullFileName);
                if (f.exists()) {
                    long time0 = System.currentTimeMillis();
                    XMLHelper h = new XMLHelper();
                    if (h.read_from_xml(fullFileName)) {
                        GraGra bgra = BaseFactory.theFactory().createGraGra();
                        h.getTopObject(bgra);
                        System.out.println("(Base) Grammar  <" + bgra.getName() + ">  loaded in  " + (System.currentTimeMillis() - time0) + "ms");
                        loadedGraGra = new EdGraGra(bgra);
                        if (f.getParent() != null) {
                            loadedGraGra.setDirName(f.getParent());
                        } else {
                            loadedGraGra.setDirName(String.valueOf(System.getProperty("user.dir")) + File.separator);
                        }
                        loadedGraGra.setFileName(f.getName());
                        loadedGraGra.getTypeSet().setResourcesPath(loadedGraGra.getDirName());
                        h.enrichObject(loadedGraGra);
                        System.out.println("(Layouted) Grammar loaded in  " + (System.currentTimeMillis() - time0) + "ms");
                        if (bgra.getRulesVec().size() > 20) {
                            System.out.println("Grammar contains Rules: " + bgra.getRulesVec().size());
                        }
                    }
                }
            } else {
                long time0 = System.currentTimeMillis();
                this.gragraLoad.setDirName(this.directory);
                this.gragraLoad.load();
                if (this.gragraLoad.getGraGra() != null) {
                    loadedGraGra = this.gragraLoad.getGraGra();
                    System.out.println("(Layouted) Grammar loaded in  " + (System.currentTimeMillis() - time0) + "ms");
                    if (loadedGraGra.getRules().size() > 100) {
                        System.out.println("Grammar contains Rules: " + loadedGraGra.getRules().size());
                    }
                }
            }
            if (loadedGraGra != null) {
                BaseFactory.theFactory().notify(loadedGraGra.getBasisGraGra());
                GrammarTreeNode grammarTreeNode = new GrammarTreeNode(loadedGraGra);
                int graIndex = grammarTreeNode.insertIntoTree(this);
                this.propagateGraGraToEditor(graIndex);
                loadedGraGra.setChanged(false);
                this.fireTreeViewEvent(new TreeViewEvent(this, 4));
                if (this.currentGraGra.getGraTraOptions().contains("layered")) {
                    this.layered = true;
                    this.priority = false;
                    this.ruleSequence = false;
                    this.treeModel.ruleNameChanged(this.currentGraGra, this.layered);
                    this.treeModel.constraintNameChanged(this.currentGraGra, this.layered);
                } else if (this.currentGraGra.getGraTraOptions().contains("priority")) {
                    this.layered = false;
                    this.priority = true;
                    this.ruleSequence = false;
                    this.treeModel.ruleNameChanged(this.currentGraGra, this.layered, this.priority);
                    this.treeModel.constraintNameChanged(this.currentGraGra, this.layered, this.priority);
                } else if (this.currentGraGra.getGraTraOptions().contains("ruleSequence")) {
                    this.ruleSequence = true;
                    this.ruleSequenceHidden = false;
                    this.layered = false;
                    this.priority = false;
                } else {
                    this.layered = false;
                    this.priority = false;
                    this.ruleSequence = false;
                }
                this.directory = this.gragraLoad.getDirName();
                this.resetEnabledOfFileMenuItems("open");
                this.filePopupMenu.resetEnabledOfFileMenuItems("open");
                this.resetEnabledOfToolBarItems("open");
            } else if (!this.gragraLoad.isCanceled()) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Cannot load the grammar.<br>Please check the .ggx file.</body></html>", "  GraGra load failed", 0);
            }
        }
    }

    public void loadBaseGraGra() {
        this.loadBaseGrammar();
        AGGAppl.hideFileLoadLogo();
    }

    protected void loadBaseGrammar() {
        this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        this.gragraLoad.loadBase();
        if (this.gragraLoad.getBaseGraGra() != null) {
            GraGra loadedBasis = this.gragraLoad.getBaseGraGra();
            BaseFactory.theFactory().notify(loadedBasis);
            EdGraGra loadedGraGra = new EdGraGra(loadedBasis);
            loadedGraGra.setDirName(this.gragraLoad.getDirName());
            loadedGraGra.setFileName(this.gragraLoad.getFileName());
            loadedGraGra.makeLayoutOfBasisGraphs();
            GrammarTreeNode grammarTreeNode = new GrammarTreeNode(loadedGraGra);
            int graIndex = grammarTreeNode.insertIntoTree(this);
            this.propagateGraGraToEditor(graIndex);
            if (this.currentGraGra.getGraTraOptions().contains("layered")) {
                this.treeModel.ruleNameChanged(this.currentGraGra, true);
            }
            this.resetEnabledOfFileMenuItems("open");
            this.filePopupMenu.resetEnabledOfFileMenuItems("open");
            this.resetEnabledOfToolBarItems("open");
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
        } else {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        }
    }

    public void doExpand(EdGraGra gragra, int graIndex) {
        if (!this.tree.isExpanded(this.tree.getPathForRow(graIndex))) {
            this.tree.expandPath(this.tree.getPathForRow(graIndex));
        }
    }

    private void propagateGraGraToEditor(int graIndex) {
        this.tree.setSelectionRow(graIndex);
        this.tree.treeDidChange();
        this.editorPath = this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        this.setCurrentData(this.editorPath);
        this.setFlagForNew();
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
    }

    public void reloadGraGra() {
        if (this.applFrame instanceof AGGAppl && ((AGGAppl)this.applFrame).getGraGraEditor().isTransformationRunning() && ((AGGAppl)this.applFrame).getGraGraEditor().getGraGra() == this.currentGraGra) {
            JOptionPane.showMessageDialog(this.applFrame, "Graph Transformation running!\nCannot reload the grammar used currently.", "Cannot reload", 0);
        } else {
            this.reloadCurrentGraGra();
            AGGAppl.hideFileLoadLogo();
        }
    }

    protected void reloadCurrentGraGra() {
        int answer;
        EdGraGra gra = this.currentGraGra;
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (((GraGraTreeNodeData)aNode.getUserObject()).isGraGra() && gra != ((GraGraTreeNodeData)aNode.getUserObject()).getGraGra()) {
            gra = ((GraGraTreeNodeData)aNode.getUserObject()).getGraGra();
        }
        if (gra.getFileName().equals("")) {
            JOptionPane.showMessageDialog(this.applFrame, "Please save the grammar first.", "", 2);
            return;
        }
        if (gra == this.currentGraGra) {
            this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        }
        if (gra.isChanged() && (answer = this.changedGraGraWarning("RELOAD")) == 1) {
            return;
        }
        EdGraGra gragra = new GrammarTreeNode().reloadCurrentGraGra(this, this.selPath, this.gragraLoad, gra);
        if (gragra != null) {
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
            this.selectPath(this.selPath);
            gra.dispose();
        }
    }

    public void synchronizeGraGraRuleView(GraGra grammar) {
        if (this.currentGraGra != null && this.currentGraGra.getBasisGraGra() == grammar) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
            if (data.isGraGra()) {
                this.updateGraGraRuleData(node);
                this.tree.treeDidChange();
            } else {
                node = (DefaultMutableTreeNode)this.selPath.getParentPath().getLastPathComponent();
                data = (GraGraTreeNodeData)node.getUserObject();
                if (data.isGraGra()) {
                    this.updateGraGraRuleData(node);
                    this.tree.treeDidChange();
                }
            }
        } else {
            DefaultMutableTreeNode node = this.getTreeNodeOfGrammar(grammar);
            if (node != null) {
                this.updateGraGraRuleData(node);
                this.tree.treeDidChange();
            }
        }
    }

    private void updateGraGraRuleData(DefaultMutableTreeNode graNode) {
        EdGraGra gragra = ((GraGraTreeNodeData)graNode.getUserObject()).getGraGra();
        Vector<Rule> preservedRules = new Vector<Rule>();
        int i = 0;
        while (i < graNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)graNode.getChildAt(i);
            GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
            if (data.isRule()) {
                if (gragra.getBasisGraGra().getRule(data.getRule().getBasisRule().getName()) == null) {
                    graNode.remove(i);
                    --i;
                } else {
                    preservedRules.add(data.getRule().getBasisRule());
                }
            }
            ++i;
        }
        GrammarTreeNode gtn = new GrammarTreeNode();
        int i2 = 0;
        while (i2 < gragra.getBasisGraGra().getListOfRules().size()) {
            Rule r = gragra.getBasisGraGra().getListOfRules().get(i2);
            if (!preservedRules.contains(r) && gragra.addRule(new EdRule(r))) {
                EdRule er = gragra.getRules().lastElement();
                gtn.insertRuleIntoTree(this, graNode, er);
            }
            ++i2;
        }
    }

    public TreePath getTreePathOfGrammar(Object elem) {
        int i = 0;
        while (i < this.tree.getRowCount()) {
            TreePath path = this.tree.getPathForRow(i);
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (data.isGraGra() && (elem == data.getData() || elem == ((EdGraGra)data.getData()).getBasisGraGra())) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public TreePath getTreePathOfGrammarElement(Object elem) {
        int i = 0;
        while (i < this.tree.getRowCount()) {
            TreePath path = this.tree.getPathForRow(i);
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (elem == data.getData()) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public DefaultMutableTreeNode getTreeNodeOfGrammarElement(Object elem) {
        int i = 0;
        while (i < this.tree.getRowCount()) {
            TreePath path = this.tree.getPathForRow(i);
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)path.getLastPathComponent();
            GraGraTreeNodeData data = (GraGraTreeNodeData)treenode.getUserObject();
            if (elem == data.getData()) {
                return treenode;
            }
            ++i;
        }
        return null;
    }

    public DefaultMutableTreeNode getTreeNodeOfGrammar(GraGra grammar) {
        int i = 0;
        while (i < this.top.getChildCount()) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.top.getChildAt(i);
            GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
            if (sd.getGraGra().getBasisGraGra() == grammar) {
                return graNode;
            }
            ++i;
        }
        return null;
    }

    public DefaultMutableTreeNode getTreeNodeOfRule(EdRule rule) {
        int i = 0;
        while (i < this.top.getChildCount()) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.top.getChildAt(i);
            int j = 0;
            while (j < graNode.getChildCount()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)graNode.getChildAt(j);
                GraGraTreeNodeData sd = (GraGraTreeNodeData)child.getUserObject();
                if (sd.isRule() && sd.getRule() == rule) {
                    return child;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private DefaultMutableTreeNode getTreeNodeOfAtomicConclusion(EdAtomic conclusion) {
        int i = 0;
        while (i < this.top.getChildCount()) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.top.getChildAt(i);
            int j = 0;
            while (j < graNode.getChildCount()) {
                DefaultMutableTreeNode grachild = (DefaultMutableTreeNode)graNode.getChildAt(j);
                GraGraTreeNodeData sdj = (GraGraTreeNodeData)grachild.getUserObject();
                if (sdj.isAtomic()) {
                    int k = 0;
                    while (k < grachild.getChildCount()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)grachild.getChildAt(k);
                        GraGraTreeNodeData sdk = (GraGraTreeNodeData)child.getUserObject();
                        if (sdk.isConclusion() && sdk.getConclusion() == conclusion) {
                            return child;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void saveGraGra(EdGraGra gragra) {
        if (gragra != null) {
            gragra.refreshAttrInstances();
            if (gragra.getDirName().equals("")) {
                this.gragraSave.setDirName(this.directory);
            }
            this.gragraSave.setGraGra(gragra, gragra.getDirName(), gragra.getFileName());
            this.gragraSave.save();
        }
    }

    public void saveGraGra() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra != null) {
            selGraGra.refreshAttrInstances();
            new GrammarTreeNode().saveGraGra(this, this.gragraSave, this.directory, selGraGra);
        }
    }

    public void saveAsGraGra() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra != null) {
            selGraGra.refreshAttrInstances();
            new GrammarTreeNode().saveAsGraGra(this, this.gragraSave, this.directory, selGraGra);
        }
    }

    public void saveAsBaseGraGra() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra != null) {
            selGraGra.refreshAttrInstances();
            selGraGra.clear();
            new GrammarTreeNode().saveAsBaseGraGra(this, this.gragraSave, this.directory, selGraGra);
        }
    }

    public String getFileDirectory() {
        return this.directory;
    }

    public void setFileDirectory(String dir) {
        this.directory = dir;
    }

    protected synchronized void resetGraph() {
        this.resetGraph(null);
    }

    public synchronized void resetGraph(EdGraph graph) {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra != null) {
            GraGraTreeNodeData ndata;
            TreePath path;
            this.fireTreeViewEvent(new TreeViewEvent(this, 16));
            GraGraTreeNodeData ndataEdit = (GraGraTreeNodeData)((DefaultMutableTreeNode)this.editorPath.getLastPathComponent()).getUserObject();
            GraGraTreeNodeData ndataSel = (GraGraTreeNodeData)((DefaultMutableTreeNode)this.selPath.getLastPathComponent()).getUserObject();
            if (ndataEdit.isGraph() && ndataSel.isGraph() && ndataEdit.getGraph() == ndataSel.getGraph()) {
                if (selGraGra.resetGraph()) {
                    ndataEdit.setData(selGraGra.getGraph());
                    ndataEdit.setString(selGraGra.getGraph().getName());
                    this.tree.treeDidChange();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 160, this.editorPath));
                }
            } else if (ndataSel.isGraph()) {
                if (ndataSel.getGraph() == selGraGra.getGraph()) {
                    if (selGraGra.resetGraph()) {
                        ndataSel.setData(selGraGra.getGraph());
                        ndataSel.setString(selGraGra.getGraph().getName());
                        this.tree.treeDidChange();
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 160, this.selPath));
                    }
                } else {
                    EdGraph g;
                    int indx = selGraGra.getIndexOfGraph(ndataSel.getGraph());
                    if (selGraGra.resetGraph(indx) && (g = selGraGra.getGraph(indx)) != null) {
                        ndataSel.setData(g);
                        ndataSel.setString(g.getName());
                        this.tree.treeDidChange();
                    }
                }
            } else if (this.currentGraph == selGraGra.getGraph()) {
                GraGraTreeNodeData ndata2;
                TreePath path2 = this.getTreePathOfGrammarElement(this.currentGraph);
                if (path2 != null && (ndata2 = (GraGraTreeNodeData)((DefaultMutableTreeNode)path2.getLastPathComponent()).getUserObject()) != null && selGraGra.resetGraph()) {
                    ndata2.setData(selGraGra.getGraph());
                    ndata2.setString(selGraGra.getGraph().getName());
                    this.currentGraph = selGraGra.getGraph();
                    this.tree.treeDidChange();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 160, path2));
                }
            } else if (graph != null && graph == selGraGra.getGraph() && (path = this.getTreePathOfGrammarElement(graph)) != null && (ndata = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) != null && selGraGra.resetGraph()) {
                ndata.setData(selGraGra.getGraph());
                ndata.setString(selGraGra.getGraph().getName());
                this.currentGraph = selGraGra.getGraph();
                this.tree.treeDidChange();
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 160, path));
            }
        }
    }

    public void exportGraphJPEG() {
        if (this.getGraGra() == null) {
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 23));
    }

    public void exportJPEG() {
        this.saveJPEG();
    }

    public void exportGraGra(String format) {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra == null) {
            return;
        }
        selGraGra.clear();
        String oldDir = selGraGra.getDirName();
        String oldFile = selGraGra.getFileName();
        String tmpn = "tmp_" + selGraGra.getName() + ".ggx";
        String tmpName = tmpn.replaceAll(" ", "");
        this.gragraSave.setGraGra(selGraGra, selGraGra.getDirName(), tmpName);
        this.gragraSave.save();
        File tmpf = new File(String.valueOf(selGraGra.getDirName()) + tmpName);
        tmpf.deleteOnExit();
        ConverterXML converter = new ConverterXML();
        String fn = "";
        String fd = "";
        String filter = "";
        if (format.equals("GXL")) {
            filter = ".gxl";
        } else if (format.equals("GTXL")) {
            filter = ".gtxl";
        } else if (format.endsWith("COLOR_GRAPH")) {
            filter = ".col";
        }
        if (!filter.equals("")) {
            JFileChooser chooser = null;
            chooser = this.directory.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.directory);
            AGGFileFilter fileFilter = null;
            fileFilter = format.endsWith("COLOR_GRAPH") ? new AGGFileFilter(filter, "COLOR_GRAPH Files (" + filter + ")") : new AGGFileFilter(filter, "XML Files (" + filter + ")");
            chooser.addChoosableFileFilter(fileFilter);
            chooser.setFileFilter(fileFilter);
            int value = chooser.showSaveDialog(this.applFrame);
            if (value == 0) {
                fd = chooser.getCurrentDirectory().toString();
                if (chooser.getSelectedFile() != null && !chooser.getSelectedFile().getName().equals("")) {
                    fn = chooser.getSelectedFile().getName();
                }
                if (!fd.endsWith(File.separator)) {
                    fd = String.valueOf(fd) + File.separator;
                }
            }
            if (!fn.equals("")) {
                File source = null;
                if (format.equals("GXL")) {
                    source = converter.copyFile(fd, "ggx2gxl.xsl");
                    if (source != null && converter.ggx2gxl(String.valueOf(selGraGra.getDirName()) + selGraGra.getFileName(), String.valueOf(fd) + fn, String.valueOf(fd) + "ggx2gxl.xsl")) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, 15));
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        JOptionPane.showMessageDialog(this.applFrame, "Export has failed!", "", 2);
                    }
                } else if (format.equals("GTXL")) {
                    source = converter.copyFile(fd, "gts2gtxl.xsl");
                    if (source != null) {
                        source = converter.copyFile(fd, "ggx2gxl.xsl");
                    }
                    if (source != null && converter.gts2gtxl(String.valueOf(selGraGra.getDirName()) + selGraGra.getFileName(), String.valueOf(fd) + fn, String.valueOf(fd) + "gts2gtxl.xsl")) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, 15));
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        JOptionPane.showMessageDialog(this.applFrame, "Export has failed!", "", 2);
                    }
                } else if (format.endsWith("COLOR_GRAPH")) {
                    Type ntype = null;
                    if (this.nodeTypeOfColorGraph != null) {
                        ntype = this.nodeTypeOfColorGraph.getBasisType();
                    }
                    Type etype = null;
                    if (this.edgeTypeOfColorGraph != null) {
                        etype = this.edgeTypeOfColorGraph.getBasisType();
                    }
                    AGG2ColorGraph.exportAGG2ColorGraph(selGraGra.getBasisGraGra(), String.valueOf(fd) + fn, ntype, etype);
                } else {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    JOptionPane.showMessageDialog(this.applFrame, "Export has failed!", "", 2);
                }
            }
        }
        selGraGra.setDirName(oldDir);
        selGraGra.setFileName(oldFile);
    }

    public void importGraGra(String format) {
        this.doImportGraGra(format);
        AGGAppl.hideFileLoadLogo();
    }

    protected synchronized void doImportGraGra(String format) {
        boolean importAsGrammar = true;
        TreePath path = this.selPath;
        GraGraTreeNodeData data = null;
        if (path != null) {
            Object[] options;
            int answer;
            data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra()) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            importAsGrammar = data == null ? true : (format.endsWith("COLOR_GRAPH") ? false : (answer = JOptionPane.showOptionDialog(this.applFrame, "\nPlease choose what do you want to import.", "Import", -1, 3, null, options = new Object[]{"Grammar", "Grammar Component"}, options[0])) == 0);
            if (!importAsGrammar && !format.endsWith("COLOR_GRAPH")) {
                EdGraGra selGraGra = data.getGraGra();
                if (this.editorPath != null && path != this.editorPath) {
                    JOptionPane.showMessageDialog(this.applFrame, "<html><body>Bad selection to import a grammar component.\nPlease select the grammar " + this.currentGraGra.getName() + "." + "\nThe Type Graph should be disabled before.", "", 2);
                    return;
                }
                if (selGraGra.getTypeSet() != null && selGraGra.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() != 0) {
                    JOptionPane.showMessageDialog(this.applFrame, "Cannot import! \nPlease disable the Type Graph first.", "Import Warning", 0);
                    return;
                }
            }
        }
        ConverterXML converter = new ConverterXML();
        String fn = "";
        String fd = "";
        String filter = "";
        if (format.equals("GGX")) {
            filter = ".ggx";
        } else if (format.equals("GXL")) {
            filter = ".gxl";
        } else if (format.equals("GTXL")) {
            filter = ".gtxl";
        } else if (format.equals("OMONDOXMI")) {
            filter = ".ecore";
        } else if (format.endsWith("COLOR_GRAPH")) {
            filter = ".res";
        }
        if (!filter.equals("")) {
            JFileChooser chooser = null;
            chooser = this.directory.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.directory);
            AGGFileFilter filterXML = null;
            filterXML = format.endsWith("COLOR_GRAPH") ? new AGGFileFilter(filter, "COLOR_GRAPH Files (" + filter + ")") : new AGGFileFilter(filter, "XML Files (" + filter + ")");
            chooser.addChoosableFileFilter(filterXML);
            chooser.setFileFilter(filterXML);
            int value = chooser.showOpenDialog(this.applFrame);
            if (value == 0 && chooser.getSelectedFile() != null && !chooser.getSelectedFile().getName().equals("")) {
                this.directory = chooser.getCurrentDirectory().toString();
                fn = chooser.getSelectedFile().getName();
                fd = chooser.getCurrentDirectory().toString();
                if (!fd.endsWith(File.separator)) {
                    fd = String.valueOf(fd) + File.separator;
                }
            }
            if (!fn.equals("")) {
                EdGraGra loadedGraGra;
                String fnOut = "";
                File gxldtd = null;
                File gtsdtd = null;
                File source = null;
                if (!format.equals("GGX")) {
                    String fd1;
                    if (format.equals("GXL")) {
                        fnOut = String.valueOf(fn.substring(0, fn.length() - 4)) + "_gxl.ggx";
                        source = converter.copyFile(fd, "gxl2ggx.xsl");
                        gxldtd = converter.copyFile(fd, "gxl.dtd");
                        fd1 = System.getProperty("user.dir");
                        if (!fd1.endsWith(File.separator)) {
                            fd1 = String.valueOf(fd1) + File.separator;
                        }
                        gtsdtd = converter.copyFile(fd, "gts.dtd");
                        gtsdtd = converter.copyFile(fd1, "gts.dtd");
                        converter.copyFile(fd, "agglayout.dtd");
                        converter.copyFile(fd1, "agglayout.dtd");
                    } else if (format.equals("GTXL")) {
                        fnOut = String.valueOf(fn.substring(0, fn.length() - 4)) + "_gtxl.ggx";
                    } else if (format.equals("OMONDOXMI")) {
                        fnOut = String.valueOf(fn.substring(0, fn.length() - 6)) + "_ecore.ggx";
                        source = converter.copyFile(fd, "gxl2ggx.xsl");
                        gxldtd = converter.copyFile(fd, "gxl.dtd");
                        fd1 = System.getProperty("user.dir");
                        if (!fd1.endsWith(File.separator)) {
                            fd1 = String.valueOf(fd1) + File.separator;
                        }
                        gtsdtd = converter.copyFile(fd, "gts.dtd");
                        gtsdtd = converter.copyFile(fd1, "gts.dtd");
                        converter.copyFile(fd, "agglayout.dtd");
                        converter.copyFile(fd1, "agglayout.dtd");
                        converter.copyFile(fd, "omondoxmi2gxl.xsl");
                    } else if (data != null && format.endsWith("COLOR_GRAPH")) {
                        EdGraGra selGraGra = data.getGraGra();
                        JOptionPane.showMessageDialog(this.applFrame, "Please note:\nColor values from result ColorGraph will be used \nas value of color attributes of the nodes of the current host graph.\nThe color attribute should be of type <int> or <String>", "Import result of ColorGraph", 1);
                        Type ntype = null;
                        if (this.nodeTypeOfColorGraph != null) {
                            ntype = this.nodeTypeOfColorGraph.getBasisType();
                        }
                        Type etype = null;
                        if (this.edgeTypeOfColorGraph != null) {
                            etype = this.edgeTypeOfColorGraph.getBasisType();
                        }
                        if (AGG2ColorGraph.importColorGraph2AGG(selGraGra.getBasisGraGra(), selGraGra.getBasisGraGra().getGraph(), String.valueOf(fd) + fn, ntype, etype)) {
                            this.fireTreeViewEvent(new TreeViewEvent(this, 19));
                        }
                    }
                }
                if (!(format.equals("GGX") || format.endsWith("COLOR_GRAPH") || gxldtd != null && gtsdtd != null)) {
                    JOptionPane.showMessageDialog(this.applFrame, "Import failed!\n File gxl.dtd resp. gts.dtd is not found.", "", 2);
                }
                if (format.equals("GGX")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fn);
                    if (this.gragraLoad.getGraGra() != null) {
                        this.handleLoadedImportGraGra(this.gragraLoad.getGraGra(), this.selPath, importAsGrammar);
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(this.applFrame, "Import GGX file failed!", "", 0);
                    }
                } else if (format.equals("GXL") && converter.gxl2ggx(String.valueOf(fd) + fn, String.valueOf(fd) + fnOut, String.valueOf(fd) + "gxl2ggx.xsl")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fnOut);
                    if (this.gragraLoad.getGraGra() != null) {
                        EdGraGra test = this.gragraLoad.getGraGra();
                        this.handleLoadedImportGraGra(this.gragraLoad.getGraGra(), this.selPath, importAsGrammar);
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(this.applFrame, "Import GXL file failed!", "", 0);
                    }
                } else if (format.equals("GTXL") && converter.gtxl2gts(String.valueOf(fd) + fn, String.valueOf(fd) + fnOut, String.valueOf(fd) + "gtxl2gts.xsl")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fnOut);
                    if (this.gragraLoad.getGraGra() != null) {
                        loadedGraGra = this.gragraLoad.getGraGra();
                        this.gragraSave.setGraGra(loadedGraGra, loadedGraGra.getDirName(), loadedGraGra.getFileName());
                        this.gragraSave.save();
                        loadedGraGra.getBasisGraGra().setGraTraOptions(new Completion_NAC(new Completion_InjCSP()));
                        BaseFactory.theFactory().notify(loadedGraGra.getBasisGraGra());
                        loadedGraGra.update();
                        GrammarTreeNode grammarTreeNode = new GrammarTreeNode(loadedGraGra);
                        int indx = grammarTreeNode.insertIntoTree(this);
                        this.fireTreeViewEvent(new TreeViewEvent(this, 4));
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(this.applFrame, "Import GTXL file failed!", "", 0);
                    }
                } else if (format.equals("OMONDOXMI") && converter.omondoxmi2ggx(String.valueOf(fd) + fn, String.valueOf(fd) + fnOut, String.valueOf(fd) + "omondoxmi2gxl.xsl", String.valueOf(fd) + "gxl2ggx.xsl")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fnOut);
                    if (this.gragraLoad.getGraGra() != null) {
                        loadedGraGra = this.gragraLoad.getGraGra();
                        if (converter.getFileExtOfImport().equals(".ecore")) {
                            loadedGraGra.createTypeGraphFrom(loadedGraGra.getGraph());
                        }
                        this.gragraSave.setGraGra(loadedGraGra, loadedGraGra.getDirName(), loadedGraGra.getFileName());
                        this.gragraSave.save();
                        this.handleLoadedImportGraGra(loadedGraGra, this.selPath, importAsGrammar);
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(this.applFrame, "Import OMONDO XMI ( .ecore ) file failed!", "", 0);
                    }
                } else if (!format.endsWith("COLOR_GRAPH")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    JOptionPane.showMessageDialog(this.applFrame, "Import has failed!", "", 0);
                }
            }
        }
    }

    private synchronized void handleLoadedImportGraGra(EdGraGra importGraGra, TreePath path, boolean importAsGrammar) {
        if (importGraGra != null) {
            Object[] options;
            int answer;
            if (this.currentGraGra == null || importAsGrammar) {
                this.importAsGrammar(importGraGra);
                return;
            }
            boolean impAsTG = false;
            boolean impAsG = false;
            boolean impAsR = false;
            boolean impAsGC = false;
            if (importGraGra.getTypeSet().getTypeGraph() != null && !importGraGra.getTypeSet().getTypeGraph().getBasisGraph().isEmpty()) {
                impAsTG = true;
            }
            if (importGraGra.getGraph() != null) {
                impAsG = true;
            }
            if (!importGraGra.getRules().isEmpty()) {
                impAsR = true;
            }
            if (!importGraGra.getAtomics().isEmpty()) {
                impAsGC = true;
            }
            if (impAsTG && impAsG && impAsR && impAsGC) {
                Object[] options2 = new Object[]{"Type Graph", "Host Graph", "Rule", "Constraints", "All", "Cancel"};
                int answer2 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options2, options2[4]);
                switch (answer2) {
                    case 0: {
                        this.importAsTypeGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 3: {
                        this.importAsGraphConstraints(importGraGra, path);
                        break;
                    }
                    case 4: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsTG && impAsG && impAsR) {
                Object[] options3 = new Object[]{"Type Graph", "Host Graph", "Rule", "All", "Cancel"};
                int answer3 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options3, options3[3]);
                switch (answer3) {
                    case 0: {
                        this.importAsTypeGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 3: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsTG && impAsG && impAsGC) {
                Object[] options4 = new Object[]{"Type Graph", "Host Graph", "Constraints", "All", "Cancel"};
                int answer4 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options4, options4[3]);
                switch (answer4) {
                    case 0: {
                        this.importAsTypeGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGraphConstraints(importGraGra, path);
                        break;
                    }
                    case 3: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsTG && impAsG) {
                Object[] options5 = new Object[]{"Type Graph", "Host Graph", "All", "Cancel"};
                int answer5 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options5, options5[2]);
                switch (answer5) {
                    case 0: {
                        this.importAsTypeGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsTG && impAsR && impAsGC) {
                Object[] options6 = new Object[]{"Type Graph", "Rule", "Constraints", "All", "Cancel"};
                int answer6 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options6, options6[3]);
                switch (answer6) {
                    case 0: {
                        this.importAsTypeGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGraphConstraints(importGraGra, path);
                        break;
                    }
                    case 3: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsTG && impAsR) {
                Object[] options7 = new Object[]{"Type Graph", "Rule", "All", "Cancel"};
                int answer7 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options7, options7[2]);
                switch (answer7) {
                    case 0: {
                        this.importAsTypeGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsG && impAsR && impAsGC) {
                Object[] options8 = new Object[]{"Host Graph", "Rule", "Constraints", "All", "Cancel"};
                int answer8 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options8, options8[3]);
                switch (answer8) {
                    case 0: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGraphConstraints(importGraGra, path);
                        break;
                    }
                    case 3: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsG && impAsR) {
                Object[] options9 = new Object[]{"Host Graph", "Rule", "All", "Cancel"};
                int answer9 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options9, options9[2]);
                switch (answer9) {
                    case 0: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsR && impAsGC) {
                Object[] options10 = new Object[]{"Rule", "Constraints", "All", "Cancel"};
                int answer10 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select to import.", "Import", -1, 3, null, options10, options10[0]);
                switch (answer10) {
                    case 0: {
                        this.importAsRule(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsGraphConstraints(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsR) {
                Object[] options11 = new Object[]{"Rule", "Cancel"};
                int answer11 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select to import.", "Import", -1, 3, null, options11, options11[0]);
                if (answer11 == 0) {
                    this.importAsRule(importGraGra, path);
                }
            } else if (impAsG && impAsGC) {
                Object[] options12 = new Object[]{"Host Graph", "Constraints", "All", "Cancel"};
                int answer12 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select to import.", "Import", -1, 3, null, options12, options12[0]);
                switch (answer12) {
                    case 0: {
                        this.importAsGraph(importGraGra, path);
                        break;
                    }
                    case 1: {
                        this.importAsGraphConstraints(importGraGra, path);
                        break;
                    }
                    case 2: {
                        this.importAsGrammarItems(importGraGra, path);
                    }
                }
            } else if (impAsG) {
                Object[] options13 = new Object[]{"Host Graph", "Cancel"};
                int answer13 = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select to import.", "Import", -1, 3, null, options13, options13[0]);
                if (answer13 == 0) {
                    this.importAsGraph(importGraGra, path);
                }
            } else if (impAsTG && (answer = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select to import.", "Import", -1, 3, null, options = new Object[]{"Type Graph", "Cancel"}, options[0])) == 0) {
                this.importAsTypeGraph(importGraGra, path);
            }
        }
    }

    private void importAsTypeGraph(EdGraGra imp, TreePath treepath) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra()) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot import!\n Please select a grammar first.", "", 0);
                return;
            }
            EdGraGra selGraGra = data.getGraGra();
            this.fireTreeViewEvent(new TreeViewEvent(this, 17));
            if (selGraGra.getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck() != 0) {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot import!\n Please disable the current type graph first.", "", 0);
                return;
            }
            boolean typeGraphImported = this.importTypeGraph(imp, selGraGra, path);
            if (!typeGraphImported && !this.rewriteTypeGraph) {
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Cannot import!\nPlease select a grammar first.", "", 0);
        }
    }

    private void importAsGraph(EdGraGra imp, TreePath treepath) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra()) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot import!\nPlease select a grammar first.", "", 0);
                return;
            }
            EdGraGra selGraGra = data.getGraGra();
            Object[] options = new Object[]{"Use as current graph", "Add to graphs"};
            int answer = JOptionPane.showOptionDialog(this.applFrame, "Do you want to use the import graph as the current graph?\n( Please note: The type graph of the current grammar should be disabled. )", "Import Graph", -1, 3, null, options, options[0]);
            if (answer == 0) {
                if (!this.importGraphAsHostGraph(imp, selGraGra, path, true)) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    this.applFrame.getRootPane().revalidate();
                }
            } else if (answer == 1 && !this.importGraph(imp, selGraGra, path, true)) {
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Cannot import!\nPlease select a grammar first.", "", 0);
        }
    }

    private void importAsGrammar(EdGraGra imp) {
        this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        if (imp.getBasisGraGra().getGraTraOptions().isEmpty()) {
            imp.getBasisGraGra().setGraTraOptions(new Completion_NAC(new Completion_InjCSP()));
        }
        BaseFactory.theFactory().notify(imp.getBasisGraGra());
        imp.update();
        GrammarTreeNode grammarTreeNode = new GrammarTreeNode(imp);
        int graIndex = grammarTreeNode.insertIntoTree(this);
        this.propagateGraGraToEditor(graIndex);
        this.fireTreeViewEvent(new TreeViewEvent(this, 4));
        imp.setChanged(false);
        this.resetEnabledOfFileMenuItems("open");
        this.filePopupMenu.resetEnabledOfFileMenuItems("open");
        this.resetEnabledOfToolBarItems("open");
    }

    private boolean importAsGrammarItems(EdGraGra importGraGra, TreePath treepath) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra()) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot import!\nPlease select a grammar first.", "", 0);
                return false;
            }
            EdGraGra selGraGra = data.getGraGra();
            this.fireTreeViewEvent(new TreeViewEvent(this, 17));
            this.importGrammarItems(importGraGra, selGraGra, path);
            return true;
        }
        return false;
    }

    private boolean importGrammarItems(EdGraGra importGraGra, EdGraGra selGraGra, TreePath path) {
        if (selGraGra.getTypeGraph() == null) {
            if (selGraGra.getTypeSet().isEmpty() && !importGraGra.getTypeSet().isEmpty()) {
                selGraGra.getTypeSet().getBasisTypeSet().setHelpInfo(String.valueOf(importGraGra.getTypeSet().getBasisTypeSet().hashCode()));
            }
            if (importGraGra.getTypeGraph() == null) {
                selGraGra.getTypeSet().getBasisTypeSet().adaptTypes(importGraGra.getBasisGraGra().getTypeSet(), true);
            } else {
                EdGraph tgraph = selGraGra.getTypeSet().createTypeGraph();
                if (!importGraGra.getTypeGraph().getBasisGraph().isEmpty()) {
                    tgraph.getBasisGraph().setHelpInfo(String.valueOf(importGraGra.getTypeGraph().getBasisGraph().hashCode()));
                }
                this.addTypeGraph(selGraGra, tgraph);
                this.importTypeGraph(importGraGra, selGraGra, path);
            }
        } else if (selGraGra.getLevelOfTypeGraphCheck() == 0) {
            if (importGraGra.getTypeGraph() != null) {
                if (selGraGra.getTypeGraph().getBasisGraph().isEmpty() && !importGraGra.getTypeGraph().getBasisGraph().isEmpty()) {
                    selGraGra.getTypeGraph().getBasisGraph().setHelpInfo(String.valueOf(importGraGra.getTypeGraph().getBasisGraph().hashCode()));
                }
                this.importTypeGraph(importGraGra, selGraGra, path);
            } else {
                if (selGraGra.getTypeSet().getBasisTypeSet().isEmpty() && !importGraGra.getBasisGraGra().getTypeSet().isEmpty()) {
                    selGraGra.getTypeSet().getBasisTypeSet().setHelpInfo(String.valueOf(importGraGra.getTypeSet().getBasisTypeSet().hashCode()));
                }
                selGraGra.getTypeSet().getBasisTypeSet().adaptTypes(importGraGra.getBasisGraGra().getTypeSet(), true);
            }
        }
        int i = 0;
        while (i < importGraGra.getGraphs().size()) {
            EdGraph eg = importGraGra.getGraphs().get(i);
            this.importGraph(eg, selGraGra);
            ++i;
        }
        Vector<String> failed = new Vector<String>();
        int i2 = 0;
        while (i2 < importGraGra.getRules().size()) {
            EdRule er = importGraGra.getRules().get(i2);
            EdRule newRule = this.importRule(er, selGraGra);
            if (newRule == null) {
                failed.add(er.getBasisRule().getName());
            }
            ++i2;
        }
        this.importGraphConstraints(importGraGra, selGraGra);
        selGraGra.getTypeSet().getBasisTypeSet().setHelpInfo("");
        selGraGra.getTypeSet().getBasisTypeSet().getTypeGraph().setHelpInfo("");
        if (failed.size() > 0) {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            JOptionPane.showMessageDialog(this.applFrame, "Import has failed for rule(s): \n" + failed.toString(), "", 2);
        }
        return true;
    }

    private boolean importTypeGraph(EdGraGra importGraGra, EdGraGra selGraGra, TreePath path) {
        int answer;
        Object[] options;
        boolean imported = false;
        if (!selGraGra.getTypeSet().getBasisTypeSet().compareTypes(importGraGra.getTypeSet().getBasisTypeSet())) {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            options = new Object[]{"OK"};
            answer = JOptionPane.showOptionDialog(this.applFrame, "There are mismatches of types. \nDo you want to rewrite the current type graph \nby the import type graph?", "Import Type Graph", -1, 2, null, options, options[0]);
            if (answer == 0) {
                this.rewriteTypeGraph = true;
            }
        } else {
            boolean selectAll = false;
            if (selGraGra.getTypeSet().getTypeGraph() == null) {
                this.addTypeGraph();
                selectAll = true;
                this.tree.treeDidChange();
            } else if (selGraGra.importTypeGraph(importGraGra.getTypeGraph(), false)) {
                imported = true;
                if (selectAll) {
                    selGraGra.getTypeSet().getTypeGraph().selectAll();
                }
            }
        }
        if (this.rewriteTypeGraph) {
            if (selGraGra.importTypeGraph(importGraGra.getTypeGraph(), true)) {
                imported = true;
            }
        } else if (!imported) {
            if (!selGraGra.getTypeSet().getBasisTypeSet().compareTypes(importGraGra.getTypeSet().getBasisTypeSet())) {
                options = new Object[]{"OK"};
                answer = JOptionPane.showOptionDialog(this.applFrame, "There are mismatches of types. \nDo you want to rewrite the current type graph \nby the import type graph?", "Import Type Graph", -1, 2, null, options, options[0]);
                if (answer == 0 && selGraGra.importTypeGraph(importGraGra.getTypeGraph(), true)) {
                    imported = true;
                }
            } else {
                boolean selectAll = false;
                if (selGraGra.getTypeSet().getTypeGraph() == null) {
                    this.addTypeGraph();
                    selectAll = true;
                    this.tree.treeDidChange();
                } else if (selGraGra.importTypeGraph(importGraGra.getTypeGraph(), true)) {
                    imported = true;
                    if (selectAll) {
                        selGraGra.getTypeSet().getTypeGraph().selectAll();
                    }
                }
            }
        }
        if (imported) {
            this.rewriteTypeGraph = false;
            DefaultMutableTreeNode pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(0);
            if (selGraGra.getBasisGraGra().getTypeGraph() != null) {
                pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(1);
            }
            ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraph());
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Import Type Graph was successful.<br>( Please note: New type graph objects are selected.<br>You may move them to the right position, if you want. )</body></html>");
            this.fireTreeViewEvent(new TreeViewEvent(this, 170));
            return true;
        }
        this.rewriteTypeGraph = false;
        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        this.applFrame.getRootPane().revalidate();
        JOptionPane.showMessageDialog(this.applFrame, "Import has failed!", "", 2);
        return false;
    }

    private boolean importGraphAsHostGraph(EdGraGra importGraGra, EdGraGra selGraGra, TreePath path, boolean adapt) {
        boolean doadapt = adapt;
        GraGraTreeNodeData graphData = null;
        if (this.currentGraGra == selGraGra) {
            DefaultMutableTreeNode gragraTreeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            int i = 0;
            while (i < gragraTreeNode.getChildCount()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)gragraTreeNode.getChildAt(i);
                GraGraTreeNodeData childData = (GraGraTreeNodeData)child.getUserObject();
                if (childData.isGraph() && childData.getGraph() == selGraGra.getGraph()) {
                    graphData = childData;
                    break;
                }
                ++i;
            }
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 17));
        EdGraph graphToImport = null;
        Vector<String> graphNames = new Vector<String>();
        if (importGraGra.getGraphs().size() > 1) {
            Vector<EdGraph> graphs = importGraGra.getGraphs();
            int i = 0;
            while (i < graphs.size()) {
                graphNames.add(graphs.get(i).getName());
                ++i;
            }
            GraphImportDialog gid = new GraphImportDialog(this.applFrame, "Graph to import", graphNames, true);
            gid.setVisible(true);
            graphNames = gid.getSelectedItemNames();
            if (!graphNames.isEmpty()) {
                graphToImport = importGraGra.getGraph(graphNames.get(0));
            }
        } else {
            graphToImport = importGraGra.getGraph();
        }
        if (graphToImport != null && !graphToImport.getBasisGraph().isEmpty()) {
            if (importGraGra.getTypeGraph() != null && (selGraGra.getTypeGraph() == null || selGraGra.getTypeGraph().getBasisGraph().isEmpty() && selGraGra.getLevelOfTypeGraphCheck() == 0) && this.importTypeGraph(importGraGra, selGraGra, path)) {
                doadapt = false;
            }
            if (doadapt) {
                if (selGraGra.importGraph(graphToImport, doadapt)) {
                    if (graphData != null) {
                        graphData.setData(selGraGra.getGraph());
                        if (!this.currentGraph.isTypeGraph()) {
                            this.currentGraph = selGraGra.getGraph();
                            this.currentGraph.getBasisGraph().setName(graphData.string());
                        }
                        this.fireTreeViewEvent(new TreeViewEvent(this, 171));
                        return true;
                    }
                    return false;
                }
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
                JOptionPane.showMessageDialog(this.applFrame, "Import has failed!", "", 0);
                return false;
            }
            if (selGraGra.importGraph(importGraGra.getGraph())) {
                if (graphData != null) {
                    graphData.setData(selGraGra.getGraph());
                    if (!this.currentGraph.isTypeGraph()) {
                        this.currentGraph = selGraGra.getGraph();
                        this.currentGraph.getBasisGraph().setName(graphData.string());
                    }
                    this.fireTreeViewEvent(new TreeViewEvent(this, 171));
                    return true;
                }
                return false;
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Import has failed!\nPlease check the types of the import graph.\nThe current type graph should be disabled before.</body></html>", "", 0);
            return false;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        this.applFrame.getRootPane().revalidate();
        return false;
    }

    private boolean importGraph(EdGraph importGraph, EdGraGra selGraGra) {
        EdGraph eg;
        if (selGraGra.addImportGraph(importGraph) && this.addGraph(selGraGra, eg = selGraGra.getGraphs().lastElement())) {
            this.tree.treeDidChange();
            return true;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        this.applFrame.getRootPane().revalidate();
        return false;
    }

    private boolean importAsRule(EdGraGra importGraGra, TreePath treepath) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra()) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Cannot import!<br>Please select a grammar first.", "", 0);
                return false;
            }
            EdGraGra selGraGra = data.getGraGra();
            this.fireTreeViewEvent(new TreeViewEvent(this, 17));
            Vector<String> ruleNames = new Vector<String>();
            Vector<EdRule> rules = importGraGra.getRules();
            int i = 0;
            while (i < rules.size()) {
                ruleNames.add(rules.get(i).getName());
                ++i;
            }
            ItemImportDialog rid = new ItemImportDialog(this.applFrame, "Rule to import", ruleNames);
            rid.setVisible(true);
            ruleNames = rid.getSelectedItemNames();
            Vector<String> failed = new Vector<String>();
            if (ruleNames.size() > 0) {
                selGraGra.getTypeSet().getBasisTypeSet().adaptTypes(importGraGra.getBasisGraGra().getTypes(), true);
                selGraGra.getTypeSet().refreshTypes(true);
                int i2 = 0;
                while (i2 < ruleNames.size()) {
                    String rname = ruleNames.get(i2);
                    EdRule er = importGraGra.getRule(importGraGra.getBasisGraGra().getRule(rname));
                    EdRule newRule = this.importRule(er, selGraGra);
                    if (newRule == null) {
                        failed.add(rname);
                    }
                    ++i2;
                }
                this.fireTreeViewEvent(new TreeViewEvent(this, 173));
            }
            if (failed.size() > 0) {
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Import failed for rules:<br>" + failed.toString() + "</body></html>", "", 2);
            }
            return true;
        }
        return false;
    }

    private EdRule importRule(EdRule er, EdGraGra selGraGra) {
        if (er instanceof EdRuleScheme) {
            RuleScheme rs = BaseFactory.theFactory().cloneRuleScheme((RuleScheme)er.getBasisRule(), selGraGra.getTypeSet().getBasisTypeSet());
            if (rs != null) {
                EdRuleScheme newRS = new EdRuleScheme(rs, selGraGra.getTypeSet());
                newRS.setLayoutByIndexFrom((EdRuleScheme)er);
                this.addRuleScheme(selGraGra, newRS);
                this.tree.treeDidChange();
                return newRS;
            }
        } else {
            EdRule newRule;
            Rule r = BaseFactory.theFactory().cloneRule(er.getBasisRule(), selGraGra.getTypeSet().getBasisTypeSet(), true);
            if (r != null && this.addRule(selGraGra, newRule = new EdRule(r, selGraGra.getTypeSet()))) {
                newRule.setLayoutByIndexFrom(er);
                this.tree.treeDidChange();
                return newRule;
            }
        }
        return null;
    }

    private boolean importAsGraphConstraints(EdGraGra importGraGra, TreePath treepath) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra()) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Cannot import!<br>Please select a grammar first.", "", 0);
                return false;
            }
            EdGraGra selGraGra = data.getGraGra();
            Object[] options = new Object[]{"All Constraints", "Atomic Graph Constraints", "Cancel"};
            int answer = JOptionPane.showOptionDialog(this.applFrame, "\nPlease select what do you want to import.", "Import", -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    this.importAllGraphConstraints(importGraGra, selGraGra);
                    break;
                }
                case 1: {
                    this.importAsAtomicGraphConstraints(importGraGra, path);
                }
            }
            return true;
        }
        return false;
    }

    private void importAllGraphConstraints(EdGraGra importGraGra, EdGraGra selGraGra) {
        this.fireTreeViewEvent(new TreeViewEvent(this, 17));
        selGraGra.getTypeSet().getBasisTypeSet().adaptTypes(importGraGra.getBasisGraGra().getTypeSet(), true);
        selGraGra.getTypeSet().refreshTypes(true);
        this.importGraphConstraints(importGraGra, selGraGra);
    }

    private void importAsAtomicGraphConstraints(EdGraGra importGraGra, TreePath path) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        EdGraGra selGraGra = data.getGraGra();
        this.fireTreeViewEvent(new TreeViewEvent(this, 17));
        Vector<String> names = importGraGra.getAtomicNames();
        ItemImportDialog rid = new ItemImportDialog(this.applFrame, "Atomic Graph Constraint to import", names);
        rid.setVisible(true);
        names = rid.getSelectedItemNames();
        Vector<String> failed = new Vector<String>();
        if (names.size() > 0) {
            selGraGra.getTypeSet().getBasisTypeSet().adaptTypes(importGraGra.getBasisGraGra().getTypes(), true);
            selGraGra.getTypeSet().refreshTypes(true);
            int i = 0;
            while (i < names.size()) {
                String name = names.get(i);
                EdAtomic ac = importGraGra.getAtomic(name);
                EdAtomic newac = this.importGraphConstraint(ac, selGraGra);
                if (newac == null) {
                    failed.add(name);
                }
                ++i;
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, 174));
        }
        if (failed.size() > 0) {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            JOptionPane.showMessageDialog(this.applFrame, "<html><body>Import failed for atomic graph constraints:<br>" + failed.toString() + "</body></html>", "Import Failed", 2);
        }
    }

    private EdAtomic importGraphConstraint(EdAtomic atom, EdGraGra selGraGra) {
        AtomConstraint ac = BaseFactory.theFactory().cloneAtomConstraint(atom.getBasisAtomic(), selGraGra.getTypeSet().getBasisTypeSet());
        if (ac != null) {
            EdAtomic newAtom = new EdAtomic(ac, selGraGra.getTypeSet(), ac.getAtomicName());
            int j = 0;
            while (j < atom.getBasisAtomic().getConclusionsSize()) {
                newAtom.getConclusion(j).setLayoutByIndexFrom(atom.getConclusion(j));
                ++j;
            }
            if (this.addAtomic(selGraGra, newAtom)) {
                this.tree.treeDidChange();
            }
            return newAtom;
        }
        return null;
    }

    private void importGraphConstraints(EdGraGra importGraGra, EdGraGra selGraGra) {
        Vector<EdAtomic> atoms = importGraGra.getAtomics();
        int i = 0;
        while (i < atoms.size()) {
            EdAtomic atom = (EdAtomic)atoms.get(i);
            this.importGraphConstraint(atom, selGraGra);
            ++i;
        }
        Vector<EdConstraint> constraints = importGraGra.getConstraints();
        int i2 = 0;
        while (i2 < constraints.size()) {
            EdConstraint newco;
            EdConstraint co = (EdConstraint)constraints.get(i2);
            Formula f = new Formula(selGraGra.getAtomicsAsEvaluable(), co.getAsIndxString());
            if (f.isValid() && this.addConstraint(selGraGra, newco = new EdConstraint(f, co.getName()))) {
                this.tree.treeDidChange();
            }
            ++i2;
        }
    }

    private boolean importGraph(EdGraGra importGraGra, EdGraGra selGraGra, TreePath path, boolean adapt) {
        boolean result = false;
        Vector<EdGraph> graphsToImport = new Vector<EdGraph>();
        Vector<String> graphNames = new Vector<String>();
        if (importGraGra.getGraphs().size() > 1) {
            Vector<EdGraph> graphs = importGraGra.getGraphs();
            int i = 0;
            while (i < graphs.size()) {
                graphNames.add(graphs.get(i).getName());
                ++i;
            }
            GraphImportDialog gid = new GraphImportDialog(this.applFrame, "Graph to import", graphNames, false);
            gid.setVisible(true);
            graphNames = gid.getSelectedItemNames();
            if (!graphNames.isEmpty()) {
                int i2 = 0;
                while (i2 < graphNames.size()) {
                    graphsToImport.add(importGraGra.getGraph(graphNames.get(i2)));
                    ++i2;
                }
            }
        } else {
            graphsToImport.add(importGraGra.getGraph());
        }
        int i = 0;
        while (i < graphsToImport.size()) {
            DefaultMutableTreeNode pathComp;
            int indx;
            EdGraph graphToImport = (EdGraph)graphsToImport.get(i);
            if (adapt) {
                if (selGraGra.addImportGraph(graphToImport, adapt) && this.addGraph(selGraGra, selGraGra.getGraphs().lastElement())) {
                    indx = selGraGra.getGraphs().size() - 1;
                    if (selGraGra.getTypeGraph() != null) {
                        ++indx;
                    }
                    pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(indx);
                    ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraphs().lastElement());
                    this.fireTreeViewEvent(new TreeViewEvent(this, 172));
                    result = true;
                }
            } else if (selGraGra.addImportGraph(graphToImport) && this.addGraph(selGraGra, selGraGra.getGraphs().lastElement())) {
                indx = selGraGra.getGraphs().size() - 1;
                if (selGraGra.getTypeGraph() != null) {
                    ++indx;
                }
                pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(indx);
                ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraphs().lastElement());
                this.fireTreeViewEvent(new TreeViewEvent(this, 172));
                result = true;
            }
            ++i;
        }
        if (result) {
            if (selGraGra.getBasisGraGra().getTypeGraph() != null && selGraGra.getTypeGraph() == null) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body> A new Type Graph of the current grammar is created. \n To make it available, please add a new Type Graph path \n into tree view of the current grammar.", "New Type Graph", 2);
            }
            return true;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        this.applFrame.getRootPane().revalidate();
        return false;
    }

    @Override
    public void transformEventOccurred(TransformEvent e) {
        if (e.getMsg() == 20) {
            this.tree.treeDidChange();
        }
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -11) {
            this.keyAdapter.performShortKeyEvent((KeyEvent)e.getObject(), false);
        } else if (e.getMsg() == -10) {
            if (e.getMessage().equals("File")) {
                this.file.doClick();
            } else if (e.getMessage().equals("New GraGra")) {
                this.executeCommand("newGraGra");
            } else if (e.getMessage().equals("Open")) {
                this.executeCommand("open");
            } else if (e.getMessage().equals("Save")) {
                this.executeCommand("save");
            } else if (e.getMessage().equals("Save As")) {
                this.executeCommand("saveAs");
            } else if (e.getMessage().equals("exportGraphJPEG")) {
                this.executeCommand("exportGraphJPEG");
            } else if (e.getMessage().equals("exportGXL")) {
                this.executeCommand("exportGXL");
            } else if (e.getMessage().equals("exportGTXL")) {
                this.executeCommand("exportGTXL");
            } else if (e.getMessage().equals("importGGX")) {
                this.executeCommand("importGGX");
            } else if (e.getMessage().equals("importGXL")) {
                this.executeCommand("importGXL");
            } else if (e.getMessage().equals("importOMONDOXMI")) {
                this.executeCommand("importOMONDOXMI");
            } else if (e.getMessage().equals("Delete")) {
                this.executeCommand("delete");
            } else if (e.getMessage().equals("Type Graph")) {
                this.executeCommand("newTypeGraph");
            } else if (e.getMessage().equals("Graph")) {
                this.executeCommand("newGraph");
            } else if (e.getMessage().equals("Rule")) {
                this.executeCommand("newRule");
            } else if (e.getMessage().equals("New NAC")) {
                this.executeCommand("newNAC");
            } else if (e.getMessage().equals("New PAC")) {
                this.executeCommand("newPAC");
            } else if (e.getMessage().equals("Atomic Constraint")) {
                this.executeCommand("newAtomic");
            } else if (e.getMessage().equals("New Conclusion")) {
                this.executeCommand("newConclusion");
            } else if (e.getMessage().equals("Constraint")) {
                this.executeCommand("newConstraint");
            } else if (e.getMessage().equals("Set Layer")) {
                this.setRuleLayer();
            } else if (e.getMessage().equals("Reload")) {
                this.reloadGraGra();
            } else if (e.getMessage().equals("Quit")) {
                this.executeCommand("exit");
            }
        } else if (e.getMsg() == -9) {
            this.applFrame.setCursor(new Cursor(0));
        } else if (e.getMsg() == -8) {
            if (this.selPath == null) {
                return;
            }
            if (e.getObject() instanceof EdAtomic) {
                DefaultMutableTreeNode atomicNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
                GraGraTreeNodeData sd = (GraGraTreeNodeData)atomicNode.getUserObject();
                if (sd.isAtomic()) {
                    DefaultMutableTreeNode conclNode = (DefaultMutableTreeNode)atomicNode.getChildAt(0);
                    this.showAtomicAttrConditions(conclNode);
                } else if (sd.isConclusion() && sd.getConclusion() == (EdAtomic)e.getObject()) {
                    this.showAtomicAttrConditions(atomicNode);
                } else if (sd.isAttrCondition()) {
                    TreePath atomicPath = this.selPath.getParentPath();
                    atomicNode = (DefaultMutableTreeNode)atomicPath.getLastPathComponent();
                    this.showAtomicAttrConditions(atomicNode);
                } else {
                    DefaultMutableTreeNode conclNode = this.getTreeNodeOfAtomicConclusion((EdAtomic)e.getObject());
                    this.showAtomicAttrConditions(conclNode);
                }
            } else if (e.getObject() instanceof EdRule) {
                DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
                TreePath rulePath = this.selPath;
                GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
                if (sd.isRule()) {
                    if (sd.getRule() == (EdRule)e.getObject()) {
                        this.showRuleAttrConditions(ruleNode);
                    }
                } else if (sd.isAttrCondition()) {
                    rulePath = this.selPath.getParentPath();
                    ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
                    sd = (GraGraTreeNodeData)ruleNode.getUserObject();
                    this.showRuleAttrConditions(ruleNode);
                } else if (sd.isNAC() || sd.isPAC() || sd.isNestedAC()) {
                    rulePath = this.selPath.getParentPath();
                    ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
                    this.showRuleAttrConditions(ruleNode);
                } else {
                    ruleNode = this.getTreeNodeOfRule((EdRule)e.getObject());
                    this.showRuleAttrConditions(ruleNode);
                }
            }
        } else if (e.getMsg() == -12) {
            if (e.getObject() instanceof EdGraph) {
                this.resetGraph((EdGraph)e.getObject());
            } else {
                this.resetGraph();
            }
        } else if (e.getMsg() == -13) {
            if (e.getObject() instanceof EdGraGra) {
                if (((EdGraGra)e.getObject()).getLevelOfTypeGraphCheck() == 20) {
                    if (this.setLevelOfTypeGraphCheck(this.currentGraGra, 10, false)) {
                        DefaultMutableTreeNode node = this.getTreeNodeOfGrammarElement(((EdGraGra)e.getObject()).getTypeGraph());
                        this.updateTypeGraphTreeNode(node, (EdGraGra)e.getObject());
                    }
                } else if (((EdGraGra)e.getObject()).getLevelOfTypeGraphCheck() == 30) {
                    if (e.getMessage().equals(String.valueOf(25)) || e.getMessage().equals(String.valueOf(22))) {
                        if (this.setLevelOfTypeGraphCheck(this.currentGraGra, 10, false)) {
                            DefaultMutableTreeNode node = this.getTreeNodeOfGrammarElement(((EdGraGra)e.getObject()).getTypeGraph());
                            this.updateTypeGraphTreeNode(node, (EdGraGra)e.getObject());
                        }
                    } else if (e.getMessage().equals(String.valueOf(24)) || e.getMessage().equals(String.valueOf(23))) {
                        if (this.setLevelOfTypeGraphCheck(this.currentGraGra, 20, false)) {
                            DefaultMutableTreeNode node = this.getTreeNodeOfGrammarElement(((EdGraGra)e.getObject()).getTypeGraph());
                            this.updateTypeGraphTreeNode(node, (EdGraGra)e.getObject());
                        } else if (this.setLevelOfTypeGraphCheck(this.currentGraGra, 10, false)) {
                            DefaultMutableTreeNode node = this.getTreeNodeOfGrammarElement(((EdGraGra)e.getObject()).getTypeGraph());
                            this.updateTypeGraphTreeNode(node, (EdGraGra)e.getObject());
                        }
                    }
                }
            }
        } else if (e.getMsg() == -14) {
            if (e.getObject() instanceof EdRule) {
                EdRuleScheme rs;
                EdRule r = (EdRule)e.getObject();
                if (r.getBasisRule() instanceof AmalgamatedRule) {
                    this.deleteAmalgamatedRule(this.getTreeNodeOfGrammarElement(r), false);
                } else if ((r.getBasisRule() instanceof KernelRule || r.getBasisRule() instanceof MultiRule) && (rs = this.currentGraGra.getRuleScheme(r.getBasisRule())) != null) {
                    DefaultMutableTreeNode delNode;
                    this.tree.expandPath(this.getTreePathOfGrammarElement(rs));
                    this.tree.treeDidChange();
                    EdRule ru = rs.getAmalgamatedRule();
                    if (ru != null && (delNode = this.getTreeNodeOfGrammarElement(ru)) != null) {
                        this.deleteAmalgamatedRule(this.getTreeNodeOfGrammarElement(ru), false);
                    }
                }
            }
        } else if (e.getMsg() == -15) {
            this.showRuleSequence();
        } else if (e.getMsg() == -16) {
            this.hideRuleSequence();
        }
    }

    public void setFlagForNew() {
        if (this.selPath != null) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
            this.setFlagForNewData(sd);
        }
    }

    void setFlagForNewData(GraGraTreeNodeData sd) {
        if (sd.isGraGra()) {
            this.newRuleOK = true;
            this.newApplCondOK = false;
        } else if (sd.isGraph()) {
            this.newRuleOK = false;
            this.newApplCondOK = false;
        } else if (sd.isRule()) {
            this.newApplCondOK = true;
            this.newRuleOK = false;
        } else if (sd.isNAC()) {
            this.newRuleOK = false;
            this.newApplCondOK = false;
        } else if (sd.isPAC()) {
            this.newRuleOK = false;
            this.newApplCondOK = false;
        } else if (sd.isNestedAC()) {
            this.newRuleOK = false;
            this.newApplCondOK = true;
        } else {
            this.newRuleOK = false;
            this.newApplCondOK = false;
        }
    }

    void setCurrentData(TreePath path) {
        EdGraGra graObj = this.currentGraGra;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        int nn = path.getPath().length;
        if (nn == 2) {
            this.setCurrentGraGra(node);
        } else if (nn == 3 ? !this.setCurrentGraph(node) && !this.setCurrentRuleScheme(node) && !this.setCurrentRule(node) && !this.setCurrentAtomicGC(node) && !this.setCurrentFormula(node) && this.setCurrentRuleSequence(node) : (nn == 4 ? !this.setCurrentNAC(node) && !this.setCurrentPAC(node) && !this.setCurrentNestedAC(node) && !this.setCurrentAttrCondition(node) && !this.setCurrentRulePostApplConstraint(node) && !this.setCurrentConclusionOfAtomicGC(node) && !this.setCurrentKernelRule(node) && this.setCurrentMultiRule(node) : (nn == 5 ? !this.setCurrentNestedAC(node) && !this.setCurrentConclusionAttrCondition(node) && !this.setCurrentNAC(node) && !this.setCurrentPAC(node) && !this.setCurrentNestedAC(node) && this.setCurrentRuleAtomicPostApplCondition(node) : nn <= 5 || this.setCurrentNestedAC(node)))) {
            // empty if block
        }
        if (this.currentGraGra != graObj && this.currentGraGra != null) {
            this.resetUndirectedArcProperty(!this.currentGraGra.getTypeSet().isArcDirected());
        }
    }

    private void setCurrentGraGra(DefaultMutableTreeNode node) {
        this.currentGraGra = this.getGraGra(node);
        this.currentGraph = this.currentGraGra.getGraph();
        if (!this.currentGraGra.getRules().isEmpty()) {
            this.currentRule = this.currentGraGra.getRules().firstElement();
            DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
            if (rnode != null) {
                this.currentNAC = null;
                this.currentPAC = null;
                this.currentNestedAC = null;
                Enumeration<TreeNode> children = rnode.children();
                if (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                    if (csd.isNAC()) {
                        this.currentNAC = csd.getNAC();
                    } else if (csd.isPAC()) {
                        this.currentPAC = csd.getPAC();
                    }
                }
            }
        } else {
            this.currentRule = null;
            this.currentNAC = null;
            this.currentPAC = null;
            this.currentNestedAC = null;
        }
        if (this.currentGraGra.getAtomics().size() != 0) {
            this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
            this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
        } else {
            this.currentAtomic = null;
            this.currentConclusion = null;
        }
        this.currentConstraint = null;
        this.currentRuleConstraint = null;
        this.currentAtomApplCond = null;
        this.layered = false;
        this.priority = false;
        if (this.currentGraGra.getBasisGraGra().isLayered()) {
            this.layered = true;
        } else if (this.currentGraGra.getBasisGraGra().trafoByPriority()) {
            this.priority = true;
        }
        this.treeModel.ruleNameChanged(this.getGraGra(), this.layered, this.priority);
        this.treeModel.constraintNameChanged(this.getGraGra(), this.layered, this.priority);
        this.tree.treeDidChange();
    }

    private boolean setCurrentGraph(DefaultMutableTreeNode node) {
        EdGraph test = this.getGraph(node);
        if (test != null) {
            this.currentGraph = test;
            if (this.currentGraph.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentGraph.getGraGra();
                if (this.currentGraGra.getRules().size() != 0) {
                    this.currentRule = this.currentGraGra.getRules().firstElement();
                    DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                    if (rnode != null) {
                        this.currentNAC = null;
                        this.currentPAC = null;
                        this.currentNestedAC = null;
                        Enumeration<TreeNode> children = rnode.children();
                        if (children.hasMoreElements()) {
                            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                            GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                            if (csd.isNAC()) {
                                this.currentNAC = csd.getNAC();
                            } else if (csd.isPAC()) {
                                this.currentPAC = csd.getPAC();
                            }
                        }
                    }
                } else {
                    this.currentRule = null;
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                }
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentRuleSequence(DefaultMutableTreeNode node) {
        RuleSequence testRuleSequence = this.getRuleSequence(node);
        if (testRuleSequence != null && this.currentGraGra != null && testRuleSequence.getGraGra() == this.currentGraGra.getBasisGraGra()) {
            this.currentRuleSequence = testRuleSequence;
            return true;
        }
        return false;
    }

    private boolean setCurrentRule(DefaultMutableTreeNode node) {
        EdRule testRule = this.getRule(node);
        if (testRule != null) {
            this.currentRule = testRule;
            this.currentNAC = null;
            this.currentPAC = null;
            this.currentNestedAC = null;
            Enumeration<TreeNode> children = node.children();
            if (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (csd.isNAC()) {
                    this.currentNAC = csd.getNAC();
                } else if (csd.isPAC()) {
                    this.currentPAC = csd.getPAC();
                } else if (csd.isNestedAC()) {
                    this.currentNestedAC = csd.getPAC();
                }
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentRuleScheme(DefaultMutableTreeNode node) {
        EdRuleScheme testRuleScheme = this.getRuleScheme(node);
        if (testRuleScheme != null) {
            this.currentRuleScheme = testRuleScheme;
            this.currentRule = null;
            this.currentNAC = null;
            this.currentPAC = null;
            this.currentNestedAC = null;
            Enumeration<TreeNode> children = node.children();
            if (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (csd.isKernelRule()) {
                    this.currentRule = csd.getKernelRule();
                } else if (csd.isMultiRule()) {
                    this.currentRule = csd.getMultiRule();
                } else if (csd.isNAC()) {
                    this.currentNAC = csd.getNAC();
                } else if (csd.isPAC()) {
                    this.currentPAC = csd.getPAC();
                } else if (csd.isNestedAC()) {
                    this.currentNestedAC = csd.getNestedAC();
                }
            }
            if (this.currentRuleScheme.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRuleScheme.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentKernelRule(DefaultMutableTreeNode node) {
        EdRule testRule = this.getKernelRule(node);
        if (testRule != null) {
            this.currentRule = testRule;
            this.currentNAC = null;
            this.currentPAC = null;
            this.currentNestedAC = null;
            Enumeration<TreeNode> children = node.children();
            if (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (csd.isNAC()) {
                    this.currentNAC = csd.getNAC();
                } else if (csd.isPAC()) {
                    this.currentPAC = csd.getPAC();
                } else if (csd.isNestedAC()) {
                    this.currentNestedAC = csd.getNestedAC();
                }
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentMultiRule(DefaultMutableTreeNode node) {
        EdRule testRule = this.getMultiRule(node);
        if (testRule != null) {
            this.currentRule = testRule;
            this.currentNAC = null;
            this.currentPAC = null;
            this.currentNestedAC = null;
            Enumeration<TreeNode> children = node.children();
            if (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (csd.isNAC()) {
                    this.currentNAC = csd.getNAC();
                } else if (csd.isPAC()) {
                    this.currentPAC = csd.getPAC();
                } else if (csd.isNestedAC()) {
                    this.currentNestedAC = csd.getNestedAC();
                }
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentAtomicGC(DefaultMutableTreeNode node) {
        EdAtomic testAtomic = this.getAtomic(node);
        if (testAtomic != null) {
            this.currentAtomic = testAtomic;
            if (this.currentAtomic.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentAtomic.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getRules().size() != 0) {
                    this.currentRule = this.currentGraGra.getRules().firstElement();
                    DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                    Enumeration<TreeNode> children = rnode.children();
                    if (children.hasMoreElements()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                        GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                        if (csd.isNAC()) {
                            this.currentNAC = csd.getNAC();
                        } else if (csd.isPAC()) {
                            this.currentPAC = csd.getPAC();
                        } else if (csd.isNestedAC()) {
                            this.currentNestedAC = csd.getNestedAC();
                        }
                    }
                } else {
                    this.currentRule = null;
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentConclusionOfAtomicGC(DefaultMutableTreeNode node) {
        EdAtomic testConclusion = this.getConclusion(node);
        if (testConclusion != null) {
            this.currentConclusion = testConclusion;
            if (this.currentConclusion.getParent() != this.currentAtomic) {
                this.currentAtomic = this.currentConclusion.getParent();
            }
            if (this.currentConclusion.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentConclusion.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getRules().size() != 0) {
                    this.currentRule = this.currentGraGra.getRules().firstElement();
                    DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                    Enumeration<TreeNode> children = rnode.children();
                    if (children.hasMoreElements()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                        GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                        if (csd.isNAC()) {
                            this.currentNAC = csd.getNAC();
                        } else if (csd.isPAC()) {
                            this.currentPAC = csd.getPAC();
                        } else if (csd.isNestedAC()) {
                            this.currentNestedAC = csd.getNestedAC();
                        }
                    }
                } else {
                    this.currentRule = null;
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentConclusionAttrCondition(DefaultMutableTreeNode node) {
        this.currentConclusionContext = this.getConclusionContext(node);
        if (this.currentConclusionContext != null) {
            if (this.currentConclusionContext.first != this.currentConclusion) {
                this.currentConclusion = (EdAtomic)this.currentConclusionContext.first;
            }
            if (this.currentConclusion.getParent() != this.currentAtomic) {
                this.currentConclusion = (EdAtomic)this.currentConclusionContext.first;
                this.currentAtomic = this.currentConclusion.getParent();
            }
            if (this.currentAtomic.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentAtomic.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getRules().size() != 0) {
                    this.currentRule = this.currentGraGra.getRules().firstElement();
                }
                DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                this.currentNAC = null;
                this.currentPAC = null;
                this.currentNestedAC = null;
                Enumeration<TreeNode> children = rnode.children();
                if (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                    if (csd.isNAC()) {
                        this.currentNAC = csd.getNAC();
                    } else if (csd.isPAC()) {
                        this.currentPAC = csd.getPAC();
                    } else if (csd.isNestedAC()) {
                        this.currentNestedAC = csd.getNestedAC();
                    }
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentFormula(DefaultMutableTreeNode node) {
        EdConstraint testConstraint = this.getConstraint(node);
        if (testConstraint != null) {
            this.currentConstraint = testConstraint;
            if (this.currentConstraint.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentConstraint.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getRules().size() != 0) {
                    this.currentRule = this.currentGraGra.getRules().firstElement();
                    DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                    Enumeration<TreeNode> children = rnode.children();
                    if (children.hasMoreElements()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                        GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                        if (csd.isNAC()) {
                            this.currentNAC = csd.getNAC();
                        } else if (csd.isPAC()) {
                            this.currentPAC = csd.getPAC();
                        } else if (csd.isNestedAC()) {
                            this.currentNestedAC = csd.getNestedAC();
                        }
                    }
                } else {
                    this.currentRule = null;
                    this.currentNAC = null;
                    this.currentPAC = null;
                    this.currentNestedAC = null;
                }
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentNestedAC(DefaultMutableTreeNode node) {
        EdNestedApplCond testAC = this.getNestedAC(node);
        if (testAC != null) {
            this.currentNestedAC = testAC;
            if (this.currentNestedAC.getRule() != this.currentRule) {
                this.currentRule = this.currentNestedAC.getRule();
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                this.currentNAC = null;
                this.currentPAC = null;
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentPAC(DefaultMutableTreeNode node) {
        EdPAC testPAC = this.getPAC(node);
        if (testPAC != null) {
            this.currentPAC = testPAC;
            if (this.currentPAC.getRule() != this.currentRule) {
                this.currentRule = this.currentPAC.getRule();
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                this.currentNAC = null;
                this.currentNestedAC = null;
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentNAC(DefaultMutableTreeNode node) {
        EdNAC testNAC = this.getNAC(node);
        if (testNAC != null) {
            this.currentNAC = testNAC;
            if (this.currentNAC.getRule() != this.currentRule) {
                this.currentRule = this.currentNAC.getRule();
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                this.currentPAC = null;
                this.currentNestedAC = null;
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentAttrCondition(DefaultMutableTreeNode node) {
        this.currentRuleContext = this.getRuleContext(node);
        if (this.currentRuleContext != null) {
            GraGraTreeNodeData csd;
            DefaultMutableTreeNode child;
            Enumeration<TreeNode> children;
            DefaultMutableTreeNode rnode;
            if (this.currentRuleContext.first != this.currentRule) {
                this.currentRule = (EdRule)this.currentRuleContext.first;
                rnode = this.getTreeNodeOfRule(this.currentRule);
                this.currentNAC = null;
                this.currentPAC = null;
                this.currentNestedAC = null;
                children = rnode.children();
                if (children.hasMoreElements()) {
                    child = (DefaultMutableTreeNode)children.nextElement();
                    csd = (GraGraTreeNodeData)child.getUserObject();
                    if (csd.isNAC()) {
                        this.currentNAC = csd.getNAC();
                    } else if (csd.isPAC()) {
                        this.currentPAC = csd.getPAC();
                    } else if (csd.isNestedAC()) {
                        this.currentNestedAC = csd.getNestedAC();
                    }
                }
            }
            if (((EdRule)this.currentRuleContext.first).getGraGra() != this.currentGraGra) {
                this.currentRule = (EdRule)this.currentRuleContext.first;
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                rnode = this.getTreeNodeOfRule(this.currentRule);
                this.currentNAC = null;
                this.currentPAC = null;
                this.currentNestedAC = null;
                children = rnode.children();
                if (children.hasMoreElements()) {
                    child = (DefaultMutableTreeNode)children.nextElement();
                    csd = (GraGraTreeNodeData)child.getUserObject();
                    if (csd.isNAC()) {
                        this.currentNAC = csd.getNAC();
                    } else if (csd.isPAC()) {
                        this.currentPAC = csd.getPAC();
                    } else if (csd.isNestedAC()) {
                        this.currentNestedAC = csd.getNestedAC();
                    }
                }
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentRulePostApplConstraint(DefaultMutableTreeNode node) {
        EdRuleConstraint testRuleConstraint = this.getRuleConstraint(node);
        if (testRuleConstraint != null) {
            this.currentRuleConstraint = testRuleConstraint;
            if (this.currentRuleConstraint.getRule() != this.currentRule) {
                this.currentRule = this.currentRuleConstraint.getRule();
                DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                this.currentNAC = null;
                this.currentPAC = null;
                this.currentNestedAC = null;
                Enumeration<TreeNode> children = rnode.children();
                if (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                    if (csd.isNAC()) {
                        this.currentNAC = csd.getNAC();
                    } else if (csd.isPAC()) {
                        this.currentPAC = csd.getPAC();
                    } else if (csd.isNestedAC()) {
                        this.currentNestedAC = csd.getNestedAC();
                    }
                }
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
                this.currentAtomApplCond = null;
            }
            return true;
        }
        return false;
    }

    private boolean setCurrentRuleAtomicPostApplCondition(DefaultMutableTreeNode node) {
        this.currentAtomApplCond = this.getAtomApplCond(node);
        if (this.currentAtomApplCond != null) {
            if (this.currentAtomApplCond.getRule() != this.currentRule) {
                this.currentRule = this.currentAtomApplCond.getRule();
                DefaultMutableTreeNode rnode = this.getTreeNodeOfRule(this.currentRule);
                this.currentNAC = null;
                this.currentPAC = null;
                this.currentNestedAC = null;
                Enumeration<TreeNode> children = rnode.children();
                if (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                    if (csd.isNAC()) {
                        this.currentNAC = csd.getNAC();
                    } else if (csd.isPAC()) {
                        this.currentPAC = csd.getPAC();
                    } else if (csd.isNestedAC()) {
                        this.currentNestedAC = csd.getNestedAC();
                    }
                }
                this.currentRuleConstraint = null;
            }
            if (this.currentRule.getGraGra() != this.currentGraGra) {
                this.currentGraGra = this.currentRule.getGraGra();
                this.currentGraph = this.currentGraGra.getGraph();
                if (this.currentGraGra.getAtomics().size() != 0) {
                    this.currentAtomic = this.currentGraGra.getAtomics().firstElement();
                    this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? this.currentAtomic.getConclusions().firstElement() : null;
                } else {
                    this.currentAtomic = null;
                    this.currentConclusion = null;
                }
                this.currentConstraint = null;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdGraGra getGraGra() {
        if (this.currentGraGra != null) {
            return this.currentGraGra;
        }
        if (this.selPath == null) {
            if (this.top.getChildCount() == 1) {
                this.tree.setSelectionRow(1);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setFlagForNew();
                return this.getGraGra((DefaultMutableTreeNode)this.selPath.getLastPathComponent());
            }
            JOptionPane.showMessageDialog(this.applFrame, "Please select a grammar.", "", 2);
            return null;
        }
        if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setFlagForNew();
            return this.getGraGra((DefaultMutableTreeNode)this.selPath.getLastPathComponent());
        }
        if (this.selPath.getPath().length == 2) return this.getGraGra((DefaultMutableTreeNode)this.selPath.getLastPathComponent());
        JOptionPane.showMessageDialog(this.applFrame, "Please select a grammar.", "", 2);
        return null;
    }

    void refreshGraGraRules(DefaultMutableTreeNode graNode) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        sd.getGraGra().getRules().removeAllElements();
        sd.getGraGra().getBasisGraGra().getListOfRules().clear();
        int i = 0;
        while (i < graNode.getChildCount()) {
            DefaultMutableTreeNode elem = (DefaultMutableTreeNode)graNode.getChildAt(i);
            GraGraTreeNodeData sdElem = (GraGraTreeNodeData)elem.getUserObject();
            if (sdElem.isRule()) {
                sd.getGraGra().getRules().addElement(sdElem.getRule());
                sd.getGraGra().getBasisGraGra().getListOfRules().add(sdElem.getRule().getBasisRule());
                sd.getGraGra().setChanged(true);
            }
            ++i;
        }
    }

    private void undoDelete() {
        this.gragraStore.showStorePalette();
    }

    public void undoDelete(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof EdNestedApplCond) {
            if (((EdNestedApplCond)obj).getParent() == null) {
                TreePath path = this.getTreePathOfGrammarElement(((EdNestedApplCond)obj).getRule());
                if (path != null && this.selPath != path) {
                    this.resetSelection(path);
                }
                if (!this.addNestedAC(((EdNestedApplCond)obj).getRule(), (EdNestedApplCond)obj)) {
                    this.gragraStore.storeNestedAC(((EdNestedApplCond)obj).getRule(), (EdNestedApplCond)obj);
                    return;
                }
            } else {
                TreePath path = this.getTreePathOfGrammarElement(((EdNestedApplCond)obj).getParent());
                if (path != null && this.selPath != path) {
                    this.resetSelection(path);
                }
                if (!this.addNestedAC(((EdNestedApplCond)obj).getParent(), (EdNestedApplCond)obj)) {
                    this.gragraStore.storeNestedAC(((EdNestedApplCond)obj).getParent(), (EdNestedApplCond)obj);
                    return;
                }
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdNAC) {
            TreePath path = this.getTreePathOfGrammarElement(((EdNAC)obj).getRule());
            if (path != null && this.selPath != path) {
                this.resetSelection(path);
            }
            if (!this.addNAC(((EdNAC)obj).getRule(), (EdNAC)obj)) {
                this.gragraStore.storeNAC(((EdNAC)obj).getRule(), (EdNAC)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdPAC) {
            TreePath path = this.getTreePathOfGrammarElement(((EdPAC)obj).getRule());
            if (path != null && this.selPath != path) {
                this.resetSelection(path);
            }
            if (!this.addPAC(((EdPAC)obj).getRule(), (EdPAC)obj)) {
                this.gragraStore.storePAC(((EdPAC)obj).getRule(), (EdPAC)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdGraph) {
            TreePath path = this.getTreePathOfGrammarElement(((EdGraph)obj).getGraGra());
            if (path != null && this.selPath != path) {
                this.resetSelection(path);
            }
            if (((EdGraph)obj).isTypeGraph()) {
                if (!this.addTypeGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj)) {
                    this.gragraStore.storeTypeGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj);
                    return;
                }
            } else if (!this.addGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj)) {
                this.gragraStore.storeGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdAtomic) {
            if (((EdAtomic)obj).getParent() == (EdAtomic)obj) {
                TreePath path = this.getTreePathOfGrammarElement(((EdAtomic)obj).getGraGra());
                if (path != null && this.selPath != path) {
                    this.resetSelection(path);
                }
                if (!this.addAtomic(((EdAtomic)obj).getGraGra(), (EdAtomic)obj)) {
                    this.gragraStore.storeAtomConstraint(((EdAtomic)obj).getGraGra(), (EdAtomic)obj);
                    return;
                }
            } else {
                TreePath path = this.getTreePathOfGrammarElement(((EdAtomic)obj).getParent());
                if (path != null && this.selPath != path) {
                    this.resetSelection(path);
                }
                if (!this.addConclusion(((EdAtomic)obj).getParent(), (EdAtomic)obj)) {
                    this.gragraStore.storeAtomConclusion(((EdAtomic)obj).getParent(), (EdAtomic)obj);
                    return;
                }
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdRule) {
            if (obj instanceof EdRuleScheme) {
                TreePath path = this.getTreePathOfGrammarElement(((EdRuleScheme)obj).getGraGra());
                if (path != null && this.selPath != path) {
                    this.resetSelection(path);
                }
                if (!this.addRuleScheme(((EdRuleScheme)obj).getGraGra(), (EdRuleScheme)obj)) {
                    this.gragraStore.storeRuleScheme(((EdRuleScheme)obj).getGraGra(), (EdRuleScheme)obj);
                    return;
                }
            } else {
                TreePath path = this.getTreePathOfGrammarElement(((EdRule)obj).getGraGra());
                if (path != null && this.selPath != path) {
                    this.resetSelection(path);
                }
                if (!this.addRule(((EdRule)obj).getGraGra(), (EdRule)obj)) {
                    this.gragraStore.storeRule(((EdRule)obj).getGraGra(), (EdRule)obj);
                    return;
                }
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdConstraint) {
            TreePath path = this.getTreePathOfGrammarElement(((EdConstraint)obj).getGraGra());
            if (path != null && this.selPath != path) {
                this.resetSelection(path);
            }
            if (!this.addConstraint(((EdConstraint)obj).getGraGra(), (EdConstraint)obj)) {
                this.gragraStore.storeConstraint(((EdConstraint)obj).getGraGra(), (EdConstraint)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        }
        this.tree.treeDidChange();
        if (this.gragraStore.isEmpty()) {
            this.trash.setEnabled(false);
        }
    }

    private void resetSelection(TreePath path) {
        this.tree.setSelectionPath(path);
        this.selPath = this.tree.getSelectionPath();
        this.setFlagForNew();
        this.editorPath = this.selPath;
        this.setCurrentData(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
    }

    private void undoDeleteTypeGraph() {
        if (this.currentGraGra != null) {
            EdGraph g = this.gragraStore.getTypeGraph(this.currentGraGra);
            if (g != null) {
                this.addTypeGraph(this.currentGraGra, g);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a grammar.", "", 2);
            return;
        }
    }

    private void undoDeleteRule() {
        if (this.currentGraGra != null) {
            EdRule r = this.gragraStore.getRule(this.currentGraGra);
            if (r != null && this.addRule(this.currentGraGra, r)) {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a grammar.", "", 2);
            return;
        }
    }

    private void undoDeleteAtomicConstraint() {
        if (this.currentGraGra != null) {
            EdAtomic c = this.gragraStore.getAtomConstraint(this.currentGraGra);
            if (c != null && this.addAtomic(this.currentGraGra, c)) {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a grammar.", "", 2);
            return;
        }
    }

    private void undoDeleteConstraint() {
        if (this.currentGraGra != null) {
            EdConstraint c = this.gragraStore.getConstraint(this.currentGraGra);
            if (c != null && this.addConstraint(this.currentGraGra, c)) {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a grammar.", "", 2);
            return;
        }
    }

    private void undoDeleteNAC() {
        if (this.currentRule != null) {
            EdNAC n = this.gragraStore.getNAC(this.currentRule);
            if (n != null) {
                this.addNAC(this.currentRule, n);
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.", "", 2);
            return;
        }
    }

    private void undoDeletePAC() {
        if (this.currentRule != null) {
            EdPAC p = this.gragraStore.getPAC(this.currentRule);
            if (p != null) {
                this.addPAC(this.currentRule, p);
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.", "", 2);
            return;
        }
    }

    private void undoDeleteNestedAC() {
        if (this.currentRule != null) {
            EdNestedApplCond p = this.gragraStore.getNestedAC(this.currentRule);
            if (p != null) {
                this.addNestedAC(this.currentRule, p);
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.", "", 2);
            return;
        }
    }

    private void undoDeleteAtomicConclusion() {
        if (this.currentAtomic != null) {
            EdAtomic c = this.gragraStore.getAtomConclusion(this.currentAtomic);
            if (c != null && this.addConclusion(this.currentAtomic, c)) {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select an atomic graph constraint.", "", 2);
            return;
        }
    }

    public int removeCurrentObjectWarning(String obj) {
        String msgStr = "Do you want to delete the current " + obj + " ?";
        if (obj.equals("GraGra")) {
            msgStr = "Do you want to close the current " + obj + " ?";
        }
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(this.applFrame, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    public int removeWarning(String obj) {
        String msgStr = "Do you want really to delete this  " + obj + " ?";
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(this.applFrame, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private int exitWarning(Object[] options, String obj, String name) {
        int answer = JOptionPane.showOptionDialog(this.applFrame, "The " + obj + "<" + name + ">" + " has been changed. \nDo you want to save it before?", " Quit AGG ", -1, 2, null, options, options[0]);
        return answer;
    }

    private int changedGraGraWarning(String action) {
        Object[] options = new Object[]{action, "CANCEL"};
        String act = action.toLowerCase();
        if (action.equals("RELOAD")) {
            act = "rewrite";
        }
        int answer = JOptionPane.showOptionDialog(this.applFrame, "This grammar has been changed.\nDo you want to " + act + " the grammar really?", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private void createMenus() {
        this.file.setMnemonic('F');
        JMenuItem mi = this.file.add(new JMenuItem("New GraGra            Ctrl+N"));
        mi.setEnabled(true);
        mi.setMnemonic('N');
        mi.setActionCommand("newGraGra");
        mi.addActionListener(this.actionAdapter);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Open                      Ctrl+O"));
        mi.setEnabled(true);
        mi.setMnemonic('O');
        mi.setActionCommand("open");
        mi.addActionListener(this.actionAdapter);
        mi = this.file.add(new JMenuItem("Save                       Ctrl+S"));
        mi.setEnabled(false);
        mi.setMnemonic('S');
        mi.setActionCommand("save");
        mi.addActionListener(this.actionAdapter);
        mi = this.file.add(new JMenuItem("Save As                   Alt+S"));
        mi.setEnabled(false);
        mi.setMnemonic(65);
        mi.setDisplayedMnemonicIndex(5);
        mi.setActionCommand("saveAs");
        mi.addActionListener(this.actionAdapter);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Open (Base)"));
        mi.setActionCommand("openBase");
        mi.addActionListener(this.actionAdapter);
        mi = this.file.add(new JMenuItem("Save As (Base)"));
        mi.setEnabled(false);
        mi.setActionCommand("saveAsBase");
        mi.addActionListener(this.actionAdapter);
        this.file.addSeparator();
        JMenu subm = (JMenu)this.file.add(new JMenu("Export"));
        subm.setEnabled(false);
        subm.setMnemonic('x');
        mi = subm.add(new JMenuItem("JPEG         Shift+J"));
        mi.setEnabled(true);
        mi.setMnemonic('J');
        mi.setActionCommand("exportGraphJPEG");
        mi.addActionListener(this.actionAdapter);
        mi = subm.add(new JMenuItem("GXL          Shift+X"));
        mi.setEnabled(true);
        mi.setMnemonic('X');
        mi.setActionCommand("exportGXL");
        mi.addActionListener(this.actionAdapter);
        mi = subm.add(new JMenuItem("GTXL        Shift+T"));
        mi.setEnabled(true);
        mi.setMnemonic('T');
        mi.setActionCommand("exportGTXL");
        mi.addActionListener(this.actionAdapter);
        subm = (JMenu)this.file.add(new JMenu("Import"));
        subm.setEnabled(true);
        subm.setMnemonic('I');
        mi = subm.add(new JMenuItem("GGX                         Shift+Alt+G"));
        mi.setEnabled(true);
        mi.setMnemonic('G');
        mi.setActionCommand("importGGX");
        mi.addActionListener(this.actionAdapter);
        mi = subm.add(new JMenuItem("GXL                          Shift+Alt+X"));
        mi.setEnabled(true);
        mi.setMnemonic('X');
        mi.setActionCommand("importGXL");
        mi.addActionListener(this.actionAdapter);
        mi = new JMenuItem("GTXL");
        mi.setEnabled(false);
        mi.setMnemonic('T');
        mi.setActionCommand("importGTXL");
        mi.addActionListener(this.actionAdapter);
        mi = subm.add(new JMenuItem("OMONDO XMI ( .ecore )   Shift+Alt+O"));
        mi.setEnabled(true);
        mi.setMnemonic('O');
        mi.setActionCommand("importOMONDOXMI");
        mi.addActionListener(this.actionAdapter);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Close GraGra           Ctrl+W"));
        mi.setEnabled(false);
        mi.setMnemonic('C');
        mi.setActionCommand("deleteGraGra");
        mi.addActionListener(this.actionAdapter);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("AGG View to JPEG"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AGGAppl)GraGraTreeView.this.applFrame).exportAppl2JPEG();
            }
        });
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Quit                        Ctrl+Q"));
        mi.setActionCommand("exit");
        mi.setMnemonic('Q');
        mi.addActionListener(this.actionAdapter);
        this.menus.addElement(this.file);
    }

    private void resetEnabledOfFileMenuItems(String command) {
        if (command.equals("newGraGra") || command.equals("open") || command.equals("importGXL")) {
            int i = 1;
            while (i < this.file.getItemCount() - 1) {
                if (this.file.getItem(i) != null) {
                    JMenuItem mi = this.file.getItem(i);
                    mi.setEnabled(true);
                }
                ++i;
            }
        } else if (command.equals("delete") || command.equals("deleteGraGra")) {
            if (this.tree.getRowCount() == 1) {
                int i = 1;
                while (i < this.file.getItemCount() - 1) {
                    if (this.file.getItem(i) instanceof JMenu) {
                        JMenu m = (JMenu)this.file.getItem(i);
                        if (m.getText().startsWith("Import")) {
                            m.setEnabled(true);
                        } else {
                            m.setEnabled(false);
                        }
                    } else if (this.file.getItem(i) != null) {
                        JMenuItem mi = this.file.getItem(i);
                        if (mi.getText().startsWith("Open") || mi.getText().startsWith("Open (Base)")) {
                            mi.setEnabled(true);
                        } else {
                            mi.setEnabled(false);
                        }
                    }
                    ++i;
                }
            }
        } else {
            command.equals("print");
        }
    }

    private void createToolBar() {
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewGraGraIcon", "New GraGra", "newGraGra", this.actionAdapter, true));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("imageable", "open", "Open", "open", this.actionAdapter, true));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("imageable", "save", "Save", "save", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewTypeGraphIcon", "New Type Graph", "newTypeGraph", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewGraphIcon", "New Graph", "newGraph", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewRuleIcon", "New Rule", "newRule", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.newNestedAC = this.toolBar.createTool("iconable", "NewNestedACIcon", "New General Application Condition", "newNestedAC", this.actionAdapter, false);
        this.indxNewNestedAC = this.toolBar.getComponentCount();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewNACIcon", "New Negative Application Condition", "newNAC", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewPACIcon", "New Positive Application Condition", "newPAC", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewAtomicIcon", "New Atomic Graph Constraint", "newAtomic", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewConclusionIcon", "New Conclusion of Atomic Graph Constraint", "newConclusion", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "NewConstraintIcon", "New Graph Constraint", "newConstraint", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteGraGraIcon", "Delete GraGra", "deleteGraGra", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteTypeGraphIcon", "Delete Type Graph", "deleteTypeGraph", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteGraphIcon", "Delete Graph", "deleteGraph", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteRuleIcon", "Delete Rule", "deleteRule", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.delNestedAC = this.toolBar.createTool("iconable", "DeleteNestedACIcon", "Delete General Application Condition", "deleteNestedAC", this.actionAdapter, false);
        this.indxDelNestedAC = this.toolBar.getComponentCount();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteNACIcon", "Delete Negative Application Condition", "deleteNAC", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeletePACIcon", "Delete Positive Application Condition", "deletePAC", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteAtomicIcon", "Delete Atomic Graph Constraint", "deleteAtomic", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteConclusionIcon", "Delete Conclusion of Atomic Graph Constraint", "deleteConclusion", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeleteConstraintIcon", "Delete Graph Constraint", "deleteConstraint", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.trash);
        this.gragraStore.setTrash(this.trash);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("imageable", "print", "Export GraGra Editor View to JPEG", "exportJPEG", this.actionAdapter, false));
        this.toolBar.addSeparator();
    }

    public void extendToolBar(JButton b) {
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(b);
    }

    private void resetEnabledOfToolBarItems(String command) {
        if (command.equals("newGraGra") || command.equals("open") && this.tree.getRowCount() > 1) {
            int i = 4;
            while (i < this.toolBar.getComponentCount()) {
                if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                    JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                    b.setEnabled(true);
                    if (b.getIcon() instanceof NewTypeGraphIcon) {
                        ((NewTypeGraphIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewGraphIcon) {
                        ((NewGraphIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewRuleIcon) {
                        ((NewRuleIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewNestedACIcon) {
                        ((NewNestedACIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewNACIcon) {
                        ((NewNACIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewPACIcon) {
                        ((NewPACIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewAtomicIcon) {
                        ((NewAtomicIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewConclusionIcon) {
                        ((NewConclusionIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof NewConstraintIcon) {
                        ((NewConstraintIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteGraGraIcon) {
                        ((DeleteGraGraIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                        ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteGraphIcon) {
                        ((DeleteGraphIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteRuleIcon) {
                        ((DeleteRuleIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteNestedACIcon) {
                        ((DeleteNestedACIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteNACIcon) {
                        ((DeleteNACIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeletePACIcon) {
                        ((DeletePACIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteAtomicIcon) {
                        ((DeleteAtomicIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteConclusionIcon) {
                        ((DeleteConclusionIcon)b.getIcon()).setEnabled(true);
                    } else if (b.getIcon() instanceof DeleteConstraintIcon) {
                        ((DeleteConstraintIcon)b.getIcon()).setEnabled(true);
                    }
                }
                ++i;
            }
        } else if (command.equals("deleteGraGra") && this.tree.getRowCount() == 1) {
            int i = 4;
            while (i < this.toolBar.getComponentCount()) {
                if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                    JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                    b.setEnabled(false);
                    if (b.getIcon() instanceof NewTypeGraphIcon) {
                        ((NewTypeGraphIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewGraphIcon) {
                        ((NewGraphIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewRuleIcon) {
                        ((NewRuleIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewNestedACIcon) {
                        ((NewNestedACIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewNACIcon) {
                        ((NewNACIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewPACIcon) {
                        ((NewPACIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewAtomicIcon) {
                        ((NewAtomicIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewConclusionIcon) {
                        ((NewConclusionIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof NewConstraintIcon) {
                        ((NewConstraintIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteGraGraIcon) {
                        ((DeleteGraGraIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                        ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteGraphIcon) {
                        ((DeleteGraphIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteRuleIcon) {
                        ((DeleteRuleIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteNestedACIcon) {
                        ((DeleteNestedACIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteNACIcon) {
                        ((DeleteNACIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeletePACIcon) {
                        ((DeletePACIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteAtomicIcon) {
                        ((DeleteAtomicIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteConclusionIcon) {
                        ((DeleteConclusionIcon)b.getIcon()).setEnabled(false);
                    } else if (b.getIcon() instanceof DeleteConstraintIcon) {
                        ((DeleteConstraintIcon)b.getIcon()).setEnabled(false);
                    }
                }
                ++i;
            }
        }
        if (this.gragraStore.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    public void resetFileIcons(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                if (b.getActionCommand().equals("open") || b.getActionCommand().equals("save")) {
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewGraGraIcon) {
                    ((NewGraGraIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewTypeGraphIcon) {
                    ((NewTypeGraphIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewGraphIcon) {
                    ((NewGraphIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewRuleIcon) {
                    ((NewRuleIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewNestedACIcon) {
                    ((NewNestedACIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewNACIcon) {
                    ((NewNACIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewPACIcon) {
                    ((NewPACIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewAtomicIcon) {
                    ((NewAtomicIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewConclusionIcon) {
                    ((NewConclusionIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof NewConstraintIcon) {
                    ((NewConstraintIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteGraGraIcon) {
                    ((DeleteGraGraIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                    ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteGraphIcon) {
                    ((DeleteGraphIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteRuleIcon) {
                    ((DeleteRuleIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteNestedACIcon) {
                    ((DeleteNestedACIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteNACIcon) {
                    ((DeleteNACIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeletePACIcon) {
                    ((DeletePACIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteAtomicIcon) {
                    ((DeleteAtomicIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteConclusionIcon) {
                    ((DeleteConclusionIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeleteConstraintIcon) {
                    ((DeleteConstraintIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                }
            }
            ++i;
        }
        if (this.gragraStore.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    public GraphicsExportJPEG getGraphicsExportJPEG() {
        return this.exportJPEG;
    }

    private void saveJPEG() {
        this.exportJPEG.setDirectory(this.directory);
        ((AGGAppl)this.applFrame).exportJPEG();
    }

    public void setNodeTypeForColorGraph(EdType type) {
        this.nodeTypeOfColorGraph = type;
    }

    public void setEdgeTypeForColorGraph(EdType type) {
        this.edgeTypeOfColorGraph = type;
    }

    public EdType getNodeTypeForColorGraph() {
        return this.nodeTypeOfColorGraph;
    }

    public EdType getEdgeTypeForColorGraph() {
        return this.edgeTypeOfColorGraph;
    }

    public void enableNestedApplCond(boolean b) {
        if (b) {
            this.rulePopupMenu.enableNestedApplCond(b);
            this.toolBar.addTool(this.newNestedAC, this.indxNewNestedAC);
            this.toolBar.addSeparator(new Dimension(3, 3), this.indxNewNestedAC + 1);
            this.toolBar.addTool(this.delNestedAC, this.indxDelNestedAC + 2);
            this.toolBar.addSeparator(new Dimension(3, 3), this.indxDelNestedAC + 3);
        }
    }
}

