/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdGraph;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import javax.swing.tree.DefaultMutableTreeNode;

public class GraphTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdGraph eGraph;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public GraphTreeNodeData(EdGraph graph) {
        this.setGraph(graph);
    }

    public GraphTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public GraphTreeNodeData(Object obj) {
        if (obj instanceof EdGraph) {
            this.setGraph((EdGraph)obj);
        } else if (obj instanceof String) {
            new GraphTreeNodeData((String)obj);
        }
    }

    @Override
    public void dispose() {
        this.eGraph = null;
        this.string = null;
        this.data = null;
        this.treeNode = null;
    }

    private void setGraph(EdGraph graph) {
        this.data = graph;
        this.string = graph.getBasisGraph().getName();
        this.eGraph = graph;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdGraph) {
            this.setGraph((EdGraph)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
            this.eGraph = null;
        } else {
            this.eGraph = null;
            this.string = null;
            this.data = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        if (!this.eGraph.getBasisGraph().getName().equals(newString)) {
            this.eGraph.getBasisGraph().setName(newString);
            this.eGraph.getGraGra().setChanged(true);
        }
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string();
    }

    @Override
    public EdGraph getGraph() {
        return this.eGraph;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isGraph() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = " Host graph ";
        if (this.eGraph.getBasisGraph() != null && !this.eGraph.getBasisGraph().getTextualComment().equals("")) {
            toolTipText = " " + this.eGraph.getBasisGraph().getTextualComment();
        }
        return toolTipText;
    }
}

