/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.layout.ZestGraphLayout;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class GraphLayouts {
    public static final String DEFAULT_LAYOUT = "Default ( Spring based )";
    public static final String SPRING_LAYOUT = "Spring";
    public static final String TREE_VERTICAL_LAYOUT = "Tree (vertical)";
    public static final String TREE_HORIZONTAL_LAYOUT = "Tree (horizontal)";
    public static final String RADIAL_LAYOUT = "Radial";
    public static final String GRID_LAYOUT = "Grid";
    public static final String VERTICAL_LAYOUT = "Vertical";
    public static final String HORIZONTAL_LAYOUT = "Horizontal";
    private final JPopupMenu menu = new JPopupMenu();
    private ButtonGroup group = new ButtonGroup();
    private ZestGraphLayout zestLayouter;
    private String msg = "";

    public GraphLayouts() {
        this.createMenu();
        this.canCreateZestGraphLayouter();
    }

    public String getMessage() {
        return this.msg;
    }

    public void addActionListener(ActionListener l) {
        Enumeration<AbstractButton> en = this.group.getElements();
        while (en.hasMoreElements()) {
            en.nextElement().addActionListener(l);
        }
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public void setZestLayoutEnabled(boolean b) {
        Enumeration<AbstractButton> en = this.group.getElements();
        en.nextElement();
        while (en.hasMoreElements()) {
            en.nextElement().setEnabled(b);
        }
    }

    public ZestGraphLayout getZestLayouter() {
        return this.zestLayouter;
    }

    private void createMenu() {
        this.menu.setName("Graph Layout");
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(DEFAULT_LAYOUT);
        mi.setActionCommand(DEFAULT_LAYOUT);
        mi.setSelected(true);
        this.menu.add(mi);
        this.group.add(mi);
        this.menu.addSeparator();
        mi = new JCheckBoxMenuItem(SPRING_LAYOUT);
        mi.setActionCommand(SPRING_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        mi = new JCheckBoxMenuItem(TREE_VERTICAL_LAYOUT);
        mi.setActionCommand(TREE_VERTICAL_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        mi = new JCheckBoxMenuItem(TREE_HORIZONTAL_LAYOUT);
        mi.setActionCommand(TREE_HORIZONTAL_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        mi = new JCheckBoxMenuItem(RADIAL_LAYOUT);
        mi.setActionCommand(RADIAL_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        mi = new JCheckBoxMenuItem(GRID_LAYOUT);
        mi.setActionCommand(GRID_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        mi = new JCheckBoxMenuItem(VERTICAL_LAYOUT);
        mi.setActionCommand(VERTICAL_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        mi = new JCheckBoxMenuItem(HORIZONTAL_LAYOUT);
        mi.setActionCommand(HORIZONTAL_LAYOUT);
        this.menu.add(mi);
        this.group.add(mi);
        this.menu.pack();
        this.menu.setBorderPainted(true);
    }

    public boolean canCreateZestGraphLayouter() {
        try {
            Class.forName("org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm");
            this.zestLayouter = new ZestGraphLayout();
            return true;
        }
        catch (Exception ex) {
            this.msg = "WARNING! Class is not found.  Program tries to load the JAR file: \n" + ex.getMessage() + "\nThere will be no further warnings about this issue.\n";
            System.out.println(this.msg);
            this.setZestLayoutEnabled(false);
            return false;
        }
    }

    public void runCurrentLayoutAlgorithm() {
    }
}

