/*
 * Decompiled with CFR 0.152.
 */
package agg.layout.evolutionary;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.layout.evolutionary.LayoutArc;
import agg.layout.evolutionary.LayoutMetrics;
import agg.layout.evolutionary.LayoutNode;
import agg.layout.evolutionary.LayoutPattern;
import agg.xt_basis.Arc;
import agg.xt_basis.Type;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class EvolutionaryGraphLayout {
    private boolean jpgOutput;
    private boolean enabled;
    private Dimension panel;
    private boolean panelChangable;
    private final LayoutMetrics lmetric;
    private EdGraph oldedgraph;
    private int gnrlEdgeLngth;
    private int temperature;
    private boolean usePattern;
    private boolean frozenPos;
    private boolean centre;
    private boolean writeMetrics;
    private int iters;
    private int nodeIntersctnIters;
    private int edgeIntersctnIters;
    private int overlapscnt;
    private final Hashtable<Type, Vector<LayoutPattern>> layoutPatterns;
    private final Hashtable<LayoutNode, Type> layoutNode2Type;
    private final Random random = new Random();

    public EvolutionaryGraphLayout(int temp, Dimension panel) {
        this.temperature = temp;
        this.panel = panel;
        this.panelChangable = true;
        this.lmetric = new LayoutMetrics();
        this.oldedgraph = null;
        this.jpgOutput = true;
        this.enabled = false;
        this.usePattern = false;
        this.frozenPos = false;
        this.centre = false;
        this.writeMetrics = true;
        this.iters = 100;
        this.nodeIntersctnIters = 1;
        this.edgeIntersctnIters = 50;
        this.overlapscnt = 0;
        this.gnrlEdgeLngth = 200;
        this.layoutPatterns = new Hashtable();
        this.layoutNode2Type = new Hashtable();
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private int getAttrForce(int d, int z) {
        return d * d / z;
    }

    private int getRepulseForce(int d, int z) {
        return z * z / Math.abs(d);
    }

    private int cool(int temp, int it) {
        return temp - temp / (it + 2);
    }

    private int reduceTempByAge(int temp, int age, int gage) {
        int ret = gage == 0 ? temp : temp - temp / (gage - age + 1);
        return ret;
    }

    public void createInheritancePattern(Vector<Arc> inheritanceArcs) {
        int i = 0;
        while (i < inheritanceArcs.size()) {
            Arc inharc = inheritanceArcs.get(i);
            Vector<LayoutPattern> v = this.getLayoutPatternsForType(inharc.getType());
            if (!v.isEmpty()) {
                v.clear();
            }
            this.createLayoutPattern("ver_tree", "edge", inharc.getType(), 'y', -1);
            this.createLayoutPattern("edge_length", "edge", inharc.getType(), 150);
            ++i;
        }
    }

    private Vector<LayoutPattern> getInheritancePattern(EdArc edge) {
        if (edge.getBasisArc().isInheritance()) {
            return this.getLayoutPatternsForType(edge.getBasisArc().getType());
        }
        return null;
    }

    public void layout(EdGraph egraph, List<EdNode> nodes, List<EdArc> arcs) {
        this.layout(egraph, nodes, arcs, this.iters);
    }

    public void layout(EdGraph egraph, List<EdNode> nodes, List<EdArc> arcs, int itrs) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(nodes);
        Vector<LayoutArc> larcs = this.getLayoutArcs(arcs);
        int temp = this.temperature;
        int i = 0;
        while (i < itrs) {
            this.calcNodeRepulse(lnodes);
            int j = 0;
            while (j < larcs.size()) {
                LayoutArc larc = larcs.get(j);
                if (larc.getEdArc().isLine()) {
                    LayoutNode lnodev = ((EdNode)larc.getEdArc().getSource()).getLNode();
                    LayoutNode lnodeu = ((EdNode)larc.getEdArc().getTarget()).getLNode();
                    int deltax = lnodev.getAkt().x - lnodeu.getAkt().x;
                    int deltay = lnodev.getAkt().y - lnodeu.getAkt().y;
                    if (deltax != 0) {
                        lnodev.setDistX(lnodev.getDistX() - deltax / Math.abs(deltax) * this.getAttrForce(deltax, lnodev.getZone()));
                        lnodeu.setDistX(lnodeu.getDistX() + deltax / Math.abs(deltax) * this.getAttrForce(deltax, lnodeu.getZone()));
                    }
                    if (deltay != 0) {
                        lnodev.setDistY(lnodev.getDistY() - deltay / Math.abs(deltay) * this.getAttrForce(deltay, lnodev.getZone()));
                        lnodeu.setDistY(lnodeu.getDistY() + deltay / Math.abs(deltay) * this.getAttrForce(deltay, lnodeu.getZone()));
                    }
                }
                ++j;
            }
            this.calcDistToPos(arcs, lnodes, temp, egraph.getGraphGen());
            temp = this.cool(temp, i);
            if (temp == 0) break;
            ++i;
        }
        egraph.setGraphDim(this.panel);
        egraph.updateNodePosLtoE(nodes);
    }

    private void calcNodeRepulse(Vector<LayoutNode> lnodes) {
        int j = 0;
        while (j < lnodes.size()) {
            LayoutNode lnodev = lnodes.get(j);
            if (!(!this.usePattern && lnodev.isFrozenByDefault() && this.frozenPos || this.isFrozen(lnodev))) {
                lnodev.setDistX(0);
                lnodev.setDistY(0);
                int k = 0;
                while (k < lnodes.size()) {
                    LayoutNode lnodeu = lnodes.get(k);
                    if (!lnodev.equals(lnodeu)) {
                        int deltax = lnodev.getAkt().x - lnodeu.getAkt().x;
                        int deltay = lnodev.getAkt().y - lnodeu.getAkt().y;
                        if (deltax != 0) {
                            lnodev.setDistX(lnodev.getDistX() + deltax / Math.abs(deltax) * this.getRepulseForce(deltax, lnodev.getZone()));
                        }
                        if (deltay != 0) {
                            lnodev.setDistY(lnodev.getDistY() + deltay / Math.abs(deltay) * this.getRepulseForce(deltay, lnodev.getZone()));
                        }
                        if (deltax == 0 && deltay == 0) {
                            int r = this.random.nextInt(this.panel.width) % 200;
                            lnodev.setDistX(lnodev.getDistX() + r);
                            lnodev.setDistY(lnodev.getDistY() - r);
                        }
                    }
                    ++k;
                }
            }
            ++j;
        }
    }

    private void calcDistToPos(List<EdArc> arcs, Vector<LayoutNode> lnodes, int temp, int gage) {
        int newy;
        int newx;
        int j = 0;
        while (j < lnodes.size()) {
            LayoutNode lnodev = lnodes.get(j);
            if (!(!this.usePattern && lnodev.isFrozenByDefault() && this.frozenPos || this.isFrozen(lnodev))) {
                newx = lnodev.getAkt().x;
                newy = lnodev.getAkt().y;
                int minx = 0;
                int miny = 0;
                int age = lnodev.getAge();
                int akttemp = this.reduceTempByAge(temp, age, gage);
                if (lnodev.getDistX() != 0) {
                    minx = Math.min(Math.abs(lnodev.getDistX()), akttemp);
                    newx = lnodev.getDistX() >= 0 ? (newx += minx) : (newx -= minx);
                }
                if (lnodev.getDistY() != 0) {
                    miny = Math.min(Math.abs(lnodev.getDistY()), akttemp);
                    newy = lnodev.getDistY() >= 0 ? (newy += miny) : (newy -= miny);
                }
                if (newx - lnodev.getEdNode().getWidth() / 2 <= 0) {
                    newx = Math.max(newx, lnodev.getEdNode().getWidth());
                }
                if (newy - lnodev.getEdNode().getHeight() / 2 <= 0) {
                    newy = Math.max(newy, lnodev.getEdNode().getHeight());
                }
                Point newp = this.getRandomPosIfNeeded(newx, newy, lnodev);
                lnodev.setOpt(newp);
                lnodev.setAkt(newp);
            }
            ++j;
        }
        if (this.usePattern) {
            int i = 0;
            while (i < arcs.size()) {
                EdArc arc = arcs.get(i);
                Vector<LayoutPattern> patterns = null;
                if (arc.isElementOfTypeGraph()) {
                    patterns = this.getInheritancePattern(arc);
                }
                if (patterns == null) {
                    patterns = this.getLayoutPatternsForType(arc.getType().getBasisType());
                }
                int p = 0;
                while (p < patterns.size()) {
                    LayoutPattern lp = patterns.get(p);
                    if (lp != null && lp.isEdgePattern()) {
                        LayoutNode source = ((EdNode)arc.getSource()).getLNode();
                        LayoutNode target = ((EdNode)arc.getTarget()).getLNode();
                        if (lp.isXOffset()) {
                            if (lp.getOffset() > 0) {
                                if (!this.isFrozen(target)) {
                                    newx = Math.max(target.getAkt().x, source.getAkt().x + 4);
                                    newy = target.getAkt().y;
                                    target.setAkt(new Point(newx, newy));
                                } else if (!this.isFrozen(source)) {
                                    newx = Math.min(target.getAkt().x - 1, source.getAkt().x);
                                    newy = source.getAkt().y;
                                    source.setAkt(new Point(newx, newy));
                                }
                            } else if (!this.isFrozen(source)) {
                                newx = Math.max(target.getAkt().x + 1, source.getAkt().x);
                                newy = source.getAkt().y;
                                source.setAkt(new Point(newx, newy));
                            } else if (!this.isFrozen(target)) {
                                newx = Math.min(target.getAkt().x, source.getAkt().x - 4);
                                newy = target.getAkt().y;
                                target.setAkt(new Point(newx, newy));
                            }
                        }
                        if (lp.isYOffset()) {
                            if (lp.getOffset() > 0) {
                                if (!this.isFrozen(target)) {
                                    newy = Math.max(target.getAkt().y, source.getAkt().y + 4);
                                    newx = target.getAkt().x;
                                    target.setAkt(new Point(newx, newy));
                                } else if (!this.isFrozen(source)) {
                                    newy = Math.min(target.getAkt().y - 1, source.getAkt().y);
                                    newx = source.getAkt().x;
                                    source.setAkt(new Point(newx, newy));
                                }
                            } else if (!this.isFrozen(source)) {
                                newy = Math.max(target.getAkt().y + 1, source.getAkt().y);
                                newx = source.getAkt().x;
                                source.setAkt(new Point(newx, newy));
                            } else if (!this.isFrozen(target)) {
                                newy = Math.min(target.getAkt().y, source.getAkt().y - 4);
                                newx = target.getAkt().x;
                                target.setAkt(new Point(newx, newy));
                            }
                        }
                    }
                    ++p;
                }
                ++i;
            }
        }
    }

    public void layoutByArcLength(EdGraph eg, List<EdNode> nodes, List<EdArc> arcs) {
        this.layoutByArcLength(eg, nodes, arcs, this.edgeIntersctnIters, this.temperature);
    }

    public boolean layoutByArcLength(EdGraph eg, List<EdNode> nodes, List<EdArc> arcs, int itrs, int temp) {
        if (arcs.size() == 0) {
            return true;
        }
        int gage = eg.getGraphGen();
        int i = 0;
        while (i < arcs.size()) {
            EdArc arc = arcs.get(i);
            arc.getLArc().calcAktLength();
            arc.getLArc().resetUsed();
            ++i;
        }
        boolean layoutDone = false;
        int i2 = 0;
        while (i2 < itrs) {
            int abw;
            int max = 0;
            int index = -1;
            int j = 0;
            while (j < arcs.size()) {
                EdArc edarc = arcs.get(j);
                LayoutArc larc = edarc.getLArc();
                int prefLength = larc.getPrefLength();
                LayoutPattern lpat = this.getLayoutPatternForType(edarc.getBasisArc().getType(), "edge_length");
                if (lpat != null && lpat.getLength() > 0) {
                    prefLength = lpat.getLength();
                }
                if ((abw = Math.abs(prefLength - larc.getAktLength())) / (larc.getUsed() + 1) > max) {
                    max = abw;
                    index = j;
                }
                ++j;
            }
            if (index != -1) {
                int tynew;
                int synew;
                int txnew;
                int sxnew;
                int ychange;
                int xchange;
                EdArc arc = arcs.get(index);
                LayoutArc larc = arc.getLArc();
                larc.incUsed();
                if (max < 20) break;
                LayoutNode source = ((EdNode)arc.getSource()).getLNode();
                LayoutNode target = ((EdNode)arc.getTarget()).getLNode();
                int prefLength = larc.getPrefLength();
                LayoutPattern lpat = this.getLayoutPatternForType(arc.getBasisArc().getType(), "edge_length");
                if (lpat != null && lpat.getLength() > 0) {
                    prefLength = lpat.getLength();
                }
                abw = larc.getAktLength() - prefLength;
                if (larc.getXLength() != 0 && larc.getYLength() != 0) {
                    xchange = Math.abs(abw / 2 * larc.getXLength() / larc.getAktLength());
                    ychange = Math.abs(abw / 2 * larc.getYLength() / larc.getAktLength());
                } else if (larc.getXLength() == 0) {
                    xchange = 0;
                    ychange = Math.abs(abw / 2);
                } else {
                    xchange = Math.abs(abw / 2);
                    ychange = 0;
                }
                int age = source.getAge();
                int akttemp = !this.frozenPos || !source.isFrozenByDefault() ? this.reduceTempByAge(temp, age, gage) : temp;
                int sxchange = Math.min(xchange, akttemp) * (abw / Math.abs(abw));
                int sychange = Math.min(ychange, akttemp) * (abw / Math.abs(abw));
                age = target.getAge();
                akttemp = !this.frozenPos || !target.isFrozenByDefault() ? this.reduceTempByAge(temp, age, gage) : temp;
                akttemp = this.reduceTempByAge(temp, age, gage);
                int txchange = Math.min(xchange, akttemp) * (abw / Math.abs(abw));
                int tychange = Math.min(ychange, akttemp) * (abw / Math.abs(abw));
                if (source.getAkt().x <= target.getAkt().x) {
                    sxnew = source.getAkt().x + sxchange;
                    txnew = target.getAkt().x - txchange;
                } else {
                    sxnew = source.getAkt().x - sxchange;
                    txnew = target.getAkt().x + txchange;
                }
                if (source.getAkt().y <= target.getAkt().y) {
                    synew = source.getAkt().y + sychange;
                    tynew = target.getAkt().y - tychange;
                } else {
                    synew = source.getAkt().y - sychange;
                    tynew = target.getAkt().y + tychange;
                }
                if (!this.frozenPos || !source.isFrozenByDefault()) {
                    Point newsp = this.getRandomPosIfNeeded(sxnew, synew, source);
                    sxnew = newsp.x;
                    synew = newsp.y;
                }
                if (!this.frozenPos || !target.isFrozenByDefault()) {
                    Point newtp = this.getRandomPosIfNeeded(txnew, tynew, target);
                    txnew = newtp.x;
                    tynew = newtp.y;
                }
                if (this.usePattern) {
                    Vector<LayoutPattern> patterns = null;
                    if (arc.isElementOfTypeGraph()) {
                        patterns = this.getInheritancePattern(arc);
                    }
                    if (patterns == null) {
                        patterns = this.getLayoutPatternsForType(arc.getType().getBasisType());
                    }
                    int p = 0;
                    while (p < patterns.size()) {
                        LayoutPattern lp = patterns.get(p);
                        if (lp != null && lp.isEdgePattern()) {
                            if (lp.isXOffset()) {
                                if (lp.getOffset() > 0) {
                                    if (!this.isFrozen(target)) {
                                        txnew = Math.max(txnew, sxnew + 4);
                                    } else if (!this.isFrozen(source)) {
                                        sxnew = Math.min(sxnew, txnew - 4);
                                    }
                                } else if (!this.isFrozen(source)) {
                                    sxnew = Math.max(sxnew, txnew + 4);
                                } else if (!this.isFrozen(target)) {
                                    txnew = Math.min(txnew, sxnew - 4);
                                }
                            }
                            if (lp.isYOffset()) {
                                if (lp.getOffset() > 0) {
                                    if (!this.isFrozen(target)) {
                                        tynew = Math.max(tynew, synew + 4);
                                    } else if (!this.isFrozen(source)) {
                                        synew = Math.min(synew, tynew - 4);
                                    }
                                } else if (!this.isFrozen(source)) {
                                    synew = Math.max(synew, tynew + 4);
                                } else if (!this.isFrozen(target)) {
                                    tynew = Math.min(tynew, synew - 4);
                                }
                            }
                        }
                        ++p;
                    }
                }
                if (!(this.frozenPos && source.isFrozenByDefault() || this.isFrozen(source))) {
                    source.getAkt().setLocation(sxnew, synew);
                    source.getOpt().setLocation(source.getAkt());
                }
                if (!(this.frozenPos && target.isFrozenByDefault() || this.isFrozen(target))) {
                    target.getAkt().setLocation(txnew, tynew);
                    target.getOpt().setLocation(target.getAkt());
                }
                int k = 0;
                while (k < arcs.size()) {
                    EdArc a = arcs.get(k);
                    if (!a.getLArc().isFrozen()) {
                        a.getLArc().calcAktLength();
                    }
                    ++k;
                }
                layoutDone = true;
            }
            ++i2;
        }
        eg.updateNodePosLtoE(nodes);
        return layoutDone;
    }

    public void combinedLayout(EdGraph eg, List<EdNode> nodes, List<EdArc> arcs) {
        this.combinedLayout(eg, nodes, arcs, this.iters, this.iters, this.edgeIntersctnIters);
    }

    public void combinedLayout(EdGraph eg, List<EdNode> nodes, List<EdArc> arcs, int itrs, int nodeit, int arcit) {
        int i = 0;
        while (i < itrs) {
            this.layout(eg, nodes, arcs, nodeit);
            this.layoutByArcLength(eg, nodes, arcs, arcit, 100);
            ++i;
        }
    }

    public boolean layoutGraph(EdGraph eg, List<EdNode> nodes, List<EdArc> arcs) {
        return this.layoutGraph(eg, nodes, arcs, this.iters, this.nodeIntersctnIters, this.edgeIntersctnIters);
    }

    public boolean layoutGraph(EdGraph eg, List<EdNode> nodes, List<EdArc> arcs, int itrs, int nodeit, int arcit) {
        int i = 0;
        while (i < arcs.size()) {
            EdArc a = arcs.get(i);
            if (!(a.getLArc().isFrozen() || this.frozenPos || a.getLArc().isFrozenByDefault())) {
                a.setAnchor(null);
            }
            ++i;
        }
        Vector<LayoutNode> lnodes = this.getLayoutNodes(nodes);
        int i2 = 0;
        while (i2 < itrs) {
            int temp2 = this.temperature;
            int j = 0;
            while (j < nodeit) {
                this.calcNodeRepulse(lnodes);
                this.calcDistToPos(eg.getArcs(), lnodes, temp2, eg.getGraphGen());
                this.cool(temp2, j);
                ++j;
            }
            this.layoutByArcLength(eg, nodes, arcs, arcit, this.temperature);
            this.cool(this.temperature, i2);
            ++i2;
        }
        this.overlapscnt = this.lmetric.getNodeIntersect(nodes, true);
        if (this.overlapscnt == 0) {
            eg.updateNodePosLtoE(nodes);
            return false;
        }
        int stop = 100;
        while (this.overlapscnt > 0 && stop > 0) {
            int i3 = 0;
            while (i3 < lnodes.size()) {
                LayoutNode lnode1 = lnodes.get(i3);
                if (!(!this.usePattern && lnode1.isFrozenByDefault() && this.frozenPos || this.isFrozen(lnode1) || !lnode1.isOverlapping())) {
                    int ovlNodeIndx = this.lmetric.getOverlappingNode(lnodes, i3);
                    if (ovlNodeIndx < 0) {
                        lnode1.unsetOverlap();
                    } else {
                        LayoutNode lnode2 = lnodes.get(ovlNodeIndx);
                        if (!(!this.usePattern && lnode2.isFrozenByDefault() && this.frozenPos || this.isFrozen(lnode2))) {
                            int y2;
                            int y1;
                            int x2;
                            int x1;
                            if (lnode1.getAkt().x < lnode2.getAkt().x) {
                                x1 = lnode1.getAkt().x - lnode1.getEdNode().getWidth();
                                x2 = lnode2.getAkt().x + lnode2.getEdNode().getWidth();
                            } else {
                                x1 = lnode1.getAkt().x + lnode1.getEdNode().getWidth();
                                x2 = lnode2.getAkt().x - lnode2.getEdNode().getWidth();
                            }
                            if (lnode1.getAkt().y < lnode2.getAkt().y) {
                                y1 = lnode1.getAkt().y - lnode1.getEdNode().getHeight();
                                y2 = lnode2.getAkt().y + lnode2.getEdNode().getHeight();
                            } else {
                                y1 = lnode1.getAkt().y + lnode1.getEdNode().getHeight();
                                y2 = lnode2.getAkt().y - lnode2.getEdNode().getHeight();
                            }
                            Point p1 = this.getRandomPosIfNeeded(x1, y1, lnode1);
                            Point p2 = this.getRandomPosIfNeeded(x2, y2, lnode2);
                            x1 = p1.x;
                            y1 = p1.y;
                            x2 = p2.x;
                            y2 = p2.y;
                            lnode1.setAkt(new Point(x1, y1));
                            lnode1.setOpt(lnode1.getAkt());
                            lnode2.setAkt(new Point(x2, y2));
                            lnode2.setOpt(lnode2.getAkt());
                            lnode1.unsetOverlap();
                            lnode2.unsetOverlap();
                        }
                    }
                }
                ++i3;
            }
            this.overlapscnt = this.lmetric.getNodeIntersect(nodes, true);
            --stop;
        }
        eg.updateNodePosLtoE(nodes);
        return true;
    }

    private boolean isFrozen(LayoutNode ln) {
        Type t;
        if (this.usePattern && this.layoutNode2Type != null && (t = this.layoutNode2Type.get(ln)) != null) {
            if (this.getLayoutPatternForType(t, "frozen_node") != null) {
                return true;
            }
            return ln.isFrozen();
        }
        return ln.isFrozen();
    }

    public boolean graphContainsNewNodes(EdGraph eg) {
        Vector<EdNode> nodes = eg.getNodes();
        Vector<EdNode> oldnodes = this.oldedgraph.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            EdNode ni = nodes.get(i);
            boolean found = false;
            int j = 0;
            while (j < oldnodes.size()) {
                EdNode nj = oldnodes.get(j);
                if (ni.getBasisNode().compareTo(nj.getBasisNode())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector<LayoutNode> getLayoutNodes(List<EdNode> nodes) {
        this.layoutNode2Type.clear();
        Vector<LayoutNode> ret = new Vector<LayoutNode>();
        int i = 0;
        while (i < nodes.size()) {
            EdNode n = nodes.get(i);
            if (n != null && n.getLNode() != null) {
                this.layoutNode2Type.put(n.getLNode(), n.getBasisNode().getType());
                ret.addElement(n.getLNode());
            }
            ++i;
        }
        return ret;
    }

    private Vector<LayoutArc> getLayoutArcs(List<EdArc> arcs) {
        Vector<LayoutArc> ret = new Vector<LayoutArc>();
        int i = 0;
        while (i < arcs.size()) {
            ret.addElement(arcs.get(i).getLArc());
            ++i;
        }
        return ret;
    }

    private Point getRandomPosIfNeeded(int xpos, int ypos, LayoutNode lnode) {
        int x = Math.max(xpos, lnode.getEdNode().getWidth());
        int y = Math.max(ypos, lnode.getEdNode().getHeight());
        if (x <= 0 || x - lnode.getEdNode().getWidth() < 0) {
            x = Math.max(x, lnode.getEdNode().getWidth());
        }
        if (y <= 0 || y - lnode.getEdNode().getHeight() < 0) {
            y = Math.max(y, lnode.getEdNode().getHeight());
        }
        int nn = 0;
        while (x > this.panel.width - lnode.getEdNode().getWidth() && nn < 6) {
            ++nn;
            x = Math.abs(x - Math.abs(this.random.nextInt(this.panel.width)));
        }
        nn = 0;
        while (y > this.panel.height - lnode.getEdNode().getHeight() && nn < 6) {
            ++nn;
            y = Math.abs(y - Math.abs(this.random.nextInt(this.panel.height)));
        }
        return new Point(x, y);
    }

    public void randomLayout(EdGraph eg, List<EdNode> nodes) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(nodes);
        int i = 0;
        while (i < lnodes.size()) {
            LayoutNode lnode = lnodes.get(i);
            if (!(!this.usePattern && lnode.isFrozenByDefault() && this.frozenPos || this.isFrozen(lnode))) {
                int x = Math.abs(this.random.nextInt(this.panel.width));
                int y = Math.abs(this.random.nextInt(this.panel.height));
                lnode.setAkt(new Point(x, y));
                lnode.setOpt(new Point(x, y));
            }
            ++i;
        }
        eg.updateNodePosLtoE(nodes);
    }

    public void makeRandomLayoutOfNodes(EdGraph eg, List<EdNode> nodes) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(nodes);
        int xdim = this.panel.width;
        int ydim = this.panel.height;
        int i = 0;
        while (i < lnodes.size()) {
            LayoutNode lnode = lnodes.get(i);
            if (!(!this.usePattern && lnode.isFrozenByDefault() && this.frozenPos || this.isFrozen(lnode) || lnode.getAge() != 0)) {
                int rdx = Math.abs(this.random.nextInt(xdim));
                int rdy = Math.abs(this.random.nextInt(ydim));
                int x = rdx % xdim;
                int y = rdy % ydim;
                if (x - lnode.getEdNode().getWidth() < 0) {
                    x = Math.max(x, lnode.getEdNode().getWidth());
                }
                if (y - lnode.getEdNode().getHeight() < 0) {
                    y = Math.max(y, lnode.getEdNode().getHeight());
                }
                if (this.usePattern) {
                    EdNode node = lnode.getEdNode();
                    Vector<EdArc> arcs = eg.getArcs();
                    int j = 0;
                    while (j < arcs.size()) {
                        EdArc arc = arcs.get(j);
                        if (arc.getSource().equals(node) || arc.getTarget().equals(node)) {
                            Vector<LayoutPattern> patterns = null;
                            if (arc.isElementOfTypeGraph()) {
                                patterns = this.getInheritancePattern(arc);
                            }
                            if (patterns == null) {
                                patterns = this.getLayoutPatternsForType(arc.getType().getBasisType());
                            }
                            int p = 0;
                            while (p < patterns.size()) {
                                LayoutPattern lp = patterns.get(p);
                                if (lp != null && lp.isEdgePattern()) {
                                    if (arc.getSource().equals(node)) {
                                        if (lp.isXOffset()) {
                                            x = arc.getTarget().getX() - lp.getOffset() * rdx % 200;
                                            x = Math.max(x, node.getWidth());
                                            x = Math.min(x, this.panel.width - node.getWidth() * 2);
                                        }
                                        if (lp.isYOffset()) {
                                            y = arc.getTarget().getY() - lp.getOffset() * rdy % 200;
                                            y = Math.max(y, node.getHeight());
                                            y = Math.max(y, this.panel.height - node.getHeight() * 2);
                                        }
                                    } else {
                                        if (lp.isXOffset()) {
                                            x = arc.getSource().getX() + lp.getOffset() * rdx % 200;
                                            x = Math.max(x, node.getWidth());
                                            x = Math.min(x, this.panel.width - node.getWidth() * 2);
                                        }
                                        if (lp.isYOffset()) {
                                            y = arc.getSource().getY() + lp.getOffset() * rdy % 200;
                                            y = Math.max(y, node.getHeight());
                                            y = Math.max(y, this.panel.height - node.getHeight() * 2);
                                        }
                                    }
                                }
                                ++p;
                            }
                        }
                        ++j;
                    }
                }
                lnode.setAkt(new Point(x, y));
                lnode.setOpt(new Point(x, y));
            }
            ++i;
        }
        eg.updateNodePosLtoE(nodes);
    }

    public void centreLayout(EdGraph eg, List<EdNode> nodes) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(nodes);
        int left = 0;
        int right = 0;
        int up = 0;
        int down = 0;
        int xmin = this.panel.width;
        int xmax = 0;
        int ymin = this.panel.height;
        int ymax = 0;
        int i = 0;
        while (i < lnodes.size()) {
            LayoutNode lnode = lnodes.get(i);
            if (lnode.getAkt().x < xmin) {
                xmin = lnode.getAkt().x;
                left = i;
            } else if (lnode.getAkt().x > xmax) {
                xmax = lnode.getAkt().x;
                right = i;
            }
            if (lnode.getAkt().y < ymin) {
                ymin = lnode.getAkt().y;
                up = i;
            } else if (lnode.getAkt().y < ymax) {
                ymax = lnode.getAkt().y;
                down = i;
            }
            ++i;
        }
        LayoutNode lnodeleft = lnodes.get(left);
        LayoutNode lnoderight = lnodes.get(right);
        LayoutNode lnodeup = lnodes.get(up);
        LayoutNode lnodedown = lnodes.get(down);
        int center = this.panel.width / 2;
        int leftdif = center - lnodeleft.getAkt().x;
        int rightdif = lnoderight.getAkt().x - center;
        center = this.panel.height / 2;
        int updif = center - lnodeup.getAkt().y;
        int downdif = lnodedown.getAkt().y - center;
        int x_change = (leftdif - rightdif) / 2;
        int y_change = (updif - downdif) / 2;
        int i2 = 0;
        while (i2 < lnodes.size()) {
            LayoutNode lnode = lnodes.get(i2);
            lnode.getAkt().x += x_change;
            lnode.getAkt().y += y_change;
            lnode.setOpt(new Point(lnode.getAkt()));
            ++i2;
        }
        eg.updateNodePosLtoE(nodes);
    }

    public void setPanelSize(Dimension dim) {
        if (this.panelChangable || this.panel.width == 0 || this.panel.height == 0) {
            this.panel = dim;
        }
    }

    public void allowChangePanelSize(boolean b) {
        this.panelChangable = b;
    }

    private Dimension getAverageNodeDim(List<EdNode> nodes) {
        float aw = 0.0f;
        float ah = 0.0f;
        if (!nodes.isEmpty()) {
            int i = 0;
            while (i < nodes.size()) {
                EdNode e = nodes.get(i);
                aw += (float)e.getWidth();
                ah += (float)e.getHeight();
                ++i;
            }
            aw /= (float)nodes.size();
            ah /= (float)nodes.size();
        }
        return new Dimension((int)aw, (int)ah);
    }

    public Dimension getNeededPanelSize(List<EdNode> nodes) {
        int sizetmp;
        int ans;
        int sizeX;
        Dimension averagenodesize = this.getAverageNodeDim(nodes);
        if (averagenodesize.width < 25 || averagenodesize.height < 25) {
            averagenodesize.width = 25;
            averagenodesize.height = 25;
        }
        if ((sizeX = (ans = averagenodesize.width >= averagenodesize.height ? averagenodesize.width : averagenodesize.height) * (sizetmp = 2 * (int)Math.sqrt(nodes.size()))) > 500 && sizeX < 1000) {
            sizeX = 1000;
        }
        int sizeY = sizeX * 3 / 4;
        Dimension neededpanelsize = new Dimension(sizeX, sizeY);
        if (neededpanelsize.width < 400 || neededpanelsize.height < 400) {
            neededpanelsize.width = 400;
            neededpanelsize.height = 400;
        }
        return neededpanelsize;
    }

    public void setOldEdGraph(EdGraph eg) {
        this.oldedgraph = eg;
    }

    public EdGraph getOldEdGraph() {
        return this.oldedgraph;
    }

    public void shockAging(EdGraph eg) {
        Vector<EdNode> nodes = eg.getNodes();
        Vector<EdNode> oldnodes = this.oldedgraph.getNodes();
        int i = 0;
        while (i < oldnodes.size()) {
            EdNode oldnode = oldnodes.get(i);
            if (oldnode.isInVectorByBasisNode(nodes) != -1) {
                int index;
                Vector<EdArc> arcsIn = this.oldedgraph.getIncomingArcs(oldnode);
                int j = 0;
                while (j < arcsIn.size()) {
                    EdNode oldnode2 = (EdNode)arcsIn.get(j).getSource();
                    index = oldnode2.isInVectorByBasisNode(nodes);
                    if (index != -1) {
                        EdNode node = nodes.get(index);
                        node.getLNode().setAge(Math.max(oldnode.getLNode().getAge(), node.getLNode().getAge()));
                    }
                    ++j;
                }
                Vector<EdArc> arcsOut = this.oldedgraph.getOutgoingArcs(oldnode);
                int j2 = 0;
                while (j2 < arcsOut.size()) {
                    EdNode oldnode2 = (EdNode)arcsOut.get(j2).getTarget();
                    index = oldnode2.isInVectorByBasisNode(nodes);
                    if (index != -1) {
                        EdNode node = nodes.get(index);
                        node.getLNode().setAge(Math.max(oldnode.getLNode().getAge(), node.getLNode().getAge()));
                    }
                    ++j2;
                }
            }
            ++i;
        }
    }

    public int getNodeIntersect(List<EdNode> nodes, boolean mark) {
        return this.lmetric.getNodeIntersect(nodes, mark);
    }

    public void setGeneralEdgeLength(int l) {
        this.gnrlEdgeLngth = l;
    }

    public int getGeneralEdgeLength() {
        return this.gnrlEdgeLngth;
    }

    public void setBeginTemperature(int t) {
        this.temperature = t;
    }

    public int getBeginTemperature() {
        return this.temperature;
    }

    public void setIterationCount(int count) {
        this.iters = count;
    }

    public int getIterationCount() {
        return this.iters;
    }

    public void setNodeIntersectionIterationCount(int count) {
        this.nodeIntersctnIters = count;
    }

    public void setEdgeIntersectionIterationCount(int count) {
        this.edgeIntersctnIters = count;
    }

    public boolean getJpgOutput() {
        return this.jpgOutput;
    }

    public void setJpgOutput(boolean b) {
        this.jpgOutput = b;
    }

    public boolean usePattern() {
        return this.usePattern;
    }

    public void setUsePattern(boolean b) {
        this.usePattern = b;
    }

    public void setFrozenByDefault(boolean b) {
        this.frozenPos = b;
    }

    public boolean isCentre() {
        return this.centre;
    }

    public void setCentre(boolean b) {
        this.centre = b;
    }

    public boolean getWriteMetricValues() {
        return this.writeMetrics;
    }

    public void setWriteMetricValues(boolean b) {
        this.writeMetrics = b;
    }

    public LayoutMetrics getLayoutMetrics() {
        return this.lmetric;
    }

    public void createLayoutPattern(String name, String pType, Type type, char offsetType, int offset) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, offsetType, offset);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String name, String pType, Type type, int length) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, length);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String name, String pType, Type type, boolean frozen) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, frozen);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void removeLayoutPattern(Type type) {
        if (this.layoutPatterns.contains(type)) {
            this.layoutPatterns.remove(type);
        }
    }

    public void removeLayoutPattern(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null || v.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            LayoutPattern lp = v.get(i);
            if (lp.getName().equals(patternName)) {
                v.remove(lp);
                --i;
            }
            ++i;
        }
        this.layoutPatterns.put(type, v);
    }

    public Hashtable<Type, Vector<LayoutPattern>> getLayoutPatterns() {
        return this.layoutPatterns;
    }

    public void clearLayoutPatterns() {
        this.layoutPatterns.clear();
    }

    public Vector<LayoutPattern> getLayoutPatternsForType(Type type) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
            this.layoutPatterns.put(type, v);
        }
        return v;
    }

    public LayoutPattern getLayoutPatternForType(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            return null;
        }
        int i = 0;
        while (i < v.size()) {
            LayoutPattern lp = v.get(i);
            if (lp.getName().equals(patternName)) {
                return lp;
            }
            ++i;
        }
        return null;
    }

    public void setLayoutPatterns(Hashtable<Type, Vector<LayoutPattern>> table) {
        this.layoutPatterns.clear();
        Enumeration<Type> keys = table.keys();
        while (keys.hasMoreElements()) {
            Type key = keys.nextElement();
            this.layoutPatterns.put(key, table.get(key));
        }
    }
}

