/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrManager;
import agg.attribute.AttrTypeMember;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueTuple;
import agg.cons.AtomConstraint;
import agg.util.Change;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.ArcTypeImpl;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.NodeTypeImpl;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.TypeGraphArc;
import agg.xt_basis.TypeImpl;
import agg.xt_basis.UndirectedTypeGraph;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TypeSet {
    public static final int UNDEFINED = -1;
    public static final int DISABLED = 0;
    public static final int ENABLED_INHERITANCE = 5;
    public static final int ENABLED = 10;
    public static final int ENABLED_MAX = 20;
    public static final int ENABLED_MAX_MIN = 30;
    public static final int ENABLED_MIN = 40;
    private static final Collection<TypeError> SUCCESS = new Vector<TypeError>(0);
    private final Vector<Type> types = new Vector();
    private boolean directed = true;
    private boolean parallel = true;
    private boolean emptyAttr = true;
    private final Type inheritanceType = new ArcTypeImpl();
    private final Vector<Arc> inheritanceArcs = new Vector();
    private TypeGraph typeGraph;
    private final AttrManager attrManager = AttrTupleManager.getDefaultManager();
    private boolean typeGraphIsProved = false;
    private int typeGraphLevel = 0;
    private boolean newTypeGraphObjectImported;
    protected String info = "";

    public TypeSet() {
    }

    public TypeSet(boolean directedArcs, boolean parallelArcs) {
        this.directed = directedArcs;
        this.parallel = parallelArcs;
    }

    public void dispose() {
        Type type;
        if (this.typeGraph != null) {
            this.typeGraph.dispose();
        }
        int j = 0;
        while (j < this.types.size()) {
            type = this.types.get(j);
            if (type.isArcType()) {
                type.dispose();
                this.types.remove(j);
                --j;
            }
            ++j;
        }
        j = 0;
        while (j < this.types.size()) {
            type = this.types.get(j);
            if (type.hasChild()) {
                List<Type> clan = type.getClan();
                int i = 0;
                while (i < clan.size()) {
                    this.removeInheritanceRelation(clan.get(i), type);
                    ++i;
                }
            }
            this.types.remove(j);
            type.dispose();
            --j;
            ++j;
        }
        j = 0;
        while (j < this.types.size()) {
            type = this.types.get(j);
            if (!type.hasChild()) {
                type.dispose();
                this.types.remove(j);
                --j;
            }
            ++j;
        }
        this.typeGraph = null;
    }

    public void finalize() {
    }

    public final Type createType() {
        Type aType = this.createType(false);
        return aType;
    }

    public final Type createType(boolean withAttributes) {
        if (withAttributes) {
            TypeImpl aType = new TypeImpl(this.attrManager.newType());
            this.types.add(aType);
            return aType;
        }
        TypeImpl aType = new TypeImpl();
        this.types.add(aType);
        return aType;
    }

    public final Type createNodeType(boolean withAttributes) {
        if (withAttributes) {
            NodeTypeImpl aType = new NodeTypeImpl(this.attrManager.newType());
            this.types.add(aType);
            return aType;
        }
        NodeTypeImpl aType = new NodeTypeImpl();
        this.types.add(aType);
        return aType;
    }

    public final Type createArcType(boolean withAttributes) {
        if (withAttributes) {
            ArcTypeImpl aType = new ArcTypeImpl(this.attrManager.newType());
            this.types.add(aType);
            return aType;
        }
        ArcTypeImpl aType = new ArcTypeImpl();
        this.types.add(aType);
        return aType;
    }

    public boolean isEmpty() {
        return this.types.size() == 0;
    }

    public final Enumeration<Type> getTypes() {
        return this.types.elements();
    }

    public final int getTypesCount() {
        return this.types.size();
    }

    public final List<Type> getTypeList() {
        return this.types;
    }

    public final Vector<Type> getTypesVec() {
        return this.types;
    }

    public final Vector<Arc> getInheritanceArcs() {
        return this.inheritanceArcs;
    }

    public final Type getInheritanceType() {
        return this.inheritanceType;
    }

    public boolean hasInheritance() {
        return !this.inheritanceArcs.isEmpty();
    }

    public boolean usesInheritance() {
        return !this.inheritanceArcs.isEmpty();
    }

    public Type getTypeByNameAndAdditionalRepr(String name, String addRepr) {
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.elementAt(i);
            if ((t.getStringRepr().equals(name) || "unnamed".equals(name) && "".equals(t.getStringRepr())) && t.getAdditionalRepr().equals(addRepr)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public Type getTypeByName(String name) {
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.elementAt(i);
            if (t.getStringRepr().equals(name) || "unnamed".equals(name) && "".equals(t.getStringRepr())) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public Type getTypeForName(String name) {
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.elementAt(i);
            if (t.getStringRepr().equals(name) || "unnamed".equals(name) && "".equals(t.getStringRepr())) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public Type getSimilarType(Type t) {
        int i = 0;
        while (i < this.types.size()) {
            Type ti = this.types.elementAt(i);
            if (ti.compareTo(t)) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    public Node getTypeGraphNode(Type t) {
        return t.getTypeGraphNodeObject();
    }

    public Arc getTypeGraphArcOLD(Type t, Type source, Type target) {
        if (this.typeGraph == null) {
            return null;
        }
        Arc result = null;
        Vector<Type> parents = source.getAllParents();
        int j = 0;
        while (j < parents.size()) {
            Type p = parents.get(j);
            for (Node n : this.typeGraph.getNodesSet()) {
                if (!n.getType().compareTo(p)) continue;
                for (Arc arc : n.getOutgoingArcsSet()) {
                    if (!arc.getType().compareTo(t) || !arc.getTarget().getType().isParentOf(target)) continue;
                    result = arc;
                }
            }
            ++j;
        }
        return result;
    }

    public Arc getTypeGraphArc(Type t, Type source, Type target) {
        if (this.typeGraph == null) {
            return null;
        }
        return this.typeGraph.getTypeGraphArc(t, source, target);
    }

    public Graph getTypeGraph() {
        return this.typeGraph;
    }

    public void setArcDirected(boolean b) {
        this.directed = b;
    }

    public boolean isArcDirected() {
        return this.directed;
    }

    public void setArcParallel(boolean b) {
        this.parallel = b;
    }

    public boolean isArcParallel() {
        return this.parallel;
    }

    public void setAllowEmptyAttr(boolean b) {
        this.emptyAttr = b;
    }

    public boolean isEmptyAttrAllowed() {
        return this.emptyAttr;
    }

    public void setTypeGraph(Graph tGraph) {
        if (tGraph != null) {
            if (!this.compareTo(tGraph.getTypeSet())) {
                throw new RuntimeException("Setting type graph failed. The specified graph does not use the same types.");
            }
            if (this != tGraph.getTypeSet()) {
                tGraph.setTypeSet(this);
            }
        }
        this.typeGraph = (TypeGraph)tGraph;
        this.typeGraphIsProved = false;
    }

    public void removeTypeGraph() {
        this.typeGraphLevel = 0;
        this.typeGraph = null;
    }

    public void destroyTypeGraph() {
        if (this.typeGraph != null) {
            this.typeGraphLevel = 0;
            this.typeGraph.dispose();
            this.typeGraph = null;
        }
    }

    public void adaptTypes(TypeSet otherTypes, boolean all) {
        this.doAdaptTypes(otherTypes.getTypes(), all);
    }

    public void adaptTypes(Enumeration<Type> otherTypes, boolean all) {
        this.doAdaptTypes(otherTypes, all);
    }

    private void doAdaptTypes(Enumeration<Type> otherTypes, boolean all) {
        Type type;
        Type similar;
        Vector<Pair<Type, Type>> v = new Vector<Pair<Type, Type>>(5);
        while (otherTypes.hasMoreElements()) {
            Type t = otherTypes.nextElement();
            similar = this.getTypeByNameAndAdditionalRepr(t.getStringRepr(), t.getAdditionalRepr());
            if (similar == null) {
                type = this.adoptType(t);
                int i = 0;
                while (i < t.getParents().size()) {
                    Type parType = t.getParents().get(i);
                    if (parType != null) {
                        v.add(new Pair<Type, Type>(type, parType));
                    }
                    ++i;
                }
                continue;
            }
            int i = 0;
            while (i < t.getParents().size()) {
                Type parType = t.getParents().get(i);
                if (parType != null) {
                    v.add(new Pair<Type, Type>(similar, parType));
                }
                ++i;
            }
            if (!all) continue;
            if (similar instanceof NodeTypeImpl) {
                ((NodeTypeImpl)similar).adaptTypeAttribute(t);
                continue;
            }
            if (!(similar instanceof ArcTypeImpl)) continue;
            ((ArcTypeImpl)similar).adaptTypeAttribute(t);
        }
        int i = 0;
        while (i < v.size()) {
            Pair pair = (Pair)v.get(i);
            type = (Type)pair.first;
            Type parent = (Type)pair.second;
            Type itsParent = this.getTypeByNameAndAdditionalRepr(parent.getName(), parent.getAdditionalRepr());
            if (itsParent != null) {
                this.addInheritanceRelation(type, itsParent);
            }
            ++i;
        }
        while (otherTypes.hasMoreElements()) {
            Type t = otherTypes.nextElement();
            similar = this.getTypeByNameAndAdditionalRepr(t.getStringRepr(), t.getAdditionalRepr());
            if (similar != null) {
                similar.adaptTypeAttribute(t);
                continue;
            }
            System.out.println(String.valueOf(this.getClass().getName()) + ".doAdaptTypes::  FAILED type:  " + t.getStringRepr());
        }
    }

    private void adaptTypeInheritance(Graph tGraph, Vector<Type> typesToAdapt, Hashtable<Type, Vector<Type>> oldInheritance) {
        if (tGraph == null || this.typeGraph == null || !this.typeGraph.getNodesSet().iterator().hasNext() || typesToAdapt.isEmpty()) {
            return;
        }
        for (Node n : this.typeGraph.getNodesSet()) {
            Node tn;
            Type t = n.getType();
            Type t1 = tGraph.getTypeSet().getTypeByName(t.getStringRepr());
            if (t1 == null || !t1.isNodeType() || !typesToAdapt.contains(t1) || (tn = tGraph.getTypeSet().getTypeGraphNode(t1)) == null) continue;
            if (!t1.getParents().isEmpty()) {
                int i = 0;
                while (i < t1.getParents().size()) {
                    Type p1i = t1.getParents().get(i);
                    this.addInheritanceRelation(t, this.getTypeByNameAndAdditionalRepr(p1i.getStringRepr(), p1i.getAdditionalRepr()));
                    ++i;
                }
            } else if (oldInheritance.get(t) != null) {
                Vector<Type> v = oldInheritance.get(t);
                int i = 0;
                while (i < v.size()) {
                    Type pi = v.get(i);
                    this.addInheritanceRelation(t, pi);
                    ++i;
                }
            } else {
                this.removeAllInheritanceRelations(t);
            }
            if (n.getAttribute() == null) continue;
            ((ValueTuple)n.getAttribute()).refreshParents();
        }
    }

    private void adaptTypeMultiplicity(Graph tGraph, Vector<Type> typesToAdapt) {
        Type t;
        if (tGraph == null || this.typeGraph == null || !this.typeGraph.getNodesSet().iterator().hasNext() || typesToAdapt.isEmpty()) {
            return;
        }
        for (Node n : this.typeGraph.getNodesSet()) {
            t = n.getType();
            Type t1 = tGraph.getTypeSet().getTypeByName(t.getStringRepr());
            if (t1 == null || !t1.isNodeType() || !typesToAdapt.contains(t1)) continue;
            if (t.getSourceMax() != -1 && (t1.getSourceMax() == -1 || t1.getSourceMax() > t.getSourceMax())) {
                t.setSourceMax(t1.getSourceMax());
            }
            if (t.getSourceMin() == -1 || t1.getSourceMin() == -1 && t1.getSourceMin() <= t.getSourceMin()) continue;
            t.setSourceMin(t1.getSourceMin());
        }
        for (Arc a : this.typeGraph.getArcsSet()) {
            TypeGraphArc subt1;
            Arc a1;
            t = a.getType();
            Type src_t = a.getSource().getType();
            Type tar_t = a.getTarget().getType();
            TypeGraphArc subt = t.getTypeGraphArc(src_t, tar_t);
            Type t1 = tGraph.getTypeSet().getTypeByNameAndAdditionalRepr(t.getName(), t.getAdditionalRepr());
            Type src_t1 = tGraph.getTypeSet().getTypeByNameAndAdditionalRepr(src_t.getName(), src_t.getAdditionalRepr());
            Type tar_t1 = tGraph.getTypeSet().getTypeByNameAndAdditionalRepr(tar_t.getName(), tar_t.getAdditionalRepr());
            if (t1 == null || src_t1 == null || tar_t1 == null || !typesToAdapt.contains(t1) || (a1 = this.getTypeGraphArc(t1, src_t1, tar_t1)) == null || (subt1 = t1.getTypeGraphArc(src_t1, tar_t1)) == null) continue;
            if (subt.getSourceMin() != -1 && (subt1.getSourceMin() != -1 || subt1.getSourceMin() > subt.getSourceMin())) {
                subt.setSourceMin(subt1.getSourceMin());
            }
            if (subt.getSourceMax() != -1 && (subt1.getSourceMax() != -1 || subt1.getSourceMax() > subt.getSourceMax())) {
                subt.setSourceMax(subt1.getSourceMax());
            }
            if (subt.getTargetMin() != -1 && (subt1.getTargetMin() != -1 || subt1.getTargetMin() > subt.getTargetMin())) {
                subt.setTargetMin(subt1.getTargetMin());
            }
            if (subt.getTargetMax() == -1 || subt1.getTargetMax() == -1 && subt1.getTargetMax() <= subt.getTargetMax()) continue;
            subt.setTargetMax(subt1.getTargetMax());
        }
    }

    private void adaptClans() {
        if (this.typeGraph == null || !this.typeGraph.getNodesSet().iterator().hasNext()) {
            return;
        }
        for (Node n : this.typeGraph.getNodesSet()) {
            Node cn;
            Type t = n.getType();
            List<Type> clan = t.getClan();
            Vector<Node> clanNodes = new Vector<Node>(5);
            int i = 0;
            while (i < clan.size()) {
                Type ct = clan.get(i);
                ct.checkDoubleAttributeType();
                cn = this.typeGraph.getTypeSet().getTypeGraphNode(ct);
                if (cn != null) {
                    clanNodes.add(cn);
                }
                ++i;
            }
            Vector<Arc> clanArcs = new Vector<Arc>(5);
            int i2 = 0;
            while (i2 < clanNodes.size()) {
                cn = (Node)clanNodes.get(i2);
                for (Arc a : cn.getIncomingArcsSet()) {
                    if (a.isInheritance() || clanArcs.contains(a) || (Node)a.getSource() == n || !clanNodes.contains(a.getSource())) continue;
                    clanArcs.add(a);
                }
                if (this.directed) {
                    for (Arc a : cn.getOutgoingArcsSet()) {
                        if (a.isInheritance() || clanArcs.contains(a) || (Node)a.getTarget() == n || !clanNodes.contains(a.getTarget())) continue;
                        clanArcs.add(a);
                    }
                }
                ++i2;
            }
            Vector<Arc> arcsToDelete = new Vector<Arc>(5);
            int nn = clanArcs.size();
            int k = 0;
            while (nn > 0 && k < nn) {
                Arc a;
                a = (Arc)clanArcs.get(k);
                boolean found = false;
                int j = k + 1;
                while (j < clanArcs.size()) {
                    Arc aj = (Arc)clanArcs.get(j);
                    if (aj.getType().getName().equals(a.getType().getName()) && (a.getSource().getType().isParentOf(aj.getSource().getType()) && a.getTarget().getType().isParentOf(aj.getTarget().getType()) || aj.getSource().getType().isParentOf(a.getSource().getType()) && aj.getTarget().getType().isParentOf(a.getTarget().getType()))) {
                        found = true;
                        arcsToDelete.add(aj);
                        clanArcs.remove(aj);
                        --j;
                    }
                    ++j;
                }
                if (found) {
                    arcsToDelete.add(a);
                }
                nn = clanArcs.size();
                ++k;
            }
            Hashtable table = new Hashtable(5, 5.0f);
            int i3 = 0;
            while (i3 < arcsToDelete.size()) {
                Arc a = (Arc)arcsToDelete.get(i3);
                TypeGraphArc subt = t.getTypeGraphArc(a.getSource().getType(), a.getTarget().getType());
                if (subt != null) {
                    Vector<Pair<Object, Object>> tmp = new Vector<Pair<Object, Object>>(3);
                    Pair<Type, Type> srcTtarT = new Pair<Type, Type>(a.getSource().getType(), a.getTarget().getType());
                    Pair<Integer, Integer> srcMult = new Pair<Integer, Integer>(subt.getSourceMin(), subt.getSourceMax());
                    Pair<Integer, Integer> tarMult = new Pair<Integer, Integer>(subt.getTargetMin(), subt.getTargetMax());
                    tmp.add(srcTtarT);
                    tmp.add(srcMult);
                    tmp.add(tarMult);
                    table.put(a.getType(), tmp);
                }
                try {
                    this.typeGraph.destroyArc(a, true, false);
                }
                catch (TypeException tmp) {
                    // empty catch block
                }
                ++i3;
            }
            if (table.isEmpty()) continue;
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                Type arcT = (Type)keys.nextElement();
                Vector tmp = (Vector)table.get(arcT);
                Pair srcTtarT = (Pair)tmp.get(0);
                Pair srcMult = (Pair)tmp.get(1);
                Pair tarMult = (Pair)tmp.get(2);
                Type srcT = (Type)srcTtarT.first;
                Type tarT = (Type)srcTtarT.second;
                Node src = this.typeGraph.getTypeSet().getTypeGraphNode(srcT);
                Node tar = this.typeGraph.getTypeSet().getTypeGraphNode(tarT);
                try {
                    this.typeGraph.createArc(arcT, src, tar);
                    TypeGraphArc subt = arcT.getTypeGraphArc(src.getType(), tar.getType());
                    subt.setSourceMin((Integer)srcMult.first);
                    subt.setSourceMax((Integer)srcMult.second);
                    subt.setTargetMin((Integer)tarMult.first);
                    subt.setTargetMax((Integer)tarMult.second);
                }
                catch (TypeException exc) {
                    System.out.println("TypeSet.adaptClans::   TypeException   for: " + arcT.getName());
                }
            }
        }
    }

    public boolean importTypeGraph(Graph tGraph, boolean rewrite) {
        boolean conflicting;
        Vector<Type> differentAttribute = new Vector<Type>(5);
        Vector<Type> differentInheritance = new Vector<Type>(5);
        Hashtable<Type, Vector<Type>> oldInheritance = new Hashtable<Type, Vector<Type>>(5, 5.0f);
        Vector<Type> differentMultiplicity = new Vector<Type>(5);
        Vector<Type> typesToAdd = new Vector<Type>(5);
        boolean bl = conflicting = !this.compareTypes(tGraph.getTypeSet(), differentAttribute, differentInheritance, differentMultiplicity, typesToAdd);
        if (conflicting && this.typeGraphLevel != 0) {
            return false;
        }
        boolean result = true;
        boolean all = true;
        if (this.typeGraph != null) {
            if (!rewrite) {
                if (!conflicting) {
                    this.adaptTypes(tGraph.getTypeSet(), !all);
                    if (this.typeGraph.addCopyOfGraph(tGraph)) {
                        this.refreshInheritanceArcs();
                    } else {
                        System.out.println("Import Type Graph failed! Something gone wrong!");
                        result = false;
                    }
                } else {
                    System.out.println("Import Type Graph failed \nbecause there are conflicts between the type graph objects!");
                    result = false;
                }
            } else if (rewrite) {
                int i = 0;
                while (i < differentInheritance.size()) {
                    Type other_t = differentInheritance.get(i);
                    Type t = this.getTypeByNameAndAdditionalRepr(other_t.getStringRepr(), other_t.getAdditionalRepr());
                    Vector<GraphObject> v = this.typeGraph.getElementsOfTypeAsVector(t);
                    if (!v.isEmpty() && v.firstElement().isNode() && !t.getParents().isEmpty()) {
                        oldInheritance.put(t, t.getParents());
                    }
                    ++i;
                }
                if (this.typeGraph.addCopyOfGraph(tGraph)) {
                    this.adaptTypeInheritance(tGraph, differentInheritance, oldInheritance);
                    this.adaptTypeMultiplicity(tGraph, differentMultiplicity);
                    this.adaptClans();
                    this.adaptTypeAttribute(differentAttribute);
                } else {
                    result = false;
                    System.out.println("Import Type Graph failed! Something gone wrong!");
                }
            }
        } else if (!rewrite) {
            if (!conflicting) {
                this.adaptTypes(tGraph.getTypeSet(), !all);
                this.typeGraph = (TypeGraph)tGraph.copy(this);
                this.typeGraph.setName("TypeGraph");
                this.refreshInheritanceArcs();
            } else {
                System.out.println("Import Type Graph failed \nbecause there are conflicts between the type graph objects!");
                result = false;
            }
        } else {
            this.createTypeGraph();
            if (this.typeGraph.addCopyOfGraph(tGraph)) {
                this.adaptTypeAttribute(differentAttribute);
            } else {
                System.out.println("Import Type Graph failed! Something gone wrong!");
                result = false;
            }
        }
        return result;
    }

    public Graph createTypeGraph() {
        this.typeGraph = this.directed ? new TypeGraph(this) : new UndirectedTypeGraph(this);
        this.typeGraph.setName("TypeGraph");
        this.typeGraph.setKind("TG");
        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
        this.typeGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
        this.typeGraphIsProved = false;
        this.checkTypeGraph();
        return this.typeGraph;
    }

    public Graph generateMinimalTypeGraph(List<Node> nodes, List<Arc> edges) {
        int i;
        if (this.typeGraph == null) {
            this.typeGraph = (TypeGraph)this.createTypeGraph();
        } else if (!this.typeGraph.isEmpty()) {
            return this.typeGraph;
        }
        this.typeGraphLevel = 0;
        if (nodes != null && nodes.isEmpty()) {
            i = 0;
            while (i < nodes.size()) {
                Node n = nodes.get(i);
                try {
                    this.typeGraph.createNode(n.getType());
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.types.size()) {
                Type t = this.types.get(i);
                if (t.isNodeType()) {
                    try {
                        this.typeGraph.createNode(t);
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        this.refreshInheritance();
        if (edges != null && !edges.isEmpty()) {
            i = 0;
            while (i < edges.size()) {
                Arc a = edges.get(i);
                List<Node> vsrc = this.typeGraph.getNodes(a.getSource().getType());
                List<Node> vtar = this.typeGraph.getNodes(a.getTarget().getType());
                if (vsrc != null && vtar != null) {
                    GraphObject src = vsrc.get(0);
                    GraphObject tar = vtar.get(0);
                    if (this.typeGraph.getArcs(a.getType(), src, tar) == null) {
                        try {
                            this.typeGraph.createArc(a.getType(), (Node)src, (Node)tar);
                        }
                        catch (TypeException typeException) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        this.adaptClans();
        return this.typeGraph;
    }

    public Graph extendTypeGraph(Iterator<Node> nodes, Iterator<Arc> edges) {
        Type t;
        if (this.typeGraph == null) {
            this.typeGraph = (TypeGraph)this.createTypeGraph();
        }
        this.typeGraphLevel = 0;
        if (nodes != null) {
            while (nodes.hasNext()) {
                Node n = nodes.next();
                t = n.getType();
                if (this.typeGraph.getNodes(t) != null) continue;
                try {
                    this.typeGraph.createNode(t);
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
        } else {
            int i = 0;
            while (i < this.types.size()) {
                t = this.types.get(i);
                if (t.isNodeType() && this.typeGraph.getNodes(t) == null) {
                    try {
                        this.typeGraph.createNode(t);
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        this.refreshInheritance();
        if (edges != null) {
            while (edges.hasNext()) {
                GraphObject tar;
                GraphObject src;
                Arc a = edges.next();
                t = a.getType();
                if (t.getName().equals("next")) {
                    System.out.println("######  next");
                }
                List<Node> vsrc = this.typeGraph.getNodes(a.getSource().getType());
                List<Node> vtar = this.typeGraph.getNodes(a.getTarget().getType());
                if (vsrc == null || vtar == null || this.typeGraph.getArcs(t, src = (GraphObject)vsrc.get(0), tar = (GraphObject)vtar.get(0)) != null) continue;
                try {
                    this.typeGraph.createArc(t, (Node)src, (Node)tar);
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
        }
        this.adaptClans();
        return this.typeGraph;
    }

    public void clearTypeGraph() {
        if (this.typeGraph != null && !this.typeGraph.isEmpty() && this.typeGraphLevel == 0) {
            for (Node n : this.typeGraph.getNodesSet()) {
                this.removeAllInheritanceRelations(n.getType());
            }
            this.inheritanceArcs.clear();
            this.typeGraph.clear();
        }
    }

    public Type addType(Type aType) {
        if (aType.isNodeType()) {
            if (!aType.hasTypeGraphNode()) {
                this.types.add(aType);
                return aType;
            }
            return this.adoptType(aType);
        }
        if (aType.isArcType()) {
            if (!aType.isTypeGraphObjectDefined()) {
                this.types.add(aType);
                return aType;
            }
            return this.adoptType(aType);
        }
        return null;
    }

    public Type adoptClan(Type aType) {
        if (this.containsType(aType)) {
            return aType;
        }
        Type t = this.getSimilarType(aType);
        if (t == null) {
            t = this.addType(aType);
        }
        if (t.getAdditionalRepr().indexOf("[NODE]") == -1) {
            t.setAdditionalRepr("[NODE]");
        }
        if (!aType.getParents().isEmpty()) {
            int i = 0;
            while (i < aType.getParents().size()) {
                Type p = aType.getParents().get(i);
                Type type = this.adoptClan(p);
                t.addParent(type);
                ++i;
            }
        }
        return t;
    }

    public Type adoptType(Type t) {
        Type type = null;
        boolean failed = false;
        DeclTuple otherTuple = (DeclTuple)t.getAttrType();
        if (otherTuple != null) {
            if (t.isNodeType()) {
                type = new NodeTypeImpl(this.attrManager.newType());
            } else if (t.isArcType()) {
                type = new ArcTypeImpl(this.attrManager.newType());
            }
            if (type != null) {
                DeclTuple declTuple = (DeclTuple)type.getAttrType();
                int i = 0;
                while (i < otherTuple.getSize()) {
                    AttrTypeMember dmnew;
                    DeclMember dm = (DeclMember)otherTuple.getMemberAt(i);
                    if (dm.getHoldingTuple() == otherTuple && (dmnew = declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherTuple.getTypeAsString(i), otherTuple.getNameAsString(i))) == null) {
                        failed = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (t.isNodeType()) {
            type = new NodeTypeImpl();
        } else if (t.isArcType()) {
            type = new ArcTypeImpl();
        }
        if (type != null && !failed) {
            type.setAbstract(t.isAbstract());
            type.setStringRepr(t.getStringRepr());
            type.setAdditionalRepr(t.getAdditionalRepr());
            this.types.add(type);
        }
        return type;
    }

    private boolean adaptTypeAttribute(Type type) {
        Type myType = this.getTypeByName(type.getStringRepr());
        if (myType != null && (type.isNodeType() && myType.isNodeType() || type.isArcType() && myType.isArcType())) {
            myType.adaptTypeAttribute(type);
        }
        return true;
    }

    private void adaptTypeAttribute(Vector<Type> typesToAdapt) {
        int i = 0;
        while (i < typesToAdapt.size()) {
            Type other_t = typesToAdapt.get(i);
            this.adaptTypeAttribute(other_t);
            ++i;
        }
    }

    public boolean containsType(Type type) {
        return this.types.contains(type);
    }

    public void destroyType(Type type) throws TypeException {
        List<Type> clan = this.getClan(type);
        int i = 0;
        while (i < clan.size()) {
            Type t = clan.get(i);
            this.removeInheritanceRelation(t, type);
            ++i;
        }
        this.types.remove(type);
        type.dispose();
    }

    public AttrManager getAttrManager() {
        return this.attrManager;
    }

    TypeError checkTypeInTypeGraph(Graph g, Type edgeType, GraphObject src, GraphObject tar, int tgl) {
        return edgeType.checkIfEdgeCreatable(g, (Node)src, (Node)tar, tgl);
    }

    TypeError checkTypeInTypeGraph(Arc arc, int tgl) {
        if (!arc.getType().hasTypeGraphArc()) {
            return new TypeError(21, "The type graph does not contain an edge type with name \"" + arc.getType().getName() + "\" \nbetween node type \"" + arc.getSourceType().getName() + "\" and \"" + arc.getTargetType().getName() + "\"" + "\n ( see graph:  " + arc.getContext().getName() + " ).", arc, arc.getType());
        }
        return arc.getType().check(arc, tgl);
    }

    TypeError checkTypeInTypeGraph(Node node, int tgl) {
        if (node.getType().getTypeGraphNodeObject() == null) {
            return new TypeError(21, "The type graph does not contain a node type with name \"" + node.getType().getName() + "\"" + "\n ( see graph:  " + node.getContext().getName() + " ).", node, node.getType());
        }
        return this.checkMultiplicity(node, tgl);
    }

    public Collection<TypeError> checkTypeGraph() {
        Type actType;
        this.typeGraphIsProved = false;
        Vector<TypeError> errors = new Vector<TypeError>();
        if (this.typeGraph == null) {
            errors.add(new TypeError(1, "The current grammar does not contain a type graph."));
            return errors;
        }
        Enumeration<Type> enTypes = this.types.elements();
        while (enTypes.hasMoreElements()) {
            actType = enTypes.nextElement();
            actType.disableTypeGraphObject();
        }
        Enumeration<GraphObject> en = this.typeGraph.getElements();
        while (en.hasMoreElements()) {
            GraphObject actGraphObject = en.nextElement();
            actType = actGraphObject.getType();
            if (actType.addTypeGraphObject(actGraphObject)) continue;
            TypeError newError = actGraphObject instanceof Node ? new TypeError(3, "The type graph contains already a node type \"" + actType.getName() + "\".", actGraphObject, actType) : new TypeError(3, "The type graph contains already an edge type \"" + actType.getName() + "\" between node types \"" + ((Arc)actGraphObject).getSource().getType().getName() + "\" and \"" + ((Arc)actGraphObject).getTarget().getType().getName() + "\".", actGraphObject, actType);
            newError.setContainingGraph(this.typeGraph);
            errors.add(newError);
        }
        if (errors.isEmpty()) {
            this.typeGraphIsProved = true;
        }
        return errors;
    }

    public TypeError addTypeGraphObject(GraphObject typeObject) {
        if (!this.typeGraphIsProved) {
            return null;
        }
        Type actType = typeObject.getType();
        if (!actType.addTypeGraphObject(typeObject)) {
            TypeError error;
            if (typeObject instanceof Node) {
                error = new TypeError(3, "The type graph contains already a type node \"" + actType.getName() + "\".", typeObject, actType);
                error.setContainingGraph(this.typeGraph);
            } else {
                error = new TypeError(3, "The type graph contains already a type edge \"" + actType.getName() + "\" between the type node \"" + ((Arc)typeObject).getSource().getType().getName() + "\" and the type node \"" + ((Arc)typeObject).getTarget().getType().getName() + "\".", typeObject, actType);
                error.setContainingGraph(this.typeGraph);
            }
            return error;
        }
        return null;
    }

    public TypeError checkInheritanceValid(Type child, Type parent) {
        return this.checkInheritanceValidity(child, parent);
    }

    public TypeError checkInheritanceValidity(Type child, Type parent) {
        if (this.typeGraph == null || parent == null) {
            return null;
        }
        if (child == parent) {
            TypeError error = new TypeError(26, "reflexive inheritance relation is not allowed");
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        if (child.getAllParents().contains(parent)) {
            TypeError error = new TypeError(26, "this parent is already an ancestor");
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        Vector<Type> grandpars = parent.getParents();
        int i = 0;
        while (i < grandpars.size()) {
            Type pi = (Type)grandpars.get(i);
            if (pi.getAllParents().contains(child)) {
                TypeError error = new TypeError(26, "cyclic inheritance relation is not allowed");
                error.setContainingGraph(this.typeGraph);
                return error;
            }
            ++i;
        }
        this.removeDoubleAttributes(child, parent);
        return null;
    }

    private void removeDoubleAttributes(Type child, Type parent) {
        if (child.getAttrType() == null || parent.getAttrType() == null) {
            return;
        }
        DeclTuple myDecl = (DeclTuple)child.getAttrType();
        DeclTuple otherDecl = (DeclTuple)parent.getAttrType();
        int i = 0;
        while (i < otherDecl.getNumberOfEntries()) {
            DeclMember mem = (DeclMember)otherDecl.getMemberAt(i);
            if (myDecl.isLegalName(mem.getName()) > 0 && mem.getHoldingTuple() != myDecl.getMemberAt(mem.getName()).getHoldingTuple()) {
                myDecl.deleteMemberAt(mem.getName());
            }
            ++i;
        }
    }

    public boolean isInheritanceArc(Arc a) {
        return a.getType() == this.inheritanceType && this.inheritanceArcs.contains(a);
    }

    public Arc addValidInheritanceRelation(Type child, Type parent) {
        if (this.typeGraph == null) {
            return null;
        }
        child.addParent(parent);
        Node childNode = null;
        Node parentNode = null;
        for (Node currentNode : this.typeGraph.getNodesSet()) {
            if (currentNode.getType() == child) {
                childNode = currentNode;
            } else if (currentNode.getType() == parent) {
                parentNode = currentNode;
            }
            if (childNode != null && parentNode != null) break;
        }
        Arc inheritArc = null;
        if (childNode != null && parentNode != null) {
            inheritArc = new Arc(null, this.inheritanceType, childNode, parentNode, this.typeGraph);
            inheritArc.setInheritance(true);
            Vector<Arc> inheritedArcs = this.getInheritedArcs(parent);
            int i = 0;
            while (i < inheritedArcs.size()) {
                GraphObject a = inheritedArcs.get(i);
                a.getType().addTypeGraphObject(a);
                ++i;
            }
            childNode.propagateAttrValueFromParentNode();
            this.inheritanceArcs.add(inheritArc);
            this.refreshInheritanceClan(child, parent, true);
            this.checkOtherDirectParents(child, parent);
            this.typeGraph.extendTypeObjectsMap(child);
            this.typeGraph.propagateChange(new Change(10, inheritArc));
        }
        return inheritArc;
    }

    public TypeError addInheritanceRelation(Type child, Type parent) {
        TypeError error = this.checkInheritanceValidity(child, parent);
        if (error == null) {
            if (this.addValidInheritanceRelation(child, parent) == null) {
                String childName = child == null ? "NULL" : child.getName();
                String parentName = parent == null ? "NULL" : parent.getName();
                return new TypeError(28, "The inharitance relation from type:  " + childName + "  to  " + parentName + "  " + "is not possible.");
            }
            return null;
        }
        return error;
    }

    private void checkOtherDirectParents(Type child, Type p) {
        int i = 1;
        while (i < p.getAllParents().size()) {
            Type pi = p.getAllParents().get(i);
            if (child.getParents().contains(pi)) {
                this.removeInheritanceRelation(child, pi);
            }
            ++i;
        }
    }

    public void removeAllInheritanceRelations(Type child) {
        while (!child.getParents().isEmpty()) {
            Type p = child.getParents().firstElement();
            this.removeInheritanceRelation(child, p);
        }
    }

    public boolean removeInheritanceRelation(Type child, Type parent) {
        if (this.typeGraph == null || parent == null || child == parent) {
            return false;
        }
        if (child.getParents().contains(parent)) {
            Arc inheritArc = null;
            int i = 0;
            while (i < this.inheritanceArcs.size()) {
                Arc currentArc = this.inheritanceArcs.get(i);
                if (currentArc.getSource().getType() == child && currentArc.getTarget().getType() == parent) {
                    inheritArc = currentArc;
                    break;
                }
                ++i;
            }
            if (inheritArc != null) {
                Vector<Arc> inheritedArcs = this.getInheritedArcs(inheritArc.getTarget().getType());
                int i2 = 0;
                while (i2 < inheritedArcs.size()) {
                    Arc a = inheritedArcs.get(i2);
                    if (a.getSource().getType() == child && !a.getType().removeTypeGraphObject(a)) {
                        return false;
                    }
                    ++i2;
                }
                this.inheritanceArcs.remove(inheritArc);
                child.removeParent(parent);
                this.refreshInheritanceClan(child, parent, false);
                this.typeGraph.propagateChange(new Change(12, inheritArc));
                inheritArc.dispose();
                return true;
            }
            child.removeParent(parent);
            this.refreshInheritanceClan(child, parent, false);
            return true;
        }
        return false;
    }

    public void refreshInheritanceArcs() {
        if (this.typeGraph == null) {
            return;
        }
        Vector<Arc> oldInheritanceArcs = new Vector<Arc>(this.inheritanceArcs.size());
        oldInheritanceArcs.addAll(this.inheritanceArcs);
        this.inheritanceArcs.clear();
        for (Node currentNode : this.typeGraph.getNodesSet()) {
            Type currentType = currentNode.getType();
            int i = 0;
            while (i < currentType.getParents().size()) {
                Type parentType = currentType.getParents().get(i);
                for (Node parentNode : this.typeGraph.getNodesSet()) {
                    if (parentNode.getType() != parentType) continue;
                    boolean found = false;
                    int j = 0;
                    while (j < oldInheritanceArcs.size()) {
                        Arc inh = (Arc)oldInheritanceArcs.get(j);
                        if (inh.getSource() == currentNode && inh.getTarget() == parentNode) {
                            found = true;
                            this.inheritanceArcs.add(inh);
                            break;
                        }
                        ++j;
                    }
                    if (found) continue;
                    Arc inheritArc = new Arc(null, this.inheritanceType, currentNode, parentNode, null);
                    inheritArc.setInheritance(true);
                    this.inheritanceArcs.add(inheritArc);
                }
                ++i;
            }
        }
        oldInheritanceArcs.clear();
    }

    public Vector<Arc> getInheritedArcs(Type parentType) {
        Vector<Arc> inheritedArcs = new Vector<Arc>();
        Vector<Type> allparents = parentType.getAllParents();
        int i = 0;
        while (i < allparents.size()) {
            Type p = allparents.get(i);
            Node go = p.getTypeGraphNodeObject();
            if (go != null) {
                for (Arc a : go.getOutgoingArcsSet()) {
                    if (a.isInheritance()) continue;
                    inheritedArcs.add(a);
                }
                for (Arc a : go.getIncomingArcsSet()) {
                    if (a.isInheritance()) continue;
                    inheritedArcs.add(a);
                }
            }
            ++i;
        }
        return inheritedArcs;
    }

    public List<Type> getClan(Type t) {
        return t.getClan();
    }

    public boolean isIncomingArcOfClan(Type aTypeOfClan, Type arcType, Type sourceNodeType) {
        if (this.typeGraph != null) {
            String keystr = String.valueOf(sourceNodeType.convertToKey()) + arcType.convertToKey() + aTypeOfClan.convertToKey();
            HashSet<GraphObject> list = this.typeGraph.getTypeObjectsMap().get(keystr);
            if (list != null && !list.isEmpty() && ((Arc)list.iterator().next()).getSource().getType().isInClanOf(sourceNodeType)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOutgoingArcOfClan(Type aTypeOfClan, Type arcType, Type targetNodeType) {
        if (this.typeGraph != null) {
            String keystr = String.valueOf(aTypeOfClan.convertToKey()) + arcType.convertToKey() + targetNodeType.convertToKey();
            HashSet<GraphObject> list = this.typeGraph.getTypeObjectsMap().get(keystr);
            if (list != null && !list.isEmpty() && ((Arc)list.iterator().next()).getSource().getType().isInClanOf(targetNodeType)) {
                return true;
            }
        }
        return false;
    }

    private void refreshInheritanceClan(Type t) {
        this.refreshInheritanceClan(t, null, false);
    }

    private void refreshInheritanceClan(Type t, Type p, boolean afterAdd) {
        List<Type> clan = this.getClan(t);
        int i = 0;
        while (i < clan.size()) {
            Type child = clan.get(i);
            if (child != t) {
                if (p != null && child.getParents().contains(p)) {
                    this.removeInheritanceRelation(child, p);
                }
                if (child.getAttrType() != null) {
                    DeclTuple myDeclTuple = (DeclTuple)child.getAttrType();
                    if (afterAdd) {
                        myDeclTuple.refreshParentsAfterAdd();
                    } else {
                        myDeclTuple.refreshParentsAfterRemove();
                    }
                }
            }
            ++i;
        }
    }

    public void refreshInheritanceClans() {
        int j = 0;
        while (j < this.types.size()) {
            Type t = this.types.get(j);
            this.refreshInheritanceClan(t);
            ++j;
        }
    }

    public void refreshInheritance() {
        int j = 0;
        while (j < this.types.size()) {
            Type t = this.types.get(j);
            this.refreshInheritanceClan(t);
            ++j;
        }
        this.refreshInheritanceArcs();
    }

    public TypeError removeTypeGraphObject(GraphObject tgo) {
        Type actType = tgo.getType();
        if (!actType.removeTypeGraphObject(tgo)) {
            if (this.typeGraphLevel == 0) {
                return null;
            }
            if (!(tgo instanceof Arc) || !this.inheritanceArcs.contains(tgo)) {
                TypeError error = new TypeError(4, "\nThe type \"" + actType.getName() + "\" cannot be deleted from the type graph," + "\nbecause at least one graph object uses it." + "\nPlease disable the type graph before delete a type.", tgo, actType);
                error.setContainingGraph(this.typeGraph);
                return error;
            }
        }
        return null;
    }

    public TypeError forceRemoveTypeGraphObject(GraphObject tgo) {
        Type actType = tgo.getType();
        if (!actType.removeTypeGraphObject(tgo, true)) {
            if (this.typeGraphLevel == 0) {
                return null;
            }
            if (!(tgo instanceof Arc) || !this.inheritanceArcs.contains(tgo)) {
                TypeError error = new TypeError(4, "\nThe type \"" + actType.getName() + "\" cannot be deleted from the type graph," + "\nbecause at least one graph object uses it." + "\nPlease disable the type graph before delete a type.", tgo, actType);
                error.setContainingGraph(this.typeGraph);
                return error;
            }
        }
        return null;
    }

    public Collection<TypeError> checkType(Graph graph) {
        Vector<TypeError> errors = new Vector<TypeError>();
        this.checkTypeSet(graph, errors);
        if (this.typeGraph == null || this.typeGraphLevel <= 10) {
            return errors;
        }
        if (graph.isEmpty() && this.typeGraphLevel <= 20) {
            return errors;
        }
        int actTypeGraphLevel = this.typeGraphLevel;
        if (!graph.isCompleteGraph() && this.typeGraphLevel >= 30) {
            actTypeGraphLevel = 20;
        }
        this.checkNodesOverTypeGraph(graph, actTypeGraphLevel, errors);
        this.checkArcsOverTypeGraph(graph, actTypeGraphLevel, errors);
        return errors;
    }

    private Vector<TypeError> checkTypeSet(Graph graph, Vector<TypeError> errors) {
        if (!this.equals(graph.getTypeSet())) {
            for (GraphObject graphObject : graph.getArcsSet()) {
                if (this.types.contains(graphObject.getType())) continue;
                errors.add(new TypeError(11, "The edge type \"" + graphObject.getType().getName() + "\" used is not part of the grammars type set ( graph \"" + graph.getName() + "\" ).", graphObject.getType()));
            }
            for (GraphObject graphObject : graph.getNodesSet()) {
                if (this.types.contains(graphObject.getType())) continue;
                errors.add(new TypeError(11, "The node type \"" + graphObject.getType().getName() + "\" used is not part of the grammars type set ( graph \"" + graph.getName() + "\" ).", graphObject.getType()));
            }
        }
        return errors;
    }

    public TypeError canCreateNode(Graph g, Type nodeType, int currentTypeGraphLevel) {
        if (currentTypeGraphLevel >= 20) {
            Vector<Type> parents = nodeType.getAllParents();
            int i = 0;
            while (i < parents.size()) {
                List<String> arctypes;
                Type t = (Type)parents.get(i);
                int count = 0;
                int maxValue = t.getSourceMax();
                HashSet<GraphObject> set = g.getTypeObjectsMap().get(nodeType.convertToKey());
                if (set != null && !set.isEmpty()) {
                    count = g.getTypeObjectsMap().get(nodeType.convertToKey()).size();
                }
                if (maxValue > 0 && count + 1 > maxValue) {
                    TypeError actError = new TypeError(25, "Too many nodes of type \"" + t.getName() + "\".\nThere are only " + maxValue + " allowed.", t);
                    actError.setContainingGraph(g);
                    return actError;
                }
                if (currentTypeGraphLevel == 30 && (arctypes = this.nodeTypeRequiresArcType(nodeType, currentTypeGraphLevel)) != null && arctypes.size() > 0) {
                    TypeError actError = new TypeError(23, "Node type  \"" + t.getName() + "\" \n" + "requires edge(s) of type: \n" + arctypes.toString(), t);
                    actError.setContainingGraph(g);
                    return actError;
                }
                ++i;
            }
        }
        return null;
    }

    public List<String> nodeTypeRequiresArcType(Type nodeType, int currentTypeGraphLevel) {
        if (this.typeGraph == null || currentTypeGraphLevel != 30) {
            return null;
        }
        Vector<String> arcTypes = new Vector<String>();
        Vector<Type> parents = nodeType.getAllParents();
        if (parents.size() > 0) {
            int i = parents.size() - 1;
            while (i >= 0) {
                Node n;
                List<Node> list = this.typeGraph.getNodes((Type)parents.get(i));
                Node node = n = list != null ? list.get(0) : null;
                if (n != null) {
                    for (Arc arc : n.getOutgoingArcsSet()) {
                        if (this.getMinTargetMultiplicity(arc.getType(), n.getType(), arc.getTargetType()) != 1) continue;
                        arcTypes.add(arc.getType().getName());
                    }
                    for (Arc arc : n.getIncomingArcsSet()) {
                        if (this.getMinSourceMultiplicity(arc.getType(), arc.getSourceType(), n.getType()) != 1) continue;
                        arcTypes.add(arc.getType().getName());
                    }
                }
                --i;
            }
        }
        return arcTypes;
    }

    public List<String> nodeTypeRequiresArcType(Type nodeType, Type arcType, Type srcNodeType, int currentTypeGraphLevel) {
        if (this.typeGraph == null || currentTypeGraphLevel != 30) {
            return null;
        }
        Vector<String> arcTypes = new Vector<String>();
        Vector<Type> parents = nodeType.getAllParents();
        if (parents.size() > 0) {
            int i = 0;
            while (i < parents.size()) {
                Node n;
                List<Node> list = this.typeGraph.getNodes((Type)parents.get(i));
                Node node = n = list != null ? list.get(0) : null;
                if (n != null) {
                    for (Arc arc : n.getOutgoingArcsSet()) {
                        if (this.getMinTargetMultiplicity(arc.getType(), n.getType(), arc.getTargetType()) != 1) continue;
                        arcTypes.add(arc.getType().getName());
                    }
                    for (Arc arc : n.getIncomingArcsSet()) {
                        if (this.getMinSourceMultiplicity(arc.getType(), arc.getSourceType(), n.getType()) != 1 || arc.getType().compareTo(arcType)) continue;
                        arcTypes.add(arc.getType().getName());
                    }
                }
                ++i;
            }
        }
        return arcTypes;
    }

    public List<String> nodeRequiresArc(Node node) {
        Vector<String> arcTypes = null;
        Vector<Type> parents = node.getType().getAllParents();
        if (parents.size() > 0) {
            Vector<Arc> outcoms = new Vector<Arc>(node.getOutgoingArcsSet());
            Vector<Arc> incoms = new Vector<Arc>(node.getIncomingArcsSet());
            int i = 0;
            while (i < parents.size()) {
                Node n;
                List<Node> list = this.typeGraph.getNodes((Type)parents.get(i));
                Node node2 = n = list != null ? list.get(0) : null;
                if (n != null) {
                    int j;
                    boolean ok;
                    for (Arc arc : n.getOutgoingArcsSet()) {
                        if (this.getMinTargetMultiplicity(arc.getType(), n.getType(), arc.getTargetType()) != 1) continue;
                        ok = false;
                        j = 0;
                        while (j < outcoms.size()) {
                            Arc out = (Arc)outcoms.get(j);
                            if (out.getType().compareTo(arc.getType())) {
                                ok = true;
                                break;
                            }
                            ++j;
                        }
                        if (ok) continue;
                        if (arcTypes == null) {
                            arcTypes = new Vector<String>();
                        }
                        arcTypes.add(arc.getType().getName());
                    }
                    for (Arc arc : n.getIncomingArcsSet()) {
                        if (this.getMinSourceMultiplicity(arc.getType(), arc.getSourceType(), n.getType()) != 1) continue;
                        ok = false;
                        j = 0;
                        while (j < incoms.size()) {
                            Arc in = (Arc)incoms.get(j);
                            if (in.getType().compareTo(arc.getType())) {
                                ok = true;
                                break;
                            }
                            ++j;
                        }
                        if (ok) continue;
                        if (arcTypes == null) {
                            arcTypes = new Vector();
                        }
                        arcTypes.add(arc.getType().getName());
                    }
                }
                ++i;
            }
        }
        return arcTypes;
    }

    public TypeError canCreateArc(Graph g, Type edgeType, Node source, Node target, int currentTypeGraphLevel) {
        return this.checkTypeInTypeGraph(g, edgeType, source, target, currentTypeGraphLevel);
    }

    public TypeError checkEdgeTypeMultiplicity(Arc typearc, Graph graph, int currentTypeGraphLevel) {
        Enumeration<GraphObject> list = graph.getElementsOfType(typearc.getType(), typearc.getSourceType(), typearc.getTargetType());
        while (list.hasMoreElements()) {
            Arc arc = (Arc)list.nextElement();
            TypeError error = arc.getType().check(arc, currentTypeGraphLevel);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public TypeError checkNodeTypeMultiplicity(Type nodeType, Graph graph, int currentTypeGraphLevel) {
        HashSet<GraphObject> set;
        TypeError actError = null;
        if (currentTypeGraphLevel > 10 && (set = graph.getTypeObjectsMap().get(nodeType.convertToKey())) != null && !set.isEmpty()) {
            int minValue;
            int nc = graph.getTypeObjectsMap().get(nodeType.convertToKey()).size();
            int maxValue = nodeType.getSourceMax();
            if (maxValue != -1 && nc > maxValue) {
                actError = new TypeError(25, "Too many (" + nc + ") nodes of type \"" + nodeType.getName() + "\".\nThere are only " + maxValue + " allowed ( graph \"" + graph.getName() + "\" ).", graph);
                return actError;
            }
            if (currentTypeGraphLevel == 30 && graph.isCompleteGraph() && (minValue = nodeType.getSourceMin()) > 0 && nc < minValue) {
                actError = new TypeError(24, "Not enough (" + nc + ") nodes of type \"" + nodeType.getName() + "\".\nThere are at least " + minValue + " needed ( graph \"" + graph.getName() + "\" ).", graph);
                return actError;
            }
        }
        return null;
    }

    private TypeError checkMultiplicity(Node n, int currentTypeGraphLevel) {
        TypeError actError = null;
        if (currentTypeGraphLevel >= 20) {
            Type nodeType = n.getType();
            Vector<Type> parents = nodeType.getAllParents();
            int i = 0;
            while (i < parents.size()) {
                Type t = (Type)parents.get(i);
                int count = 0;
                int minValue = t.getSourceMin();
                int maxValue = t.getSourceMax();
                HashSet<GraphObject> set = n.getContext().getTypeObjectsMap().get(t.convertToKey());
                if (set != null && !set.isEmpty()) {
                    count = n.getContext().getTypeObjectsMap().get(t.convertToKey()).size();
                }
                if (!n.getContext().isNode(n)) {
                    ++count;
                }
                if (maxValue != -1 && count > maxValue) {
                    actError = new TypeError(25, "Too many (" + count + ") nodes of type \"" + t.getName() + "\".\nThere are only " + maxValue + " allowed ( graph \"" + n.getContext().getName() + "\" ).", n, t);
                    actError.setContainingGraph(n.getContext());
                    return actError;
                }
                if (currentTypeGraphLevel == 30 && n.getContext().isCompleteGraph() && minValue > 0 && count < minValue) {
                    actError = new TypeError(24, "Not enough (" + count + ") nodes of type \"" + t.getName() + "\".\nThere are at least " + minValue + " needed ( graph \"" + n.getContext().getName() + "\" ).", n, t);
                    actError.setContainingGraph(n.getContext());
                    return actError;
                }
                ++i;
            }
        }
        return null;
    }

    private Vector<TypeError> checkNodesOverTypeGraph(Graph graph, int actTypeGraphLevel, Vector<TypeError> errors) {
        TypeError err;
        boolean localresult = true;
        Iterator<Node> nodesTG = this.typeGraph.getNodesSet().iterator();
        while (nodesTG.hasNext() && localresult) {
            Node n = nodesTG.next();
            TypeError err2 = this.checkNodeTypeMultiplicity(n.getType(), graph, actTypeGraphLevel);
            if (err2 == null) continue;
            errors.add(err2);
            localresult = false;
        }
        if (localresult && (err = graph.checkNodeRequiresArc(actTypeGraphLevel)) != null) {
            errors.add(err);
        }
        return errors;
    }

    private Vector<TypeError> checkArcsOverTypeGraph(Graph graph, int actTypeGraphLevel, Vector<TypeError> errors) {
        TypeError actError = null;
        for (Arc actArc : graph.getArcsSet()) {
            actError = this.checkTypeInTypeGraph(actArc, actTypeGraphLevel);
            if (actError == null) continue;
            actError.setContainingGraph(graph);
            errors.add(actError);
        }
        return errors;
    }

    public Collection<TypeError> checkType(Graph graph, int typeGraphCheckLevel) {
        Vector<TypeError> errors = new Vector<TypeError>();
        if (this.typeGraph == null || typeGraphCheckLevel == 0) {
            return errors;
        }
        int actTypeGraphLevel = typeGraphCheckLevel;
        if (typeGraphCheckLevel >= 30 && !graph.isCompleteGraph()) {
            actTypeGraphLevel = 20;
        }
        this.checkNodesOverTypeGraph(graph, actTypeGraphLevel, errors);
        this.checkArcsOverTypeGraph(graph, actTypeGraphLevel, errors);
        return errors;
    }

    public TypeError checkTypeMaxMultiplicity(Graph graph, int typeGraphCheckLevel) {
        TypeError actError;
        if (this.typeGraph == null || typeGraphCheckLevel <= 10) {
            return null;
        }
        int actTypeGraphLevel = 20;
        Vector<Type> checkedTypes = new Vector<Type>();
        for (Node n : graph.getNodesSet()) {
            if (checkedTypes.contains(n.getType())) continue;
            checkedTypes.add(n.getType());
            if (!n.getType().hasTypeGraphNode()) {
                actError = new TypeError(21, "No type node with name \"" + n.getType().getName() + "\"" + "\n ( see graph:  " + graph.getName() + " ).", graph);
                return actError;
            }
            actError = this.checkNodeTypeMultiplicity(n.getType(), graph, actTypeGraphLevel);
            if (actError == null) continue;
            return actError;
        }
        checkedTypes.clear();
        for (Arc a : graph.getArcsSet()) {
            if (!a.getType().hasTypeGraphArc()) {
                actError = new TypeError(21, "No type edge with name \"" + a.getType().getName() + "\" \nbetween node \"" + a.getSourceType() + "\" and \"" + a.getTargetType() + "\"" + "\n ( see graph:  " + graph.getName() + " ).", graph);
                return actError;
            }
            actError = a.getType().checkSourceMax(graph, (Node)a.getSource(), (Node)a.getTarget());
            if (actError != null) {
                actError.setContainingGraph(graph);
                return actError;
            }
            actError = a.getType().checkTargetMax(graph, (Node)a.getSource(), (Node)a.getTarget());
            if (actError == null) continue;
            actError.setContainingGraph(graph);
            return actError;
        }
        return null;
    }

    public Collection<TypeError> checkType(Rule rule) {
        Vector<TypeError> errors = new Vector<TypeError>();
        errors.addAll(this.checkType(rule.getOriginal()));
        errors.addAll(this.checkType(rule.getImage()));
        List<OrdinaryMorphism> nacs = rule.getNACsList();
        int l = 0;
        while (l < nacs.size()) {
            OrdinaryMorphism nac = nacs.get(l);
            errors.addAll(this.checkType(nac.getImage()));
            ++l;
        }
        List<OrdinaryMorphism> pacs = rule.getPACsList();
        int l2 = 0;
        while (l2 < pacs.size()) {
            OrdinaryMorphism pac = pacs.get(l2);
            errors.addAll(this.checkType(pac.getImage()));
            ++l2;
        }
        return errors;
    }

    public Collection<TypeError> checkType(AtomConstraint atomic) {
        Vector<TypeError> errors = new Vector<TypeError>();
        errors.addAll(this.checkType(atomic.getOriginal()));
        Enumeration<AtomConstraint> cons = atomic.getConclusions();
        while (cons.hasMoreElements()) {
            OrdinaryMorphism actCon = cons.nextElement();
            errors.addAll(this.checkType(actCon.getImage()));
        }
        return errors;
    }

    public Collection<TypeError> checkType(OrdinaryMorphism morphism) {
        Vector<TypeError> errors = new Vector<TypeError>();
        errors.addAll(this.checkType(morphism.getOriginal()));
        errors.addAll(this.checkType(morphism.getImage()));
        return errors;
    }

    public TypeError checkType(Arc arc, boolean isComplete) {
        if (this.typeGraphLevel <= 0) {
            return null;
        }
        if (isComplete && this.typeGraphLevel >= 20) {
            return this.checkTypeInTypeGraph(arc, this.typeGraphLevel);
        }
        if (!isComplete && this.typeGraphLevel >= 20) {
            return this.checkTypeInTypeGraph(arc, 20);
        }
        return null;
    }

    public TypeError checkType(Node node, boolean isComplete) {
        if (this.typeGraphLevel == 0) {
            return null;
        }
        if (this.typeGraphLevel >= 20) {
            if (isComplete) {
                return this.checkTypeInTypeGraph(node, this.typeGraphLevel);
            }
            return this.checkTypeInTypeGraph(node, 20);
        }
        return null;
    }

    public TypeError checkType(GraphObject object) {
        if (object instanceof Node) {
            return this.checkType((Node)object, false);
        }
        if (object instanceof Arc) {
            return this.checkType((Arc)object, false);
        }
        return null;
    }

    public Collection<TypeError> setLevelOfTypeGraphCheck(int level) {
        Collection<TypeError> errors;
        if (!(level == 0 || this.typeGraphIsProved && this.typeGraphLevel != 0 || (errors = this.checkTypeGraph()).isEmpty())) {
            return errors;
        }
        this.typeGraphLevel = level;
        return SUCCESS;
    }

    public void setLevelOfTypeGraph(int level) {
        this.typeGraphLevel = level;
    }

    public int getLevelOfTypeGraphCheck() {
        return this.typeGraphLevel;
    }

    public void disableTypeGraphCheck() {
        this.setLevelOfTypeGraphCheck(0);
    }

    public Collection<TypeError> enableTypeGraphCheck() {
        return this.setLevelOfTypeGraphCheck(20);
    }

    public boolean compareTo(TypeSet ts) {
        if (ts == this) {
            return true;
        }
        Enumeration<Type> e = ts.getTypes();
        Vector<Type> another = new Vector<Type>();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.types.size() != another.size()) {
            return false;
        }
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.elementAt(i);
            int j = another.size() - 1;
            while (j >= 0) {
                Type t1 = (Type)another.elementAt(j);
                if (t.compareTo(t1)) {
                    another.remove(t1);
                    break;
                }
                --j;
            }
            ++i;
        }
        if (another.size() != 0) {
            return false;
        }
        if (this.typeGraph == null && ts.getTypeGraph() == null) {
            return true;
        }
        if (this.typeGraph != null && ts.getTypeGraph() == null) {
            return false;
        }
        if (this.typeGraph == null && ts.getTypeGraph() != null) {
            return false;
        }
        return this.typeGraph.compareTo(ts.getTypeGraph());
    }

    public boolean compareTypes(TypeSet ts) {
        if (String.valueOf(ts.hashCode()).equals(this.info)) {
            return true;
        }
        return this.compareTypes(ts, new Vector<Type>(), new Vector<Type>(), new Vector<Type>(), new Vector<Type>());
    }

    public boolean compareTypes(TypeSet ts, Vector<Type> differentAttribute, Vector<Type> differentInheritance, Vector<Type> differentMultiplicity) {
        return this.compareTypes(ts, differentAttribute, differentInheritance, differentMultiplicity, new Vector<Type>());
    }

    public boolean isNewTypeGraphObjectImported() {
        return this.newTypeGraphObjectImported;
    }

    private boolean compareTypes(TypeSet ts, Vector<Type> differentAttribute, Vector<Type> differentInheritance, Vector<Type> differentMultiplicity, Vector<Type> typesToAdd) {
        if (ts == this || String.valueOf(ts.hashCode()).equals(this.info)) {
            return true;
        }
        differentInheritance.clear();
        differentAttribute.clear();
        differentMultiplicity.clear();
        typesToAdd.clear();
        boolean conflict = false;
        Vector<Type> another = new Vector<Type>(ts.getTypeList());
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.elementAt(i);
            int j = 0;
            while (j < another.size()) {
                Type t1 = another.elementAt(j);
                if (t.getStringRepr().equals(t1.getStringRepr()) && (t.isNodeType() && t1.isNodeType() || t.isArcType() && t1.isArcType())) {
                    if (!t.compareTo(t1)) {
                        if (!differentAttribute.contains(t1)) {
                            differentAttribute.add(t1);
                        }
                        conflict = true;
                    }
                    if (t.getTypeGraphNodeObject() != null && t1.getTypeGraphNodeObject() != null) {
                        if (!t1.getParents().isEmpty()) {
                            if (!t.getParents().isEmpty()) {
                                Vector<Type> t1Parents;
                                Vector<Type> tParents = t.getAllParents();
                                if (!this.compareParents(tParents, t1Parents = t1.getAllParents())) {
                                    conflict = true;
                                    if (!differentInheritance.contains(t1)) {
                                        differentInheritance.add(t1);
                                    }
                                }
                            } else {
                                conflict = true;
                                if (!differentInheritance.contains(t1)) {
                                    differentInheritance.add(t1);
                                }
                            }
                        }
                        if (t.getSourceMax() != t1.getSourceMax()) {
                            conflict = true;
                            if (!differentMultiplicity.contains(t1)) {
                                differentMultiplicity.add(t1);
                            }
                        } else if (t.getSourceMin() != t1.getSourceMin()) {
                            conflict = true;
                            if (!differentMultiplicity.contains(t1)) {
                                differentMultiplicity.add(t1);
                            }
                        }
                    } else if (t.hasTypeGraphArc() && t1.hasTypeGraphArc()) {
                        if (!t.compareTypeGraphArcs(t1) && !typesToAdd.contains(t1)) {
                            typesToAdd.add(t1);
                        }
                        if (!t.compareTypeGraphArcsMultiplicity(t1)) {
                            conflict = true;
                            if (!differentMultiplicity.contains(t1)) {
                                differentMultiplicity.add(t1);
                            }
                        }
                    } else if (t1.hasTypeGraphNode()) {
                        if (!typesToAdd.contains(t1)) {
                            typesToAdd.add(t1);
                        }
                    } else if (t1.hasTypeGraphArc() && !typesToAdd.contains(t1)) {
                        typesToAdd.add(t1);
                    }
                    another.remove(t1);
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (typesToAdd.isEmpty()) {
            int j = 0;
            while (j < another.size()) {
                Type t1 = another.elementAt(j);
                if (t1.hasTypeGraphNode()) {
                    if (!typesToAdd.contains(t1)) {
                        typesToAdd.add(t1);
                    }
                } else if (t1.hasTypeGraphArc() && !typesToAdd.contains(t1)) {
                    typesToAdd.add(t1);
                }
                ++j;
            }
        }
        this.newTypeGraphObjectImported = !typesToAdd.isEmpty();
        return !conflict;
    }

    private boolean compareParents(Vector<Type> allParents1, Vector<Type> allParents2) {
        int nm = allParents1.size();
        int i = 1;
        while (i < nm) {
            Type p2;
            Type p1 = allParents1.get(i);
            if (!p1.compareTo(p2 = allParents2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(TypeSet ts) {
        if (ts == this || String.valueOf(ts.hashCode()).equals(this.info)) {
            return true;
        }
        if (this.types.size() < ts.getTypesCount()) {
            return false;
        }
        int count = 0;
        int i = 0;
        while (i < this.types.size()) {
            Type ti = this.types.elementAt(i);
            int j = 0;
            while (j < ts.getTypeList().size()) {
                Type tj = ts.getTypeList().get(j);
                if (ti.compareTo(tj)) {
                    ++count;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (count != ts.getTypeList().size()) {
            return false;
        }
        return this.typeGraph == null || ts.getTypeGraph() == null || this.typeGraph.contains(ts.getTypeGraph());
    }

    public TypeError checkIfRemovable(Node node) {
        if (this.typeGraphLevel < 30) {
            return null;
        }
        TypeError error = node.getType().checkIfRemovable(node, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfRemovable(Arc arc) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        GraphObject node = arc.getSource();
        TypeError error = node.getType().checkIfRemovableFromSource(node, arc, this.typeGraphLevel);
        if (error != null) {
            return error;
        }
        node = arc.getTarget();
        error = node.getType().checkIfRemovableFromTarget(node, arc, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfRemovable(Arc arc, boolean deleteSrc, boolean deleteTar) {
        GraphObject node;
        if (this.typeGraphLevel != 30) {
            return null;
        }
        TypeError error = null;
        if (!deleteTar) {
            node = arc.getSource();
            error = node.getType().checkIfRemovableFromSource(node, arc, deleteSrc, deleteTar, this.typeGraphLevel);
        }
        if (error == null && !deleteSrc) {
            node = arc.getTarget();
            error = node.getType().checkIfRemovableFromTarget(node, arc, deleteSrc, deleteTar, this.typeGraphLevel);
        }
        return error;
    }

    public TypeError checkIfRemovableFromSource(Arc arc) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        GraphObject node = arc.getSource();
        TypeError error = node.getType().checkIfRemovableFromSource(node, arc, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfRemovableFromTarget(Arc arc) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        GraphObject node = arc.getTarget();
        TypeError error = node.getType().checkIfRemovableFromTarget(node, arc, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfEdgeCreatable(Type type, Node src, Node tar) {
        if (this.typeGraphLevel == 0 || this.typeGraphLevel == 10) {
            return null;
        }
        return type.checkIfEdgeCreatable(src, tar, this.typeGraphLevel);
    }

    public int getMaxMultiplicity(Type type) {
        return type.getSourceMax();
    }

    public int getMinMultiplicity(Type type) {
        return type.getSourceMin();
    }

    public int getMaxSourceMultiplicity(Type type, Type srctype, Type tartype) {
        return type.getSourceMax(srctype, tartype);
    }

    public int getMinSourceMultiplicity(Type type, Type srctype, Type tartype) {
        return type.getSourceMin(srctype, tartype);
    }

    public int getMaxTargetMultiplicity(Type type, Type srctype, Type tartype) {
        return type.getTargetMax(srctype, tartype);
    }

    public int getMinTargetMultiplicity(Type type, Type srctype, Type tartype) {
        return type.getTargetMin(srctype, tartype);
    }

    public String showTypes() {
        String out = "Types:\n";
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.get(i);
            out = String.valueOf(out) + t.getName() + t.getAdditionalRepr() + "\n";
            ++i;
        }
        return out;
    }

    public String showNodeTypes() {
        String out = "Types:\n";
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.get(i);
            if (t.getAdditionalRepr().indexOf("NODE") >= 0) {
                out = String.valueOf(out) + t.getName() + t.getAdditionalRepr() + "\n";
            }
            ++i;
        }
        return out;
    }

    public String showArcTypes() {
        String out = "Types:\n";
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.get(i);
            if (t.getAdditionalRepr().indexOf("EDGE") >= 0) {
                out = String.valueOf(out) + t.getName() + t.getAdditionalRepr() + "\n";
            }
            ++i;
        }
        return out;
    }

    public void refreshTypeGraphObjects() {
        if (this.typeGraph == null) {
            return;
        }
        this.refreshInheritance();
    }

    public void setHelpInfo(String str) {
        this.info = str;
    }

    public String getHelpInfo() {
        return this.info;
    }

    public void trimToSize() {
        if (this.typeGraph != null) {
            this.typeGraph.trimToSize();
        }
        this.types.trimToSize();
        this.inheritanceArcs.trimToSize();
    }
}

