/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.attribute.AttrContext;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.csp.BinaryConstraint;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Solution_Backjump;
import agg.util.csp.Variable;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.csp.Constraint_Attribute;
import agg.xt_basis.csp.Constraint_ObjectName;
import agg.xt_basis.csp.Constraint_Source;
import agg.xt_basis.csp.Constraint_SourceTarget;
import agg.xt_basis.csp.Constraint_Target;
import agg.xt_basis.csp.Constraint_TargetSource;
import agg.xt_basis.csp.Constraint_Type;
import agg.xt_basis.csp.Query_Incoming;
import agg.xt_basis.csp.Query_IncomingOutgoing;
import agg.xt_basis.csp.Query_Outgoing;
import agg.xt_basis.csp.Query_OutgoingIncoming;
import agg.xt_basis.csp.Query_Source;
import agg.xt_basis.csp.Query_SourceTarget;
import agg.xt_basis.csp.Query_Target;
import agg.xt_basis.csp.Query_TargetSource;
import agg.xt_basis.csp.Query_Type;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public class ALR_CSP
extends CSP {
    private AttrContext itsAttrContext;
    private boolean randomizedDomain;
    private boolean directed = true;
    private final Dictionary<GraphObject, Variable> itsObjVarMap = new Hashtable<GraphObject, Variable>();
    private final Dictionary<String, HashSet<GraphObject>> itsTypeMap = new Hashtable<String, HashSet<GraphObject>>();

    public ALR_CSP(Graph vargraph, AttrContext ac, boolean injective) {
        super(new Solution_Backjump(injective));
        this.itsAttrContext = ac;
        this.directed = vargraph.getTypeSet().isArcDirected();
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Graph vargraph, AttrContext ac, SolutionStrategy st) {
        super(st);
        this.itsAttrContext = ac;
        this.directed = vargraph.getTypeSet().isArcDirected();
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Graph vargraph, AttrContext ac, boolean injective, boolean randomizeDomainOfVariable) {
        super(new Solution_Backjump(injective));
        this.itsAttrContext = ac;
        this.randomizedDomain = randomizeDomainOfVariable;
        this.directed = vargraph.getTypeSet().isArcDirected();
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Graph vargraph, AttrContext ac, SolutionStrategy st, boolean randomizeDomainOfVariable) {
        super(st);
        this.itsAttrContext = ac;
        this.randomizedDomain = randomizeDomainOfVariable;
        this.directed = vargraph.getTypeSet().isArcDirected();
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Collection<Node> varnodes, Collection<Arc> varedges, AttrContext ac, boolean injective, boolean randomizeDomainOfVariable) {
        super(new Solution_Backjump(injective));
        this.itsAttrContext = ac;
        this.randomizedDomain = randomizeDomainOfVariable;
        this.buildConstraintGraph(varnodes, varedges);
    }

    public void clear() {
        this.itsSolver.clear();
        ((Hashtable)this.itsObjVarMap).clear();
    }

    private final synchronized void buildConstraintGraph(Collection<Node> varnodes, Collection<Arc> varedges) {
        Variable anObjVar;
        String keystr;
        GraphObject anObj;
        while (varnodes.iterator().hasNext()) {
            anObj = varnodes.iterator().next();
            keystr = ((Node)anObj).convertToKey();
            if (this.itsTypeMap.get(keystr) == null) {
                this.itsTypeMap.put(keystr, new LinkedHashSet());
            }
            anObjVar = new Variable();
            anObjVar.setKind(0);
            anObjVar.setGraphObject(anObj);
            this.itsObjVarMap.put(anObj, anObjVar);
        }
        while (varedges.iterator().hasNext()) {
            anObj = varedges.iterator().next();
            keystr = ((Arc)anObj).convertToKey();
            if (this.itsTypeMap.get(keystr) == null) {
                String src_keystr = ((Arc)anObj).getSource().convertToKey();
                String tar_keystr = ((Arc)anObj).getTarget().convertToKey();
                if (this.itsTypeMap.get(src_keystr) == null || this.itsTypeMap.get(tar_keystr) == null) continue;
                this.itsTypeMap.put(keystr, new LinkedHashSet());
            }
            anObjVar = new Variable();
            anObjVar.setKind(1);
            anObjVar.setGraphObject(anObj);
            this.itsObjVarMap.put(anObj, anObjVar);
        }
        this.buildQueriesAndConstraints(this.itsObjVarMap.keys());
    }

    private final synchronized void buildConstraintGraph(Graph vargraph) {
        for (GraphObject graphObject : vargraph.getNodesSet()) {
            String string = graphObject.convertToKey();
            if (this.itsTypeMap.get(string) == null) {
                this.itsTypeMap.put(string, new LinkedHashSet());
            }
            Variable anObjVar = new Variable();
            anObjVar.setKind(0);
            anObjVar.setGraphObject(graphObject);
            this.itsObjVarMap.put(graphObject, anObjVar);
        }
        for (GraphObject graphObject : vargraph.getArcsSet()) {
            String keystr = graphObject.convertToKey();
            if (this.itsTypeMap.get(keystr) == null) {
                this.itsTypeMap.put(keystr, new LinkedHashSet());
            }
            Variable anObjVar = new Variable();
            anObjVar.setKind(1);
            anObjVar.setGraphObject(graphObject);
            this.itsObjVarMap.put(graphObject, anObjVar);
        }
        this.buildQueriesAndConstraints(this.itsObjVarMap.keys());
    }

    private void buildQueriesAndConstraints(Enumeration<GraphObject> anEnum) {
        while (anEnum.hasMoreElements()) {
            GraphObject anObj = anEnum.nextElement();
            Variable anObjVar = this.itsObjVarMap.get(anObj);
            Query query = new Query_Type(anObjVar);
            ((Query_Type)query).setRandomizedDomain(this.randomizedDomain);
            BinaryConstraint constraint = new Constraint_Type(anObj, anObjVar);
            query.setCorrespondent(constraint);
            if (anObj.getType().getAttrType() != null || anObj.getType().hasInheritedAttribute()) {
                new Constraint_Attribute(anObj, anObjVar, this.itsAttrContext, AttrTupleManager.getDefaultManager());
            }
            if (!anObj.isArc()) continue;
            Variable aSrcObjVar = this.itsObjVarMap.get(((Arc)anObj).getSource());
            Variable aTarObjVar = this.itsObjVarMap.get(((Arc)anObj).getTarget());
            if (this.directed) {
                constraint = new Constraint_Source(aSrcObjVar, anObjVar);
                query = new Query_Outgoing(aSrcObjVar, anObjVar);
                query.setCorrespondent(constraint);
                query = new Query_Source(anObjVar, aSrcObjVar);
                query.setCorrespondent(constraint);
                constraint = new Constraint_Target(aTarObjVar, anObjVar);
                query = new Query_Incoming(aTarObjVar, anObjVar);
                query.setCorrespondent(constraint);
                query = new Query_Target(anObjVar, aTarObjVar);
                query.setCorrespondent(constraint);
                continue;
            }
            constraint = new Constraint_SourceTarget(aSrcObjVar, anObjVar);
            query = new Query_OutgoingIncoming(aSrcObjVar, anObjVar);
            query.setCorrespondent(constraint);
            query = new Query_SourceTarget(anObjVar, aSrcObjVar);
            query.setCorrespondent(constraint);
            constraint = new Constraint_TargetSource(aTarObjVar, anObjVar);
            query = new Query_IncomingOutgoing(aTarObjVar, anObjVar);
            query.setCorrespondent(constraint);
            query = new Query_TargetSource(anObjVar, aTarObjVar);
            query.setCorrespondent(constraint);
        }
    }

    @Override
    protected final synchronized void preprocessDomain(Object domaingraph) {
        this.resetTypeMap((Graph)domaingraph);
    }

    protected AttrContext getAttrContext() {
        return this.itsAttrContext;
    }

    @Override
    public final Enumeration<Variable> getVariables() {
        return this.itsObjVarMap.elements();
    }

    public void enableAllVariables() {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject obj = keys.nextElement();
            Variable var = this.itsObjVarMap.get(obj);
            var.setEnabled(true);
        }
    }

    public boolean isDomainOfTypeEmpty(Type t) {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject go = keys.nextElement();
            if (go.isArc() || !go.getType().compareTo(t)) continue;
            Variable var = this.itsObjVarMap.get(go);
            return !var.hasNext();
        }
        return false;
    }

    public boolean isDomainOfTypeEmpty(Type t, Type src, Type tar) {
        Enumeration<GraphObject> keys = this.itsObjVarMap.keys();
        while (keys.hasMoreElements()) {
            GraphObject go = keys.nextElement();
            if (go.isNode() || !go.getType().compareTo(t) || !((Arc)go).getSource().getType().compareTo(src) || !((Arc)go).getTarget().getType().compareTo(tar)) continue;
            Variable var = this.itsObjVarMap.get(go);
            return !var.hasNext();
        }
        return false;
    }

    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relatedVarMap) {
        this.itsSolver.setRelatedInstanceVarMap(relatedVarMap);
    }

    public Dictionary<Object, Variable> getInstanceVarMap() {
        return this.itsSolver.getInstanceVarMap();
    }

    @Override
    public final int getSize() {
        return this.itsObjVarMap.size();
    }

    @Override
    public final Variable getVariable(GraphObject obj) {
        return this.itsObjVarMap.get(obj);
    }

    @Override
    public void addObjectNameConstraint(GraphObject anObj) {
        Variable anObjVar = this.itsObjVarMap.get(anObj);
        if (anObjVar != null) {
            new Constraint_ObjectName(anObj, anObjVar);
        }
    }

    @Override
    public void removeObjectNameConstraint(GraphObject anObj) {
        Variable anObjVar = this.itsObjVarMap.get(anObj);
        if (anObjVar != null) {
            Enumeration<?> cons = anObjVar.getConstraints();
            while (cons.hasMoreElements()) {
                Object c = cons.nextElement();
                if (!(c instanceof Constraint_ObjectName)) continue;
                anObjVar.removeConstraint((Constraint_ObjectName)c);
            }
        }
    }

    protected void fillTypeMap(Graph domaingraph) {
        HashSet<GraphObject> anObjVec;
        String keystr;
        for (Node node : domaingraph.getNodesSet()) {
            keystr = node.convertToKey();
            if (node.getType().hasParent()) {
                Vector<Type> myParents = node.getType().getAllParents();
                if (myParents == null) continue;
                int i = 0;
                while (i < myParents.size()) {
                    keystr = myParents.get(i).convertToKey();
                    if (this.itsTypeMap.get(keystr) != null) {
                        HashSet<GraphObject> anObjVec2 = this.itsTypeMap.get(keystr);
                        anObjVec2.add(node);
                    }
                    ++i;
                }
                continue;
            }
            if (this.itsTypeMap.get(keystr) == null) continue;
            anObjVec = this.itsTypeMap.get(keystr);
            anObjVec.add(node);
        }
        for (Arc arc : domaingraph.getArcsSet()) {
            keystr = arc.convertToKey();
            if (arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
                Vector<Type> mySrcParents = arc.getSource().getType().getAllParents();
                Vector<Type> myTarParents = arc.getTarget().getType().getAllParents();
                int i = 0;
                while (i < mySrcParents.size()) {
                    int j = 0;
                    while (j < myTarParents.size()) {
                        keystr = String.valueOf(mySrcParents.get(i).convertToKey()) + arc.getType().convertToKey() + myTarParents.get(j).convertToKey();
                        if (this.itsTypeMap.get(keystr) != null) {
                            HashSet<GraphObject> anObjVec3 = this.itsTypeMap.get(keystr);
                            anObjVec3.add(arc);
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            if (this.itsTypeMap.get(keystr) == null) continue;
            anObjVec = this.itsTypeMap.get(keystr);
            anObjVec.add(arc);
        }
    }

    public void removeFromObjectVarMap(GraphObject anObj) {
        Variable v;
        if (anObj.isNode()) {
            Iterator<Arc> iter = ((Node)anObj).getIncomingArcs();
            while (iter.hasNext()) {
                this.removeFromObjectVarMap(iter.next());
            }
            iter = ((Node)anObj).getOutgoingArcs();
            while (iter.hasNext()) {
                this.removeFromObjectVarMap(iter.next());
            }
        }
        if ((v = this.itsObjVarMap.get(anObj)) != null) {
            v.setInstance(null);
            v.clear();
            this.itsObjVarMap.remove(anObj);
        }
    }

    protected void removeFromTypeObjectsMap(GraphObject anObj) {
        if (anObj.isNode()) {
            if (anObj.getType().hasParent()) {
                Vector<Type> myParents = anObj.getType().getAllParents();
                if (myParents != null) {
                    int i = 0;
                    while (i < myParents.size()) {
                        String keystr = myParents.get(i).convertToKey();
                        HashSet<GraphObject> anObjVec = this.itsTypeMap.get(keystr);
                        if (anObjVec != null) {
                            anObjVec.remove(anObj);
                        }
                        ++i;
                    }
                }
            } else {
                HashSet<GraphObject> anObjVec = this.itsTypeMap.get(anObj.getType().convertToKey());
                if (anObjVec != null) {
                    anObjVec.remove(anObj);
                }
            }
        } else if (((Arc)anObj).getSource().getType().hasParent() || ((Arc)anObj).getTarget().getType().hasParent()) {
            Vector<Type> mySrcParents = ((Arc)anObj).getSource().getType().getAllParents();
            Vector<Type> myTarParents = ((Arc)anObj).getTarget().getType().getAllParents();
            int i = 0;
            while (i < mySrcParents.size()) {
                int j = 0;
                while (j < myTarParents.size()) {
                    String keystr = String.valueOf(mySrcParents.get(i).convertToKey()) + anObj.getType().convertToKey() + myTarParents.get(j).convertToKey();
                    HashSet<GraphObject> anObjVec = this.itsTypeMap.get(keystr);
                    if (anObjVec != null) {
                        anObjVec.remove(anObj);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            HashSet<GraphObject> anObjVec = this.itsTypeMap.get(anObj.getType().convertToKey());
            if (anObjVec != null) {
                anObjVec.remove(anObj);
            }
        }
    }

    protected void resetTypeMap(Graph g) {
        Enumeration<GraphObject> lhsObjs = this.itsObjVarMap.keys();
        while (lhsObjs.hasMoreElements()) {
            GraphObject obj = lhsObjs.nextElement();
            Variable var = this.itsObjVarMap.get(obj);
            String key = obj.convertToKey();
            HashSet<GraphObject> list = g.getTypeObjectsMap().get(key);
            if (list == null) {
                list = new LinkedHashSet<GraphObject>();
                g.getTypeObjectsMap().put(key, list);
            }
            this.itsTypeMap.put(key, list);
            var.getTypeQuery().setObjects(list);
        }
    }

    protected void resetTypeMap(Hashtable<String, HashSet<GraphObject>> aTypeMap) {
        Enumeration<GraphObject> lhsObjs = this.itsObjVarMap.keys();
        while (lhsObjs.hasMoreElements()) {
            GraphObject obj = lhsObjs.nextElement();
            Variable var = this.itsObjVarMap.get(obj);
            String key = obj.convertToKey();
            HashSet<GraphObject> list = aTypeMap.get(key);
            if (list == null) {
                list = new LinkedHashSet<GraphObject>();
                aTypeMap.put(key, list);
            }
            this.itsTypeMap.put(key, list);
            var.getTypeQuery().setObjects(list);
        }
    }

    protected void reinitializeSolver(boolean doUpdateQueries) {
        this.itsSolver.reinitialize(doUpdateQueries);
    }

    protected void resetSolver(boolean doUpdateQueries) {
        this.resetSolverVariables();
        this.itsSolver.reinitialize(doUpdateQueries);
    }

    protected void resetSolverVariables() {
        Enumeration<Variable> cspVars = this.itsObjVarMap.elements();
        while (cspVars.hasMoreElements()) {
            cspVars.nextElement().setInstance(null);
        }
    }

    protected void resetVariableDomain(boolean resetByNull) {
        if (resetByNull) {
            Enumeration<Variable> cspVars = this.itsObjVarMap.elements();
            while (cspVars.hasMoreElements()) {
                cspVars.nextElement().setInstance(null);
            }
        }
        this.unsetAttrContextVariable();
    }

    protected void resetVariableDomain(GraphObject go) {
        Variable var = this.itsObjVarMap.get(go);
        if (var != null) {
            this.itsSolver.reinitialize(var);
            var.setInstance(null);
            this.unsetAttrContextVariable(go);
        }
    }

    protected void unsetAttrContextVariable() {
        if (this.itsSolver.hasQueries()) {
            VarTuple varTuple = (VarTuple)this.itsAttrContext.getVariables();
            int i = 0;
            while (i < varTuple.getSize()) {
                VarMember vm = varTuple.getVarMemberAt(i);
                if (vm != null) {
                    vm.setExpr(null);
                }
                ++i;
            }
        }
    }

    protected void unsetAttrContextVariable(GraphObject go) {
        if (go.getAttribute() != null && this.itsSolver.hasQueries()) {
            Vector<String> attrVars = ((ValueTuple)go.getAttribute()).getAllVariableNames();
            VarTuple varTup = (VarTuple)this.itsAttrContext.getVariables();
            int i = 0;
            while (i < attrVars.size()) {
                String name = attrVars.elementAt(i);
                VarMember vm = varTup.getVarMemberAt(name);
                if (vm != null) {
                    vm.setExpr(null);
                }
                ++i;
            }
        }
    }
}

