/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeEditorInput;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.interpreter.ui.util.TransformOperation;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinWizardPage;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ModelSelector;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ParameterEditTable;
import org.eclipse.emf.henshin.interpreter.ui.wizard.UnitSelector;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class HenshinWizard
extends Wizard
implements UnitSelector.UnitSelectionListener,
ModelSelector.ModelSelectorListener,
ParameterEditTable.ParameterChangeListener {
    protected Unit initialUnit;
    protected Module module;
    protected List<Unit> allUnits;
    protected List<Unit> outerUnits;
    protected List<CompletionListener> completionListeners = new ArrayList<CompletionListener>();
    protected TransformOperation transformOperation;
    protected HenshinWizardPage page;

    private HenshinWizard() {
        this.setWindowTitle(HenshinInterpreterUIPlugin.LL("_UI_Wizard"));
        this.setNeedsProgressMonitor(true);
    }

    public HenshinWizard(Module module) {
        this();
        this.module = module;
    }

    public HenshinWizard(Unit unit) {
        this(unit.getModule());
        this.initialUnit = unit;
    }

    public void addPages() {
        this.page = new HenshinWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.module = this.module;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.initData();
    }

    protected void initData() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource oldModuleResource = this.module.eResource();
        Resource newModuleResource = resourceSet.createResource(oldModuleResource.getURI());
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection copies = copier.copyAll((Collection)oldModuleResource.getContents());
        copier.copyReferences();
        newModuleResource.getContents().addAll(copies);
        this.module = (Module)copier.get((Object)this.module);
        if (this.initialUnit != null) {
            this.initialUnit = (Unit)copier.get((Object)this.initialUnit);
        }
        for (EPackage ePackage : this.module.getImports()) {
            resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        this.allUnits = new ArrayList<Unit>();
        this.allUnits.addAll((Collection<Unit>)this.module.getUnits());
        this.initializeOuterUnits();
        int initIdx = this.getInitialUnitIndex();
        this.setUnitSelector(initIdx);
        this.transformOperation = new TransformOperation();
        if (this.initialUnit != null) {
            this.transformOperation.setUnit(this.initialUnit, this.getParameterPreferences(this.initialUnit));
            this.page.parameterEditor.setParameters(this.transformOperation.getParameterConfigurations());
        }
        this.page.unitSelector.addUnitSelectionListener(this);
        this.page.inputSelector.addModelSelectorListener(this);
        this.page.outputSelector.addModelSelectorListener(this);
        this.page.parameterEditor.addParameterChangeListener(this);
    }

    private void initializeOuterUnits() {
        this.outerUnits = new ArrayList<Unit>();
        for (Unit unit : this.allUnits) {
            boolean isOuterUnit = this.isUnitOuterUnit(unit);
            if (!isOuterUnit) continue;
            this.outerUnits.add(unit);
        }
    }

    private void setUnitSelector(int initIdx) {
        ArrayList<String> selectableUnitLabels = new ArrayList<String>();
        for (Unit unit : this.allUnits) {
            String unitLabel = unit.toString();
            selectableUnitLabels.add(unitLabel);
        }
        ArrayList<String> outerUnitLabels = new ArrayList<String>();
        for (Unit outUnit : this.outerUnits) {
            String outUnitLabel = outUnit.toString();
            outerUnitLabels.add(outUnitLabel);
        }
        if (!this.outerUnits.contains(this.initialUnit)) {
            this.page.unitSelector.unitFilter.setSelection(true);
        }
        this.page.unitSelector.setSelectableUnits(selectableUnitLabels.toArray(new String[0]), outerUnitLabels.toArray(new String[0]));
        this.page.unitSelector.setSelection(initIdx);
    }

    private int getInitialUnitIndex() {
        if (this.outerUnits.contains(this.initialUnit)) {
            return this.outerUnits.indexOf(this.initialUnit);
        }
        int initIdx = -1;
        int index = 0;
        while (index < this.allUnits.size()) {
            Unit unit = this.allUnits.get(index);
            if (this.initialUnit != null) {
                if (this.initialUnit == unit) {
                    initIdx = index;
                    break;
                }
            } else if (initIdx < 0 && unit.getName() != null && unit.getName().toLowerCase().equals("main")) {
                initIdx = index;
                this.initialUnit = unit;
                break;
            }
            ++index;
        }
        if (initIdx < 0) {
            initIdx = 0;
            this.initialUnit = this.allUnits.get(0);
        }
        return initIdx;
    }

    private boolean isUnitOuterUnit(Unit unit) {
        boolean isOuterUnit = true;
        for (Unit outerUnit : this.allUnits) {
            if (!outerUnit.getSubUnits(true).contains((Object)unit)) continue;
            isOuterUnit = false;
            break;
        }
        return isOuterUnit;
    }

    protected List<ParameterConfig> getParameterPreferences(Unit unit) {
        ArrayList<ParameterConfig> result = new ArrayList<ParameterConfig>();
        for (Parameter param : unit.getParameters()) {
            result.add(new ParameterConfig(param));
        }
        return result;
    }

    public boolean canFinish() {
        if (this.transformOperation.getInputUri() == null || this.transformOperation.getOutputUri() == null || this.transformOperation.getUnit() == null) {
            return false;
        }
        IFile file = this.getFile(this.transformOperation.getOutputUri().toString());
        this.page.setMessage(null);
        if (file != null && file.exists()) {
            this.page.setMessage("Warning: Output file exists already and will be overridden.", 2);
        }
        return true;
    }

    private IFile getFile(String uriString) {
        try {
            URI uri = URI.createURI((String)uriString);
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.toPlatformString(false));
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)this.transformOperation);
            if (this.page.openCompare.getSelection()) {
                ResourceSetImpl resourceSet1 = new ResourceSetImpl();
                ResourceSetImpl resourceSet2 = new ResourceSetImpl();
                String xmi1 = this.page.outputSelector.getModelURI();
                String xmi2 = this.page.inputSelector.getModelURI();
                this.load(xmi1, (ResourceSet)resourceSet1);
                this.load(xmi2, (ResourceSet)resourceSet2);
                IEObjectMatcher matcher = DefaultMatchEngine.createDefaultEObjectMatcher((UseIdentifiers)UseIdentifiers.NEVER);
                DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory());
                MatchEngineFactoryImpl matchEngineFactory = new MatchEngineFactoryImpl(matcher, (IComparisonFactory)comparisonFactory);
                matchEngineFactory.setRanking(20);
                MatchEngineFactoryRegistryImpl matchEngineRegistry = new MatchEngineFactoryRegistryImpl();
                matchEngineRegistry.add((IMatchEngine.Factory)matchEngineFactory);
                EMFCompare comparator = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineRegistry).build();
                DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)resourceSet1, (Notifier)resourceSet2, null);
                ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)resourceSet1, (Notifier)resourceSet2, null);
                ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                ComparisonScopeEditorInput input = new ComparisonScopeEditorInput(new EMFCompareConfiguration(new CompareConfiguration()), editingDomain, (AdapterFactory)adapterFactory, comparator, (IComparisonScope)scope);
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
        }
        catch (InvocationTargetException e) {
            String message = "Error applying transformation";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                message = e.getCause().getMessage();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)message);
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void load(String absolutePath, ResourceSet resourceSet) {
        URI uri = URI.createURI((String)absolutePath);
        System.out.println(uri);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getResource(uri, true);
    }

    @Override
    public boolean unitSelected(int idx, boolean showInnerUnits) {
        Unit unit = showInnerUnits ? this.allUnits.get(idx) : this.outerUnits.get(idx);
        this.transformOperation.setUnit(unit, this.getParameterPreferences(unit));
        this.page.parameterEditor.setParameters(this.transformOperation.getParameterConfigurations());
        this.fireCompletionChange();
        return false;
    }

    @Override
    public boolean modelURIChanged(String modelUri) {
        try {
            this.transformOperation.setInputURI(URI.createURI((String)this.page.inputSelector.getModelURI()));
            this.transformOperation.setOutputURI(URI.createURI((String)this.page.outputSelector.getModelURI()));
            this.fireCompletionChange();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return false;
    }

    @Override
    public void parameterChanged(ParameterConfig paramCfg) {
        this.fireCompletionChange();
    }

    protected void fireCompletionChange() {
        this.getContainer().updateButtons();
        for (CompletionListener l : this.completionListeners) {
            l.completionChanged();
        }
    }

    public void addCompletionListener(CompletionListener listener) {
        this.completionListeners.add(listener);
    }

    public static interface CompletionListener {
        public void completionChanged();
    }
}

