/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import java.util.List;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.commands.AbstractStateSpaceCommand;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;

public class ExploreStatesCommand
extends AbstractStateSpaceCommand {
    private StateSpaceExplorationHelper helper;
    private List<State> statesToExplore;
    private boolean generateLocations;
    private boolean result = true;

    public ExploreStatesCommand(StateSpaceExplorationHelper helper) {
        super("explore states", helper.getStateSpaceManager());
        this.helper = helper;
    }

    public ExploreStatesCommand(StateSpaceManager manager, List<State> states, boolean generateLocations) {
        super("explore states", manager);
        this.statesToExplore = states;
        this.generateLocations = generateLocations;
    }

    @Override
    public void doExecute() throws StateSpaceException {
        if (this.helper != null) {
            this.result = this.helper.doExplorationStep();
        } else {
            this.result = !this.statesToExplore.isEmpty();
            this.getStateSpaceManager().exploreStates(this.statesToExplore, this.generateLocations);
        }
    }

    public boolean canUndo() {
        return false;
    }

    public boolean getResult() {
        return this.result;
    }
}

