/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.emf.henshin.text.ui.labeling

import com.google.inject.Inject
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider
import org.eclipse.emf.henshin.text.henshin_text.Model
import org.eclipse.emf.henshin.text.henshin_text.Rule
import org.eclipse.emf.henshin.text.henshin_text.Unit
import org.eclipse.emf.henshin.text.henshin_text.Parameter
import org.eclipse.emf.henshin.text.henshin_text.Graph
import org.eclipse.emf.henshin.text.henshin_text.Node
import org.eclipse.emf.henshin.text.henshin_text.JavaImport
import org.eclipse.emf.henshin.text.henshin_text.CheckDangling
import org.eclipse.emf.henshin.text.henshin_text.InjectiveMatching
import org.eclipse.emf.henshin.text.henshin_text.Conditions
import org.eclipse.emf.henshin.text.henshin_text.Edges
import org.eclipse.emf.henshin.text.henshin_text.Edge
import org.eclipse.emf.henshin.text.henshin_text.Attribute
import org.eclipse.emf.henshin.text.henshin_text.Formula
import org.eclipse.emf.henshin.text.henshin_text.MultiRule
import org.eclipse.emf.henshin.text.henshin_text.MultiRuleReuseNode
import org.eclipse.emf.henshin.text.henshin_text.ORorXOR
import org.eclipse.emf.henshin.text.henshin_text.AND
import org.eclipse.emf.henshin.text.henshin_text.Not
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraphRef
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraph
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdges
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdge
import org.eclipse.emf.henshin.text.henshin_text.ConditionNode
import org.eclipse.emf.henshin.text.henshin_text.ConditionReuseNode
import org.eclipse.emf.henshin.text.henshin_text.Match
import org.eclipse.emf.henshin.text.henshin_text.Strict
import org.eclipse.emf.henshin.text.henshin_text.Rollback
import org.eclipse.emf.henshin.text.henshin_text.IndependentUnit
import org.eclipse.emf.henshin.text.henshin_text.ConditionalUnit
import org.eclipse.emf.henshin.text.henshin_text.PriorityUnit
import org.eclipse.emf.henshin.text.henshin_text.IteratedUnit
import org.eclipse.emf.henshin.text.henshin_text.LoopUnit
import org.eclipse.emf.henshin.text.henshin_text.Call
import org.eclipse.emf.henshin.text.henshin_text.Expression
import org.eclipse.emf.henshin.text.henshin_text.OrExpression
import org.eclipse.emf.henshin.text.henshin_text.AndExpression
import org.eclipse.emf.henshin.text.henshin_text.EqualityExpression
import org.eclipse.emf.henshin.text.henshin_text.ComparisonExpression
import org.eclipse.emf.henshin.text.henshin_text.PlusExpression
import org.eclipse.emf.henshin.text.henshin_text.MinusExpression
import org.eclipse.emf.henshin.text.henshin_text.MulOrDivExpression
import org.eclipse.emf.henshin.text.henshin_text.BracketExpression
import org.eclipse.emf.henshin.text.henshin_text.NotExpression
import org.eclipse.emf.henshin.text.henshin_text.ParameterValue
import org.eclipse.emf.henshin.text.henshin_text.JavaClassValue
import org.eclipse.emf.henshin.text.henshin_text.JavaAttributeValue
import org.eclipse.emf.henshin.text.henshin_text.StringValue
import org.eclipse.emf.henshin.text.henshin_text.NumberValue
import org.eclipse.emf.henshin.text.henshin_text.IntegerValue
import org.eclipse.emf.henshin.text.henshin_text.NaturalValue
import org.eclipse.emf.henshin.text.henshin_text.BoolValue
import org.eclipse.emf.henshin.text.henshin_text.List

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#label-provider
 */
class Henshin_textLabelProvider extends DefaultEObjectLabelProvider {

	@Inject
	new(AdapterFactoryLabelProvider delegate) {
		super(delegate);
	}
	
	def image(Model ele) { "outline/HenshinDiagramFile.gif" }
	def image(Rule ele) { "outline/Rule.gif" }
	def image(Unit ele) { "outline/Unit.gif" }
	def image(Parameter ele) { "outline/Parameter.gif" }
	def text(Parameter ele) {
		ele.name+":"+
		if(ele.type.type!=null){
			ele.type.type.name
		}else{
			ele.type.enumType
		}
	}
	def image(JavaImport ele) { "outline/NamedElement.gif" }
	def image(CheckDangling ele) { "outline/NamedElement.gif" }
	def image(InjectiveMatching ele) { "outline/NamedElement.gif" }
	def image(Conditions ele) { "outline/AttributeCondition.gif" }
	def text(Conditions ele){ "Conditions" }
	def image(Graph ele) { "outline/Graph.gif" }
	def text(Graph ele) {"Graph"}
	def image(Edges ele) { "outline/Edge.gif" }
	def text(Edges ele){
		"Edges"
	}
	def image(Edge ele) { "outline/Edge.gif" }
	def text(Edge ele) { 
		ele.type.name
	}
	def image(Node ele) { "outline/Node.gif" }
	def image(Attribute ele) { "outline/Attribute.gif" }
	def text(Attribute ele) { 
		if(ele.update!=null){
			"set-"+ele.name.name
		}else{
			ele.name.name
		}
		
	}
	def image(Formula ele) { "outline/Formula.gif" }
	def text(Formula ele) { "Formula" }
	def image(MultiRule ele) { "outline/Rule.gif" }
	def image(MultiRuleReuseNode ele) { "outline/Node.gif" }
	def text(MultiRuleReuseNode ele) {
		ele.name.name
	}
	def image(ORorXOR ele){
		if(ele.op.equals("OR")){
			"outline/Or.gif"
		}else{
			"outline/Xor.gif"
		}
	}
	def text(ORorXOR ele){
		if(ele.op.equals("OR")){
			"OR"
		}else{
			"COR"
		}
	}
	def image(AND ele) { "outline/And.gif" }
	def text(AND ele){ "AND" }
	def image(Not ele) { "outline/Not.gif" }
	def text(Not ele) { "NOT" }
	def image(ConditionGraphRef ele) { "outline/Graph.gif" }
	def text(ConditionGraphRef ele){
		ele.conditionGraphRef.name
	}
	def image(ConditionGraph ele) { "outline/Graph.gif" }
	def image(ConditionEdges ele) { "outline/Edge.gif" }
	def text(ConditionEdges ele){
		"Edges"
	}
	def image(ConditionEdge ele) { "outline/Edge.gif" }
	def text(ConditionEdge ele) { ele.type.name}
	def image(ConditionNode ele) { "outline/Node.gif" }
	def text(ConditionNode ele){ ele.name}
	def image(ConditionReuseNode ele) { "outline/Node.gif" }
	def text(ConditionReuseNode ele) {
		ele.name.name
	}
	def image(Match ele) { "outline/Attribute.gif" }
	def text(Match ele) { ele.name.name }
	def image(Call ele) {
		if(ele.elementCall instanceof Rule){
			"outline/RuleCall.gif"
		}else{
			"outline/UnitCall.gif"
		}
	}
	def text(Call ele) {
		ele.elementCall.name
	}
	def image(Strict ele) { "outline/NamedElement.gif" }
	def text(Strict ele) { "Strict" }
	def image(Rollback ele) { "outline/NamedElement.gif" }
	def text(Rollback ele) { "Rollback" }
	def image(IndependentUnit ele) { "outline/IndependentUnit.gif" }
	def text(IndependentUnit ele) { "IndependentUnit" }
	def image(ConditionalUnit ele) { "outline/ConditionalUnit.gif" }
	def text(ConditionalUnit ele) { "ConditionalUnit" }
	def image(PriorityUnit ele) { "outline/PriorityUnit.gif" }
	def text(PriorityUnit ele) { "PriorityUnit" }
	def image(List ele) { "outline/Unit.gif" }
	def text(List ele) { "subUnit" }
	def image(IteratedUnit ele) { "outline/IteratedUnit.gif" }
	def text(IteratedUnit ele) { "IteratedUnit" }
	def image(Expression ele) { "outline/Attribute_yellow.gif" }
	def text(Expression ele) { ExpressionToString(ele) }
	def image(LoopUnit ele) { "outline/LoopUnit.gif" }
	def text(LoopUnit ele) { "LoopUnit" }
	
	private def ExpressionToString(Expression expression){
		switch (expression) {  
			OrExpression :  return ExpressionToString(expression.left)+" OR "+ExpressionToString(expression.right)
			AndExpression : return ExpressionToString(expression.left)+" AND "+ExpressionToString(expression.right)
			EqualityExpression : return ExpressionToString(expression.left)+" "+expression.op+" "+ExpressionToString(expression.right)
			ComparisonExpression : return ExpressionToString(expression.left)+" "+expression.op+" "+ExpressionToString(expression.right)
			PlusExpression : return ExpressionToString(expression.left)+" + "+ExpressionToString(expression.right)
			MinusExpression : return ExpressionToString(expression.left)+" - "+ExpressionToString(expression.right)
			MulOrDivExpression : return ExpressionToString(expression.left)+" "+expression.op+" "+ExpressionToString(expression.right)
			BracketExpression : return "("+ExpressionToString(expression.expression)+")"
			NotExpression : return "!"+ExpressionToString(expression.expression)
			ParameterValue : return expression.value.name
			JavaClassValue : return expression.value+"(...)"
			JavaAttributeValue : return expression.value
  			StringValue : return expression.value
  			NumberValue : return expression.value
  			IntegerValue : return expression.value
  			NaturalValue : return expression.value
   			BoolValue : return expression.value 
		}
	}


	// Labels and icons can be computed like this:
	
//	def text(Greeting ele) {
//		'A greeting to ' + ele.name
//	}
//
//	def image(Greeting ele) {
//		'Greeting.gif'
//	}
}
