/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.helpers;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.AbstractConcealingStrategy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class ShapeAlphaConcealingStrategy
extends AbstractConcealingStrategy {
    private final int CONCEAL_ALPHA = 25;
    private final int REVEAL_ALPHA = 255;

    @Override
    public void doReveal(AbstractGraphicalEditPart abstractEditPart) {
        IFigure figure = this.getFigure(abstractEditPart);
        if (figure instanceof Shape) {
            this.doReveal((Shape)figure);
        } else {
            this.doReveal(figure);
        }
    }

    private void doReveal(Shape shape) {
        shape.setAlpha(255);
        for (Object o : shape.getChildren()) {
            if (o instanceof Shape) {
                this.doReveal((Shape)o);
                continue;
            }
            if (!(o instanceof IFigure)) continue;
            this.doReveal((IFigure)o);
        }
    }

    private void doReveal(IFigure figure) {
        FontData fontData = figure.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), 0));
        figure.setFont(font);
    }

    @Override
    public void doConceal(AbstractGraphicalEditPart abstractEditPart) {
        IFigure figure = this.getFigure(abstractEditPart);
        if (figure instanceof Shape) {
            this.doConceal((Shape)figure);
        } else if (figure instanceof WrappingLabel) {
            this.doConceal((WrappingLabel)figure);
        }
    }

    private void doConceal(Shape shape) {
        shape.setAlpha(25);
        for (Object o : shape.getChildren()) {
            if (o instanceof Shape) {
                this.doConceal((Shape)o);
                continue;
            }
            if (!(o instanceof WrappingLabel)) continue;
            this.doConceal((WrappingLabel)o);
        }
    }

    private void doConceal(WrappingLabel wrappingLabel) {
        FontData fontData = wrappingLabel.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        wrappingLabel.setFont(font);
    }
}

