/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.colim;

import agg.xt_basis.colim.COLIM_GRAPH;
import agg.xt_basis.colim.COLIM_PARTITION;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.COPROD_OBJECT;
import agg.xt_basis.colim.INT_VECTOR;
import java.util.Enumeration;

public class SET_DIAGRAM
extends COLIM_GRAPH {
    private COLIM_VECTOR f_name = new COLIM_VECTOR();
    private COLIM_VECTOR f_coproduct = new COLIM_VECTOR();
    private INT_VECTOR f_colimit = new INT_VECTOR();
    private INT_VECTOR f_colimit_pos;
    private COLIM_VECTOR f_colimit_set;
    private INT_VECTOR f_colimit_indices;
    private COLIM_PARTITION f_partition = new COLIM_PARTITION();
    private boolean f_colimit_valid = false;

    public SET_DIAGRAM() {
        this.f_coproduct.push_back(null);
        this.f_colimit.push_back(0);
        this.f_partition.make_block();
    }

    public int insert_object(COLIM_VECTOR set, String name) {
        int set_lower;
        int set_upper = set_lower = this.coproduct_size();
        int i = 0;
        while (i < set.size()) {
            Object element = set.item(i);
            this.f_colimit.push_back(set_upper);
            this.f_coproduct.push_back(element);
            this.f_partition.make_block();
            ++i;
            ++set_upper;
        }
        this.f_name.push_back(name);
        this.f_colimit_valid = false;
        return this.insert_node(new COPROD_OBJECT(set_lower, set_upper - 1));
    }

    int insert_morphism(INT_VECTOR morphism, int v, int w) {
        int source_lower = this.set_at_node((int)v).lower;
        int source_upper = this.set_at_node((int)v).upper;
        int target_lower = this.set_at_node((int)w).lower;
        int source_pos = source_lower;
        while (source_pos <= source_upper) {
            int target = morphism.item(source_pos - source_lower);
            if (target == -1) {
                this.delete_element(source_pos);
            } else {
                int target_pos = target_lower + target;
                int partition = this.f_partition.union_elements(source_pos, target_pos);
                if (this.f_colimit.item(partition) != 0 && this.f_coproduct.item(source_pos) != this.f_coproduct.item(target_pos)) {
                    this.f_colimit.put(target_pos, partition);
                }
            }
            ++source_pos;
        }
        this.f_colimit_valid = false;
        return this.insert_edge(morphism, v, w);
    }

    public INT_VECTOR get_colimit_indices() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colimit_indices;
    }

    public COLIM_VECTOR get_colimit_set() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colimit_set;
    }

    public COLIM_VECTOR get_coproduct_set() {
        return this.f_coproduct;
    }

    public void delete_element(int element) {
        this.f_colimit_valid = false;
        this.f_colimit.put(0, this.f_partition.union_elements(element, 0));
    }

    public void define_representing(int element, int node) {
        this.f_colimit_valid = false;
        int colimit_index = this.f_partition.find(this.set_at_node((int)node).lower + element);
        this.f_colimit.put(element, colimit_index);
    }

    public Object get_element(int element) {
        return this.f_coproduct.item(element);
    }

    public void put_element(int element, Object value) {
        this.f_coproduct.put(value, element);
    }

    public Object get_colimit_element(int element) {
        return this.get_element(this.get_colimit_index(element));
    }

    public Object get_colimit_element_at_node(int element, int node) {
        return this.get_element(this.get_colimit_index_at_node(element, node));
    }

    public int get_colimit_index(int element) {
        if (this.f_colimit_valid) {
            return this.f_colimit.item(element);
        }
        return this.f_colimit.item(this.f_partition.find(element));
    }

    public int get_colimit_pos(int element) {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colimit_pos.item(this.f_colimit.item(element));
    }

    public int get_colimit_index_at_node(int element, int node) {
        return this.get_colimit_index(element + this.set_at_node((int)node).lower);
    }

    public String get_name(int node) {
        return (String)this.f_name.item(node);
    }

    public COPROD_OBJECT set_at_node(int node) {
        return (COPROD_OBJECT)this.f_node.item(node);
    }

    public INT_VECTOR morphism_at_edge(int edge) {
        return (INT_VECTOR)this.f_edge.item(edge);
    }

    public int source_at_edge(int edge) {
        return this.f_source.item(edge);
    }

    public int target_at_edge(int edge) {
        return this.f_target.item(edge);
    }

    public int object_count() {
        return this.f_node.size();
    }

    public int morphism_count() {
        return this.f_edge.size();
    }

    public int object_size(int node) {
        COPROD_OBJECT set = this.set_at_node(node);
        return set.upper - set.lower + 1;
    }

    public int coproduct_size() {
        return this.f_coproduct.size();
    }

    @Override
    public String toString() {
        StringBuffer Result2 = new StringBuffer("\nobjects: ");
        int index = 0;
        Enumeration en = this.f_node.elements();
        while (en.hasMoreElements()) {
            Object n = en.nextElement();
            Result2.append(this.get_name(index));
            Result2.append(": ");
            Result2.append(this.out_object(index));
            if (en.hasMoreElements()) {
                Result2.append("; ");
            }
            ++index;
        }
        Result2.append("\nmorphisms: ");
        index = 0;
        en = this.f_edge.elements();
        while (en.hasMoreElements()) {
            Object e = en.nextElement();
            Result2.append(this.out_morphism(index));
            if (en.hasMoreElements()) {
                Result2.append("; ");
            }
            ++index;
        }
        Result2.append("\n");
        return new String(Result2);
    }

    String out_object(int node) {
        StringBuffer Result2 = new StringBuffer("{");
        COPROD_OBJECT set = this.set_at_node(node);
        int i = set.lower;
        while (i <= set.upper) {
            Result2.append(this.get_element(i).toString());
            if (++i > set.upper) continue;
            Result2.append(",");
        }
        Result2.append("}");
        return new String(Result2);
    }

    public String out_morphism(int edge) {
        StringBuffer Result2 = new StringBuffer("");
        int s = this.f_source.item(edge);
        int t = this.f_target.item(edge);
        COPROD_OBJECT source_set = this.set_at_node(s);
        COPROD_OBJECT target_set = this.set_at_node(t);
        INT_VECTOR mor = this.morphism_at_edge(edge);
        Result2.append(this.get_name(s));
        Result2.append(" --> ");
        Result2.append(this.get_name(t));
        Result2.append(": ");
        Result2.append("{");
        int i = source_set.lower;
        while (i <= source_set.upper) {
            Result2.append(this.get_element(i).toString());
            Result2.append("->");
            int pos = mor.item(i - source_set.lower);
            if (pos == -1) {
                Result2.append("#");
            } else {
                Result2.append(this.get_element(pos + target_set.lower).toString());
            }
            if (++i > source_set.upper) continue;
            Result2.append(", ");
        }
        Result2.append("}");
        return new String(Result2);
    }

    private void compute_colimit() {
        this.f_colimit_indices = new INT_VECTOR();
        this.f_colimit_set = new COLIM_VECTOR();
        int element = 1;
        while (element < this.coproduct_size()) {
            int colim_index = this.f_colimit.item(this.f_partition.find(element));
            this.f_colimit.put(colim_index, element);
            if (element == colim_index) {
                this.f_colimit_indices.push_back(colim_index);
                this.f_colimit_set.push_back(this.f_coproduct.item(colim_index));
            }
            ++element;
        }
        this.f_colimit_pos = new INT_VECTOR();
        this.f_colimit_pos.setSize(this.coproduct_size());
        this.f_colimit_pos.put(-1, 0);
        element = 0;
        while (element < this.f_colimit_indices.size()) {
            this.f_colimit_pos.put(element, this.f_colimit_indices.item(element));
            ++element;
        }
        this.f_colimit_valid = true;
    }
}

